/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.lang.reflect.Field;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.util.CollectionTypeSerializer;
import org.cyclonedx.util.ComponentWrapperSerializer;
import org.cyclonedx.util.LicenseChoiceSerializer;
import org.cyclonedx.util.TrimStringSerializer;
import org.cyclonedx.util.VersionJsonAnnotationIntrospector;

public abstract class AbstractBomJsonGenerator
extends CycloneDxSchema
implements BomJsonGenerator {
    private final ObjectMapper mapper = new ObjectMapper();
    private final DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();

    public AbstractBomJsonGenerator() {
        this.setupObjectMapper(this.mapper);
        this.setupPrettyPrinter(this.prettyPrinter);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    private void setupPrettyPrinter(DefaultPrettyPrinter prettyPrinter) {
        prettyPrinter.indentArraysWith(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
    }

    private void setupObjectMapper(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector(new VersionJsonAnnotationIntrospector(String.valueOf(this.getSchemaVersion().getVersion())));
        SimpleModule licenseModule = new SimpleModule();
        SimpleModule depModule = new SimpleModule();
        SimpleModule componentWrapperModule = new SimpleModule();
        SimpleModule stringModule = new SimpleModule();
        stringModule.addSerializer(new TrimStringSerializer());
        mapper.registerModule(stringModule);
        licenseModule.addSerializer(new LicenseChoiceSerializer());
        mapper.registerModule(licenseModule);
        depModule.setSerializers(new CollectionTypeSerializer(false));
        mapper.registerModule(depModule);
        componentWrapperModule.addSerializer(new ComponentWrapperSerializer(mapper));
        mapper.registerModule(componentWrapperModule);
    }

    String toJson(Bom bom, boolean prettyPrint) throws GeneratorException {
        try {
            if (prettyPrint) {
                return this.mapper.writer(this.prettyPrinter).writeValueAsString(bom);
            }
            return this.mapper.writeValueAsString(bom);
        }
        catch (JsonProcessingException e2) {
            throw new GeneratorException(e2);
        }
    }

    Bom injectBomFormatAndSpecVersion(Bom bom) throws GeneratorException {
        try {
            Field field = Bom.class.getDeclaredField("bomFormat");
            field.setAccessible(true);
            field.set(bom, "CycloneDX");
            field = Bom.class.getDeclaredField("specVersion");
            field.setAccessible(true);
            field.set(bom, this.getSchemaVersion().getVersionString());
            return bom;
        }
        catch (IllegalAccessException | NoSuchFieldException e2) {
            throw new GeneratorException(e2);
        }
    }
}

