/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cyclonedx.model.Property;

public class PropertyDeserializer
extends StdDeserializer<List<Property>> {
    private static final long serialVersionUID = 3080840606644733407L;

    public PropertyDeserializer() {
        this((Class<?>)null);
    }

    public PropertyDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public List<Property> deserialize(JsonParser parser, DeserializationContext context2) throws IOException {
        ArrayList<Property> properties = new ArrayList();
        if (parser instanceof FromXmlParser) {
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            if (node.has("properties")) {
                JsonNode propertiesNode = node.get("properties");
                if (propertiesNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)node;
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        node = node.get("property");
                        properties.addAll(this.parsePropertyNode(node, new ArrayList<Property>()));
                    }
                }
            } else if (node.has("property")) {
                node = node.get("property");
                properties.addAll(this.parsePropertyNode(node, new ArrayList<Property>()));
            }
        } else {
            Property[] props = parser.readValueAs(Property[].class);
            properties = Arrays.asList((Object[])props.clone());
        }
        return properties;
    }

    private Property parseProperty(JsonNode node) {
        JsonNode valueNode;
        String name = null;
        String value = null;
        JsonNode nameNode = node.get("name");
        if (nameNode != null) {
            name = nameNode.asText();
        }
        if ((valueNode = node.get("")) != null) {
            value = valueNode.asText();
        } else if (this.isPreleaseDeserializationEnabled() && (valueNode = node.get("value")) != null) {
            value = valueNode.asText();
        }
        Property prop = new Property();
        prop.setName(name);
        prop.setValue(value);
        return prop;
    }

    private List<Property> parseArrayNode(ArrayNode arrayNode, List<Property> props) {
        for (int i = 0; i < arrayNode.size(); ++i) {
            JsonNode node = arrayNode.get(i);
            if (node instanceof ArrayNode) {
                this.parseArrayNode((ArrayNode)node, props);
                continue;
            }
            props.add(this.parseProperty(node));
        }
        return props;
    }

    private List<Property> parsePropertyNode(JsonNode node, List<Property> properties) {
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            properties.addAll(this.parseArrayNode(arrayNode, new ArrayList<Property>()));
        } else {
            properties.add(this.parseProperty(node));
        }
        return properties;
    }

    private boolean isPreleaseDeserializationEnabled() {
        String s = System.getProperty("cyclonedx.prerelease.13.properties");
        return Boolean.parseBoolean(s);
    }
}

