/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import javax.annotation.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class Collector {
    private Collector() {
    }

    public static Elements collect(Evaluator eval2, Element root2) {
        Elements elements = new Elements();
        NodeTraversor.traverse((NodeVisitor)new Accumulator(root2, elements, eval2), root2);
        return elements;
    }

    @Nullable
    public static Element findFirst(Evaluator eval2, Element root2) {
        FirstFinder finder = new FirstFinder(eval2);
        return finder.find(root2, root2);
    }

    private static class Accumulator
    implements NodeVisitor {
        private final Element root;
        private final Elements elements;
        private final Evaluator eval;

        Accumulator(Element root2, Elements elements, Evaluator eval2) {
            this.root = root2;
            this.elements = elements;
            this.eval = eval2;
        }

        @Override
        public void head(Node node, int depth) {
            Element el;
            if (node instanceof Element && this.eval.matches(this.root, el = (Element)node)) {
                this.elements.add(el);
            }
        }

        @Override
        public void tail(Node node, int depth) {
        }
    }

    static class FirstFinder
    implements NodeFilter {
        @Nullable
        private Element evalRoot = null;
        @Nullable
        private Element match = null;
        private final Evaluator eval;

        FirstFinder(Evaluator eval2) {
            this.eval = eval2;
        }

        @Nullable
        Element find(Element root2, Element start) {
            this.evalRoot = root2;
            this.match = null;
            NodeTraversor.filter((NodeFilter)this, start);
            return this.match;
        }

        @Override
        public NodeFilter.FilterResult head(Node node, int depth) {
            Element el;
            if (node instanceof Element && this.eval.matches(this.evalRoot, el = (Element)node)) {
                this.match = el;
                return NodeFilter.FilterResult.STOP;
            }
            return NodeFilter.FilterResult.CONTINUE;
        }

        @Override
        public NodeFilter.FilterResult tail(Node node, int depth) {
            return NodeFilter.FilterResult.CONTINUE;
        }
    }
}

