/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.cdx2spdx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import javax.annotation.Nullable;
import org.cyclonedx.model.Ancestors;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.BomReference;
import org.cyclonedx.model.Commit;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Composition;
import org.cyclonedx.model.Copyright;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Descendants;
import org.cyclonedx.model.Evidence;
import org.cyclonedx.model.ExtensibleType;
import org.cyclonedx.model.Extension;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Patch;
import org.cyclonedx.model.Pedigree;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Service;
import org.cyclonedx.model.Swid;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.Variants;
import org.spdx.cdx2spdx.CycloneConversionException;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.ReferenceType;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxCreatorInformation;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxItem;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.AnnotationType;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.FileType;
import org.spdx.library.model.enumerations.Purpose;
import org.spdx.library.model.enumerations.ReferenceCategory;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ConjunctiveLicenseSet;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.ListedLicenses;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.library.model.license.SpdxNoneLicense;
import org.spdx.library.referencetype.ListedReferenceTypes;
import org.spdx.storage.IModelStore;

public class CycloneSpdxConverter {
    private static final String CYCLONE_URI_PREFIX = "https://cyclonedx/";
    static final String REFERENCE_SITE_MAVEN_CENTRAL = "http://repo1.maven.org/maven2/";
    static final String REFERENCE_SITE_NPM = "https://www.npmjs.com/";
    static final String REFERENCE_SITE_NUGET = "https://www.nuget.org/";
    static final String REFERENCE_SITE_BOWER = "http://bower.io/";
    static final SimpleDateFormat SPDX_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final String INVALID_REF_REGEX = "[^0-9a-zA-Z\\.\\-\\+]";
    private static final String NULL_SHA1_VALUE = "0000000000000000000000000000000000000000";
    private static final String MISSING_CDX_PROPERTY_STR = "MISSING_CDX_PROPERTY:";
    static final Gson GSON;
    static Map<String, ChecksumAlgorithm> CDX_ALGORITHM_TO_SPDX_ALGORITHM;
    static Map<Component.Type, Purpose> COMPONENT_TYPE_TO_PURPOSE;
    private Bom cycloneBom;
    private IModelStore spdxModelStore;
    private ModelCopyManager copyManager;
    private List<String> warnings = new ArrayList<String>();
    private String documentUri;
    private boolean converted = false;
    private Map<String, SpdxElement> componentIdToSpdxElement = new HashMap<String, SpdxElement>();
    private Map<String, AnyLicenseInfo> cdxLicenseIdToSpdxLicense = new HashMap<String, AnyLicenseInfo>();

    static {
        SPDX_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").create();
        HashMap<String, ChecksumAlgorithm> algToSpdx = new HashMap<String, ChecksumAlgorithm>();
        algToSpdx.put("MD5", ChecksumAlgorithm.MD5);
        algToSpdx.put("SHA-1", ChecksumAlgorithm.SHA1);
        algToSpdx.put("SHA-256", ChecksumAlgorithm.SHA256);
        algToSpdx.put("SHA-384", ChecksumAlgorithm.SHA384);
        algToSpdx.put("SHA-512", ChecksumAlgorithm.SHA512);
        algToSpdx.put("SHA3-256", ChecksumAlgorithm.SHA3_256);
        algToSpdx.put("SHA3-384", ChecksumAlgorithm.SHA3_384);
        algToSpdx.put("SHA3-512", ChecksumAlgorithm.SHA3_512);
        algToSpdx.put("BLAKE2b-256", ChecksumAlgorithm.BLAKE2b_256);
        algToSpdx.put("BLAKE2b-384", ChecksumAlgorithm.BLAKE2b_384);
        algToSpdx.put("BLAKE2b-512", ChecksumAlgorithm.BLAKE2b_512);
        algToSpdx.put("BLAKE3", ChecksumAlgorithm.BLAKE3);
        CDX_ALGORITHM_TO_SPDX_ALGORITHM = Collections.unmodifiableMap(algToSpdx);
        HashMap<Component.Type, Purpose> compPurpose = new HashMap<Component.Type, Purpose>();
        compPurpose.put(Component.Type.APPLICATION, Purpose.APPLICATION);
        compPurpose.put(Component.Type.CONTAINER, Purpose.CONTAINER);
        compPurpose.put(Component.Type.DEVICE, Purpose.DEVICE);
        compPurpose.put(Component.Type.FILE, Purpose.FILE);
        compPurpose.put(Component.Type.FIRMWARE, Purpose.FIRMWARE);
        compPurpose.put(Component.Type.FRAMEWORK, Purpose.FRAMEWORK);
        compPurpose.put(Component.Type.LIBRARY, Purpose.LIBRARY);
        compPurpose.put(Component.Type.OPERATING_SYSTEM, Purpose.OPERATING_SYSTEM);
        COMPONENT_TYPE_TO_PURPOSE = Collections.unmodifiableMap(compPurpose);
    }

    public CycloneSpdxConverter(Bom cycloneBom, IModelStore spdxModelStore) {
        this.cycloneBom = cycloneBom;
        this.spdxModelStore = spdxModelStore;
        this.copyManager = new ModelCopyManager();
    }

    public void convert() throws CycloneConversionException {
        SpdxElement describes;
        List<Service> services;
        List<Component> components;
        this.checkSetConverted();
        String serialNumber = this.cycloneBom.getSerialNumber();
        if (Objects.nonNull(serialNumber)) {
            if (serialNumber.startsWith("urn:uuid:")) {
                serialNumber = serialNumber.substring("urn:uuid:".length());
            }
        } else {
            serialNumber = UUID.randomUUID().toString();
        }
        this.documentUri = CYCLONE_URI_PREFIX + serialNumber;
        this.documentUri = String.valueOf(this.documentUri) + "_" + this.cycloneBom.getVersion();
        SpdxDocument spdxDoc = null;
        try {
            spdxDoc = SpdxModelFactory.createSpdxDocument(this.spdxModelStore, this.documentUri, this.copyManager);
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new CycloneConversionException("Error creating SPDX document:" + e2.getMessage());
        }
        try {
            this.copyMetadata(this.cycloneBom.getMetadata(), this.cycloneBom.getSpecVersion(), spdxDoc);
        }
        catch (CycloneConversionException | InvalidSPDXAnalysisException e3) {
            throw new CycloneConversionException("Eror copying metadata: " + e3.getMessage(), e3);
        }
        if (Objects.nonNull(this.cycloneBom.getExternalReferences()) && !this.cycloneBom.getExternalReferences().isEmpty()) {
            this.retainFidelity(spdxDoc, "externalReferences", this.cycloneBom.getExternalReferences(), this.warnings);
        }
        if (Objects.nonNull(this.cycloneBom.getExtensibleTypes()) && !this.cycloneBom.getExtensibleTypes().isEmpty()) {
            this.retainFidelity(spdxDoc, "extensibleTypes", this.cycloneBom.getExtensibleTypes(), this.warnings);
        }
        if (Objects.nonNull(this.cycloneBom.getExtensions()) && !this.cycloneBom.getExtensions().isEmpty()) {
            this.retainFidelity(spdxDoc, "extensions", this.cycloneBom.getExtensions(), this.warnings);
        }
        if (Objects.nonNull(components = this.cycloneBom.getComponents())) {
            for (Component component : components) {
                try {
                    this.componentToElement(spdxDoc, component);
                }
                catch (CycloneConversionException | InvalidSPDXAnalysisException e4) {
                    throw new CycloneConversionException("Error converinging a CycloneDX component to element: " + e4.getMessage(), e4);
                }
            }
        }
        try {
            this.copyDependencies(this.cycloneBom.getDependencies());
        }
        catch (InvalidSPDXAnalysisException e5) {
            throw new CycloneConversionException("Eror copying dependencies: " + e5.getMessage(), e5);
        }
        if (Objects.nonNull(this.cycloneBom.getProperties()) && !this.cycloneBom.getProperties().isEmpty()) {
            this.retainFidelity(spdxDoc, "properties", this.cycloneBom.getProperties(), this.warnings);
        }
        if (Objects.nonNull(services = this.cycloneBom.getServices()) && !services.isEmpty()) {
            this.retainFidelity(spdxDoc, "services", this.cycloneBom.getServices(), this.warnings);
        }
        if (Objects.nonNull(this.cycloneBom.getMetadata()) && Objects.nonNull(this.cycloneBom.getMetadata().getComponent()) && Objects.isNull(describes = this.componentIdToSpdxElement.get(this.cycloneBom.getMetadata().getComponent().getBomRef())) && Objects.nonNull(this.cycloneBom.getMetadata().getComponent())) {
            try {
                this.componentToElement(spdxDoc, this.cycloneBom.getMetadata().getComponent());
            }
            catch (CycloneConversionException | InvalidSPDXAnalysisException e6) {
                throw new CycloneConversionException("Error copying component to element: " + e6.getMessage(), e6);
            }
            describes = this.componentIdToSpdxElement.get(this.cycloneBom.getMetadata().getComponent().getBomRef());
            if (Objects.nonNull(describes)) {
                this.componentIdToSpdxElement.put(this.cycloneBom.getMetadata().getComponent().getBomRef(), describes);
                try {
                    spdxDoc.getDocumentDescribes().add(describes);
                }
                catch (InvalidSPDXAnalysisException e7) {
                    throw new CycloneConversionException("Eror adding document describes: " + e7.getMessage(), e7);
                }
            }
        }
        try {
            this.copyCompositions(this.cycloneBom.getCompositions());
        }
        catch (InvalidSPDXAnalysisException e8) {
            throw new CycloneConversionException("Error copying compositions: " + e8.getMessage(), e8);
        }
        try {
            if (spdxDoc.getDocumentDescribes().isEmpty() && Objects.nonNull(this.cycloneBom.getComponents()) && !this.cycloneBom.getComponents().isEmpty()) {
                for (Component component : this.cycloneBom.getComponents()) {
                    spdxDoc.getDocumentDescribes().add(this.componentIdToSpdxElement.get(component.getBomRef()));
                }
            }
        }
        catch (InvalidSPDXAnalysisException e9) {
            throw new CycloneConversionException("Error setting document describes: " + e9.getMessage(), e9);
        }
        String name = "From-Cyclone-DX";
        try {
            if (spdxDoc.getDocumentDescribes().size() == 1) {
                name = "SBOM-for-" + spdxDoc.getDocumentDescribes().toArray(new SpdxElement[0])[0].getName().get();
            }
        }
        catch (InvalidSPDXAnalysisException e10) {
            throw new CycloneConversionException("Error setting document describes name: " + e10.getMessage(), e10);
        }
        try {
            spdxDoc.setName(name);
        }
        catch (InvalidSPDXAnalysisException e11) {
            throw new CycloneConversionException("Error setting document name: " + e11.getMessage(), e11);
        }
    }

    public synchronized void checkSetConverted() throws CycloneConversionException {
        if (this.converted) {
            throw new CycloneConversionException("The CycloneDX BOM has already been converted");
        }
        this.converted = true;
    }

    private void copyCompositions(List<Composition> compositions) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(compositions)) {
            return;
        }
        for (Composition composition : compositions) {
            List<BomReference> dependencies;
            Composition.Aggregate aggregate = composition.getAggregate();
            if (Objects.isNull((Object)aggregate)) {
                this.warnings.add("Null aggregate for a composition - skipping");
                continue;
            }
            List<BomReference> assemblies = composition.getAssemblies();
            if (Objects.nonNull(assemblies)) {
                this.addCommentToRelationships(assemblies, aggregate.toString(), RelationshipType.CONTAINS);
            }
            if (!Objects.nonNull(dependencies = composition.getDependencies())) continue;
            this.addCommentToRelationships(dependencies, aggregate.toString(), RelationshipType.DEPENDS_ON);
        }
    }

    private void addCommentToRelationships(List<BomReference> bomRefs, String comment, @Nullable RelationshipType relationshipType) throws InvalidSPDXAnalysisException {
        for (BomReference assembly : bomRefs) {
            String bomRef = assembly.getRef();
            if (Objects.isNull(bomRef)) {
                this.warnings.add("Null BOM Ref in compositions - skipping");
                continue;
            }
            SpdxElement element = this.componentIdToSpdxElement.get(bomRef);
            if (Objects.isNull(element)) {
                this.warnings.add("The component " + bomRef + "referenced in compositions was not found in the CycloneDX SBOM");
                continue;
            }
            for (Relationship relationship : element.getRelationships()) {
                if (Objects.nonNull(relationshipType)) {
                    if (!relationshipType.equals(relationship.getRelationshipType())) continue;
                    relationship.setComment(comment);
                    continue;
                }
                relationship.setComment(comment);
            }
        }
    }

    private void copyDependencies(List<Dependency> dependencies) throws InvalidSPDXAnalysisException {
        if (Objects.nonNull(dependencies)) {
            for (Dependency dependency : dependencies) {
                SpdxElement fromElement = this.componentIdToSpdxElement.get(dependency.getRef());
                if (Objects.isNull(fromElement)) {
                    this.warnings.add("From dependency component ref does not exist: " + dependency.getRef());
                    continue;
                }
                List<Dependency> directDependencies = dependency.getDependencies();
                if (!Objects.nonNull(directDependencies)) continue;
                for (Dependency directDependency : directDependencies) {
                    if (!Objects.nonNull(directDependency)) continue;
                    SpdxElement toElement = this.componentIdToSpdxElement.get(directDependency.getRef());
                    if (Objects.isNull(toElement)) {
                        this.warnings.add("To dependency component ref does not exist: " + dependency.getRef());
                        continue;
                    }
                    Relationship relationship = fromElement.createRelationship(toElement, RelationshipType.DEPENDS_ON, null);
                    Collection<Relationship> fromRelationships = fromElement.getRelationships();
                    if (fromRelationships.contains(relationship)) continue;
                    fromRelationships.add(relationship);
                }
                this.copyDependencies(directDependencies);
            }
        }
    }

    private void addPedigreeRelationships(SpdxElement element, Pedigree pedigree) throws InvalidSPDXAnalysisException, CycloneConversionException {
        Map<String, Extension> extensions;
        List<ExtensibleType> extensibleTypes;
        String notes;
        Variants variants;
        List<Patch> patches;
        List<Commit> commits;
        Descendants descendants;
        Ancestors ancestors = pedigree.getAncestors();
        if (Objects.nonNull(ancestors) && Objects.nonNull(ancestors.getComponents())) {
            for (Component ancestor : ancestors.getComponents()) {
                if (Component.Scope.REQUIRED.equals((Object)this.componentToElement(element, ancestor))) {
                    SpdxElement ancestorElement = this.componentIdToSpdxElement.get(ancestor.getBomRef());
                    Relationship relationship = element.createRelationship(ancestorElement, RelationshipType.ANCESTOR_OF, null);
                    element.addRelationship(relationship);
                    continue;
                }
                this.warnings.add("Ancestor relationship has scope other than required");
            }
        }
        if (Objects.nonNull(descendants = pedigree.getDescendants()) && Objects.nonNull(ancestors.getComponents())) {
            for (Component descendant : descendants.getComponents()) {
                if (Component.Scope.REQUIRED.equals((Object)this.componentToElement(element, descendant))) {
                    SpdxElement descendantElement = this.componentIdToSpdxElement.get(descendant.getBomRef());
                    Relationship relationship = element.createRelationship(descendantElement, RelationshipType.DESCENDANT_OF, null);
                    element.addRelationship(relationship);
                    continue;
                }
                this.warnings.add("Descendant relationship has scope other than required");
            }
        }
        if (Objects.nonNull(commits = pedigree.getCommits())) {
            this.retainFidelity(element, "pedigree.commits", commits, this.warnings);
        }
        if (Objects.nonNull(patches = pedigree.getPatches())) {
            this.retainFidelity(element, "pedigree.patches", patches, this.warnings);
        }
        if (Objects.nonNull(variants = pedigree.getVariants())) {
            for (Component variant : variants.getComponents()) {
                if (Component.Scope.REQUIRED.equals((Object)this.componentToElement(element, variant))) {
                    SpdxElement variantElement = this.componentIdToSpdxElement.get(variant.getBomRef());
                    Relationship relationship = element.createRelationship(variantElement, RelationshipType.VARIANT_OF, null);
                    element.addRelationship(relationship);
                    continue;
                }
                this.warnings.add("Variant relationship has scope other than required");
            }
        }
        if (Objects.nonNull(notes = pedigree.getNotes()) && !notes.isBlank()) {
            this.retainFidelity(element, "pedigree.notes", notes, this.warnings);
        }
        if (Objects.nonNull(extensibleTypes = pedigree.getExtensibleTypes()) && !extensibleTypes.isEmpty()) {
            this.retainFidelity(element, "pedigree.extensibleTypes", extensibleTypes, this.warnings);
        }
        if (Objects.nonNull(extensions = pedigree.getExtensions()) && !extensions.isEmpty()) {
            this.retainFidelity(element, "pedigree.extensions", extensions, this.warnings);
        }
    }

    private Component.Scope componentToElement(SpdxElement spdxDoc, Component component) throws InvalidSPDXAnalysisException, CycloneConversionException {
        Swid swid;
        Component.Scope scope;
        List<Property> properties;
        Pedigree pedigree;
        Map<String, Extension> extensions;
        SpdxItem element;
        String copyright;
        String group;
        String name;
        Component.Type componentType = component.getType();
        if (Objects.isNull((Object)componentType)) {
            this.warnings.add("Could not process component due to missing component type");
            return null;
        }
        String elementId = CycloneSpdxConverter.bomRefToSpdxId(component.getBomRef());
        if (Objects.isNull(elementId)) {
            elementId = spdxDoc.getModelStore().getNextId(IModelStore.IdType.SpdxId, spdxDoc.getDocumentUri());
        }
        if (Objects.isNull(name = component.getName())) {
            this.warnings.add("Missing name for component");
            name = "[MISSING]";
        }
        if (Objects.nonNull(group = component.getGroup()) && !group.isBlank()) {
            name = String.valueOf(group) + ":" + name;
        }
        List<Hash> hashes = component.getHashes();
        Checksum sha1 = null;
        if (Objects.nonNull(hashes)) {
            for (Hash hash : hashes) {
                if (!"SHA-1".equals(hash.getAlgorithm())) continue;
                sha1 = spdxDoc.createChecksum(ChecksumAlgorithm.SHA1, hash.getValue());
                break;
            }
        }
        if (Objects.isNull(sha1)) {
            this.warnings.add("Missing required SHA1 Checksum for " + name);
            sha1 = spdxDoc.createChecksum(ChecksumAlgorithm.SHA1, NULL_SHA1_VALUE);
        }
        if (Objects.isNull(copyright = component.getCopyright())) {
            copyright = SpdxConstants.NOASSERTION_VALUE;
        }
        if (Component.Type.FILE.equals((Object)componentType) && !this.containsPackageOnlyProperties(component)) {
            element = spdxDoc.createSpdxFile(elementId, name, new SpdxNoAssertionLicense(), new ArrayList<AnyLicenseInfo>(), copyright, sha1).build();
            this.addFileProperties((SpdxFile)element, component);
        } else {
            element = spdxDoc.createPackage(elementId, name, new SpdxNoAssertionLicense(), copyright, new SpdxNoAssertionLicense()).setFilesAnalyzed(false).setPrimaryPurpose(COMPONENT_TYPE_TO_PURPOSE.get((Object)componentType)).build();
            this.addPackageProperties((SpdxPackage)element, component);
        }
        List<ExtensibleType> extensibleTypes = component.getExtensibleTypes();
        if (Objects.nonNull(extensibleTypes) && !extensibleTypes.isEmpty()) {
            this.retainFidelity(element, "extensibleTypes", extensibleTypes, this.warnings);
        }
        if (Objects.nonNull(extensions = component.getExtensions()) && !extensions.isEmpty()) {
            this.retainFidelity(element, "extensions", extensions, this.warnings);
        }
        if (Objects.nonNull(pedigree = component.getPedigree())) {
            this.addPedigreeRelationships(element, pedigree);
        }
        if (Objects.nonNull(properties = component.getProperties()) && !properties.isEmpty()) {
            this.retainFidelity(element, "properites", properties, this.warnings);
        }
        if (Objects.isNull((Object)(scope = component.getScope()))) {
            scope = Component.Scope.REQUIRED;
        }
        if (Objects.nonNull(swid = component.getSwid())) {
            this.retainFidelity(element, "swid", swid, this.warnings);
        }
        if (Objects.isNull(component.getBomRef())) {
            component.setBomRef(element.getId());
        }
        this.componentIdToSpdxElement.put(component.getBomRef(), element);
        return scope;
    }

    private void addPackageProperties(SpdxPackage spdxPackage, Component component) throws InvalidSPDXAnalysisException, CycloneConversionException {
        Evidence evidence;
        String purl;
        String version2;
        OrganizationalEntity supplier;
        String mimeType;
        List<ExternalReference> externalReferences;
        String description;
        List<Component> subComponents;
        if (Objects.nonNull((Object)component.getType())) {
            this.retainFidelity(spdxPackage, "componentType", (Object)component.getType(), this.warnings);
            if (Component.Type.FILE.equals((Object)component.getType())) {
                spdxPackage.setPackageFileName(spdxPackage.getName().get());
                spdxPackage.setPackageVerificationCode(spdxPackage.createPackageVerificationCode(spdxPackage.getSha1(), new ArrayList<String>()));
            }
        }
        spdxPackage.setLicenseDeclared(this.listToLicenseSet(spdxPackage, this.convertCycloneLicenseInfo(spdxPackage, component.getLicenseChoice())));
        List<Hash> hashes = component.getHashes();
        if (Objects.nonNull(hashes)) {
            for (Hash hash : hashes) {
                ChecksumAlgorithm algorithm = CDX_ALGORITHM_TO_SPDX_ALGORITHM.get(hash.getAlgorithm());
                if (Objects.isNull(algorithm)) {
                    this.retainFidelity(spdxPackage, "hash", hash, this.warnings);
                    continue;
                }
                spdxPackage.addChecksum(spdxPackage.createChecksum(algorithm, hash.getValue()));
            }
        }
        String publisher = component.getPublisher();
        String author = component.getAuthor();
        if (Objects.nonNull(publisher) && !publisher.isBlank()) {
            spdxPackage.setOriginator("Organization: " + publisher);
            if (Objects.nonNull(author) && !author.isBlank()) {
                this.retainFidelity(spdxPackage, "author", author, this.warnings);
            }
        } else if (Objects.nonNull(author) && !author.isBlank()) {
            spdxPackage.setOriginator("Person: " + author);
        }
        if (Objects.nonNull(subComponents = component.getComponents())) {
            for (Component subComponent : subComponents) {
                Relationship subRelationship;
                Component.Scope scope = this.componentToElement(spdxPackage, subComponent);
                SpdxElement subElement = this.componentIdToSpdxElement.get(subComponent.getBomRef());
                if (!Objects.nonNull(subElement)) continue;
                if (Component.Scope.REQUIRED.equals((Object)scope)) {
                    subRelationship = spdxPackage.createRelationship(subElement, RelationshipType.CONTAINS, null);
                    spdxPackage.addRelationship(subRelationship);
                    continue;
                }
                if (Component.Scope.OPTIONAL.equals((Object)scope)) {
                    subRelationship = spdxPackage.createRelationship(spdxPackage, RelationshipType.OPTIONAL_COMPONENT_OF, null);
                    subElement.addRelationship(subRelationship);
                    continue;
                }
                this.warnings.add("Sub component is of excluded type: " + subComponent.getBomRef());
            }
        }
        if (Objects.nonNull(description = component.getDescription())) {
            spdxPackage.setDescription(description);
        }
        if (Objects.nonNull(externalReferences = component.getExternalReferences()) && !externalReferences.isEmpty()) {
            CycloneSpdxConverter.copyExternalReferences(externalReferences, spdxPackage, this.warnings);
        }
        if (spdxPackage.getDownloadLocation().isEmpty()) {
            spdxPackage.setDownloadLocation(SpdxConstants.NOASSERTION_VALUE);
        }
        if (Objects.nonNull(mimeType = component.getMimeType())) {
            this.retainFidelity(spdxPackage, "mimeType", mimeType, this.warnings);
        }
        if (Objects.nonNull(supplier = component.getSupplier()) && !supplier.getName().isBlank()) {
            StringBuilder sb = new StringBuilder("Organization: ");
            sb.append(supplier.getName());
            List<OrganizationalContact> contacts = supplier.getContacts();
            String email = null;
            boolean contactFidelity = false;
            if (Objects.nonNull(contacts) && !contacts.isEmpty()) {
                int i = 0;
                while (i < contacts.size()) {
                    OrganizationalContact contact = contacts.get(i);
                    if (Objects.nonNull(contact.getName()) && !contact.getName().isBlank() || Objects.nonNull(contact.getExtensibleTypes()) && !contact.getExtensibleTypes().isEmpty() || Objects.nonNull(contact.getExtensions()) && !contact.getExtensions().isEmpty()) {
                        contactFidelity = true;
                    }
                    if (Objects.nonNull(contact.getEmail()) && !contact.getEmail().isBlank()) {
                        if (Objects.isNull(email)) {
                            email = contact.getEmail();
                        } else {
                            contactFidelity = true;
                        }
                    }
                    ++i;
                }
            }
            if (Objects.nonNull(email)) {
                sb.append(" (");
                sb.append(email);
                sb.append(")");
            }
            if (contactFidelity) {
                this.retainFidelity(spdxPackage, "supplier.contacts", supplier.getContacts(), this.warnings);
            }
            if (Objects.nonNull(supplier.getUrls()) && !supplier.getUrls().isEmpty()) {
                this.retainFidelity(spdxPackage, "supplier.urls", supplier.getUrls(), this.warnings);
            }
            spdxPackage.setSupplier(sb.toString());
            this.warnings.add("Supplier is assumed to be an organization");
        }
        if (Objects.nonNull(version2 = component.getVersion()) && !version2.isBlank()) {
            spdxPackage.setVersionInfo(version2);
        }
        if (Objects.nonNull(purl = component.getPurl()) && !purl.isBlank()) {
            ExternalRef purlRef = spdxPackage.createExternalRef(ReferenceCategory.PACKAGE_MANAGER, ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName("purl"), purl, null);
            spdxPackage.addExternalRef(purlRef);
        }
        if (Objects.nonNull(evidence = component.getEvidence())) {
            AnyLicenseInfo spdxLicenseEvidence;
            List<Copyright> copyrights = evidence.getCopyright();
            if (Objects.nonNull(copyrights) && !copyrights.isEmpty()) {
                for (Copyright copyright : copyrights) {
                    String copyrightText = copyright.getText();
                    if (!Objects.nonNull(copyrightText) || copyrightText.isBlank()) continue;
                    spdxPackage.getAttributionText().add(copyrightText);
                }
            }
            if (Objects.nonNull(evidence.getLicenseChoice()) && Objects.nonNull(spdxLicenseEvidence = this.licenseChoiceToSpdxLicense(spdxPackage, evidence.getLicenseChoice())) && !(spdxLicenseEvidence instanceof SpdxNoAssertionLicense)) {
                spdxPackage.getAttributionText().add("Evidence license text for: " + spdxLicenseEvidence.toString());
            }
        }
        if (Objects.nonNull(component.getModified()) && component.getModified().booleanValue()) {
            spdxPackage.setSourceInfo("This package has been modified");
        }
    }

    private void addFileProperties(SpdxFile spdxFile, Component component) throws InvalidSPDXAnalysisException, CycloneConversionException {
        String mimeType;
        spdxFile.getLicenseInfoFromFiles().addAll(this.convertCycloneLicenseInfo(spdxFile, component.getLicenseChoice()));
        List<Hash> hashes = component.getHashes();
        if (Objects.nonNull(hashes)) {
            for (Hash hash : hashes) {
                ChecksumAlgorithm algorithm = CDX_ALGORITHM_TO_SPDX_ALGORITHM.get(hash.getAlgorithm());
                if (Objects.isNull(algorithm)) {
                    this.retainFidelity(spdxFile, "hash", hash, this.warnings);
                    continue;
                }
                if (ChecksumAlgorithm.SHA1.equals(algorithm)) continue;
                spdxFile.addChecksum(spdxFile.createChecksum(algorithm, hash.getValue()));
            }
        }
        if (Objects.nonNull(mimeType = component.getMimeType())) {
            FileType fileType = this.mimeToFileType(mimeType);
            if (Objects.nonNull(fileType)) {
                spdxFile.addFileType(fileType);
            } else {
                this.retainFidelity(spdxFile, "mimeType", mimeType, this.warnings);
            }
        }
    }

    private boolean containsPackageOnlyProperties(Component component) {
        return Objects.nonNull(component.getAuthor()) && !component.getAuthor().isBlank() && Objects.nonNull(component.getDescription()) && !component.getDescription().isBlank() && Objects.nonNull(component.getPublisher()) && !component.getPublisher().isBlank() && Objects.nonNull(component.getPurl()) && !component.getPurl().isBlank() && Objects.nonNull(component.getSupplier()) && !component.getSupplier().getName().isBlank() && Objects.nonNull(component.getVersion()) && !component.getVersion().isBlank() && Objects.nonNull(component.getPurl()) && !component.getPurl().isBlank() && Objects.nonNull(component.getComponents()) && !component.getComponents().isEmpty() && Objects.nonNull(component.getEvidence()) && Objects.nonNull(component.getExternalReferences()) && !component.getExternalReferences().isEmpty();
    }

    @Nullable
    private FileType mimeToFileType(String mimeType) {
        String[] mimeParts = mimeType.toLowerCase().trim().split("/");
        if (mimeParts.length < 2) {
            return null;
        }
        switch (mimeParts[0]) {
            case "application": {
                if (mimeParts[1].startsWith("spdx+")) {
                    return FileType.SPDX;
                }
                if (mimeParts[1].endsWith("+zip") || mimeParts[1].endsWith("+gzip") || mimeParts[1].endsWith("+rar")) {
                    return FileType.ARCHIVE;
                }
                if (mimeParts[1].contains("x-bytecode")) {
                    return FileType.BINARY;
                }
                switch (mimeParts[1]) {
                    case "x-bzip": 
                    case "x-7z-compressed": 
                    case "rar": 
                    case "zip": 
                    case "gzip": 
                    case "x-tar": 
                    case "x-bzip2": 
                    case "vnd.rar": {
                        return FileType.ARCHIVE;
                    }
                    case "java-archive": {
                        return FileType.BINARY;
                    }
                    case "x-sh": {
                        return FileType.SOURCE;
                    }
                    case "octet-stream": {
                        return FileType.BINARY;
                    }
                }
                return FileType.APPLICATION;
            }
            case "audio": {
                return FileType.AUDIO;
            }
            case "font": {
                return FileType.OTHER;
            }
            case "example": {
                return FileType.OTHER;
            }
            case "image": {
                return FileType.IMAGE;
            }
            case "message": {
                return FileType.OTHER;
            }
            case "model": {
                return FileType.OTHER;
            }
            case "multipart": {
                return FileType.ARCHIVE;
            }
            case "text": {
                switch (mimeParts[1]) {
                    case "x-script.phyton": 
                    case "x-csharp": 
                    case "x-c": 
                    case "x-java-source": 
                    case "text/javascript": {
                        return FileType.SOURCE;
                    }
                }
                return FileType.TEXT;
            }
            case "video": {
                return FileType.VIDEO;
            }
        }
        return FileType.OTHER;
    }

    private List<AnyLicenseInfo> convertCycloneLicenseInfo(SpdxElement parentElement, LicenseChoice licenseChoice) throws InvalidSPDXAnalysisException, CycloneConversionException {
        ArrayList<AnyLicenseInfo> retval = new ArrayList<AnyLicenseInfo>();
        if (Objects.nonNull(licenseChoice)) {
            List<License> licenses;
            String expression = licenseChoice.getExpression();
            if (Objects.nonNull(expression) && !expression.isBlank()) {
                try {
                    retval.add(LicenseInfoFactory.parseSPDXLicenseString(expression, parentElement.getModelStore(), parentElement.getDocumentUri(), parentElement.getCopyManager()));
                }
                catch (InvalidLicenseStringException ex) {
                    this.warnings.add("Invalid license expression '" + expression + "'");
                }
            }
            if (Objects.nonNull(licenses = licenseChoice.getLicenses())) {
                for (License lic : licenses) {
                    try {
                        retval.add(this.cdxLicenseToSpdxLicense(lic, parentElement.getModelStore(), parentElement.getDocumentUri(), parentElement.getCopyManager()));
                        if (Objects.nonNull(lic.getExtensibleTypes()) && !lic.getExtensibleTypes().isEmpty()) {
                            this.retainFidelity(parentElement, "licenseChoice.licenses.extensibleTypes", lic.getExtensibleTypes(), this.warnings);
                        }
                        if (!Objects.nonNull(lic.getExtensions()) || lic.getExtensions().isEmpty()) continue;
                        this.retainFidelity(parentElement, "licenseChoice.licenses.extensions", lic.getExtensions(), this.warnings);
                    }
                    catch (InvalidSPDXAnalysisException ex) {
                        this.warnings.add("Invalid CDX license '" + lic.getId() + "'");
                    }
                }
            }
        }
        return retval;
    }

    private synchronized AnyLicenseInfo cdxLicenseToSpdxLicense(License cdxLicense, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        String id = cdxLicense.getId();
        if (Objects.isNull(id)) {
            id = cdxLicense.getName();
            this.warnings.add("Missing CycloneDX license ID for license name " + id);
        }
        if (ListedLicenses.getListedLicenses().isSpdxListedLicenseId(id)) {
            return ListedLicenses.getListedLicenses().getListedLicenseById(id);
        }
        if (!this.cdxLicenseIdToSpdxLicense.containsKey(id)) {
            String name;
            String url;
            String licenseText;
            ExtractedLicenseInfo eli = new ExtractedLicenseInfo(modelStore, documentUri, this.cdxLicenseIdToSpdxLicenseId(id), copyManager, true);
            AttachmentText attachmentText = cdxLicense.getAttachmentText();
            if (Objects.nonNull(attachmentText) && Objects.nonNull(licenseText = attachmentText.getText()) && !licenseText.isBlank()) {
                eli.setExtractedText(licenseText);
            }
            if (Objects.nonNull(url = cdxLicense.getUrl()) && !url.isBlank()) {
                eli.getSeeAlso().add(url);
            }
            if (Objects.nonNull(name = cdxLicense.getName()) && !name.isBlank()) {
                eli.setName(name);
            }
            this.cdxLicenseIdToSpdxLicense.put(id, eli);
        }
        return this.cdxLicenseIdToSpdxLicense.get(id);
    }

    private String cdxLicenseIdToSpdxLicenseId(String id) {
        return String.valueOf(SpdxConstants.NON_STD_LICENSE_ID_PRENUM) + id.replaceAll(INVALID_REF_REGEX, "-");
    }

    private AnyLicenseInfo listToLicenseSet(SpdxElement parentElement, List<AnyLicenseInfo> licenses) throws InvalidSPDXAnalysisException {
        if (licenses.size() == 0) {
            return new SpdxNoAssertionLicense();
        }
        if (licenses.size() == 1) {
            return licenses.get(0);
        }
        ConjunctiveLicenseSet retval = new ConjunctiveLicenseSet(parentElement.getModelStore(), parentElement.getDocumentUri(), parentElement.getModelStore().getNextId(IModelStore.IdType.Anonymous, parentElement.getDocumentUri()), parentElement.getCopyManager(), true);
        retval.getMembers().addAll(licenses);
        return retval;
    }

    @Nullable
    private static String bomRefToSpdxId(String bomRef) {
        if (Objects.isNull(bomRef)) {
            return null;
        }
        return String.valueOf(SpdxConstants.SPDX_ELEMENT_REF_PRENUM) + bomRef.replaceAll(INVALID_REF_REGEX, "-");
    }

    private static void copyExternalReferences(List<ExternalReference> externalReferences, SpdxPackage spdxPackage, List<String> warnings) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(externalReferences)) {
            return;
        }
        for (ExternalReference externalRef : externalReferences) {
            ExternalReference.Type type = externalRef.getType();
            String url = externalRef.getUrl();
            if (Objects.isNull(url) || Objects.isNull((Object)type)) {
                warnings.add("Skipping empty externalReference");
                continue;
            }
            String comment = externalRef.getComment();
            switch (type) {
                case VCS: {
                    if (url.startsWith(REFERENCE_SITE_BOWER)) {
                        spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.PACKAGE_MANAGER, ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName("bower"), url, comment));
                        break;
                    }
                    if (url.startsWith(REFERENCE_SITE_MAVEN_CENTRAL)) {
                        spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.PACKAGE_MANAGER, ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName("maven-central"), url, comment));
                        break;
                    }
                    if (url.startsWith(REFERENCE_SITE_NPM)) {
                        spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.PACKAGE_MANAGER, ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName("npm"), url, comment));
                        break;
                    }
                    if (url.startsWith(REFERENCE_SITE_NUGET)) {
                        spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.PACKAGE_MANAGER, ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName("nuget"), url, comment));
                        break;
                    }
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.PACKAGE_MANAGER, new ReferenceType("http://cyclonedx.org/referenctype/other-package-manager"), url, comment));
                    break;
                }
                case ISSUE_TRACKER: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/issue-tracker"), url, comment));
                    break;
                }
                case WEBSITE: {
                    if (spdxPackage.getHomepage().isPresent()) {
                        warnings.add("More than one home page in CycloneDX.  The following will be ignored: " + url);
                        break;
                    }
                    spdxPackage.setHomepage(url);
                    break;
                }
                case ADVISORIES: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.SECURITY, ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName("advisory"), url, comment));
                    break;
                }
                case BOM: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/bom"), url, comment));
                    break;
                }
                case MAILING_LIST: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/mailing_list"), url, comment));
                    break;
                }
                case SOCIAL: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/social"), url, comment));
                    break;
                }
                case CHAT: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/chat"), url, comment));
                    break;
                }
                case DOCUMENTATION: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/documentation"), url, comment));
                    break;
                }
                case SUPPORT: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/support"), url, comment));
                    break;
                }
                case DISTRIBUTION: {
                    spdxPackage.setDownloadLocation(url);
                    break;
                }
                case LICENSE: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/license"), url, comment));
                    break;
                }
                case BUILD_META: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/buildmeta"), url, comment));
                    break;
                }
                case BUILD_SYSTEM: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/buildsystem"), url, comment));
                    break;
                }
                default: {
                    spdxPackage.addExternalRef(spdxPackage.createExternalRef(ReferenceCategory.OTHER, new ReferenceType("http://cyclonedx.org/referenctype/other"), url, comment));
                }
            }
        }
    }

    private void copyMetadata(Metadata metadata, String cycloneSpecVersion, SpdxDocument spdxDoc) throws InvalidSPDXAnalysisException, CycloneConversionException {
        OrganizationalEntity supplier;
        OrganizationalEntity manufacture;
        String name;
        StringBuilder sb;
        if (Objects.isNull(metadata)) {
            return;
        }
        ArrayList<String> creators = new ArrayList<String>();
        boolean authorFidelity = false;
        List<OrganizationalContact> authors = metadata.getAuthors();
        if (Objects.nonNull(authors) && !authors.isEmpty()) {
            for (OrganizationalContact oc : metadata.getAuthors()) {
                StringBuilder sb2 = new StringBuilder("Person: ");
                String name2 = oc.getName();
                String email = oc.getEmail();
                if (Objects.nonNull(name2)) {
                    sb2.append(name2);
                } else {
                    sb2.append("[UNKNOWN]");
                }
                if (Objects.nonNull(email)) {
                    sb2.append(" (");
                    sb2.append(email);
                    sb2.append(")");
                }
                creators.add(sb2.toString());
                if (!(Objects.nonNull(oc.getPhone()) && !oc.getPhone().isBlank() || Objects.nonNull(oc.getExtensibleTypes()) && !oc.getExtensibleTypes().isEmpty()) && (!Objects.nonNull(oc.getExtensions()) || oc.getExtensions().isEmpty())) continue;
                authorFidelity = true;
            }
        }
        if (authorFidelity) {
            this.retainFidelity(spdxDoc, "metadata.authors", metadata.getAuthors(), this.warnings);
        }
        boolean toolFidelity = false;
        List<Tool> tools = metadata.getTools();
        if (tools != null) {
            for (Tool tool : tools) {
                sb = new StringBuilder("Tool: ");
                name = tool.getName();
                String vendor = tool.getVendor();
                String version2 = tool.getVersion();
                if (Objects.nonNull(vendor)) {
                    sb.append(vendor);
                    sb.append(":");
                }
                if (Objects.nonNull(name)) {
                    sb.append(name);
                } else {
                    sb.append("[UNKNOWN]");
                }
                if (Objects.nonNull(version2)) {
                    sb.append("-");
                    sb.append(version2);
                }
                creators.add(sb.toString());
                if (!(Objects.nonNull(tool.getHashes()) && !tool.getHashes().isEmpty() || Objects.nonNull(tool.getExtensibleTypes()) && !tool.getExtensibleTypes().isEmpty()) && (!Objects.nonNull(tool.getExtensions()) || tool.getExtensions().isEmpty())) continue;
                toolFidelity = true;
            }
        }
        if (toolFidelity) {
            this.retainFidelity(spdxDoc, "metadata.tools", metadata.getTools(), this.warnings);
        }
        if (Objects.nonNull(manufacture = metadata.getManufacture())) {
            this.retainFidelity(spdxDoc, "metadata.manufacture", manufacture, this.warnings);
        }
        if (Objects.nonNull(supplier = metadata.getSupplier())) {
            sb = new StringBuilder("Organization: ");
            name = supplier.getName();
            if (Objects.nonNull(name)) {
                sb.append(name);
            } else {
                sb.append("[UNKNOWN]");
            }
            String email = null;
            boolean contactFidelity = false;
            if (Objects.nonNull(supplier.getContacts()) && supplier.getContacts().size() > 0) {
                for (OrganizationalContact contact : supplier.getContacts()) {
                    if (Objects.nonNull(contact.getEmail()) && !contact.getEmail().isBlank()) {
                        if (Objects.isNull(email)) {
                            email = contact.getEmail();
                        } else {
                            contactFidelity = true;
                        }
                    }
                    if (!(Objects.nonNull(contact.getName()) && !contact.getName().isBlank() || Objects.nonNull(contact.getPhone()) && !contact.getPhone().isBlank() || Objects.nonNull(contact.getExtensibleTypes()) && !contact.getExtensibleTypes().isEmpty()) && (!Objects.nonNull(contact.getExtensions()) || contact.getExtensions().isEmpty())) continue;
                    contactFidelity = true;
                }
            }
            creators.add(sb.toString());
            if (contactFidelity) {
                this.retainFidelity(spdxDoc, "metadata.supplier.contacts", supplier.getContacts(), this.warnings);
            }
            if (Objects.nonNull(supplier.getUrls()) && supplier.getUrls().size() > 0) {
                this.retainFidelity(spdxDoc, "metadata.supplier.urls", supplier.getUrls(), this.warnings);
            }
        }
        creators.add("Tool: CycloneToSpdx-0.0.3");
        Date timestamp = metadata.getTimestamp();
        if (Objects.isNull(timestamp)) {
            throw new CycloneConversionException("Creation timestamp missing from CycloneDX BOM Metadata");
        }
        SpdxCreatorInformation creatorInfo = spdxDoc.createCreationInfo(creators, SPDX_DATE_FORMAT.format(timestamp));
        if (Objects.nonNull(cycloneSpecVersion)) {
            creatorInfo.setComment("Converted from CycloneDX spec version " + cycloneSpecVersion);
        } else {
            creatorInfo.setComment("Converted from CycloneDX");
        }
        creatorInfo.setLicenseListVersion(ListedLicenses.getListedLicenses().getLicenseListVersion());
        LicenseChoice lc = metadata.getLicenseChoice();
        AnyLicenseInfo dataLicense = Objects.nonNull(lc) ? this.licenseChoiceToSpdxLicense(spdxDoc, lc) : ListedLicenses.getListedLicenses().getListedLicenseById("CC0-1.0");
        spdxDoc.setDataLicense(dataLicense);
        List<Property> properties = metadata.getProperties();
        if (Objects.nonNull(properties) && properties.size() > 0) {
            this.retainFidelity(spdxDoc, "metadata.properties", properties, this.warnings);
        }
        spdxDoc.setCreationInfo(creatorInfo);
    }

    protected void retainFidelity(SpdxElement spdxElement, String cycloneDxPropertyName, Object cycloneDxPropertyValue, List<String> warnings) throws CycloneConversionException {
        Objects.requireNonNull(spdxElement, "Null SPDX element for loss of fidelity");
        Objects.requireNonNull(cycloneDxPropertyName, "Null CycloneDX property name for loss of fidelity");
        StringBuilder annotationComment = new StringBuilder(MISSING_CDX_PROPERTY_STR);
        annotationComment.append(cycloneDxPropertyName);
        annotationComment.append("=");
        if (Objects.nonNull(cycloneDxPropertyValue)) {
            annotationComment.append(GSON.toJson(cycloneDxPropertyValue));
        }
        try {
            spdxElement.addAnnotation(spdxElement.createAnnotation("Tool: CycloneToSpdx", AnnotationType.OTHER, SPDX_DATE_FORMAT.format(new Date()), annotationComment.toString()));
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new CycloneConversionException("Error adding annotation for lost fidelity: " + e2.getMessage());
        }
        StringBuilder message = new StringBuilder("SPDX does not support property or property value ");
        message.append(cycloneDxPropertyName);
        message.append(" for SPDX type " + spdxElement.getType());
        message.append(".  An annotation was added to the element to capture this information.");
        warnings.add(message.toString());
    }

    private AnyLicenseInfo licenseChoiceToSpdxLicense(SpdxElement parent, LicenseChoice licenseChoice) throws InvalidSPDXAnalysisException, CycloneConversionException {
        List<AnyLicenseInfo> licenses = this.convertCycloneLicenseInfo(parent, licenseChoice);
        if (licenses.size() == 1) {
            return licenses.get(0);
        }
        if (licenses.size() == 0) {
            return new SpdxNoneLicense();
        }
        return parent.createConjunctiveLicenseSet(licenses);
    }

    public Bom getCycloneBom() {
        return this.cycloneBom;
    }

    public IModelStore getSpdxModelStore() {
        return this.spdxModelStore;
    }

    public ModelCopyManager getCopyManager() {
        return this.copyManager;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public String getDocumentUri() {
        return this.documentUri;
    }

    public boolean isConverted() {
        return this.converted;
    }
}

