/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxVerificationHelper;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.ReferenceType;
import org.spdx.library.model.SimpleUriValue;
import org.spdx.library.model.enumerations.ReferenceCategory;
import org.spdx.storage.IModelStore;

public class ExternalRef
extends ModelObject
implements Comparable<ExternalRef> {
    public ExternalRef() throws InvalidSPDXAnalysisException {
    }

    public ExternalRef(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public ExternalRef(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Override
    public String getType() {
        return "ExternalRef";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            ReferenceCategory referenceCategory = this.getReferenceCategory();
            if (ReferenceCategory.MISSING.equals(referenceCategory)) {
                retval.add("Missing or invalid reference category");
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting reference category: " + e2.getMessage());
        }
        try {
            ReferenceType referenceType = this.getReferenceType();
            if ("http://spdx.org/rdf/refeferences/MISSING".equals(referenceType.getIndividualURI())) {
                retval.add("Missing or invalid reference type");
            }
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting reference type: " + e3.getMessage());
        }
        try {
            String referenceLocator = this.getReferenceLocator();
            if (referenceLocator.isEmpty()) {
                retval.add("Missing or invalid reference locator");
            } else if (referenceLocator.contains(" ")) {
                retval.add("Reference locator contains spaces");
            }
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting reference locator: " + e4.getMessage());
        }
        return retval;
    }

    @Override
    public int compareTo(ExternalRef o) {
        String compRefType;
        String myReferenceType;
        int retval = 0;
        try {
            myReferenceType = this.getReferenceType().getIndividualURI();
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Invalid reference type during compare", e2);
            myReferenceType = "http://spdx.org/rdf/refeferences/MISSING";
        }
        try {
            compRefType = o.getReferenceType().getIndividualURI();
        }
        catch (InvalidSPDXAnalysisException e3) {
            logger.error("Invalid reference type during compare", e3);
            compRefType = "http://spdx.org/rdf/refeferences/MISSING";
        }
        retval = myReferenceType.compareTo(compRefType);
        if (retval == 0) {
            String myReferenceLocator = "";
            String compareReferenceLocator = "";
            try {
                myReferenceLocator = this.getReferenceLocator();
            }
            catch (InvalidSPDXAnalysisException e4) {
                logger.error("Invalid reference locator during compare", e4);
            }
            try {
                compareReferenceLocator = o.getReferenceLocator();
            }
            catch (InvalidSPDXAnalysisException e5) {
                logger.error("Invalid compare reference locator during compare", e5);
            }
            retval = myReferenceLocator.compareTo(compareReferenceLocator);
        }
        if (retval == 0) {
            ReferenceCategory referenceCategory = ReferenceCategory.MISSING;
            ReferenceCategory compareReferenceCategory = ReferenceCategory.MISSING;
            try {
                referenceCategory = this.getReferenceCategory();
            }
            catch (InvalidSPDXAnalysisException e6) {
                logger.error("Invalid reference category during compare", e6);
            }
            try {
                compareReferenceCategory = o.getReferenceCategory();
            }
            catch (InvalidSPDXAnalysisException e7) {
                logger.error("Invalid compare reference category during compare", e7);
            }
            retval = referenceCategory.toString().compareTo(compareReferenceCategory.toString());
        }
        if (retval == 0) {
            Optional<Object> myComment = Optional.empty();
            Optional<Object> compareComment = Optional.empty();
            try {
                myComment = this.getComment();
            }
            catch (InvalidSPDXAnalysisException e8) {
                logger.error("Invalid comment during compare", e8);
            }
            try {
                compareComment = o.getComment();
            }
            catch (InvalidSPDXAnalysisException e9) {
                logger.error("Invalid compare comment during compare", e9);
            }
            if (!myComment.isPresent()) {
                if (compareComment.isPresent()) {
                    retval = 1;
                }
            } else {
                retval = !compareComment.isPresent() ? -1 : ((String)myComment.get()).compareTo((String)compareComment.get());
            }
        }
        return retval;
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("comment");
    }

    public ExternalRef setComment(String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("comment", comment);
        return this;
    }

    public ReferenceCategory getReferenceCategory() throws InvalidSPDXAnalysisException {
        Optional<Enum<?>> retval = this.getEnumPropertyValue("referenceCategory");
        if (retval.isPresent()) {
            if (!(retval.get() instanceof ReferenceCategory)) {
                throw new InvalidSPDXAnalysisException("Invalid type for reference category: " + retval.get().getClass().toString());
            }
            return (ReferenceCategory)retval.get();
        }
        return ReferenceCategory.MISSING;
    }

    public ExternalRef setReferenceCategory(ReferenceCategory referenceCategory) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull(referenceCategory)) {
            throw new InvalidSPDXAnalysisException("Can not set required referenceCategory to null");
        }
        if (ReferenceCategory.MISSING.equals(referenceCategory)) {
            throw new InvalidSPDXAnalysisException("Can not set required referenceCategory to MISSING");
        }
        this.setPropertyValue("referenceCategory", referenceCategory);
        return this;
    }

    public ReferenceType getReferenceType() throws InvalidSPDXAnalysisException {
        Optional<Object> retval = this.getObjectPropertyValue("referenceType");
        if (!retval.isPresent()) {
            return ReferenceType.getMissingReferenceType();
        }
        if (retval.get() instanceof ReferenceType) {
            return (ReferenceType)retval.get();
        }
        if (retval.get() instanceof SimpleUriValue) {
            return new ReferenceType((SimpleUriValue)retval.get());
        }
        throw new InvalidSPDXAnalysisException("Invalid type returned for reference type: " + retval.get().getClass().toString());
    }

    public ExternalRef setReferenceType(ReferenceType referenceType) throws InvalidSPDXAnalysisException {
        if (Objects.isNull(referenceType)) {
            if (this.strict) {
                throw new InvalidSPDXAnalysisException("Can not set required referenceType to null");
            }
            this.setPropertyValue("referenceType", null);
        } else {
            if ("http://spdx.org/rdf/refeferences/MISSING".equals(referenceType.getIndividualURI())) {
                throw new InvalidSPDXAnalysisException("Can not set referenceType to MISSING");
            }
            if (this.strict && !SpdxVerificationHelper.isValidUri(referenceType.getIndividualURI())) {
                throw new InvalidSPDXAnalysisException("Invalid URI for referenceType");
            }
            this.setPropertyValue("referenceType", referenceType);
        }
        return this;
    }

    public String getReferenceLocator() throws InvalidSPDXAnalysisException {
        Optional<String> retval = this.getStringPropertyValue("referenceLocator");
        if (retval.isPresent()) {
            return retval.get();
        }
        return "";
    }

    public ExternalRef setReferenceLocator(String referenceLocator) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (Objects.isNull(referenceLocator)) {
                throw new InvalidSPDXAnalysisException("Can not set required reference locator to null");
            }
            if (referenceLocator.isEmpty()) {
                throw new InvalidSPDXAnalysisException("Can not set required reference locator to an empty string");
            }
            if (referenceLocator.contains(" ")) {
                throw new InvalidSPDXAnalysisException("Reference locator contains spaces");
            }
        }
        this.setPropertyValue("referenceLocator", referenceLocator);
        return this;
    }

    @Override
    public boolean equivalent(ModelObject compare, boolean ignoreRelatedElements) throws InvalidSPDXAnalysisException {
        if (!(compare instanceof ExternalRef)) {
            return false;
        }
        ExternalRef compareEf = (ExternalRef)compare;
        return Objects.equals(this.getReferenceLocator(), compareEf.getReferenceLocator()) && Objects.equals(this.getComment(), compareEf.getComment()) && Objects.equals(this.getReferenceCategory(), compareEf.getReferenceCategory());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            ReferenceCategory referenceCategory = this.getReferenceCategory();
            if (ReferenceCategory.MISSING.equals(referenceCategory)) {
                sb.append("[NONE] ");
            } else {
                sb.append(referenceCategory.toString());
                sb.append(' ');
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            sb.append("[ERROR] ");
        }
        try {
            ReferenceType referenceType = this.getReferenceType();
            if (!"http://spdx.org/rdf/refeferences/MISSING".equals(referenceType.getIndividualURI())) {
                sb.append(referenceType.getIndividualURI());
                sb.append(' ');
            } else {
                sb.append("[NONE] ");
            }
        }
        catch (InvalidSPDXAnalysisException e3) {
            sb.append("[ERROR] ");
        }
        try {
            String referenceLocator = this.getReferenceLocator();
            if (!referenceLocator.isEmpty()) {
                sb.append(referenceLocator);
                sb.append(' ');
            } else {
                sb.append("[NONE]");
            }
        }
        catch (InvalidSPDXAnalysisException e4) {
            sb.append("[ERROR] ");
        }
        try {
            Optional<String> comment = this.getComment();
            if (comment.isPresent()) {
                sb.append('(');
                sb.append(comment.get());
                sb.append(')');
            }
        }
        catch (InvalidSPDXAnalysisException e5) {
            sb.append("([ERROR])");
        }
        return sb.toString();
    }
}

