/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.ModelCollection;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxIdInUseException;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.storage.IModelStore;

public class RelatedElementCollection
implements Collection<SpdxElement> {
    static final Logger logger = LoggerFactory.getLogger(RelatedElementCollection.class);
    ModelCollection<Relationship> relationshipCollection;
    private RelationshipType relationshipTypeFilter;
    private String relatedElementTypeFilter;
    private Set<String> createdRelationshipIds = new HashSet<String>();
    private SpdxElement owningElement;

    public RelatedElementCollection(SpdxElement owningElement, @Nullable RelationshipType relationshipTypeFilter) throws InvalidSPDXAnalysisException {
        this(owningElement, relationshipTypeFilter, null);
    }

    public RelatedElementCollection(SpdxElement owningElement, @Nullable RelationshipType relationshipTypeFilter, @Nullable String relatedElementTypeFilter) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(owningElement, "Owning element can not be null");
        this.owningElement = owningElement;
        this.relationshipCollection = new ModelCollection(owningElement.getModelStore(), owningElement.getDocumentUri(), owningElement.getId(), "relationship", owningElement.getCopyManager(), Relationship.class);
        this.relationshipTypeFilter = relationshipTypeFilter;
        this.relatedElementTypeFilter = relatedElementTypeFilter;
    }

    public List<SpdxElement> toImmutableList() {
        ArrayList<SpdxElement> retval = new ArrayList<SpdxElement>();
        for (Object item : this.relationshipCollection.toImmutableList()) {
            if (!(item instanceof Relationship)) continue;
            Relationship relationship = (Relationship)item;
            try {
                Optional<SpdxElement> relatedElement;
                RelationshipType relationshipType = relationship.getRelationshipType();
                if (!Objects.isNull(this.relationshipTypeFilter) && !this.relationshipTypeFilter.equals(relationshipType) || !(relatedElement = relationship.getRelatedSpdxElement()).isPresent() || !Objects.isNull(this.relatedElementTypeFilter) && !this.relatedElementTypeFilter.equals(relatedElement.get().getType())) continue;
                retval.add(relatedElement.get());
            }
            catch (InvalidSPDXAnalysisException e2) {
                logger.warn("error getting relationship type - skipping relationship", e2);
            }
        }
        return Collections.unmodifiableList(retval);
    }

    @Override
    public int size() {
        return this.toImmutableList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.toImmutableList().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof SpdxElement)) {
            return false;
        }
        String elementId = ((SpdxElement)o).getId();
        for (Object item : this.relationshipCollection) {
            if (!(item instanceof Relationship)) continue;
            Relationship relationship = (Relationship)item;
            try {
                Optional<SpdxElement> relatedElement;
                RelationshipType relationshipType = relationship.getRelationshipType();
                if (!Objects.isNull(this.relationshipTypeFilter) && !this.relationshipTypeFilter.equals(relationshipType) || !(relatedElement = relationship.getRelatedSpdxElement()).isPresent() || !elementId.equals(relatedElement.get().getId())) continue;
                return true;
            }
            catch (InvalidSPDXAnalysisException e2) {
                logger.warn("error getting relationship type - skipping relationship", e2);
            }
        }
        return false;
    }

    @Override
    public Iterator<SpdxElement> iterator() {
        return this.toImmutableList().iterator();
    }

    public SpdxElement[] toArray() {
        List<SpdxElement> list = this.toImmutableList();
        return list.toArray(new SpdxElement[list.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toImmutableList().toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(SpdxElement e2) {
        if (Objects.isNull(this.relationshipTypeFilter)) {
            logger.error("Ambiguous relationship type - can not add element");
            throw new RuntimeException("Can not add element to RelatedElementCollection due to ambiguous relationship type.  Add a relationshipTypeFilter to resolve.");
        }
        if (Objects.isNull(e2) || this.contains(e2)) {
            return false;
        }
        IModelStore.IModelStoreLock lock = this.owningElement.getModelStore().enterCriticalSection(this.owningElement.getDocumentUri(), false);
        try {
            Relationship relationship = this.owningElement.createRelationship(e2, this.relationshipTypeFilter, null);
            this.createdRelationshipIds.add(relationship.getId());
            boolean bl = this.owningElement.addRelationship(relationship);
            this.owningElement.getModelStore().leaveCriticalSection(lock);
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.owningElement.getModelStore().leaveCriticalSection(lock);
                throw throwable;
            }
            catch (InvalidSPDXAnalysisException e1) {
                logger.error("Error adding relationship", e1);
                throw new RuntimeException(e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object o) {
        if (o instanceof Relationship) {
            return this.relationshipCollection.remove(o);
        }
        if (!(o instanceof SpdxElement)) return false;
        if (Objects.isNull(this.relationshipTypeFilter)) {
            logger.error("Ambiguous relationship type - can not add element");
            throw new RuntimeException("Can not remove element from RelatedElementCollection due to ambiguous relationship type.  Add a relationshipTypeFilter to resolve.");
        }
        List<Object> relationships = this.relationshipCollection.toImmutableList();
        Iterator<Object> iterator = relationships.iterator();
        while (iterator.hasNext()) {
            Object rel = iterator.next();
            if (!(rel instanceof Relationship)) continue;
            Relationship relationship = (Relationship)rel;
            try {
                Optional<SpdxElement> relatedElement = relationship.getRelatedSpdxElement();
                if (!relatedElement.isPresent() || !relatedElement.get().equals(o) || !relationship.getRelationshipType().equals(this.relationshipTypeFilter)) continue;
                IModelStore modelStore = relationship.getModelStore();
                String documentUri = relationship.getDocumentUri();
                IModelStore.IModelStoreLock lock = modelStore.enterCriticalSection(documentUri, false);
                try {
                    if (this.relationshipCollection.remove(relationship)) {
                        try {
                            if (this.createdRelationshipIds.contains(relationship.getId())) {
                                this.createdRelationshipIds.remove(relationship.getId());
                                modelStore.delete(documentUri, relationship.getId());
                            }
                        }
                        catch (SpdxIdInUseException spdxIdInUseException) {
                            // empty catch block
                        }
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    modelStore.leaveCriticalSection(lock);
                }
            }
            catch (InvalidSPDXAnalysisException e2) {
                logger.error("Error getting relationship properties - skipping removal of element", e2);
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.toImmutableList().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends SpdxElement> c) {
        boolean modified = false;
        for (SpdxElement spdxElement : c) {
            if (!this.add(spdxElement)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object element : c) {
            if (!this.remove(element)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        List<SpdxElement> existingElements = this.toImmutableList();
        boolean modified = false;
        for (SpdxElement existingElement : existingElements) {
            if (c.contains(existingElement) || !this.remove(existingElement)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        if (Objects.isNull(this.relationshipTypeFilter) && Objects.isNull(this.relatedElementTypeFilter)) {
            this.relationshipCollection.clear();
        } else {
            List<SpdxElement> existingElements = this.toImmutableList();
            for (SpdxElement existingElement : existingElements) {
                this.remove(existingElement);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RelatedElementCollection)) {
            return false;
        }
        RelatedElementCollection compare = (RelatedElementCollection)o;
        return Objects.equals(this.owningElement, compare.getOwningElement()) && Objects.equals(this.relationshipTypeFilter, compare.getRelationshipTypeFilter()) && Objects.equals(this.relatedElementTypeFilter, compare.getRelatedElementTypeFilter());
    }

    @Override
    public int hashCode() {
        int retval = 0x21 ^ this.owningElement.hashCode();
        if (Objects.nonNull(this.relationshipTypeFilter)) {
            retval ^= this.relationshipTypeFilter.hashCode();
        }
        if (Objects.nonNull(this.relatedElementTypeFilter)) {
            retval ^= this.relatedElementTypeFilter.hashCode();
        }
        return retval;
    }

    public ModelCollection<Relationship> getRelationshipCollection() {
        return this.relationshipCollection;
    }

    public RelationshipType getRelationshipTypeFilter() {
        return this.relationshipTypeFilter;
    }

    public String getRelatedElementTypeFilter() {
        return this.relatedElementTypeFilter;
    }

    public SpdxElement getOwningElement() {
        return this.owningElement;
    }
}

