/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.Version;
import org.spdx.library.model.ExternalSpdxElement;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.storage.IModelStore;

public class Relationship
extends ModelObject
implements Comparable<Relationship> {
    public Relationship() throws InvalidSPDXAnalysisException {
    }

    public Relationship(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public Relationship(IModelStore modelStore, String documentUri, String id, ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Override
    public String getType() {
        return "Relationship";
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Optional<SpdxElement> relatedSpdxElement = this.getRelatedSpdxElement();
            if (!relatedSpdxElement.isPresent()) {
                retval.add("Missing related SPDX element");
            } else if (relatedSpdxElement.get() instanceof ExternalSpdxElement) {
                retval.addAll(relatedSpdxElement.get().verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting related SPDX element for relationship: " + e2.getMessage());
        }
        try {
            RelationshipType relationshipType = this.getRelationshipType();
            if (RelationshipType.MISSING.equals(relationshipType)) {
                retval.add("Missing relationship type");
            }
            if (Version.versionLessThan(specVersion, "SPDX-2.3") && (RelationshipType.REQUIREMENT_DESCRIPTION_FOR.equals(relationshipType) || RelationshipType.SPECIFICATION_FOR.equals(relationshipType))) {
                retval.add(relationshipType.toString() + " is not supported in SPDX spec versions less than " + "SPDX-2.3");
            }
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting relationship type: " + e3.getMessage());
        }
        return retval;
    }

    public RelationshipType getRelationshipType() throws InvalidSPDXAnalysisException {
        Optional<Enum<?>> retval = this.getEnumPropertyValue("relationshipType");
        if (retval.isPresent()) {
            if (!(retval.get() instanceof RelationshipType)) {
                throw new SpdxInvalidTypeException("Invalid type for relationship type individual value: " + retval.get().toString());
            }
            return (RelationshipType)retval.get();
        }
        return RelationshipType.MISSING;
    }

    public Relationship setRelationshipType(RelationshipType type) throws InvalidSPDXAnalysisException {
        if (RelationshipType.MISSING.equals(type)) {
            throw new InvalidSPDXAnalysisException("Can not set required relationshipType to MISSING");
        }
        if (this.strict && type == null) {
            throw new InvalidSPDXAnalysisException("Can not set required relationshipType to null");
        }
        this.setPropertyValue("relationshipType", type);
        return this;
    }

    public Optional<String> getComment() throws InvalidSPDXAnalysisException {
        return this.getStringPropertyValue("comment");
    }

    public Relationship setComment(String comment) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("comment", comment);
        return this;
    }

    public Optional<SpdxElement> getRelatedSpdxElement() throws InvalidSPDXAnalysisException {
        return this.getElementPropertyValue("relatedSpdxElement");
    }

    public Relationship setRelatedSpdxElement(SpdxElement relatedSpdxElement) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("relatedSpdxElement", relatedSpdxElement);
        return this;
    }

    @Override
    public int compareTo(Relationship o) {
        Optional<String> myComment;
        Optional<String> compComment;
        Optional<SpdxElement> myRelatedElement;
        Optional<SpdxElement> compareRelatedElement;
        RelationshipType oRelationshipType;
        RelationshipType myRelationshipType;
        try {
            myRelationshipType = this.getRelationshipType();
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.warn("Error getting my relationship type", e2);
            myRelationshipType = RelationshipType.MISSING;
        }
        try {
            oRelationshipType = o.getRelationshipType();
        }
        catch (InvalidSPDXAnalysisException e3) {
            logger.warn("Error getting compare relationship type", e3);
            oRelationshipType = RelationshipType.MISSING;
        }
        int retval = myRelationshipType.toString().compareTo(oRelationshipType.toString());
        if (retval != 0) {
            return retval;
        }
        try {
            compareRelatedElement = o.getRelatedSpdxElement();
        }
        catch (InvalidSPDXAnalysisException e4) {
            logger.warn("Error getting compare related element", e4);
            compareRelatedElement = Optional.empty();
        }
        try {
            myRelatedElement = this.getRelatedSpdxElement();
        }
        catch (InvalidSPDXAnalysisException e5) {
            logger.warn("Error getting compare related element", e5);
            myRelatedElement = Optional.empty();
        }
        if (!compareRelatedElement.isPresent() && myRelatedElement.isPresent()) {
            return 1;
        }
        if (!myRelatedElement.isPresent()) {
            return -1;
        }
        retval = myRelatedElement.get().getId().compareTo(compareRelatedElement.get().getId());
        if (retval != 0) {
            return retval;
        }
        try {
            compComment = o.getComment();
        }
        catch (InvalidSPDXAnalysisException e6) {
            logger.warn("Error getting my comment", e6);
            compComment = Optional.empty();
        }
        try {
            myComment = this.getComment();
        }
        catch (InvalidSPDXAnalysisException e7) {
            logger.warn("Error getting compare comment", e7);
            myComment = Optional.empty();
        }
        if (!compComment.isPresent() && myComment.isPresent()) {
            return 1;
        }
        if (!myComment.isPresent()) {
            return -1;
        }
        return myComment.get().compareTo(compComment.get());
    }

    @Override
    public String toString() {
        try {
            Optional<SpdxElement> relatedElement = this.getRelatedSpdxElement();
            StringBuilder sb = new StringBuilder();
            sb.append(this.getRelationshipType().toString());
            sb.append(" ");
            if (relatedElement.isPresent()) {
                sb.append(relatedElement.get().toString());
            } else {
                sb.append("[Missing related element]");
            }
            return sb.toString();
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Error in toString: ", e2);
            return "Error: " + e2.getMessage();
        }
    }
}

