/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.Version;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.RelatedElementCollection;
import org.spdx.library.model.SpdxCreatorInformation;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.SpdxItem;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.library.model.license.SpdxNoneLicense;
import org.spdx.storage.IModelStore;

public class SpdxDocument
extends SpdxElement {
    Collection<SpdxElement> documentDescribes = new RelatedElementCollection(this, RelationshipType.DESCRIBES, null);
    Collection<ExternalDocumentRef> externalDocumentRefs = this.getObjectPropertyValueSet("externalDocumentRef", ExternalDocumentRef.class);
    Collection<ExtractedLicenseInfo> extractedLicenseInfos = this.getObjectPropertyValueSet("hasExtractedLicensingInfo", ExtractedLicenseInfo.class);

    public SpdxDocument(IModelStore modelStore, String documentUri, ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, "SPDXRef-DOCUMENT", copyManager, create);
    }

    public SpdxDocument(String documentUri) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), documentUri, DefaultModelStore.getDefaultCopyManager(), true);
    }

    @Override
    public String getType() {
        return "SpdxDocument";
    }

    @Override
    protected String getNamePropertyName() {
        return "name";
    }

    public Collection<SpdxElement> getDocumentDescribes() throws InvalidSPDXAnalysisException {
        return this.documentDescribes;
    }

    public SpdxDocument setDocumentDescribes(List<SpdxItem> documentDescribes) {
        Objects.requireNonNull(documentDescribes, "Document describes can not be null");
        this.documentDescribes.clear();
        this.documentDescribes.addAll(documentDescribes);
        return this;
    }

    @Nullable
    public SpdxCreatorInformation getCreationInfo() throws InvalidSPDXAnalysisException {
        Optional<Object> retval = this.getObjectPropertyValue("creationInfo");
        if (retval.isPresent()) {
            if (!(retval.get() instanceof SpdxCreatorInformation)) {
                throw new SpdxInvalidTypeException("Invalid tpe for CreationInfo: " + retval.get().getClass().toString());
            }
            return (SpdxCreatorInformation)retval.get();
        }
        logger.warn("No creation info for document " + this.getName());
        return null;
    }

    public void setCreationInfo(SpdxCreatorInformation creationInfo) throws InvalidSPDXAnalysisException {
        if (this.strict && Objects.isNull(creationInfo)) {
            throw new InvalidSPDXAnalysisException("Can not set required creation info to null");
        }
        this.setPropertyValue("creationInfo", creationInfo);
    }

    public AnyLicenseInfo getDataLicense() throws InvalidSPDXAnalysisException {
        Optional<AnyLicenseInfo> retval = this.getAnyLicenseInfoPropertyValue("dataLicense");
        if (retval.isPresent()) {
            return retval.get();
        }
        logger.warn("No data license for " + this.getName());
        return new SpdxNoneLicense();
    }

    public void setDataLicense(AnyLicenseInfo dataLicense) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (Objects.isNull(dataLicense)) {
                throw new InvalidSPDXAnalysisException("Can not set required data license to null");
            }
            if (!(dataLicense instanceof SpdxListedLicense)) {
                throw new InvalidSPDXAnalysisException("Invalid license type for data license - must be an SPDX Listed license");
            }
            if (!((SpdxListedLicense)dataLicense).getLicenseId().equals("CC0-1.0")) {
                throw new InvalidSPDXAnalysisException("Incorrect data license.  Must be CC0-1.0");
            }
        }
        this.setPropertyValue("dataLicense", dataLicense);
    }

    public Collection<ExternalDocumentRef> getExternalDocumentRefs() throws InvalidSPDXAnalysisException {
        return this.externalDocumentRefs;
    }

    public Collection<ExtractedLicenseInfo> getExtractedLicenseInfos() throws InvalidSPDXAnalysisException {
        return this.extractedLicenseInfos;
    }

    public boolean addExtractedLicenseInfos(ExtractedLicenseInfo licenseInfo) {
        Objects.requireNonNull(licenseInfo, "License info can not be null");
        return this.extractedLicenseInfos.add(licenseInfo);
    }

    public SpdxDocument setExtractedLicenseInfos(List<ExtractedLicenseInfo> extractedLicenseInfos) {
        Objects.requireNonNull(extractedLicenseInfos, "Extracted license infos can not be null");
        this.extractedLicenseInfos.clear();
        this.extractedLicenseInfos.addAll(extractedLicenseInfos);
        return this;
    }

    public String getSpecVersion() throws InvalidSPDXAnalysisException {
        Optional<String> retval = this.getStringPropertyValue("spdxVersion");
        if (retval.isPresent()) {
            return retval.get();
        }
        return "";
    }

    public void setSpecVersion(String specVersion) throws InvalidSPDXAnalysisException {
        if (this.strict) {
            if (Objects.isNull(specVersion)) {
                throw new InvalidSPDXAnalysisException("Can not set required spec version to null");
            }
            String verify = Version.verifySpdxVersion(specVersion);
            if (Objects.nonNull(verify) && !verify.isEmpty()) {
                throw new InvalidSPDXAnalysisException(verify);
            }
        }
        this.setPropertyValue("spdxVersion", specVersion);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String verifySpecVersion) {
        String specVersion;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            specVersion = this.getSpecVersion();
            if (specVersion.isEmpty()) {
                retval.add("Missing required SPDX version");
                specVersion = verifySpecVersion;
            } else {
                String verify = Version.verifySpdxVersion(specVersion);
                if (verify != null) {
                    retval.add(verify);
                    specVersion = verifySpecVersion;
                }
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting spec version");
            specVersion = verifySpecVersion;
        }
        retval.addAll(super._verify(verifiedIds, specVersion));
        try {
            Optional<String> name = this.getName();
            if (!name.isPresent() || name.get().isEmpty()) {
                retval.add("Missing required document name");
            }
        }
        catch (InvalidSPDXAnalysisException e1) {
            retval.add("Error getting document name");
        }
        try {
            SpdxCreatorInformation creator = this.getCreationInfo();
            if (Objects.isNull(creator)) {
                retval.add("Missing required Creator");
            } else {
                retval.addAll(creator.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Error getting creator information: " + e2.getMessage());
        }
        try {
            for (ExtractedLicenseInfo licInfo : this.getExtractedLicenseInfos()) {
                retval.addAll(licInfo.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Error getting extracted licensing info: " + e3.getMessage());
        }
        try {
            AnyLicenseInfo dataLicense = this.getDataLicense();
            if (dataLicense.toString().equals("NONE")) {
                retval.add("Missing required data license");
            } else if (!(dataLicense instanceof SpdxListedLicense)) {
                retval.add("Invalid license type for data license - must be an SPDX Listed license");
            } else if (!((SpdxListedLicense)dataLicense).getLicenseId().equals("CC0-1.0")) {
                retval.add("Incorrect data license for SPDX version 1.0 document - found " + ((SpdxListedLicense)dataLicense).getLicenseId() + ", expected " + "CC0-1.0");
            }
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Error getting data license: " + e4.getMessage());
        }
        try {
            for (ExternalDocumentRef externalRef : this.getExternalDocumentRefs()) {
                retval.addAll(externalRef.verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Error getting external document references: " + e5.getMessage());
        }
        try {
            if (this.getDocumentDescribes().size() == 0) {
                retval.add("Document must have at least one relationship of type DOCUMENT_DESCRIBES");
            } else {
                for (SpdxElement element : this.getDocumentDescribes()) {
                    retval.addAll(element.verify(verifiedIds, specVersion));
                }
            }
        }
        catch (InvalidSPDXAnalysisException e6) {
            retval.add("Error getting document describes: " + e6.getMessage());
        }
        return retval;
    }

    public SpdxDocument setExternalDocumentRefs(Collection<ExternalDocumentRef> externalDocumentRefs) {
        Objects.requireNonNull(externalDocumentRefs, "External document refs can not be null");
        this.externalDocumentRefs.clear();
        this.externalDocumentRefs.addAll(externalDocumentRefs);
        return this;
    }
}

