/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseExpressionParser;
import org.spdx.library.model.license.LicenseParserException;
import org.spdx.library.model.license.ListedLicenseException;
import org.spdx.library.model.license.ListedLicenses;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.storage.IModelStore;

public class LicenseInfoFactory {
    static final Logger logger = LoggerFactory.getLogger(LicenseInfoFactory.class.getName());
    public static final String NOASSERTION_LICENSE_NAME = "NOASSERTION";
    public static final String NONE_LICENSE_NAME = "NONE";

    public static SpdxListedLicense getListedLicenseById(String licenseId) throws InvalidSPDXAnalysisException {
        return ListedLicenses.getListedLicenses().getListedLicenseById(licenseId);
    }

    public static AnyLicenseInfo parseSPDXLicenseString(String licenseString, @Nullable IModelStore store, @Nullable String documentUri, @Nullable ModelCopyManager copyManager) throws InvalidLicenseStringException {
        if (Objects.isNull(store)) {
            store = DefaultModelStore.getDefaultModelStore();
        }
        if (Objects.isNull(documentUri)) {
            documentUri = DefaultModelStore.getDefaultDocumentUri();
        }
        if (Objects.isNull(copyManager)) {
            copyManager = DefaultModelStore.getDefaultCopyManager();
        }
        try {
            return LicenseExpressionParser.parseLicenseExpression(licenseString, store, documentUri, copyManager);
        }
        catch (LicenseParserException e2) {
            throw new InvalidLicenseStringException(e2.getMessage(), e2);
        }
        catch (InvalidSPDXAnalysisException e3) {
            throw new InvalidLicenseStringException("Unexpected SPDX error parsing license string");
        }
    }

    public static AnyLicenseInfo parseSPDXLicenseString(String licenseString) throws InvalidLicenseStringException {
        return LicenseInfoFactory.parseSPDXLicenseString(licenseString, null, null, null);
    }

    public static boolean isSpdxListedLicenseId(String licenseID) {
        return ListedLicenses.getListedLicenses().isSpdxListedLicenseId(licenseID);
    }

    public static List<String> getSpdxListedLicenseIds() {
        return ListedLicenses.getListedLicenses().getSpdxListedLicenseIds();
    }

    public static String getLicenseListVersion() {
        return ListedLicenses.getListedLicenses().getLicenseListVersion();
    }

    public static boolean isSpdxListedExceptionId(String id) {
        return ListedLicenses.getListedLicenses().isSpdxListedExceptionId(id);
    }

    public static ListedLicenseException getListedExceptionById(String id) throws InvalidSPDXAnalysisException {
        return ListedLicenses.getListedLicenses().getListedExceptionById(id);
    }

    public static Optional<String> listedLicenseIdCaseSensitive(String licenseId) {
        return ListedLicenses.getListedLicenses().listedLicenseIdCaseSensitive(licenseId);
    }

    public static Optional<String> listedExceptionIdCaseSensitive(String exceptionId) {
        return ListedLicenses.getListedLicenses().listedExceptionIdCaseSensitive(exceptionId);
    }
}

