/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spdx.library.DefaultModelStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.storage.IModelStore;

public abstract class LicenseSet
extends AnyLicenseInfo {
    Collection<AnyLicenseInfo> members = this.getObjectPropertyValueSet("member", AnyLicenseInfo.class);

    public LicenseSet() throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore().getNextId(IModelStore.IdType.Anonymous, DefaultModelStore.getDefaultDocumentUri()));
    }

    public LicenseSet(String id) throws InvalidSPDXAnalysisException {
        this(DefaultModelStore.getDefaultModelStore(), DefaultModelStore.getDefaultDocumentUri(), id, DefaultModelStore.getDefaultCopyManager(), true);
    }

    LicenseSet(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    public void setMembers(Collection<AnyLicenseInfo> licenseInfos) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("member", licenseInfos);
    }

    public Collection<AnyLicenseInfo> getMembers() throws InvalidSPDXAnalysisException {
        return this.members;
    }

    public void addMember(AnyLicenseInfo member) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(member, "Member can not be null");
        this.members.add(member);
    }

    public void removeMember(AnyLicenseInfo member) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(member, "Member can not be null");
        this.members.remove(member);
    }

    @Override
    protected List<String> _verify(Set<String> verifiedIds, String specVersion) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Iterator<AnyLicenseInfo> iter = this.getMembers().iterator();
            while (iter.hasNext()) {
                retval.addAll(iter.next().verify(verifiedIds, specVersion));
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Exception getting license set members: " + e2.getMessage());
        }
        return retval;
    }
}

