/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.referencetype;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.ReferenceType;

public class ListedReferenceTypes {
    static final Logger logger = LoggerFactory.getLogger(ListedReferenceTypes.class);
    private static final ReadWriteLock listedReferenceTypesModificationLock = new ReentrantReadWriteLock();
    private static final String LISTED_REFERENCE_TYPE__RDF_LOCAL_DIR = "resources/listedexternaltypes";
    private static final String LISTED_REFERENCE_TYPE_PROPERTIES_FILENAME = "resources/listedexternaltypes/listedreferencetypes.properties";
    private static final String LISTED_REFERENCE_TYPE_PROPERTIES_CLASS_PATH = "org/spdx/library/referencetype/listedreferencetypes.properties";
    private static final String PROPERTY_LISTED_REFERENCE_TYPES = "listedReferenceTypes";
    private static ListedReferenceTypes listedReferenceTypes;
    private Properties listedReferenceTypeProperties;
    List<String> listedReferenceNames;
    ConcurrentMap<String, ReferenceType> listedReferenceTypeCache;

    private ListedReferenceTypes() {
        block14: {
            this.listedReferenceNames = new ArrayList<String>();
            this.listedReferenceTypeCache = new ConcurrentHashMap<String, ReferenceType>();
            this.listedReferenceTypeProperties = new Properties();
            InputStream in = null;
            try {
                try {
                    in = ListedReferenceTypes.class.getResourceAsStream("/resources/listedexternaltypes/listedreferencetypes.properties");
                    if (Objects.nonNull(in)) {
                        this.listedReferenceTypeProperties.load(in);
                    }
                }
                catch (IOException e2) {
                    logger.warn("IO Exception reading listed reference type properties file: " + e2.getMessage() + ", loading properties from class properties file.");
                }
                if (!Objects.isNull(in)) break block14;
                try {
                    in = ListedReferenceTypes.class.getClassLoader().getResourceAsStream(LISTED_REFERENCE_TYPE_PROPERTIES_CLASS_PATH);
                    if (Objects.nonNull(in)) {
                        this.listedReferenceTypeProperties.load(in);
                        break block14;
                    }
                    logger.error("Unable to load listed reference type properties");
                }
                catch (IOException ex2) {
                    logger.error("IO exception reading listed reference type properties from class properties file: " + ex2.getMessage());
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        logger.warn("Unable to close listed license properties file: " + e3.getMessage());
                    }
                }
            }
        }
        this.loadReferenceTypeNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadReferenceTypeNames() {
        listedReferenceTypesModificationLock.readLock().lock();
        try {
            String[] referenceTypeNamesAr;
            String referenceTypeNamesStr = this.listedReferenceTypeProperties.getProperty(PROPERTY_LISTED_REFERENCE_TYPES);
            for (String name : referenceTypeNamesAr = referenceTypeNamesStr.split(",", -1)) {
                this.listedReferenceNames.add(name.trim());
            }
        }
        finally {
            listedReferenceTypesModificationLock.readLock().unlock();
        }
    }

    public static ListedReferenceTypes getListedReferenceTypes() {
        listedReferenceTypesModificationLock.writeLock().lock();
        try {
            if (listedReferenceTypes == null) {
                listedReferenceTypes = new ListedReferenceTypes();
            }
            ListedReferenceTypes listedReferenceTypes = ListedReferenceTypes.listedReferenceTypes;
            return listedReferenceTypes;
        }
        finally {
            listedReferenceTypesModificationLock.writeLock().unlock();
        }
    }

    public static ListedReferenceTypes resetListedReferenceTypes() {
        listedReferenceTypesModificationLock.writeLock().lock();
        try {
            ListedReferenceTypes listedReferenceTypes = ListedReferenceTypes.listedReferenceTypes = new ListedReferenceTypes();
            return listedReferenceTypes;
        }
        finally {
            listedReferenceTypesModificationLock.writeLock().unlock();
        }
    }

    public boolean isListedReferenceType(URI uri) {
        if (uri.toString().startsWith("http://spdx.org/rdf/references/")) {
            String referenceTypeName = uri.toString().substring("http://spdx.org/rdf/references/".length());
            return this.listedReferenceNames.contains(referenceTypeName);
        }
        return false;
    }

    public URI getListedReferenceUri(String listedReferenceName) throws InvalidSPDXAnalysisException {
        URI retval;
        try {
            retval = new URI("http://spdx.org/rdf/references/" + listedReferenceName);
        }
        catch (URISyntaxException e2) {
            logger.error("Error forming listed license URI", e2);
            throw new InvalidSPDXAnalysisException(listedReferenceName + " is not a valid SPDX listed reference type syntax.");
        }
        if (!this.isListedReferenceType(retval)) {
            throw new InvalidSPDXAnalysisException(listedReferenceName + " is not a valid SPDX listed reference type.");
        }
        return retval;
    }

    public ReferenceType getListedReferenceTypeByName(String listedReferenceName) throws InvalidSPDXAnalysisException {
        URI listedRefUri;
        ReferenceType oldValue;
        ReferenceType retval = (ReferenceType)this.listedReferenceTypeCache.get(listedReferenceName);
        if (retval == null && (oldValue = this.listedReferenceTypeCache.putIfAbsent(listedReferenceName, retval = new ReferenceType((listedRefUri = this.getListedReferenceUri(listedReferenceName)).toString()))) != null) {
            retval = oldValue;
        }
        return retval;
    }

    public String getListedReferenceName(URI uri) throws InvalidSPDXAnalysisException {
        if (!this.isListedReferenceType(uri)) {
            throw new InvalidSPDXAnalysisException(uri.toString() + " is not a valid URI for an SPDX listed reference type.");
        }
        return uri.toString().substring("http://spdx.org/rdf/references/".length());
    }
}

