/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.CSVWriter;
import com.opencsv.exceptions.CsvValidationException;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public abstract class AbstractSheet {
    static final int MAX_CHARACTERS_PER_CELL = Short.MAX_VALUE;
    static final char CSV_SEPARATOR_CHAR = ',';
    static final char CSV_QUOTING_CHAR = '\"';
    static final char CSV_ESCAPE_CHAR = '\\';
    static final String CSV_LINE_END = "\n";
    private static final CSVParser parser = new CSVParserBuilder().withEscapeChar('\\').withQuoteChar('\"').withSeparator(',').build();
    public static Pattern CHECKSUM_PATTERN = Pattern.compile("(\\S+):\\s+(\\S+)");
    static final String FONT_NAME = "Arial";
    protected static final short FONT_SIZE = 200;
    static final String CHECKBOX_FONT_NAME = "Wingdings 2";
    static final String CHECKBOX = "P";
    private static final short MAX_ROW_LINES = 10;
    protected CellStyle checkboxStyle;
    protected CellStyle dateStyle;
    protected CellStyle greenWrapped;
    protected CellStyle redWrapped;
    protected CellStyle yellowWrapped;
    protected Workbook workbook;
    protected Sheet sheet;
    protected int lastRowNum;
    protected int firstCellNum;
    protected int firstRowNum;
    protected IModelStore modelStore;
    protected String documentUri;
    protected ModelCopyManager copyManager;

    public AbstractSheet(Workbook workbook, String sheetName, IModelStore modelStore, @Nullable String documentUri, ModelCopyManager copyManager) {
        Objects.requireNonNull(workbook, "Missing required workbook");
        Objects.requireNonNull(sheetName, "Missing required sheetName");
        Objects.requireNonNull(modelStore, "Missing required modelStore");
        Objects.requireNonNull(copyManager, "Missing required copyManager");
        this.modelStore = modelStore;
        this.documentUri = documentUri;
        this.workbook = workbook;
        this.copyManager = copyManager;
        this.sheet = workbook.getSheet(sheetName);
        if (this.sheet != null) {
            this.firstRowNum = this.sheet.getFirstRowNum();
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            this.firstCellNum = firstRow == null ? 1 : (int)firstRow.getFirstCellNum();
            this.findLastRow();
        } else {
            this.firstRowNum = 0;
            this.lastRowNum = 0;
            this.firstCellNum = 0;
        }
        this.createStyles(workbook);
    }

    private void createStyles(Workbook wb) {
        this.checkboxStyle = wb.createCellStyle();
        this.checkboxStyle.setAlignment(HorizontalAlignment.CENTER);
        this.checkboxStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.checkboxStyle.setBorderBottom(BorderStyle.THIN);
        this.checkboxStyle.setBorderLeft(BorderStyle.THIN);
        this.checkboxStyle.setBorderRight(BorderStyle.THIN);
        this.checkboxStyle.setBorderTop(BorderStyle.THIN);
        Font checkboxFont = wb.createFont();
        checkboxFont.setFontHeight((short)200);
        checkboxFont.setFontName(CHECKBOX_FONT_NAME);
        this.checkboxStyle.setFont(checkboxFont);
        this.dateStyle = wb.createCellStyle();
        DataFormat df = wb.createDataFormat();
        this.dateStyle.setDataFormat(df.getFormat("m/d/yy h:mm"));
        this.greenWrapped = AbstractSheet.createLeftWrapStyle(wb);
        this.greenWrapped.setFillForegroundColor(IndexedColors.LIGHT_GREEN.getIndex());
        this.greenWrapped.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.greenWrapped.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.yellowWrapped = AbstractSheet.createLeftWrapStyle(wb);
        this.yellowWrapped.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        this.yellowWrapped.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.redWrapped = AbstractSheet.createLeftWrapStyle(wb);
        this.redWrapped.setFillForegroundColor(IndexedColors.RED.getIndex());
        this.redWrapped.setFillPattern(FillPatternType.SOLID_FOREGROUND);
    }

    private void findLastRow() {
        boolean done = false;
        this.lastRowNum = this.firstRowNum + 1;
        try {
            while (!done) {
                Row row = this.sheet.getRow(this.lastRowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getStringCellValue() == null || row.getCell(this.firstCellNum).getCellType() == CellType.BLANK || row.getCell(this.firstCellNum).getStringCellValue().trim().isEmpty()) {
                    --this.lastRowNum;
                    done = true;
                    continue;
                }
                ++this.lastRowNum;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Row addRow() {
        ++this.lastRowNum;
        Row row = this.sheet.createRow(this.lastRowNum);
        return row;
    }

    public void clear() {
        int i = this.lastRowNum;
        while (i > this.firstRowNum) {
            Row row = this.sheet.getRow(i);
            this.sheet.removeRow(row);
            --i;
        }
        this.lastRowNum = this.firstRowNum;
    }

    public int getFirstDataRow() {
        return this.firstRowNum + 1;
    }

    public int getNumDataRows() {
        return this.lastRowNum - this.firstRowNum;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public abstract String verify();

    public static CellStyle createHeaderStyle(Workbook wb) {
        CellStyle headerStyle = wb.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = wb.createFont();
        headerFont.setFontName(FONT_NAME);
        headerFont.setFontHeight((short)200);
        headerFont.setBold(true);
        headerStyle.setFont(headerFont);
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setWrapText(true);
        return headerStyle;
    }

    public static CellStyle createLeftWrapStyle(Workbook wb) {
        CellStyle wrapStyle = wb.createCellStyle();
        wrapStyle.setWrapText(true);
        wrapStyle.setAlignment(HorizontalAlignment.LEFT);
        wrapStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return wrapStyle;
    }

    public static CellStyle createCenterStyle(Workbook wb) {
        CellStyle centerStyle = wb.createCellStyle();
        centerStyle.setWrapText(false);
        centerStyle.setAlignment(HorizontalAlignment.CENTER);
        return centerStyle;
    }

    public void resizeRows() {
        int lastRow = this.getNumDataRows() + this.getFirstDataRow() - 1;
        int i = 0;
        while (i <= lastRow) {
            Row row = this.sheet.getRow(i);
            int lastCell = row.getLastCellNum();
            int maxNumLines = 1;
            int j = 0;
            while (j < lastCell) {
                int cellLines;
                Cell cell = row.getCell(j);
                if (cell != null && (cellLines = this.getNumWrappedLines(cell)) > maxNumLines) {
                    maxNumLines = cellLines;
                }
                ++j;
            }
            if (maxNumLines > 10) {
                maxNumLines = 10;
            }
            if (maxNumLines > 1) {
                row.setHeight((short)(this.sheet.getDefaultRowHeight() * maxNumLines));
            }
            ++i;
        }
    }

    private int getNumWrappedLines(Cell cell) {
        if (cell.getCellType() == CellType.STRING) {
            String val = cell.getStringCellValue();
            if (val == null || val.isEmpty()) {
                return 1;
            }
            CellStyle style = cell.getCellStyle();
            if (style == null || !style.getWrapText()) {
                return 1;
            }
            Font font = this.sheet.getWorkbook().getFontAt(style.getFontIndex());
            AttributedString astr = new AttributedString(val);
            java.awt.Font awtFont = new java.awt.Font(font.getFontName(), 0, font.getFontHeightInPoints());
            float cellWidth = (float)this.sheet.getColumnWidth(cell.getColumnIndex()) / 256.0f * 5.5f;
            astr.addAttribute(TextAttribute.FONT, awtFont);
            FontRenderContext context2 = new FontRenderContext(null, true, true);
            LineBreakMeasurer measurer = new LineBreakMeasurer(astr.getIterator(), context2);
            int pos = 0;
            int numLines = 0;
            while (measurer.getPosition() < val.length()) {
                pos = measurer.nextOffset(cellWidth);
                ++numLines;
                measurer.setPosition(pos);
            }
            return numLines;
        }
        return 1;
    }

    public String checksumsToString(Collection<Checksum> checksumCollection) throws InvalidSPDXAnalysisException {
        if (checksumCollection == null || checksumCollection.size() == 0) {
            return "";
        }
        Object[] checksums = checksumCollection.toArray(new Checksum[checksumCollection.size()]);
        Arrays.sort(checksums);
        StringBuilder sb = new StringBuilder(this.checksumToString((Checksum)checksums[0]));
        int i = 1;
        while (i < checksums.length) {
            sb.append(CSV_LINE_END);
            String checksum = this.checksumToString((Checksum)checksums[i]);
            sb.append(checksum);
            ++i;
        }
        return sb.toString();
    }

    public String checksumToString(Checksum checksum) throws InvalidSPDXAnalysisException {
        if (checksum == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(checksum.getAlgorithm().toString().replaceAll("_", "-"));
        sb.append(": ");
        sb.append(checksum.getValue());
        return sb.toString();
    }

    public Collection<Checksum> strToChecksums(String checksumsString) throws SpreadsheetException {
        if (checksumsString == null || checksumsString.trim().isEmpty()) {
            return new ArrayList<Checksum>();
        }
        String[] parts = checksumsString.split(CSV_LINE_END);
        ArrayList<Checksum> retval = new ArrayList<Checksum>();
        int i = 0;
        while (i < parts.length) {
            retval.add(this.parseChecksum(parts[i].trim()));
            ++i;
        }
        return retval;
    }

    public Checksum parseChecksum(String value) throws SpreadsheetException {
        ChecksumAlgorithm algorithm;
        Matcher matcher = CHECKSUM_PATTERN.matcher(value.trim());
        if (!matcher.find()) {
            throw new SpreadsheetException("Invalid checksum: " + value);
        }
        try {
            algorithm = ChecksumAlgorithm.valueOf(matcher.group(1).replaceAll("-", "_"));
        }
        catch (Exception ex) {
            algorithm = null;
        }
        if (algorithm == null) {
            throw new SpreadsheetException("Invalid checksum algorithm: " + value);
        }
        try {
            return Checksum.create(this.modelStore, this.documentUri, algorithm, matcher.group(2));
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error creating checksum for " + value, e2);
        }
    }

    /*
     * Loose catch block
     */
    public static String stringsToCsv(Collection<String> strings) {
        String retval;
        StringWriter writer = new StringWriter();
        CSVWriter csvWriter = new CSVWriter(writer, ',', '\"', '\\', CSV_LINE_END);
        csvWriter.writeNext(strings.toArray(new String[strings.size()]));
        csvWriter.flush();
        String string = retval = writer.toString().trim();
        try {
            csvWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
        catch (Exception e2) {
            try {
                csvWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "ERROR PARSING CSV Entries";
            catch (Throwable throwable) {
                try {
                    csvWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static List<String> csvToStrings(String csv) {
        StringReader reader = new StringReader(csv);
        CSVReader csvReader = new CSVReaderBuilder(reader).withCSVParser(parser).build();
        try {
            List<String> list = Arrays.asList(csvReader.readNext());
            return list;
        }
        catch (IOException e2) {
            List<String> list = Arrays.asList("I/O ERROR PARSING CSV String");
            return list;
        }
        catch (CsvValidationException e3) {
            List<String> list = Arrays.asList("CSV VALIDATION ERROR PARSING CSV String");
            return list;
        }
        finally {
            try {
                csvReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String licensesToString(Collection<AnyLicenseInfo> licenseCollection) {
        if (licenseCollection == null || licenseCollection.isEmpty()) {
            return "";
        }
        AnyLicenseInfo[] licenses = licenseCollection.toArray(new AnyLicenseInfo[licenseCollection.size()]);
        if (licenses.length == 1) {
            return licenses[0].toString();
        }
        StringBuilder sb = new StringBuilder(licenses[0].toString());
        int i = 1;
        while (i < licenses.length) {
            sb.append(", ");
            sb.append(licenses[i].toString());
            ++i;
        }
        return sb.toString();
    }
}

