/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spreadsheetstore;

import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.spreadsheetstore.AbstractSheet;
import org.spdx.spreadsheetstore.SpreadsheetException;
import org.spdx.storage.IModelStore;

public class RelationshipsSheet
extends AbstractSheet {
    static final int ID_COL = 0;
    static final int RELATIONSHIP_COL = 1;
    static final int RELATED_ID_COL = 2;
    static final int COMMENT_COL = 3;
    static final int USER_DEFINED_COL = 4;
    static final int NUM_COLS = 4;
    static final String[] HEADER_TITLES = new String[]{"SPDX Identifier A", "Relationship", "SPDX Identifier B", "Relationship Comment", "Optional User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{20, 25, 20, 70, 50};
    static final boolean[] LEFT_WRAP;
    static final boolean[] CENTER_NOWRAP;
    static final boolean[] REQUIRED;

    static {
        boolean[] blArray = new boolean[5];
        blArray[3] = true;
        blArray[4] = true;
        LEFT_WRAP = blArray;
        boolean[] blArray2 = new boolean[5];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[2] = true;
        CENTER_NOWRAP = blArray2;
        boolean[] blArray3 = new boolean[5];
        blArray3[0] = true;
        blArray3[1] = true;
        blArray3[2] = true;
        REQUIRED = blArray3;
    }

    public RelationshipsSheet(Workbook workbook, String sheetName, IModelStore modelStore, String documentUri, ModelCopyManager copyManager) {
        super(workbook, sheetName, modelStore, documentUri, copyManager);
    }

    @Override
    public String verify() {
        block8: {
            if (this.sheet != null) break block8;
            return "Worksheet for Relationships does not exist";
        }
        try {
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            int i = 0;
            while (i < 4) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().equals(HEADER_TITLES[i])) {
                    return "Column " + HEADER_TITLES[i] + " missing for Relationship worksheet";
                }
                ++i;
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null || row.getCell(this.firstCellNum).getCellType() == CellType.BLANK || row.getCell(this.firstCellNum).getCellType() == CellType.STRING && row.getCell(this.firstCellNum).getStringCellValue().trim().isEmpty()) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying Relationship worksheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        int i = 0;
        while (i < 4) {
            Cell cell = row.getCell(i);
            if (REQUIRED[i] && cell == null) {
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum()) + " in relationships sheet";
            }
            if (i == 1 && cell.getStringCellValue() != null) {
                try {
                    RelationshipType.valueOf(cell.getStringCellValue().trim());
                }
                catch (IllegalArgumentException ex) {
                    return "Invalid relationship type in row " + String.valueOf(row) + ": " + cell.getStringCellValue();
                }
            }
            ++i;
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        int i = 0;
        while (i < HEADER_TITLES.length) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
            ++i;
        }
    }

    public void add(Relationship relationship, String elementId) throws SpreadsheetException {
        Row row = this.addRow();
        if (elementId != null) {
            Cell idCell = row.createCell(0, CellType.STRING);
            idCell.setCellValue(elementId);
        }
        try {
            Optional<String> comment;
            Optional<SpdxElement> relatedElement;
            if (relationship.getRelationshipType() != null) {
                Cell relationshipCell = row.createCell(1, CellType.STRING);
                relationshipCell.setCellValue(relationship.getRelationshipType().toString());
            }
            if ((relatedElement = relationship.getRelatedSpdxElement()).isPresent()) {
                Cell relatedIdCell = row.createCell(2, CellType.STRING);
                relatedIdCell.setCellValue(relatedElement.get().getId());
            }
            if ((comment = relationship.getComment()).isPresent()) {
                Cell commentCell = row.createCell(3, CellType.STRING);
                commentCell.setCellValue(comment.get());
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting relationship fields", e2);
        }
    }

    public String getElmementId(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        return row.getCell(0).getStringCellValue();
    }

    public Relationship getRelationship(int rowNum) throws SpreadsheetException {
        SpdxElement element;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell relatedIdCell = row.getCell(2);
        String relatedId = null;
        if (relatedIdCell != null && relatedIdCell.getStringCellValue() != null) {
            relatedId = relatedIdCell.getStringCellValue();
        }
        RelationshipType type = null;
        Cell relationshipCell = row.getCell(1);
        if (relationshipCell != null && relationshipCell.getStringCellValue() != null) {
            try {
                type = RelationshipType.valueOf(relationshipCell.getStringCellValue().trim());
            }
            catch (Exception ex) {
                throw new SpreadsheetException("Invalid relationship type: " + relationshipCell.getStringCellValue().trim());
            }
        }
        Cell commentCell = row.getCell(3);
        String comment = null;
        if (commentCell != null && commentCell.getStringCellValue() != null) {
            comment = commentCell.getStringCellValue();
        }
        if (relatedId == null) {
            throw new SpreadsheetException("No related element ID for relationship");
        }
        try {
            Optional<ModelObject> mo = SpdxModelFactory.getModelObject(this.modelStore, this.documentUri, relatedId, this.copyManager);
            if (!mo.isPresent()) {
                throw new SpreadsheetException("No element found for relationship with related ID " + relatedId);
            }
            if (!(mo.get() instanceof SpdxElement)) {
                throw new SpreadsheetException("Related ID " + relatedId + " is not of type SpdxElement");
            }
            element = (SpdxElement)mo.get();
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("Error getting SpdxElement for relationship with related ID " + relatedId, e2);
        }
        try {
            return element.createRelationship(element, type, comment);
        }
        catch (InvalidSPDXAnalysisException e3) {
            throw new SpreadsheetException("Error creating relationship for related ID " + relatedId, e3);
        }
    }
}

