/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.IndividualUriValue;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.SpdxInvalidTypeException;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.TypedValue;
import org.spdx.library.model.enumerations.SpdxEnumFactory;
import org.spdx.storage.IModelStore;

public class StoredTypedItem
extends TypedValue {
    static final Logger logger = LoggerFactory.getLogger(TypedValue.class);
    private static final String NO_ID_ID = "__NO_ID__";
    static Set<String> SPDX_CLASSES = new HashSet<String>(Arrays.asList(SpdxConstants.ALL_SPDX_CLASSES));
    private ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap();
    private int referenceCount = 0;
    private final ReadWriteLock countLock = new ReentrantReadWriteLock();

    public StoredTypedItem(String documentUri, String id, String type) throws InvalidSPDXAnalysisException {
        super(id, type);
    }

    public List<String> getPropertyValueNames() {
        Iterator<Map.Entry<String, Object>> iter = this.properties.entrySet().iterator();
        ArrayList<String> retval = new ArrayList<String>();
        while (iter.hasNext()) {
            Map.Entry<String, Object> entry = iter.next();
            retval.add(entry.getKey());
        }
        return Collections.unmodifiableList(retval);
    }

    public int incReferenceCount() {
        this.countLock.writeLock().lock();
        try {
            ++this.referenceCount;
            int n = this.referenceCount;
            return n;
        }
        finally {
            this.countLock.writeLock().unlock();
        }
    }

    public int decReferenceCount() throws SpdxInvalidTypeException {
        this.countLock.writeLock().lock();
        try {
            if (this.referenceCount < 1) {
                throw new SpdxInvalidTypeException("Usage count underflow - usage count decremented more than incremented");
            }
            --this.referenceCount;
            int n = this.referenceCount;
            return n;
        }
        finally {
            this.countLock.writeLock().unlock();
        }
    }

    public int getReferenceCount() throws SpdxInvalidTypeException {
        this.countLock.readLock().lock();
        try {
            int n = this.referenceCount;
            return n;
        }
        finally {
            this.countLock.readLock().unlock();
        }
    }

    public void setValue(String propertyName, Object value) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        if (value instanceof ModelObject) {
            throw new SpdxInvalidTypeException("Can not store Model Object in store.  Convert to TypedValue first");
        }
        if (value instanceof List || value instanceof Collection) {
            throw new SpdxInvalidTypeException("Can not store list values directly.  Use addValueToCollection.");
        }
        if (!(value.getClass().isPrimitive() || value.getClass().isAssignableFrom(String.class) || value.getClass().isAssignableFrom(Boolean.class) || value.getClass().isAssignableFrom(Integer.class) || value.getClass().isAssignableFrom(TypedValue.class) || value instanceof IndividualUriValue)) {
            throw new SpdxInvalidTypeException(value.getClass().toString() + " is not a supported class to be stored.");
        }
        this.properties.put(propertyName, value);
    }

    public void clearPropertyValueList(String propertyName) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Object value = this.properties.get(propertyName);
        if (value == null) {
            return;
        }
        if (!(value instanceof ConcurrentHashMap)) {
            throw new SpdxInvalidTypeException("Trying to clear a list for non list type for property " + propertyName);
        }
        ((ConcurrentHashMap)value).clear();
    }

    public boolean addValueToList(String propertyName, Object value) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        if (value instanceof ModelObject) {
            throw new SpdxInvalidTypeException("Can not store Model Object in store.  Convert to TypedValue first");
        }
        if (!(value.getClass().isPrimitive() || value.getClass().isAssignableFrom(String.class) || value.getClass().isAssignableFrom(Boolean.class) || value.getClass().isAssignableFrom(Integer.class) || value.getClass().isAssignableFrom(TypedValue.class) || value instanceof IndividualUriValue)) {
            throw new SpdxInvalidTypeException(value.getClass().toString() + " is not a supported class to be stored.");
        }
        Object map = this.properties.get(propertyName);
        if (map == null) {
            this.properties.putIfAbsent(propertyName, new ConcurrentHashMap());
            map = this.properties.get(propertyName);
            if (map == null) {
                return true;
            }
        }
        if (!(map instanceof ConcurrentHashMap)) {
            throw new SpdxInvalidTypeException("Trying to add a list for non list type for property " + propertyName);
        }
        try {
            ConcurrentHashMap idValueMap = (ConcurrentHashMap)map;
            String id = value instanceof TypedValue ? ((TypedValue)value).getId() : NO_ID_ID;
            idValueMap.putIfAbsent(id, new ArrayList());
            ArrayList<Object> list = (ArrayList<Object>)idValueMap.get(id);
            if (list == null) {
                list = new ArrayList<Object>();
                idValueMap.putIfAbsent(id, list);
            }
            return list.add(value);
        }
        catch (Exception ex) {
            throw new SpdxInvalidTypeException("Invalid list type for " + propertyName);
        }
    }

    public boolean removeTypedValueFromList(String propertyName, TypedValue value) throws SpdxInvalidTypeException {
        Object map = this.properties.get(propertyName);
        if (map == null) {
            return false;
        }
        if (!(map instanceof ConcurrentHashMap)) {
            throw new SpdxInvalidTypeException("Trying to remove from a list for non typed value list type for property " + propertyName);
        }
        try {
            ConcurrentHashMap typedValueMap = (ConcurrentHashMap)map;
            List list = (List)typedValueMap.get(value.getId());
            if (list == null) {
                return false;
            }
            return list.remove(value);
        }
        catch (Exception ex) {
            throw new SpdxInvalidTypeException("Invalid list type for " + propertyName);
        }
    }

    public boolean removeValueFromList(String propertyName, Object value) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        Object map = this.properties.get(propertyName);
        if (map == null) {
            return false;
        }
        if (!(map instanceof ConcurrentHashMap)) {
            throw new SpdxInvalidTypeException("Trying to remove from a list for non list type for property " + propertyName);
        }
        try {
            ConcurrentHashMap idValueMap = (ConcurrentHashMap)map;
            String id = value instanceof TypedValue ? ((TypedValue)value).getId() : NO_ID_ID;
            List list = (List)idValueMap.get(id);
            if (list == null) {
                return false;
            }
            return list.remove(value);
        }
        catch (Exception ex) {
            throw new SpdxInvalidTypeException("Invalid list type for " + propertyName);
        }
    }

    public Iterator<Object> getValueList(String propertyName) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Object list = this.properties.get(propertyName);
        if (list == null) {
            return Collections.emptyIterator();
        }
        if (list instanceof ConcurrentHashMap) {
            ArrayList valueList = new ArrayList();
            for (Object value : ((ConcurrentHashMap)list).values()) {
                if (value instanceof Collection) {
                    valueList.addAll((Collection)value);
                    continue;
                }
                valueList.add(value);
            }
            return valueList.iterator();
        }
        throw new SpdxInvalidTypeException("Trying to get a list for non list type for property " + propertyName);
    }

    public Object getValue(String propertyName) {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        return this.properties.get(propertyName);
    }

    public void removeProperty(String propertyName) {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        this.properties.remove(propertyName);
    }

    public void copyValuesFrom(String fromDocumentUri, IModelStore store) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(fromDocumentUri, "From document URI can not be null");
        Objects.requireNonNull(store, "Store can not be null");
        List<String> propertyNames = store.getPropertyValueNames(fromDocumentUri, this.getId());
        for (String propertyName : propertyNames) {
            Optional<Object> value = store.getValue(fromDocumentUri, this.getId(), propertyName);
            if (!value.isPresent()) continue;
            this.setValue(propertyName, value.get());
        }
    }

    public int collectionSize(String propertyName) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Object map = this.properties.get(propertyName);
        if (map == null) {
            this.properties.putIfAbsent(propertyName, new ConcurrentHashMap());
            map = this.properties.get(propertyName);
            if (map == null) {
                return 0;
            }
        }
        if (map instanceof ConcurrentHashMap) {
            int count = 0;
            for (Object value : ((ConcurrentHashMap)map).values()) {
                if (value instanceof Collection) {
                    count += ((Collection)value).size();
                    continue;
                }
                ++count;
            }
            return count;
        }
        throw new SpdxInvalidTypeException("Trying to get size for a non list type for property " + propertyName);
    }

    public boolean collectionContains(String propertyName, Object value) throws SpdxInvalidTypeException {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Objects.requireNonNull(value, "Value can not be null");
        Object map = this.properties.get(propertyName);
        if (map == null) {
            this.properties.putIfAbsent(propertyName, new ConcurrentHashMap());
            map = this.properties.get(propertyName);
            if (map == null) {
                return false;
            }
        }
        if (map instanceof ConcurrentHashMap) {
            ConcurrentHashMap typedValueMap = (ConcurrentHashMap)map;
            String id = value instanceof TypedValue ? ((TypedValue)value).getId() : NO_ID_ID;
            List valueList = (List)typedValueMap.get(id);
            if (valueList == null) {
                return false;
            }
            return valueList.contains(value);
        }
        throw new SpdxInvalidTypeException("Trying to find contains for non list type for property " + propertyName);
    }

    public boolean isCollectionMembersAssignableTo(String propertyName, Class<?> clazz) {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Objects.requireNonNull(clazz, "Class can not be null");
        Object map = this.properties.get(propertyName);
        if (map == null) {
            return true;
        }
        if (!(map instanceof ConcurrentHashMap)) {
            return false;
        }
        ConcurrentHashMap idValueMap = (ConcurrentHashMap)map;
        for (List valueList : idValueMap.values()) {
            for (Object value : valueList) {
                if (clazz.isAssignableFrom(value.getClass())) continue;
                if (value instanceof IndividualUriValue) {
                    String uri = ((IndividualUriValue)value).getIndividualURI();
                    Enum<?> spdxEnum = SpdxEnumFactory.uriToEnum.get(uri);
                    if (!(Objects.nonNull(spdxEnum) ? !clazz.isAssignableFrom(spdxEnum.getClass()) : !"http://spdx.org/rdf/terms#noassertion".equals(uri) && !"http://spdx.org/rdf/terms#none".equals(uri))) continue;
                    return false;
                }
                if (value instanceof TypedValue) {
                    try {
                        if (clazz == TypedValue.class || clazz.isAssignableFrom(SpdxModelFactory.typeToClass(((TypedValue)value).getType()))) continue;
                        return false;
                    }
                    catch (InvalidSPDXAnalysisException e2) {
                        logger.error("Error converting typed value to class", e2);
                        return false;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public boolean isPropertyValueAssignableTo(String propertyName, Class<?> clazz) {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Objects.requireNonNull(clazz, "Class can not be null");
        Object value = this.properties.get(propertyName);
        if (value == null) {
            return false;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return true;
        }
        if (value instanceof TypedValue) {
            try {
                return clazz.isAssignableFrom(SpdxModelFactory.typeToClass(((TypedValue)value).getType()));
            }
            catch (InvalidSPDXAnalysisException e2) {
                logger.error("Error converting typed value to class", e2);
                return false;
            }
        }
        if (value instanceof IndividualUriValue) {
            String uri = ((IndividualUriValue)value).getIndividualURI();
            if ("http://spdx.org/rdf/terms#noassertion".equals(uri)) {
                return true;
            }
            if ("http://spdx.org/rdf/terms#none".equals(uri)) {
                return true;
            }
            Enum<?> spdxEnum = SpdxEnumFactory.uriToEnum.get(uri);
            if (Objects.nonNull(spdxEnum)) {
                return clazz.isAssignableFrom(spdxEnum.getClass());
            }
            return false;
        }
        return false;
    }

    public boolean isCollectionProperty(String propertyName) {
        Objects.requireNonNull(propertyName, "Property name can not be null");
        Object value = this.properties.get(propertyName);
        return value instanceof ConcurrentHashMap;
    }

    public boolean usesId(String elementId) {
        if (Objects.isNull(elementId)) {
            return false;
        }
        for (Object value : this.properties.values()) {
            if (value instanceof List && ((List)value).size() > 0 && ((List)value).get(0) instanceof TypedValue) {
                for (Object listValue : (List)value) {
                    if (!(listValue instanceof TypedValue) || !((TypedValue)listValue).getId().toLowerCase().equals(elementId.toLowerCase())) continue;
                    return true;
                }
                continue;
            }
            if (!(value instanceof TypedValue) || !((TypedValue)value).getId().toLowerCase().equals(elementId.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

