/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tag;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.Annotation;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalDocumentRef;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.ReferenceType;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxCreatorInformation;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.SpdxNoAssertionElement;
import org.spdx.library.model.SpdxNoneElement;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.SpdxPackageVerificationCode;
import org.spdx.library.model.SpdxSnippet;
import org.spdx.library.model.enumerations.AnnotationType;
import org.spdx.library.model.enumerations.ChecksumAlgorithm;
import org.spdx.library.model.enumerations.FileType;
import org.spdx.library.model.enumerations.Purpose;
import org.spdx.library.model.enumerations.ReferenceCategory;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.referencetype.ListedReferenceTypes;
import org.spdx.storage.IModelStore;
import org.spdx.tag.InvalidFileFormatException;
import org.spdx.tag.InvalidSpdxTagFileException;
import org.spdx.tag.TagValueBehavior;

public class BuildDocument
implements TagValueBehavior {
    private static Pattern EXTERNAL_DOC_REF_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)\\s+([A-Za-z0-9\\-_]+)(:|\\s)\\s*(\\S+)");
    private static Pattern RELATIONSHIP_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)");
    public static Pattern CHECKSUM_PATTERN = Pattern.compile("([A-Za-z0-9\\-_]+)(:|\\s)\\s*(\\S+)");
    private static Pattern NUMBER_RANGE_PATTERN = Pattern.compile("(\\d+):(\\d+)");
    private static Pattern EXTERNAL_REF_PATTERN = Pattern.compile("([^ ]+) ([^ ]+) (.+)");
    private Set<String> ANNOTATION_TAGS = new HashSet<String>();
    private Set<String> FILE_TAGS = new HashSet<String>();
    private Set<String> SNIPPET_TAGS = new HashSet<String>();
    private Set<String> EXTRACTED_LICENSE_TAGS = new HashSet<String>();
    private Set<String> PACKAGE_TAGS = new HashSet<String>();
    private Properties constants;
    private SpdxDocument analysis;
    private Annotation lastReviewer = null;
    private int lastReviewerLineNumber = 0;
    private ExtractedLicenseInfo lastExtractedLicense = null;
    private int lastExtractedLicenseLineNumber = 0;
    private SpdxFile lastFile = null;
    private List<String> lastFileDependencies = new ArrayList<String>();
    private int lastFileLineNumber = 0;
    private SpdxSnippet lastSnippet = null;
    private int lastSnippetLineNumber = 0;
    private DoapProject lastProject = null;
    private int lastProjectLineNumber = 0;
    private Map<String, Integer> elementIdLineNumberMap = new HashMap<String, Integer>();
    private Map<String, List<SpdxFile>> fileDependencyMap = new HashMap<String, List<SpdxFile>>();
    private Map<String, List<SpdxSnippet>> snippetDependencyMap = new HashMap<String, List<SpdxSnippet>>();
    private Map<SpdxSnippet, String> snippetByteRangeMap = new HashMap<SpdxSnippet, String>();
    private Map<SpdxSnippet, String> snippetLineRangeMap = new HashMap<SpdxSnippet, String>();
    private RelationshipWithId lastRelationship = null;
    private Map<String, Map<String, List<RelationshipWithId>>> relationships = new HashMap<String, Map<String, List<RelationshipWithId>>>();
    private AnnotationWithId lastAnnotation;
    private List<AnnotationWithId> annotations = new ArrayList<AnnotationWithId>();
    private String documentNamespace;
    private String specVersion;
    private AnyLicenseInfo dataLicense;
    private String documentName;
    private ModelCopyManager copyManager = new ModelCopyManager();
    List<String> warningMessages;
    private boolean inPackageDefinition = false;
    private boolean inFileDefinition = false;
    private boolean inSnippetDefinition = false;
    private boolean inAnnotation = false;
    private boolean inExtractedLicenseDefinition = false;
    private SpdxPackage lastPackage = null;
    private int lastPackageLineNumber = 0;
    private ExternalRef lastExternalRef = null;
    private IModelStore modelStore;
    private String lastFileId = null;
    private String lastPackageId = null;

    public BuildDocument(IModelStore modelStore, Properties constants, List<String> warnings) {
        this.constants = constants;
        this.warningMessages = warnings;
        this.modelStore = modelStore;
        this.ANNOTATION_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_DATE").trim()) + " ");
        this.ANNOTATION_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_COMMENT").trim()) + " ");
        this.ANNOTATION_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_ID").trim()) + " ");
        this.ANNOTATION_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_TYPE").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_TYPE").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_LICENSE").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_COPYRIGHT").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_CHECKSUM").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_SEEN_LICENSE").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_LIC_COMMENTS").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_COMMENT").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_DEPENDENCY").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_CONTRIBUTOR").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_NOTICE_TEXT").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_ELEMENT_ID").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_PROJECT_NAME").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_PROJECT_HOMEPAGE").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_PROJECT_URI").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_DOCUMENT_NAMESPACE").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_RELATIONSHIP").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_RELATIONSHIP_COMMENT").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATOR").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_DATE").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_COMMENT").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_ID").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_TYPE").trim()) + " ");
        this.FILE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_ATTRIBUTION_TEXT").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_SNIPPET_FROM_FILE_ID").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_SNIPPET_BYTE_RANGE").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_SNIPPET_LINE_RANGE").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_SNIPPET_CONCLUDED_LICENSE").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_SNIPPET_LIC_COMMENTS").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_SNIPPET_COPYRIGHT").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_SNIPPET_COMMENT").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_SNIPPET_NAME").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_SNIPPET_SEEN_LICENSE").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_DOCUMENT_NAMESPACE").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_RELATIONSHIP").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_RELATIONSHIP_COMMENT").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATOR").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_DATE").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_COMMENT").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_ID").trim()) + " ");
        this.SNIPPET_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_TYPE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_COMMENT").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_FILE_NAME").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_CHECKSUM").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_DOWNLOAD_URL").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_SOURCE_INFO").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_DECLARED_LICENSE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_CONCLUDED_LICENSE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_DECLARED_COPYRIGHT").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_SHORT_DESC").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_DESCRIPTION").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_VERIFICATION_CODE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_LICENSE_INFO_FROM_FILES").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_LICENSE_COMMENT").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_VERSION_INFO").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_ORIGINATOR").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_SUPPLIER").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_HOMEPAGE_URL").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_ELEMENT_ID").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_FILE_NAME").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_RELATIONSHIP").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_RELATIONSHIP_COMMENT").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATOR").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_DATE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_COMMENT").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_ID").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_ANNOTATION_TYPE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_EXTERNAL_REFERENCE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_EXTERNAL_REFERENCE_COMMENT").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_FILES_ANALYZED").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_ATTRIBUTION_TEXT").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PRIMARY_PACKAGE_PURPOSE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_BUILT_DATE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_RELEASE_DATE").trim()) + " ");
        this.PACKAGE_TAGS.add(String.valueOf(constants.getProperty("PROP_PACKAGE_VALID_UNTIL_DATE").trim()) + " ");
        this.EXTRACTED_LICENSE_TAGS.add(String.valueOf(constants.getProperty("PROP_LICENSE_TEXT").trim()) + " ");
        this.EXTRACTED_LICENSE_TAGS.add(String.valueOf(constants.getProperty("PROP_EXTRACTED_TEXT").trim()) + " ");
        this.EXTRACTED_LICENSE_TAGS.add(String.valueOf(constants.getProperty("PROP_LICENSE_COMMENT").trim()) + " ");
        this.EXTRACTED_LICENSE_TAGS.add(String.valueOf(constants.getProperty("PROP_LICENSE_NAME").trim()) + " ");
        this.EXTRACTED_LICENSE_TAGS.add(String.valueOf(constants.getProperty("PROP_SOURCE_URLS").trim()) + " ");
    }

    @Override
    public void enter() throws Exception {
    }

    @Override
    public void buildDocument(String tag, String value, int lineNumber) throws Exception {
        tag = String.valueOf(tag.trim()) + " ";
        value = BuildDocument.trim(value.trim());
        if (this.inAnnotation && this.ANNOTATION_TAGS.contains(tag)) {
            this.buildAnnotation(tag, value, this.lastAnnotation);
        } else if (this.inFileDefinition && this.FILE_TAGS.contains(tag)) {
            this.buildFile(this.lastFile, tag, value, lineNumber);
        } else if (this.inSnippetDefinition && this.SNIPPET_TAGS.contains(tag)) {
            this.buildSnippet(this.lastSnippet, tag, value, lineNumber);
        } else if (this.inPackageDefinition && this.PACKAGE_TAGS.contains(tag)) {
            this.buildPackage(this.lastPackage, tag, value, lineNumber);
        } else if (this.inExtractedLicenseDefinition && this.EXTRACTED_LICENSE_TAGS.contains(tag)) {
            this.buildExtractedLicense(this.lastExtractedLicense, tag, value, lineNumber);
        } else {
            if (this.inExtractedLicenseDefinition && this.lastExtractedLicense != null) {
                this.verifyElement(this.lastExtractedLicense.verify(), "Extracted License", this.lastExtractedLicenseLineNumber, false);
            }
            if (this.inFileDefinition) {
                this.addLastFile();
            }
            if (this.inSnippetDefinition) {
                this.addLastSnippet();
            }
            this.inAnnotation = false;
            this.inFileDefinition = false;
            this.inPackageDefinition = false;
            this.inSnippetDefinition = false;
            this.buildDocumentProperties(tag, value, lineNumber);
        }
    }

    private void buildSnippet(SpdxSnippet snippet, String tag, String value, int lineNumber) throws InvalidSpdxTagFileException, InvalidSPDXAnalysisException, InvalidLicenseStringException {
        if (snippet == null) {
            throw new InvalidSpdxTagFileException("Missing Snippet ID - An SPDX Snippet ID must be specified before the snippet properties");
        }
        if (tag.equals(this.constants.getProperty("PROP_SNIPPET_FROM_FILE_ID"))) {
            List<SpdxSnippet> snippetsWithThisAsADependency = this.snippetDependencyMap.get(value);
            if (snippetsWithThisAsADependency == null) {
                snippetsWithThisAsADependency = new ArrayList<SpdxSnippet>();
                this.snippetDependencyMap.put(value, snippetsWithThisAsADependency);
            }
            snippetsWithThisAsADependency.add(snippet);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_BYTE_RANGE"))) {
            this.snippetByteRangeMap.put(snippet, value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_LINE_RANGE"))) {
            this.snippetLineRangeMap.put(snippet, value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_CONCLUDED_LICENSE"))) {
            snippet.setLicenseConcluded(LicenseInfoFactory.parseSPDXLicenseString(value, this.modelStore, this.documentNamespace, this.copyManager));
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_LIC_COMMENTS"))) {
            snippet.setLicenseComments(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_COPYRIGHT"))) {
            snippet.setCopyrightText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_COMMENT"))) {
            snippet.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_NAME"))) {
            snippet.setName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_SEEN_LICENSE"))) {
            snippet.getLicenseInfoFromFiles().add(LicenseInfoFactory.parseSPDXLicenseString(value, this.modelStore, this.documentNamespace, this.copyManager));
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATOR"))) {
            if (this.lastAnnotation != null) {
                this.annotations.add(this.lastAnnotation);
            }
            this.inAnnotation = true;
            this.lastAnnotation = new AnnotationWithId(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP"))) {
            if (this.lastRelationship != null) {
                this.addToRelationships(this.lastRelationship);
            }
            this.lastRelationship = this.parseRelationship(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP_COMMENT"))) {
            if (this.lastRelationship == null) {
                throw new InvalidSpdxTagFileException("Relationship comment found outside of a relationship: " + value + " at line number " + lineNumber);
            }
            this.lastRelationship.setComment(value);
        } else {
            throw new InvalidSPDXAnalysisException("Error parsing snippet.  Unrecognized tag: " + tag + " at line number " + lineNumber);
        }
    }

    private void addToRelationships(RelationshipWithId relationship) {
        List<RelationshipWithId> relationshipsForRelatedId;
        Map<String, List<RelationshipWithId>> relationshipsForId = this.relationships.get(relationship.getId());
        if (Objects.isNull(relationshipsForId)) {
            relationshipsForId = new HashMap<String, List<RelationshipWithId>>();
            this.relationships.put(relationship.getId(), relationshipsForId);
        }
        if (Objects.isNull(relationshipsForRelatedId = relationshipsForId.get(relationship.getRelatedId()))) {
            relationshipsForRelatedId = new ArrayList<RelationshipWithId>();
            relationshipsForId.put(relationship.getRelatedId(), relationshipsForRelatedId);
        }
        if (!relationshipsForRelatedId.contains(relationship)) {
            relationshipsForRelatedId.add(relationship);
        }
    }

    private void verifyElement(List<String> verify, String prefix, int lineNumber) {
        this.verifyElement(verify, prefix, lineNumber, false);
    }

    private void verifyElement(List<String> verify, String prefix, int lineNumber, boolean ignoreMissingLicenseText) {
        if (!verify.isEmpty()) {
            for (String verMsg : verify) {
                if (ignoreMissingLicenseText && verMsg.contains("Missing required license text")) continue;
                boolean found = false;
                String newWarning = String.valueOf(prefix) + " at line " + lineNumber + " invalid: " + verMsg;
                for (String existingWarn : this.warningMessages) {
                    if (!existingWarn.equals(newWarning)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.warningMessages.add(newWarning);
            }
        }
    }

    private void buildExtractedLicense(ExtractedLicenseInfo license, String tag, String value, int lineNumber) throws InvalidSPDXAnalysisException {
        if (tag.equals(this.constants.getProperty("PROP_EXTRACTED_TEXT"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license text at line number " + lineNumber);
            }
            license.setExtractedText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_NAME"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license name at line number " + lineNumber);
            }
            license.setName(value);
        } else if (tag.equals(this.constants.getProperty("PROP_SOURCE_URLS"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license URL at line number " + lineNumber);
            }
            String[] values = value.split(",");
            int i = 0;
            while (i < values.length) {
                license.getSeeAlso().add(values[i].trim());
                ++i;
            }
        } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_COMMENT"))) {
            if (this.lastExtractedLicense == null) {
                throw new InvalidSpdxTagFileException("Missing Extracted License - An  extracted license ID must be provided before the license comment at line number " + lineNumber);
            }
            license.setComment(value);
        }
    }

    private void buildDocumentProperties(String tag, String value, int lineNumber) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_SPDX_VERSION"))) {
            this.specVersion = value;
            if (this.analysis != null) {
                this.analysis.setSpecVersion(value);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_SPDX_DATA_LICENSE"))) {
            try {
                this.dataLicense = LicenseInfoFactory.getListedLicenseById(value);
            }
            catch (InvalidSPDXAnalysisException ex) {
                this.dataLicense = null;
            }
            if (this.dataLicense == null) {
                this.dataLicense = new ExtractedLicenseInfo(value, "NO TEXT FOR " + value);
            }
            if (this.analysis != null) {
                this.analysis.setDataLicense(this.dataLicense);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_DOCUMENT_NAME"))) {
            this.documentName = value;
            if (this.analysis != null) {
                this.analysis.setName(value);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_DOCUMENT_NAMESPACE"))) {
            if (this.analysis != null) {
                throw new InvalidSpdxTagFileException("More than one document namespace was specified at line number " + lineNumber);
            }
            this.documentNamespace = value;
            this.analysis = new SpdxDocument(this.modelStore, this.documentNamespace, this.copyManager, true);
            if (this.specVersion != null) {
                this.analysis.setSpecVersion(this.specVersion);
            }
            if (this.dataLicense != null) {
                this.analysis.setDataLicense(this.dataLicense);
            }
            if (this.documentName != null) {
                this.analysis.setName(this.documentName);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_ELEMENT_ID"))) {
            if (!value.equals("SPDXRef-DOCUMENT")) {
                throw new InvalidSpdxTagFileException("SPDX Document " + value + " is invalid.  Document IDs must be " + "SPDXRef-DOCUMENT" + " at line number " + lineNumber);
            }
        } else if (tag.equals(this.constants.getProperty("PROP_EXTERNAL_DOC_URI"))) {
            this.checkAnalysisNull();
            this.addExternalDocRef(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP"))) {
            if (this.lastRelationship != null) {
                this.addToRelationships(this.lastRelationship);
            }
            this.lastRelationship = this.parseRelationship(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP_COMMENT"))) {
            if (this.lastRelationship == null) {
                throw new InvalidSpdxTagFileException("Relationship comment found outside of a relationship: " + value + " at line number " + lineNumber);
            }
            this.lastRelationship.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATOR"))) {
            if (this.lastAnnotation != null) {
                this.annotations.add(this.lastAnnotation);
            }
            this.inAnnotation = true;
            this.lastAnnotation = new AnnotationWithId(value, lineNumber);
        } else {
            if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_DATE"))) {
                throw new InvalidSpdxTagFileException("Annotation date found outside of an annotation: " + value + " at line number " + lineNumber);
            }
            if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_COMMENT"))) {
                throw new InvalidSpdxTagFileException("Annotation comment found outside of an annotation: " + value + " at line number " + lineNumber);
            }
            if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_ID"))) {
                throw new InvalidSpdxTagFileException("Annotation ID found outside of an annotation: " + value + " at line number " + lineNumber);
            }
            if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_TYPE"))) {
                throw new InvalidSpdxTagFileException("Annotation type found outside of an annotation: " + value + " at line number " + lineNumber);
            }
            if (tag.equals(this.constants.getProperty("PROP_CREATION_CREATOR"))) {
                this.checkAnalysisNull();
                if (this.analysis.getCreationInfo() == null) {
                    SpdxCreatorInformation creator = new SpdxCreatorInformation(this.modelStore, this.documentNamespace, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentNamespace), this.copyManager, true);
                    this.analysis.setCreationInfo(creator);
                }
                this.analysis.getCreationInfo().getCreators().add(value);
            } else if (tag.equals(this.constants.getProperty("PROP_CREATION_CREATED"))) {
                this.checkAnalysisNull();
                if (this.analysis.getCreationInfo() == null) {
                    SpdxCreatorInformation creator = new SpdxCreatorInformation(this.modelStore, this.documentNamespace, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentNamespace), this.copyManager, true);
                    this.analysis.setCreationInfo(creator);
                }
                this.analysis.getCreationInfo().setCreated(value);
            } else if (tag.equals(this.constants.getProperty("PROP_CREATION_COMMENT"))) {
                this.checkAnalysisNull();
                if (this.analysis.getCreationInfo() == null) {
                    SpdxCreatorInformation creator = new SpdxCreatorInformation(this.modelStore, this.documentNamespace, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentNamespace), this.copyManager, true);
                    this.analysis.setCreationInfo(creator);
                }
                this.analysis.getCreationInfo().setComment(value);
            } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_LIST_VERSION"))) {
                this.checkAnalysisNull();
                if (this.analysis.getCreationInfo() == null) {
                    SpdxCreatorInformation creator = new SpdxCreatorInformation(this.modelStore, this.documentNamespace, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentNamespace), this.copyManager, true);
                    this.analysis.setCreationInfo(creator);
                }
                this.analysis.getCreationInfo().setLicenseListVersion(value);
            } else if (tag.equals(this.constants.getProperty("PROP_SPDX_COMMENT"))) {
                this.checkAnalysisNull();
                this.analysis.setComment(value);
            } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_REVIEWER"))) {
                this.checkAnalysisNull();
                this.lastReviewer = new Annotation(this.modelStore, this.documentNamespace, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentNamespace), this.copyManager, true);
                this.lastReviewer.setAnnotationType(AnnotationType.REVIEW);
                this.lastReviewer.setAnnotator(value);
                this.analysis.getAnnotations().add(this.lastReviewer);
                this.warningMessages.add("Converted deprecated Reviewer to annotation for reviewer " + value);
                this.lastReviewerLineNumber = lineNumber;
                this.verifyElement(this.lastReviewer.verify(), "Reviewer", this.lastReviewerLineNumber);
            } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_DATE"))) {
                this.checkAnalysisNull();
                if (this.lastReviewer == null) {
                    throw new InvalidSpdxTagFileException("Missing Reviewer - A reviewer must be provided before a review date");
                }
                this.lastReviewer.setAnnotationDate(value);
                this.verifyElement(this.lastReviewer.verify(), "Reviewer", this.lastReviewerLineNumber);
            } else if (tag.equals(this.constants.getProperty("PROP_REVIEW_COMMENT"))) {
                this.checkAnalysisNull();
                if (this.lastReviewer == null) {
                    throw new InvalidSpdxTagFileException("Missing Reviewer - A reviewer must be provided before a review comment");
                }
                this.lastReviewer.setComment(value);
            } else if (tag.equals(this.constants.getProperty("PROP_LICENSE_ID"))) {
                this.checkAnalysisNull();
                if (value == null || !value.startsWith(SpdxConstants.NON_STD_LICENSE_ID_PRENUM)) {
                    if (LicenseInfoFactory.isSpdxListedLicenseId(value) || LicenseInfoFactory.isSpdxListedExceptionId(value)) {
                        throw new InvalidSpdxTagFileException("Attempting to redefine a listed license or listed exception with ID " + value);
                    }
                    this.warningMessages.add("Invalid SPDX Listed License ID - must start with " + SpdxConstants.NON_STD_LICENSE_ID_PRENUM + ":" + value);
                }
                if (this.inExtractedLicenseDefinition) {
                    this.verifyElement(this.lastExtractedLicense.verify(), "Extracted License", this.lastExtractedLicenseLineNumber, false);
                }
                if (this.modelStore.exists(this.documentNamespace, value)) {
                    this.lastExtractedLicense = new ExtractedLicenseInfo(this.modelStore, this.documentNamespace, value, this.copyManager, false);
                } else {
                    this.lastExtractedLicense = new ExtractedLicenseInfo(this.modelStore, this.documentNamespace, value, this.copyManager, true);
                    this.lastExtractedLicenseLineNumber = lineNumber;
                }
                this.analysis.addExtractedLicenseInfos(this.lastExtractedLicense);
                this.inExtractedLicenseDefinition = true;
            } else if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_NAME"))) {
                this.checkAnalysisNull();
                this.inPackageDefinition = true;
                this.inFileDefinition = false;
                this.inAnnotation = false;
                this.inSnippetDefinition = false;
                this.inExtractedLicenseDefinition = false;
                this.addLastPackage();
                this.lastPackage = new SpdxPackage(this.modelStore, this.documentNamespace, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentNamespace), this.copyManager, true);
                this.lastPackage.setName(value);
                this.lastPackageLineNumber = lineNumber;
            } else if (tag.equals(this.constants.getProperty("PROP_FILE_NAME"))) {
                this.checkAnalysisNull();
                this.addLastFile();
                this.inFileDefinition = true;
                this.inPackageDefinition = false;
                this.inAnnotation = false;
                this.inSnippetDefinition = false;
                this.inExtractedLicenseDefinition = false;
                this.lastFile = new SpdxFile(this.modelStore, this.documentNamespace, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentNamespace), this.copyManager, true);
                this.lastFile.setName(value);
                this.lastFileLineNumber = lineNumber;
            } else if (tag.equals(this.constants.getProperty("PROP_SNIPPET_SPDX_ID"))) {
                this.checkAnalysisNull();
                this.addLastSnippet();
                this.inSnippetDefinition = true;
                this.inFileDefinition = false;
                this.inPackageDefinition = false;
                this.inAnnotation = false;
                this.inExtractedLicenseDefinition = false;
                this.lastSnippet = new SpdxSnippet(this.modelStore, this.documentNamespace, value, this.copyManager, true);
                this.lastSnippetLineNumber = lineNumber;
            } else {
                throw new InvalidSpdxTagFileException("Expecting a definition of a file, package, license information, or document property at " + tag + value + " line number " + lineNumber);
            }
        }
    }

    private void addLastPackage() throws InvalidSPDXAnalysisException {
        if (this.lastPackage != null) {
            if (Objects.isNull(this.lastPackageId)) {
                this.warningMessages.add("Missing SPDX ID for package defined at " + this.lastPackageLineNumber);
                this.lastPackageId = this.modelStore.getNextId(IModelStore.IdType.SpdxId, this.documentNamespace);
            }
            SpdxPackage newPkg = new SpdxPackage(this.modelStore, this.documentNamespace, this.lastPackageId, this.copyManager, true);
            newPkg.copyFrom(this.lastPackage);
            this.modelStore.delete(this.documentNamespace, this.lastPackage.getId());
            this.lastPackage = newPkg;
            this.elementIdLineNumberMap.put(this.lastPackageId, this.lastPackageLineNumber);
            this.lastPackageId = null;
            this.lastPackage = null;
        }
    }

    private void addLastFile() throws InvalidSPDXAnalysisException {
        if (this.lastFile != null) {
            if (Objects.isNull(this.lastFileId)) {
                this.warningMessages.add("Missing SPDX ID for file defined at line " + this.lastFileLineNumber);
                this.lastFileId = this.modelStore.getNextId(IModelStore.IdType.SpdxId, this.documentNamespace);
            }
            SpdxFile newFile = new SpdxFile(this.modelStore, this.documentNamespace, this.lastFileId, this.copyManager, true);
            newFile.copyFrom(this.lastFile);
            this.modelStore.delete(this.documentNamespace, this.lastFile.getId());
            for (String depdendeFileName : this.lastFileDependencies) {
                this.addFileDependency(newFile, depdendeFileName);
            }
            if (this.lastPackage != null) {
                this.addToRelationships(new RelationshipWithId(this.lastPackageId, this.lastFileId, RelationshipType.CONTAINS, this.lastFileLineNumber));
            }
            this.elementIdLineNumberMap.put(this.lastFileId, this.lastFileLineNumber);
            this.lastFileDependencies.clear();
            this.lastFileId = null;
        }
        this.lastFile = null;
    }

    private void addLastSnippet() throws InvalidSPDXAnalysisException {
        if (this.lastSnippet != null) {
            this.elementIdLineNumberMap.put(this.lastSnippet.getId(), this.lastSnippetLineNumber);
        }
        this.lastSnippet = null;
    }

    private void buildAnnotation(String tag, String value, AnnotationWithId annotation) throws InvalidSPDXAnalysisException {
        if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_DATE"))) {
            annotation.setDate(value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_COMMENT"))) {
            annotation.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_ID"))) {
            annotation.setId(value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATION_TYPE"))) {
            try {
                AnnotationType annotationType = AnnotationType.valueOf(value);
                annotation.setAnnotationType(annotationType);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidSPDXAnalysisException("Invalid annotation type: " + value + " at line number " + annotation.getLineNumber());
            }
        }
    }

    private RelationshipWithId parseRelationship(String value, int lineNumber) throws InvalidSpdxTagFileException {
        Matcher matcher = RELATIONSHIP_PATTERN.matcher(value.trim());
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid relationship: " + value + " at line number " + lineNumber);
        }
        RelationshipType relationshipType = null;
        try {
            relationshipType = RelationshipType.valueOf(matcher.group(2).toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidSpdxTagFileException("Invalid relationship type: " + value + " at line number " + lineNumber);
        }
        return new RelationshipWithId(matcher.group(1), matcher.group(3), relationshipType, lineNumber);
    }

    private void checkAnalysisNull() throws InvalidSpdxTagFileException, InvalidSPDXAnalysisException, InvalidFileFormatException {
        if (this.analysis == null) {
            if (this.specVersion != null && this.specVersion.compareTo("SPDX-2.0") < 0) {
                this.analysis = new SpdxDocument(this.modelStore, this.generateDocumentNamespace(), this.copyManager, true);
            } else {
                throw new InvalidFileFormatException("The SPDX Document Namespace must be set before other SPDX document properties are set.");
            }
        }
    }

    private String generateDocumentNamespace() {
        return "http://spdx.org/documents/" + UUID.randomUUID().toString();
    }

    private void addExternalDocRef(String value, int lineNumber) throws InvalidSpdxTagFileException, InvalidSPDXAnalysisException {
        ExternalDocumentRef ref = BuildDocument.parseExternalDocumentRef(value, lineNumber, this.analysis);
        this.verifyElement(ref.verify(), "External Document Reference", lineNumber);
        this.analysis.getExternalDocumentRefs().add(ref);
    }

    public static ExternalDocumentRef parseExternalDocumentRef(String refStr, int lineNumber, SpdxDocument document) throws InvalidSPDXAnalysisException {
        Matcher matcher = EXTERNAL_DOC_REF_PATTERN.matcher(refStr.trim());
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid external document reference: " + refStr + " at line number " + lineNumber);
        }
        ChecksumAlgorithm algorithm = null;
        try {
            algorithm = ChecksumAlgorithm.valueOf(matcher.group(3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidSpdxTagFileException("Invalid checksum algorithm: " + refStr + " at line number " + lineNumber);
        }
        Checksum checksum = document.createChecksum(algorithm, matcher.group(5));
        ExternalDocumentRef ref = document.createExternalDocumentRef(matcher.group(1), matcher.group(2), checksum);
        return ref;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildPackage(SpdxPackage pkg, String tag, String value, int lineNumber) throws InvalidSPDXAnalysisException, InvalidSpdxTagFileException, InvalidLicenseStringException {
        if (tag.equals(this.constants.getProperty("PROP_ELEMENT_ID"))) {
            if (this.lastPackageId != null) {
                throw new InvalidSpdxTagFileException("SPDX ID " + this.lastPackageId + " was not consumed before new SPDX ID " + value + " was used for a package");
            }
            this.lastPackageId = value;
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_VERSION_INFO"))) {
            pkg.setVersionInfo(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_FILE_NAME"))) {
            pkg.setPackageFileName(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SUPPLIER"))) {
            pkg.setSupplier(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_ORIGINATOR"))) {
            pkg.setOriginator(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DOWNLOAD_URL"))) {
            pkg.setDownloadLocation(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_VERIFICATION_CODE"))) {
            SpdxPackageVerificationCode verificationCode = null;
            if (value.contains("(")) {
                String[] verification = value.split("\\(");
                String[] excludedFiles = verification[1].replace(")", "").replace("excludes:", "").split(",");
                ArrayList<String> excludedFilesList = new ArrayList<String>();
                int i = 0;
                while (i < excludedFiles.length) {
                    excludedFilesList.add(excludedFiles[i].trim());
                    ++i;
                }
                verificationCode = pkg.createPackageVerificationCode(verification[0].trim(), excludedFilesList);
            } else {
                verificationCode = pkg.createPackageVerificationCode(value, new ArrayList<String>());
            }
            this.verifyElement(verificationCode.verify(), "Verification Code", lineNumber);
            pkg.setPackageVerificationCode(verificationCode);
            return;
        }
        if (this.constants.getProperty("PROP_PACKAGE_CHECKSUM").startsWith(tag)) {
            Checksum checksum = BuildDocument.parseChecksum(value, lineNumber, this.analysis);
            this.verifyElement(checksum.verify(), "Package Checksum", lineNumber);
            pkg.addChecksum(checksum);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_HOMEPAGE_URL"))) {
            pkg.setHomepage(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SOURCE_INFO"))) {
            pkg.setSourceInfo(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_BUILT_DATE"))) {
            pkg.setBuiltDate(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_RELEASE_DATE"))) {
            pkg.setReleaseDate(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_VALID_UNTIL_DATE"))) {
            pkg.setValidUntilDate(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_CONCLUDED_LICENSE"))) {
            AnyLicenseInfo licenseSet = LicenseInfoFactory.parseSPDXLicenseString(value, this.modelStore, this.documentNamespace, this.copyManager);
            pkg.setLicenseConcluded(licenseSet);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_LICENSE_INFO_FROM_FILES"))) {
            AnyLicenseInfo license = LicenseInfoFactory.parseSPDXLicenseString(value, this.modelStore, this.documentNamespace, this.copyManager);
            pkg.getLicenseInfoFromFiles().add(license);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_LICENSE"))) {
            AnyLicenseInfo licenseSet = LicenseInfoFactory.parseSPDXLicenseString(value, this.modelStore, this.documentNamespace, this.copyManager);
            pkg.setLicenseDeclared(licenseSet);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_LICENSE_COMMENT"))) {
            pkg.setLicenseComments(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DECLARED_COPYRIGHT"))) {
            pkg.setCopyrightText(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_SHORT_DESC"))) {
            pkg.setSummary(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_DESCRIPTION"))) {
            pkg.setDescription(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_EXTERNAL_REFERENCE"))) {
            this.lastExternalRef = this.parseExternalRef(value, lineNumber);
            this.verifyElement(this.lastExternalRef.verify(), "External Reference", lineNumber);
            pkg.addExternalRef(this.lastExternalRef);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_EXTERNAL_REFERENCE_COMMENT"))) {
            if (this.lastExternalRef == null) {
                throw new InvalidSpdxTagFileException("External reference comment found without an external reference: " + value + " at line number " + lineNumber);
            }
            Optional<String> lastExternalRefComment = this.lastExternalRef.getComment();
            if (lastExternalRefComment.isPresent() && !lastExternalRefComment.get().isEmpty()) {
                throw new InvalidSpdxTagFileException("Second reference comment found for the same external reference: " + value + " at line number " + lineNumber);
            }
            this.lastExternalRef.setComment(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_ANNOTATOR"))) {
            if (this.lastAnnotation != null) {
                this.annotations.add(this.lastAnnotation);
            }
            this.inAnnotation = true;
            this.lastAnnotation = new AnnotationWithId(value, lineNumber);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP"))) {
            if (this.lastRelationship != null) {
                this.addToRelationships(this.lastRelationship);
            }
            this.lastRelationship = this.parseRelationship(value, lineNumber);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP_COMMENT"))) {
            if (this.lastRelationship == null) {
                throw new InvalidSpdxTagFileException("Relationship comment found outside of a relationship: " + value + " at line number " + lineNumber);
            }
            this.lastRelationship.setComment(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_FILE_NAME"))) {
            this.addLastFile();
            this.lastFile = new SpdxFile(this.modelStore, this.documentNamespace, this.modelStore.getNextId(IModelStore.IdType.Anonymous, this.documentNamespace), this.copyManager, true);
            this.lastFile.setName(value);
            this.lastFileLineNumber = lineNumber;
            this.inFileDefinition = true;
            this.inSnippetDefinition = false;
            this.inAnnotation = false;
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_SNIPPET_SPDX_ID"))) {
            this.addLastSnippet();
            this.inSnippetDefinition = true;
            this.inFileDefinition = false;
            this.inPackageDefinition = false;
            this.inAnnotation = false;
            this.lastSnippet = new SpdxSnippet(this.modelStore, this.documentNamespace, value, this.copyManager, true);
            this.elementIdLineNumberMap.put(value, lineNumber);
            this.lastSnippetLineNumber = lineNumber;
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_COMMENT"))) {
            pkg.setComment(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PACKAGE_ATTRIBUTION_TEXT"))) {
            pkg.getAttributionText().add(value);
            return;
        }
        if (tag.equals(this.constants.getProperty("PROP_PRIMARY_PACKAGE_PURPOSE"))) {
            Purpose purpose = null;
            try {
                purpose = Purpose.valueOf(value.trim());
            }
            catch (IllegalArgumentException ex) {
                try {
                    purpose = Purpose.valueOf(value.trim().toUpperCase());
                    this.warningMessages.add("Invalid Package Purpose - needs to be uppercased: " + value + " at line number " + lineNumber);
                }
                catch (IllegalArgumentException ex2) {
                    throw new InvalidSpdxTagFileException("Unknown Package Purpose: " + value + " at line number " + lineNumber);
                }
            }
            pkg.setPrimaryPurpose(purpose);
            return;
        }
        if (!tag.equals(this.constants.getProperty("PROP_PACKAGE_FILES_ANALYZED"))) throw new InvalidSpdxTagFileException("Expecting a file definition, snippet definition or a package property.  Found " + value + " at line number " + lineNumber);
        if ("TRUE".equals(value.toUpperCase())) {
            pkg.setFilesAnalyzed(true);
            return;
        } else {
            if (!"FALSE".equals(value.toUpperCase())) throw new InvalidSpdxTagFileException("Invalid value for files analyzed.  Must be 'true' or 'false'.  Found value: " + value + " at line number " + lineNumber);
            pkg.setFilesAnalyzed(false);
        }
    }

    private ExternalRef parseExternalRef(String value, int lineNumber) throws InvalidSpdxTagFileException, InvalidSPDXAnalysisException {
        Matcher matcher = EXTERNAL_REF_PATTERN.matcher(value);
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid External Ref format: " + value + " at line number " + lineNumber);
        }
        ReferenceCategory referenceCategory = null;
        try {
            referenceCategory = ReferenceCategory.valueOf(matcher.group(1).trim().replace("-", "_"));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidSpdxTagFileException("Invalid External Ref category: " + value + " at line number " + lineNumber);
        }
        ReferenceType referenceType = null;
        String tagType = matcher.group(2).trim();
        try {
            referenceType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(tagType);
        }
        catch (InvalidSPDXAnalysisException e2) {
            referenceType = null;
        }
        if (referenceType == null) {
            try {
                URI refTypeUri = null;
                refTypeUri = tagType.contains("/") || tagType.contains(":") ? new URI(tagType) : new URI(String.valueOf(this.documentNamespace) + "#" + matcher.group(2).trim());
                referenceType = new ReferenceType(refTypeUri.toString());
            }
            catch (URISyntaxException e3) {
                throw new InvalidSpdxTagFileException("Invalid External Ref type: " + value + " at line number " + lineNumber);
            }
        }
        return this.analysis.createExternalRef(referenceCategory, referenceType, matcher.group(3), null);
    }

    public static Checksum parseChecksum(String value, int lineNumber, SpdxDocument document) throws InvalidSPDXAnalysisException {
        Matcher matcher = CHECKSUM_PATTERN.matcher(value.trim());
        if (!matcher.find()) {
            throw new InvalidSpdxTagFileException("Invalid checksum: " + value + " at line number " + lineNumber);
        }
        try {
            ChecksumAlgorithm algorithm = ChecksumAlgorithm.valueOf(matcher.group(1).replaceAll("-", "_"));
            return document.createChecksum(algorithm, matcher.group(3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidSpdxTagFileException("Invalid checksum algorithm: " + value + " at line number " + lineNumber);
        }
    }

    private void buildFile(SpdxFile file, String tag, String value, int lineNumber) throws Exception {
        if (file == null) {
            if (this.FILE_TAGS.contains(tag)) {
                throw new InvalidSpdxTagFileException("Missing File Name - A file name must be specified before the file properties at line number " + lineNumber);
            }
            throw new InvalidSpdxTagFileException("Unrecognized SPDX Tag: " + tag + " at line number " + lineNumber);
        }
        if (tag.equals(this.constants.getProperty("PROP_ELEMENT_ID"))) {
            if (Objects.nonNull(this.lastFileId)) {
                throw new InvalidSpdxTagFileException("Multiple SPDX ID's defined for file at line " + lineNumber + "; old ID=" + this.lastFileId);
            }
            this.lastFileId = value;
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_TYPE"))) {
            FileType fileType = null;
            try {
                fileType = FileType.valueOf(value.trim());
            }
            catch (IllegalArgumentException ex) {
                try {
                    fileType = FileType.valueOf(value.trim().toUpperCase());
                    this.warningMessages.add("Invalid filetype - needs to be uppercased: " + value + " at line number " + lineNumber);
                }
                catch (IllegalArgumentException ex2) {
                    throw new InvalidSpdxTagFileException("Unknown file type: " + value + " at line number " + lineNumber);
                }
            }
            file.addFileType(fileType);
        } else if (this.constants.getProperty("PROP_FILE_CHECKSUM").startsWith(tag)) {
            file.addChecksum(BuildDocument.parseChecksum(value, lineNumber, this.analysis));
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_LICENSE"))) {
            AnyLicenseInfo licenseSet = LicenseInfoFactory.parseSPDXLicenseString(value, this.modelStore, this.documentNamespace, this.copyManager);
            file.setLicenseConcluded(licenseSet);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_SEEN_LICENSE"))) {
            AnyLicenseInfo fileLicense = LicenseInfoFactory.parseSPDXLicenseString(value, this.modelStore, this.documentNamespace, this.copyManager);
            file.getLicenseInfoFromFiles().add(fileLicense);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_LIC_COMMENTS"))) {
            file.setLicenseComments(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_COPYRIGHT"))) {
            file.setCopyrightText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_COMMENT"))) {
            file.setComment(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_NOTICE_TEXT"))) {
            file.setNoticeText(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_CONTRIBUTOR"))) {
            file.getFileContributors().add(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_DEPENDENCY"))) {
            this.lastFileDependencies.add(value);
        } else if (tag.equals(this.constants.getProperty("PROP_FILE_ATTRIBUTION_TEXT"))) {
            file.getAttributionText().add(value);
        } else if (tag.equals(this.constants.getProperty("PROP_ANNOTATOR"))) {
            if (this.lastAnnotation != null) {
                this.annotations.add(this.lastAnnotation);
            }
            this.inAnnotation = true;
            this.lastAnnotation = new AnnotationWithId(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP"))) {
            if (this.lastRelationship != null) {
                this.addToRelationships(this.lastRelationship);
            }
            this.lastRelationship = this.parseRelationship(value, lineNumber);
        } else if (tag.equals(this.constants.getProperty("PROP_RELATIONSHIP_COMMENT"))) {
            if (this.lastRelationship == null) {
                throw new InvalidSpdxTagFileException("Relationship comment found outside of a relationship: " + value + " at line number " + lineNumber);
            }
            this.lastRelationship.setComment(value);
        } else {
            this.buildProject(file, tag, value, lineNumber);
        }
    }

    private void addFileDependency(SpdxFile file, String dependentFileName) {
        List<SpdxFile> filesWithThisAsADependency = this.fileDependencyMap.get(dependentFileName);
        if (filesWithThisAsADependency == null) {
            filesWithThisAsADependency = new ArrayList<SpdxFile>();
            this.fileDependencyMap.put(dependentFileName, filesWithThisAsADependency);
        }
        filesWithThisAsADependency.add(file);
    }

    private void buildProject(SpdxFile file, String tag, String value, int lineNumber) throws Exception {
        if (tag.equals(this.constants.getProperty("PROP_PROJECT_NAME"))) {
            if (this.lastProject != null) {
                this.verifyElement(this.lastProject.verify(), "DOAP Project", this.lastProjectLineNumber);
            }
            this.lastProject = new DoapProject(value, file);
            this.lastProjectLineNumber = lineNumber;
        } else if (tag.equals(this.constants.getProperty("PROP_PROJECT_HOMEPAGE"))) {
            if (this.lastProject == null) {
                throw new InvalidSpdxTagFileException("Missing Project Name - A project name must be provided before the project properties at line number" + lineNumber);
            }
            this.lastProject.setHomePage(value);
        } else if (tag.equals(this.constants.getProperty("PROP_PROJECT_URI"))) {
            this.lastProject.setProjectUri(value);
        } else {
            throw new InvalidSpdxTagFileException("Unrecognized tag: " + tag + " at line number" + lineNumber);
        }
    }

    private static String trim(String value) {
        value = value.replaceAll("\u00a0", " ");
        value = value.trim();
        value = value.replaceAll("<text>", "").replaceAll("</text>", "");
        return value;
    }

    @Override
    public void exit() throws Exception {
        if (this.inExtractedLicenseDefinition && this.lastExtractedLicense != null) {
            this.verifyElement(this.lastExtractedLicense.verify(), "Extracted License", this.lastExtractedLicenseLineNumber, false);
        }
        this.addLastFile();
        this.addLastPackage();
        if (this.lastPackage != null) {
            this.elementIdLineNumberMap.put(this.lastPackage.getId(), this.lastPackageLineNumber);
        }
        this.fixFileAndSnippetDependencies();
        this.addRelationships();
        this.checkSinglePackageDefault();
        this.addAnnotations();
        this.modelStore.getAllItems(this.documentNamespace, "Package").forEach(element -> {
            if (this.modelStore.getIdType(element.getId()).equals((Object)IModelStore.IdType.Anonymous)) {
                this.warningMessages.add("Anonymous type was found for package");
            }
            if (this.elementIdLineNumberMap.containsKey(element.getId())) {
                try {
                    this.verifyElement(new SpdxPackage(this.modelStore, this.documentNamespace, element.getId(), this.copyManager, false).verify(), "Package", this.elementIdLineNumberMap.get(element.getId()));
                }
                catch (InvalidSPDXAnalysisException e2) {
                    this.warningMessages.add("Exception verifying element " + element.getId() + ": " + e2.getMessage());
                }
            }
        });
        this.modelStore.getAllItems(this.documentNamespace, "Snippet").forEach(element -> {
            if (this.elementIdLineNumberMap.containsKey(element.getId())) {
                try {
                    this.verifyElement(new SpdxSnippet(this.modelStore, this.documentNamespace, element.getId(), this.copyManager, false).verify(), "Snippet", this.elementIdLineNumberMap.get(element.getId()));
                }
                catch (InvalidSPDXAnalysisException e2) {
                    this.warningMessages.add("Exception verifying element " + element.getId() + ": " + e2.getMessage());
                }
            }
        });
        this.modelStore.getAllItems(this.documentNamespace, "File").forEach(element -> {
            if (this.elementIdLineNumberMap.containsKey(element.getId())) {
                try {
                    this.verifyElement(new SpdxFile(this.modelStore, this.documentNamespace, element.getId(), this.copyManager, false).verify(), "File", this.elementIdLineNumberMap.get(element.getId()));
                }
                catch (InvalidSPDXAnalysisException e2) {
                    this.warningMessages.add("Exception verifying element " + element.getId() + ": " + e2.getMessage());
                }
            }
        });
        List<String> analysisVerify = this.analysis.verify();
        for (String analysisVerifyMsg : analysisVerify) {
            boolean found = false;
            for (String warningMsg : this.warningMessages) {
                if (!warningMsg.contains(analysisVerifyMsg)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.warningMessages.add(analysisVerifyMsg);
        }
    }

    private void checkSinglePackageDefault() throws InvalidSPDXAnalysisException, InvalidSpdxTagFileException {
        for (Relationship relationship : this.analysis.getRelationships()) {
            if (relationship.getRelationshipType() != RelationshipType.DESCRIBES) continue;
            return;
        }
        ArrayList pkgs = new ArrayList();
        this.modelStore.getAllItems(this.documentNamespace, "Package").forEach(element -> {
            try {
                pkgs.add(new SpdxPackage(this.modelStore, this.documentNamespace, element.getId(), this.copyManager, true));
            }
            catch (InvalidSPDXAnalysisException e2) {
                this.warningMessages.add("Error adding default document describes: " + e2.getMessage());
            }
        });
        if (pkgs.size() == 0) {
            throw new InvalidSpdxTagFileException("Missing describes relationship and there is no package to create a default - see SPDX specification relationship section under DESCRIBES relationship description for more information");
        }
        Relationship describesRelationship = this.analysis.createRelationship((SpdxElement)pkgs.get(0), RelationshipType.DESCRIBES, "This describes relationship was added as a default relationship by the SPDX Tools Tag parser.");
        this.analysis.addRelationship(describesRelationship);
    }

    private void addAnnotations() throws InvalidSPDXAnalysisException {
        if (this.lastAnnotation != null) {
            this.annotations.add(this.lastAnnotation);
            this.lastAnnotation = null;
        }
        int i = 0;
        while (i < this.annotations.size()) {
            block8: {
                String id = this.annotations.get(i).getId();
                if (id == null) {
                    this.warningMessages.add("missing SPDXREF: tag in annotation " + this.annotations.get(i).getAnnotation().getComment() + " at line number " + this.annotations.get(i).getLineNumber());
                } else {
                    Optional<ModelObject> mo = SpdxModelFactory.getModelObject(this.modelStore, this.documentNamespace, id, this.copyManager);
                    if (!mo.isPresent()) {
                        this.warningMessages.add("Invalid element reference in annotation: " + id + " at line number " + this.annotations.get(i).getLineNumber());
                    } else {
                        SpdxElement element = null;
                        try {
                            element = (SpdxElement)mo.get();
                        }
                        catch (ClassCastException ex) {
                            this.warningMessages.add("Invalid element reference in annotation: " + id + " at line number " + this.annotations.get(i).getLineNumber());
                            break block8;
                        }
                        this.verifyElement(this.annotations.get(i).getAnnotation().verify(), "Annotation", this.annotations.get(i).getLineNumber());
                        element.getAnnotations().add(this.annotations.get(i).getAnnotation());
                    }
                }
            }
            ++i;
        }
    }

    private void addRelationships() throws InvalidSPDXAnalysisException {
        if (this.lastRelationship != null) {
            this.addToRelationships(this.lastRelationship);
            this.lastRelationship = null;
        }
        for (Map.Entry<String, Map<String, List<RelationshipWithId>>> entry : this.relationships.entrySet()) {
            String id = entry.getKey();
            Optional<ModelObject> mo = SpdxModelFactory.getModelObject(this.modelStore, this.documentNamespace, id, this.copyManager);
            if (!mo.isPresent()) {
                this.warningMessages.add("Invalid element reference in relationship: " + id + ".  The element itself was not defined in the SPDX document.");
                continue;
            }
            SpdxElement element = null;
            try {
                element = (SpdxElement)mo.get();
            }
            catch (ClassCastException ex) {
                this.warningMessages.add("Invalid element reference in relationship: " + id + " The element itself could not be created do to SPDX exception (" + ex.getMessage() + ").");
                continue;
            }
            HashMap<String, HashSet<RelationshipType>> existingRelationships = new HashMap<String, HashSet<RelationshipType>>();
            for (Relationship relationship : element.getRelationships()) {
                HashSet<RelationshipType> existingRelationshipTypes = (HashSet<RelationshipType>)existingRelationships.get(relationship.getId());
                if (Objects.isNull(existingRelationshipTypes)) {
                    existingRelationshipTypes = new HashSet<RelationshipType>();
                    existingRelationships.put(relationship.getId(), existingRelationshipTypes);
                }
                existingRelationshipTypes.add(relationship.getRelationshipType());
            }
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                SpdxElement relatedElement = null;
                String relatedElementId = (String)entry2.getKey();
                if ("NONE".equals(relatedElementId)) {
                    relatedElement = new SpdxNoneElement();
                } else if ("NOASSERTION".equals(relatedElementId)) {
                    relatedElement = new SpdxNoAssertionElement();
                } else {
                    Optional<ModelObject> relatedMo = SpdxModelFactory.getModelObject(this.modelStore, this.documentNamespace, relatedElementId, this.copyManager);
                    if (!relatedMo.isPresent()) {
                        this.warningMessages.add("Invalid related element reference in relationship: " + relatedElementId);
                        continue;
                    }
                    try {
                        relatedElement = (SpdxElement)relatedMo.get();
                    }
                    catch (ClassCastException ex) {
                        this.warningMessages.add("Invalid related element reference in relationship: " + id);
                        continue;
                    }
                }
                for (RelationshipWithId relwId : (List)entry2.getValue()) {
                    if (existingRelationships.containsKey(relatedElementId) && ((Set)existingRelationships.get(relatedElementId)).contains(relwId.getRelationshipType())) continue;
                    Relationship newRelationship = element.createRelationship(relatedElement, relwId.getRelationshipType(), relwId.getComment());
                    this.verifyElement(newRelationship.verify(), "Relationship", relwId.getLineNumber());
                    element.addRelationship(newRelationship);
                }
            }
        }
    }

    private void fixFileAndSnippetDependencies() throws InvalidSPDXAnalysisException, InvalidSpdxTagFileException, InvalidFileFormatException {
        Set<String> missingSnippetFileIds;
        HashMap<SpdxFile, ArrayList<SpdxFile>> filesWithDependencies = new HashMap<SpdxFile, ArrayList<SpdxFile>>();
        HashMap filesWithSnippets = new HashMap();
        this.checkAnalysisNull();
        ArrayList allFiles = new ArrayList();
        Throwable throwable = null;
        Object var5_8 = null;
        try (Stream<?> fileStream = SpdxModelFactory.getElements(this.modelStore, this.documentNamespace, this.copyManager, SpdxFile.class);){
            fileStream.forEach(file -> {
                allFiles.add(file);
                if (this.modelStore.getIdType(file.getId()).equals((Object)IModelStore.IdType.Anonymous) && this.modelStore.getIdType(file.getId()).equals((Object)IModelStore.IdType.Anonymous)) {
                    this.warningMessages.add("Anonymous type was found for file");
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int i = 0;
        while (i < allFiles.size()) {
            List<SpdxSnippet> alSnippetsWithThisFile;
            Optional<String> fileName = ((SpdxFile)allFiles.get(i)).getName();
            String name = fileName.isPresent() ? fileName.get() : "";
            List<SpdxFile> alFilesHavingThisDependency = this.fileDependencyMap.get(name);
            if (alFilesHavingThisDependency != null) {
                int j = 0;
                while (j < alFilesHavingThisDependency.size()) {
                    SpdxFile fileWithDependency = alFilesHavingThisDependency.get(j);
                    ArrayList<SpdxFile> alDepdenciesForThisFile = (ArrayList<SpdxFile>)filesWithDependencies.get(fileWithDependency);
                    if (alDepdenciesForThisFile == null) {
                        alDepdenciesForThisFile = new ArrayList<SpdxFile>();
                        filesWithDependencies.put(fileWithDependency, alDepdenciesForThisFile);
                    }
                    alDepdenciesForThisFile.add((SpdxFile)allFiles.get(i));
                    ++j;
                }
                this.fileDependencyMap.remove(name);
            }
            if ((alSnippetsWithThisFile = this.snippetDependencyMap.get(((SpdxFile)allFiles.get(i)).getId())) != null) {
                ArrayList<SpdxSnippet> snippets = new ArrayList<SpdxSnippet>();
                filesWithSnippets.put((SpdxFile)allFiles.get(i), snippets);
                for (SpdxSnippet snippet : alSnippetsWithThisFile) {
                    snippets.add(snippet);
                }
            }
            this.snippetDependencyMap.remove(((SpdxFile)allFiles.get(i)).getId());
            ++i;
        }
        for (Map.Entry entry : filesWithDependencies.entrySet()) {
            List alDependencies = (List)entry.getValue();
            if (alDependencies == null || alDependencies.size() <= 0) continue;
            SpdxFile fileWithDepdencies = (SpdxFile)entry.getKey();
            fileWithDepdencies.getFileDependency().addAll(alDependencies);
        }
        for (Map.Entry entry : filesWithSnippets.entrySet()) {
            List alSnippets = (List)entry.getValue();
            if (alSnippets == null) continue;
            for (SpdxSnippet snippet : alSnippets) {
                int end;
                int start;
                Matcher matcher;
                String value;
                snippet.setSnippetFromFile((SpdxFile)entry.getKey());
                if (this.snippetByteRangeMap.containsKey(snippet)) {
                    value = this.snippetByteRangeMap.get(snippet);
                    matcher = NUMBER_RANGE_PATTERN.matcher(value.trim());
                    if (!matcher.find()) {
                        throw new InvalidSpdxTagFileException("Invalid snippet byte range: " + value);
                    }
                    start = 0;
                    try {
                        start = Integer.parseInt(matcher.group(1));
                    }
                    catch (Exception ex) {
                        throw new InvalidSpdxTagFileException("Non integer start to snippet byte offset: " + value);
                    }
                    end = 0;
                    try {
                        end = Integer.parseInt(matcher.group(2));
                    }
                    catch (Exception ex) {
                        throw new InvalidSpdxTagFileException("Non integer end to snippet byte offset: " + value);
                    }
                    snippet.setByteRange(start, end);
                }
                if (!this.snippetLineRangeMap.containsKey(snippet)) continue;
                value = this.snippetLineRangeMap.get(snippet);
                matcher = NUMBER_RANGE_PATTERN.matcher(value.trim());
                if (!matcher.find()) {
                    throw new InvalidSpdxTagFileException("Invalid snippet line range: " + value);
                }
                start = 0;
                try {
                    start = Integer.parseInt(matcher.group(1));
                }
                catch (Exception ex) {
                    throw new InvalidSpdxTagFileException("Non integer start to snippet line offset: " + value);
                }
                end = 0;
                try {
                    end = Integer.parseInt(matcher.group(2));
                }
                catch (Exception ex) {
                    throw new InvalidSpdxTagFileException("Non integer end to snippet line offset: " + value);
                }
                snippet.setLineRange(start, end);
            }
        }
        Set<String> missingDependencies = this.fileDependencyMap.keySet();
        if (missingDependencies != null && missingDependencies.size() > 0) {
            this.warningMessages.add("The following file names were listed as file dependencies but were not found in the list of files:");
            Iterator<String> missingIter = missingDependencies.iterator();
            while (missingIter.hasNext()) {
                this.warningMessages.add("\t" + missingIter.next());
            }
        }
        if ((missingSnippetFileIds = this.snippetDependencyMap.keySet()) != null && missingSnippetFileIds.size() > 0) {
            this.warningMessages.add("The following file IDs were listed as files for snippets but were not found in the list of files:");
            Iterator<String> missingIter = missingSnippetFileIds.iterator();
            while (missingIter.hasNext()) {
                this.warningMessages.add("\t" + missingIter.next());
            }
        }
    }

    public String getDocumentUri() {
        return this.documentNamespace;
    }

    private class AnnotationWithId {
        private Annotation annotation;
        private String id;
        private int lineNumber;

        private AnnotationWithId(String annotator, int lineNumber) throws InvalidSPDXAnalysisException {
            this.annotation = new Annotation(BuildDocument.this.modelStore, BuildDocument.this.documentNamespace, BuildDocument.this.modelStore.getNextId(IModelStore.IdType.Anonymous, BuildDocument.this.documentNamespace), BuildDocument.this.copyManager, true);
            this.annotation.setAnnotator(annotator);
            this.lineNumber = lineNumber;
        }

        public void setAnnotator(String annotator) throws InvalidSPDXAnalysisException {
            this.annotation.setAnnotator(annotator);
        }

        public void setDate(String date2) throws InvalidSPDXAnalysisException {
            this.annotation.setAnnotationDate(date2);
        }

        public void setAnnotationType(AnnotationType annotationType) throws InvalidSPDXAnalysisException {
            this.annotation.setAnnotationType(annotationType);
        }

        public void setComment(String comment) throws InvalidSPDXAnalysisException {
            this.annotation.setComment(comment);
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    private class DoapProject {
        Relationship relationship;
        SpdxPackage pkg;

        public DoapProject(String projectName, SpdxFile file) throws InvalidSPDXAnalysisException {
            this.pkg = new SpdxPackage(BuildDocument.this.modelStore, BuildDocument.this.documentNamespace, BuildDocument.this.modelStore.getNextId(IModelStore.IdType.SpdxId, BuildDocument.this.documentNamespace), BuildDocument.this.copyManager, true);
            this.pkg.setName(projectName);
            this.pkg.setComment("This package was created to replace a deprecated DoapProject");
            this.relationship = file.createRelationship(this.pkg, RelationshipType.GENERATED_FROM, "This relationship was translated from an deprecated ArtifactOf");
            file.getRelationships().add(this.relationship);
        }

        public List<String> verify() {
            return this.relationship.verify();
        }

        public void setHomePage(String homePage) throws InvalidSPDXAnalysisException {
            this.pkg.setHomepage(homePage);
        }

        public void setProjectUri(String projectUri) throws InvalidSPDXAnalysisException {
            if (!this.pkg.getHomepage().isPresent()) {
                this.pkg.setHomepage(projectUri);
            }
        }
    }

    private static class RelationshipWithId {
        private String id;
        private String relatedId;
        private RelationshipType relationshipType;
        private String comment;
        private int lineNumber;

        public RelationshipWithId(String id, String relatedId, RelationshipType relationshipType, int lineNumber) {
            this.id = id;
            this.relatedId = relatedId;
            this.relationshipType = relationshipType;
            this.lineNumber = lineNumber;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getId() {
            return this.id;
        }

        public String getRelatedId() {
            return this.relatedId;
        }

        public RelationshipType getRelationshipType() {
            return this.relationshipType;
        }

        public String getComment() {
            return this.comment;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RelationshipWithId)) {
                return false;
            }
            RelationshipWithId compare = (RelationshipWithId)o;
            return Objects.equals(this.id, compare.getId()) && Objects.equals(this.relatedId, compare.getRelatedId()) && Objects.equals(this.relationshipType, compare.getRelationshipType());
        }

        public int hashCode() {
            return 0x4F ^ this.id.hashCode() ^ this.relatedId.hashCode() ^ this.relationshipType.hashCode();
        }
    }
}

