/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.utility.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.Checksum;
import org.spdx.library.model.ExternalRef;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxFile;
import org.spdx.library.model.SpdxItem;
import org.spdx.library.model.SpdxPackage;
import org.spdx.utility.compare.LicenseCompareHelper;
import org.spdx.utility.compare.SpdxCompareException;
import org.spdx.utility.compare.SpdxComparer;
import org.spdx.utility.compare.SpdxExternalRefDifference;
import org.spdx.utility.compare.SpdxFileDifference;
import org.spdx.utility.compare.SpdxItemComparer;

public class SpdxPackageComparer
extends SpdxItemComparer {
    private boolean inProgress = false;
    private boolean differenceFound = false;
    private boolean packageVersionsEquals = true;
    private boolean packageFilenamesEquals = true;
    private boolean packageSuppliersEquals = true;
    private boolean packageDownloadLocationsEquals = true;
    private boolean packageVerificationCodesEquals = true;
    private boolean packageChecksumsEquals = true;
    private boolean packageSourceInfosEquals = true;
    private boolean declaredLicensesEquals = true;
    private boolean packageSummaryEquals = true;
    private boolean packageDescriptionsEquals = true;
    private boolean packageOriginatorsEqual = true;
    private boolean packageHomePagesEquals = true;
    private boolean packageFilesEquals = true;
    private boolean filesAnalyzedEquals = true;
    private boolean externalRefsEquals = true;
    private Map<SpdxDocument, Map<SpdxDocument, List<Checksum>>> uniqueChecksums = new HashMap<SpdxDocument, Map<SpdxDocument, List<Checksum>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<SpdxFile>>> uniqueFiles = new HashMap<SpdxDocument, Map<SpdxDocument, List<SpdxFile>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<SpdxFileDifference>>> fileDifferences = new HashMap<SpdxDocument, Map<SpdxDocument, List<SpdxFileDifference>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<ExternalRef>>> uniqueExternalRefs = new HashMap<SpdxDocument, Map<SpdxDocument, List<ExternalRef>>>();
    private Map<SpdxDocument, Map<SpdxDocument, List<SpdxExternalRefDifference>>> externalRefDifferences = new HashMap<SpdxDocument, Map<SpdxDocument, List<SpdxExternalRefDifference>>>();
    private Comparator<? super ExternalRef> externalRefTypeNameComparator = new Comparator<ExternalRef>(){

        @Override
        public int compare(ExternalRef arg0, ExternalRef arg1) {
            if (arg0 == null) {
                if (arg1 == null) {
                    return 0;
                }
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            try {
                if (arg0.getReferenceType() == null) {
                    if (arg1.getReferenceType() != null) {
                        return -1;
                    }
                } else {
                    int retval = arg0.getReferenceType().compareTo(arg1.getReferenceType());
                    if (retval != 0) {
                        return retval;
                    }
                }
            }
            catch (InvalidSPDXAnalysisException retval) {
                // empty catch block
            }
            try {
                if (arg0.getReferenceLocator() == null) {
                    if (arg1.getReferenceLocator() == null) {
                        return 0;
                    }
                    return -1;
                }
                return arg0.getReferenceLocator().compareTo(arg1.getReferenceLocator());
            }
            catch (InvalidSPDXAnalysisException e2) {
                return -1;
            }
        }
    };

    public SpdxPackageComparer(Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) {
        super(extractedLicenseIdMap);
    }

    public void addDocumentPackage(SpdxDocument spdxDocument, SpdxPackage spdxPackage) throws SpdxCompareException, InvalidSPDXAnalysisException {
        this.checkInProgress();
        Optional<String> packageName = spdxPackage.getName();
        if (this.name == null && packageName.isPresent()) {
            this.name = packageName.get();
        } else if (!Objects.equals(this.name, packageName.get())) {
            throw new SpdxCompareException("Names do not match for item being added to comparer: " + packageName + ", expecting " + this.name);
        }
        this.inProgress = true;
        Iterator iter = this.documentItem.entrySet().iterator();
        SpdxPackage pkg2 = null;
        Map licenseXlationMap = null;
        while (iter.hasNext() && pkg2 == null) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof SpdxPackage)) continue;
            pkg2 = (SpdxPackage)entry.getValue();
            licenseXlationMap = (Map)((Map)this.extractedLicenseIdMap.get(spdxDocument)).get(entry.getKey());
        }
        if (pkg2 != null) {
            Optional<String> v2;
            Optional<String> v1 = spdxPackage.getVersionInfo();
            if (!SpdxComparer.stringsEqual(v1, v2 = pkg2.getVersionInfo())) {
                this.packageVersionsEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getPackageFileName(), pkg2.getPackageFileName())) {
                this.packageFilenamesEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getSupplier(), pkg2.getSupplier())) {
                this.packageSuppliersEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getOriginator(), pkg2.getOriginator())) {
                this.packageOriginatorsEqual = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getDownloadLocation(), pkg2.getDownloadLocation())) {
                this.packageDownloadLocationsEquals = false;
                this.differenceFound = true;
            }
            try {
                if (!SpdxComparer.compareVerificationCodes(spdxPackage.getPackageVerificationCode(), pkg2.getPackageVerificationCode())) {
                    this.packageVerificationCodesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e2) {
                throw new SpdxCompareException("SPDX error getting package verification codes: " + e2.getMessage(), e2);
            }
            try {
                this.compareNewPackageChecksums(spdxDocument, spdxPackage.getChecksums());
            }
            catch (InvalidSPDXAnalysisException e3) {
                throw new SpdxCompareException("SPDX error getting package checksums: " + e3.getMessage(), e3);
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getSourceInfo(), pkg2.getSourceInfo())) {
                this.packageSourceInfosEquals = false;
                this.differenceFound = true;
            }
            try {
                if (!LicenseCompareHelper.isLicenseEqual(spdxPackage.getLicenseDeclared(), pkg2.getLicenseDeclared(), licenseXlationMap)) {
                    this.declaredLicensesEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e4) {
                throw new SpdxCompareException("SPDX error getting declared license: " + e4.getMessage(), e4);
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getSummary(), pkg2.getSummary())) {
                this.packageSummaryEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getDescription(), pkg2.getDescription())) {
                this.packageDescriptionsEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxPackage.getHomepage(), pkg2.getHomepage())) {
                this.packageHomePagesEquals = false;
                this.differenceFound = true;
            }
            try {
                if (spdxPackage.isFilesAnalyzed() != pkg2.isFilesAnalyzed()) {
                    this.filesAnalyzedEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e5) {
                throw new SpdxCompareException("SPDX error getting filesAnalyzed: " + e5.getMessage(), e5);
            }
            try {
                this.compareNewPackageFiles(spdxDocument, spdxPackage.getFiles());
            }
            catch (InvalidSPDXAnalysisException e6) {
                throw new SpdxCompareException("SPDX error getting package files: " + e6.getMessage(), e6);
            }
            try {
                this.compareNewPackageExternalRefs(spdxDocument, spdxPackage.getExternalRefs());
            }
            catch (InvalidSPDXAnalysisException e7) {
                throw new SpdxCompareException("SPDX error getting package external refs: " + e7.getMessage(), e7);
            }
        }
        this.inProgress = false;
        super.addDocumentItem(spdxDocument, spdxPackage);
    }

    private void compareNewPackageExternalRefs(SpdxDocument spdxDocument, Collection<ExternalRef> externalRefCollection) throws InvalidSPDXAnalysisException {
        Map<SpdxDocument, List<SpdxExternalRefDifference>> docExternalRefDiffs;
        Object[] externalRefs = externalRefCollection.toArray(new ExternalRef[externalRefCollection.size()]);
        Arrays.sort(externalRefs);
        Map<SpdxDocument, List<ExternalRef>> docUniqueExternalRefs = this.uniqueExternalRefs.get(spdxDocument);
        if (docUniqueExternalRefs == null) {
            docUniqueExternalRefs = new HashMap<SpdxDocument, List<ExternalRef>>();
            this.uniqueExternalRefs.put(spdxDocument, docUniqueExternalRefs);
        }
        if ((docExternalRefDiffs = this.externalRefDifferences.get(spdxDocument)) == null) {
            docExternalRefDiffs = new HashMap<SpdxDocument, List<SpdxExternalRefDifference>>();
            this.externalRefDifferences.put(spdxDocument, docExternalRefDiffs);
        }
        for (Map.Entry entry : this.documentItem.entrySet()) {
            if (!(entry.getValue() instanceof SpdxPackage)) continue;
            Collection<ExternalRef> compareExternalRefCollection = ((SpdxPackage)entry.getValue()).getExternalRefs();
            Object[] compareExternalRefs = compareExternalRefCollection.toArray(new ExternalRef[compareExternalRefCollection.size()]);
            Arrays.sort(compareExternalRefs);
            List<SpdxExternalRefDifference> externalRefDifferences = this.findExternalRefDifferences(spdxDocument, (SpdxDocument)entry.getKey(), (ExternalRef[])externalRefs, (ExternalRef[])compareExternalRefs);
            if (externalRefDifferences.size() > 0) {
                this.externalRefsEquals = false;
                this.differenceFound = true;
            }
            docExternalRefDiffs.put((SpdxDocument)entry.getKey(), externalRefDifferences);
            Map<SpdxDocument, List<SpdxExternalRefDifference>> compareExternalRefDiffs = this.externalRefDifferences.get(entry.getKey());
            if (compareExternalRefDiffs == null) {
                compareExternalRefDiffs = new HashMap<SpdxDocument, List<SpdxExternalRefDifference>>();
                this.externalRefDifferences.put((SpdxDocument)entry.getKey(), compareExternalRefDiffs);
            }
            compareExternalRefDiffs.put(spdxDocument, externalRefDifferences);
            List<ExternalRef> uniqueRefs = this.findUniqueExternalRefs((ExternalRef[])externalRefs, (ExternalRef[])compareExternalRefs);
            if (uniqueRefs.size() > 0) {
                this.externalRefsEquals = false;
                this.differenceFound = true;
            }
            this.uniqueExternalRefs.put((SpdxDocument)entry.getKey(), docUniqueExternalRefs);
            Map<SpdxDocument, List<ExternalRef>> compareUniqueRefs = this.uniqueExternalRefs.get(entry.getKey());
            if (compareUniqueRefs == null) {
                compareUniqueRefs = new HashMap<SpdxDocument, List<ExternalRef>>();
                this.uniqueExternalRefs.put((SpdxDocument)entry.getKey(), compareUniqueRefs);
            }
            if ((uniqueRefs = this.findUniqueExternalRefs((ExternalRef[])compareExternalRefs, (ExternalRef[])externalRefs)).size() > 0) {
                this.externalRefsEquals = false;
                this.differenceFound = true;
            }
            compareUniqueRefs.put(spdxDocument, uniqueRefs);
        }
    }

    private List<ExternalRef> findUniqueExternalRefs(ExternalRef[] externalRefsA, ExternalRef[] externalRefsB) throws InvalidSPDXAnalysisException {
        int bIndex = 0;
        int aIndex = 0;
        ArrayList<ExternalRef> alRetval = new ArrayList<ExternalRef>();
        while (aIndex < externalRefsA.length) {
            if (bIndex >= externalRefsB.length) {
                alRetval.add(externalRefsA[aIndex]);
                ++aIndex;
                continue;
            }
            int compareVal = this.externalRefTypeNameComparator.compare(externalRefsA[aIndex], externalRefsB[bIndex]);
            if (compareVal == 0) {
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compareVal > 0) {
                ++bIndex;
                continue;
            }
            alRetval.add(externalRefsA[aIndex]);
            ++aIndex;
        }
        return alRetval;
    }

    private List<SpdxExternalRefDifference> findExternalRefDifferences(SpdxDocument spdxDocument, SpdxDocument key, ExternalRef[] externalRefsA, ExternalRef[] externalRefsB) throws InvalidSPDXAnalysisException {
        ArrayList<SpdxExternalRefDifference> retval = new ArrayList<SpdxExternalRefDifference>();
        int aIndex = 0;
        int bIndex = 0;
        Arrays.sort(externalRefsA, this.externalRefTypeNameComparator);
        Arrays.sort(externalRefsB, this.externalRefTypeNameComparator);
        while (aIndex < externalRefsA.length && bIndex < externalRefsB.length) {
            int compare = this.externalRefTypeNameComparator.compare(externalRefsA[aIndex], externalRefsB[bIndex]);
            if (compare == 0) {
                if (!Objects.equals(externalRefsA[aIndex].getComment(), externalRefsB[bIndex].getComment()) || !Objects.equals(externalRefsA[aIndex].getReferenceCategory(), externalRefsB[bIndex].getReferenceCategory())) {
                    retval.add(new SpdxExternalRefDifference(externalRefsA[aIndex], externalRefsB[bIndex]));
                }
                ++aIndex;
                ++bIndex;
                continue;
            }
            if (compare > 0) {
                ++bIndex;
                continue;
            }
            ++aIndex;
        }
        return retval;
    }

    private void compareNewPackageFiles(SpdxDocument spdxDocument, Collection<SpdxFile> filesCollection) throws SpdxCompareException, InvalidSPDXAnalysisException {
        Map<SpdxDocument, List<SpdxFileDifference>> docDifferentFiles;
        Object[] files = filesCollection.toArray(new SpdxFile[filesCollection.size()]);
        Arrays.sort(files);
        Map<SpdxDocument, List<SpdxFile>> docUniqueFiles = this.uniqueFiles.get(spdxDocument);
        if (docUniqueFiles == null) {
            docUniqueFiles = new HashMap<SpdxDocument, List<SpdxFile>>();
            this.uniqueFiles.put(spdxDocument, docUniqueFiles);
        }
        if ((docDifferentFiles = this.fileDifferences.get(spdxDocument)) == null) {
            docDifferentFiles = new HashMap<SpdxDocument, List<SpdxFileDifference>>();
            this.fileDifferences.put(spdxDocument, docDifferentFiles);
        }
        for (Map.Entry entry : this.documentItem.entrySet()) {
            if (!(entry.getValue() instanceof SpdxPackage)) continue;
            Collection<SpdxFile> compareFilesCollection = ((SpdxPackage)entry.getValue()).getFiles();
            Object[] compareFiles = compareFilesCollection.toArray(new SpdxFile[compareFilesCollection.size()]);
            Arrays.sort(compareFiles);
            List<SpdxFileDifference> fileDifferences = SpdxComparer.findFileDifferences(spdxDocument, (SpdxDocument)entry.getKey(), (SpdxFile[])files, (SpdxFile[])compareFiles, this.extractedLicenseIdMap);
            if (fileDifferences.size() > 0) {
                this.packageFilesEquals = false;
                this.differenceFound = true;
            }
            docDifferentFiles.put((SpdxDocument)entry.getKey(), fileDifferences);
            Map<SpdxDocument, List<SpdxFileDifference>> compareDifferentFiles = this.fileDifferences.get(entry.getKey());
            if (compareDifferentFiles == null) {
                compareDifferentFiles = new HashMap<SpdxDocument, List<SpdxFileDifference>>();
                this.fileDifferences.put((SpdxDocument)entry.getKey(), compareDifferentFiles);
            }
            compareDifferentFiles.put(spdxDocument, fileDifferences);
            List<SpdxFile> uniqueFiles = SpdxComparer.findUniqueFiles((SpdxFile[])files, (SpdxFile[])compareFiles);
            if (uniqueFiles.size() > 0) {
                this.packageFilesEquals = false;
                this.differenceFound = true;
            }
            docUniqueFiles.put((SpdxDocument)entry.getKey(), uniqueFiles);
            Map<SpdxDocument, List<SpdxFile>> compareUniqueFiles = this.uniqueFiles.get(entry.getKey());
            if (compareUniqueFiles == null) {
                compareUniqueFiles = new HashMap<SpdxDocument, List<SpdxFile>>();
                this.uniqueFiles.put((SpdxDocument)entry.getKey(), compareUniqueFiles);
            }
            if ((uniqueFiles = SpdxComparer.findUniqueFiles((SpdxFile[])compareFiles, (SpdxFile[])files)).size() > 0) {
                this.packageFilesEquals = false;
                this.differenceFound = true;
            }
            compareUniqueFiles.put(spdxDocument, uniqueFiles);
        }
    }

    private void compareNewPackageChecksums(SpdxDocument spdxDocument, Collection<Checksum> checksums) throws SpdxCompareException {
        try {
            HashMap<SpdxDocument, List<Checksum>> docUniqueChecksums = new HashMap<SpdxDocument, List<Checksum>>();
            this.uniqueChecksums.put(spdxDocument, docUniqueChecksums);
            for (Map.Entry entry : this.documentItem.entrySet()) {
                if (!(entry.getValue() instanceof SpdxPackage)) continue;
                Collection<Checksum> compareChecksums = ((SpdxPackage)entry.getValue()).getChecksums();
                List<Checksum> uniqueChecksums = SpdxComparer.findUniqueChecksums(checksums, compareChecksums);
                if (uniqueChecksums.size() > 0) {
                    this.packageChecksumsEquals = false;
                    this.differenceFound = true;
                }
                docUniqueChecksums.put((SpdxDocument)entry.getKey(), uniqueChecksums);
                Map<SpdxDocument, List<Checksum>> compareUniqueChecksums = this.uniqueChecksums.get(entry.getKey());
                if (compareUniqueChecksums == null) {
                    compareUniqueChecksums = new HashMap<SpdxDocument, List<Checksum>>();
                    this.uniqueChecksums.put((SpdxDocument)entry.getKey(), compareUniqueChecksums);
                }
                if ((uniqueChecksums = SpdxComparer.findUniqueChecksums(compareChecksums, checksums)).size() > 0) {
                    this.packageChecksumsEquals = false;
                    this.differenceFound = true;
                }
                compareUniqueChecksums.put(spdxDocument, uniqueChecksums);
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpdxCompareException("SPDX error getting package checksums: " + e2.getMessage(), e2);
        }
    }

    @Override
    public boolean isInProgress() {
        return this.inProgress;
    }

    @Override
    public boolean isDifferenceFound() throws SpdxCompareException {
        this.checkInProgress();
        return this.differenceFound || super.isDifferenceFound();
    }

    @Override
    protected void checkInProgress() throws SpdxCompareException {
        if (this.inProgress) {
            throw new SpdxCompareException("File compare in progress - can not obtain compare results until compare has completed");
        }
        super.checkInProgress();
    }

    public boolean isPackageVersionsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageVersionsEquals;
    }

    public boolean isPackageFilenamesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageFilenamesEquals;
    }

    public boolean isPackageSuppliersEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageSuppliersEquals;
    }

    public boolean isPackageDownloadLocationsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageDownloadLocationsEquals;
    }

    public boolean isPackageVerificationCodesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageVerificationCodesEquals;
    }

    public boolean isFilesAnalyzedEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.filesAnalyzedEquals;
    }

    public boolean isPackageChecksumsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageChecksumsEquals;
    }

    public boolean isPackageSourceInfosEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageSourceInfosEquals;
    }

    public boolean isDeclaredLicensesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.declaredLicensesEquals;
    }

    public boolean isPackageSummaryEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageSummaryEquals;
    }

    public boolean isPackageDescriptionsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageDescriptionsEquals;
    }

    public boolean isPackageOriginatorsEqual() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageOriginatorsEqual;
    }

    public boolean isPackageHomePagesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageHomePagesEquals;
    }

    public boolean isExternalRefsEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.externalRefsEquals;
    }

    public SpdxPackage getDocPackage(SpdxDocument document) throws SpdxCompareException {
        SpdxItem retItem = (SpdxItem)this.documentItem.get(document);
        if (retItem != null && retItem instanceof SpdxPackage) {
            return (SpdxPackage)retItem;
        }
        return null;
    }

    public List<Checksum> getUniqueChecksums(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, List<Checksum>> uniqueMap = this.uniqueChecksums.get(docA);
        if (uniqueMap == null) {
            return new ArrayList<Checksum>();
        }
        List<Checksum> retval = uniqueMap.get(docB);
        if (retval == null) {
            return new ArrayList<Checksum>();
        }
        return retval;
    }

    public List<ExternalRef> getUniqueExternalRefs(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, List<ExternalRef>> uniqueMap = this.uniqueExternalRefs.get(docA);
        if (uniqueMap == null) {
            return new ArrayList<ExternalRef>();
        }
        List<ExternalRef> retval = uniqueMap.get(docB);
        if (retval == null) {
            return new ArrayList<ExternalRef>();
        }
        return retval;
    }

    public List<SpdxExternalRefDifference> getExternalRefDifferences(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, List<SpdxExternalRefDifference>> externalRefDiffMap = this.externalRefDifferences.get(docA);
        if (externalRefDiffMap == null) {
            return new ArrayList<SpdxExternalRefDifference>();
        }
        List<SpdxExternalRefDifference> retval = externalRefDiffMap.get(docB);
        if (retval == null) {
            return new ArrayList<SpdxExternalRefDifference>();
        }
        return retval;
    }

    public boolean isPackageFilesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.packageFilesEquals;
    }

    public List<SpdxFileDifference> getFileDifferences(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, List<SpdxFileDifference>> uniqueMap = this.fileDifferences.get(docA);
        if (uniqueMap == null) {
            return new ArrayList<SpdxFileDifference>();
        }
        List<SpdxFileDifference> retval = uniqueMap.get(docB);
        if (retval == null) {
            return new ArrayList<SpdxFileDifference>();
        }
        return retval;
    }

    public List<SpdxFile> getUniqueFiles(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, List<SpdxFile>> uniqueMap = this.uniqueFiles.get(docA);
        if (uniqueMap == null) {
            return new ArrayList<SpdxFile>();
        }
        List<SpdxFile> retval = uniqueMap.get(docB);
        if (retval == null) {
            return new ArrayList<SpdxFile>();
        }
        return retval;
    }

    public String getPackageName() throws SpdxCompareException {
        this.checkInProgress();
        return this.name;
    }

    public int getNumPackages() throws SpdxCompareException {
        this.checkInProgress();
        return this.documentItem.size();
    }
}

