/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.cdx2spdx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cyclonedx.BomParserFactory;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.model.Bom;
import org.cyclonedx.parsers.Parser;
import org.spdx.cdx2spdx.CycloneConversionException;
import org.spdx.cdx2spdx.CycloneSpdxConverter;
import org.spdx.cdx2spdx.InvalidFileNameException;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.spreadsheetstore.SpreadsheetStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.tagvaluestore.TagValueStore;

public class CycloneToSpdx {
    static final int ERROR_STATUS = 1;
    static final String VERSION = "0.0.3";
    static Map<String, SerFileType> EXT_TO_FILETYPE;

    static {
        HashMap<String, SerFileType> temp = new HashMap<String, SerFileType>();
        temp.put("json", SerFileType.JSON);
        temp.put("rdf.xml", SerFileType.RDFXML);
        temp.put("rdf", SerFileType.RDFXML);
        temp.put("xml", SerFileType.XML);
        temp.put("xls", SerFileType.XLS);
        temp.put("xlsx", SerFileType.XLSX);
        temp.put("yaml", SerFileType.YAML);
        temp.put("tag", SerFileType.TAG);
        temp.put("spdx", SerFileType.TAG);
        temp.put("yml", SerFileType.YAML);
        EXT_TO_FILETYPE = Collections.unmodifiableMap(temp);
    }

    public static ISerializableModelStore fileTypeToStore(SerFileType fileType) throws InvalidSPDXAnalysisException {
        switch (fileType) {
            case JSON: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.JSON_PRETTY, MultiFormatStore.Verbose.COMPACT);
            }
            case RDFXML: {
                return new RdfStore();
            }
            case TAG: {
                return new TagValueStore((IModelStore)new InMemSpdxStore());
            }
            case XLS: {
                return new SpreadsheetStore((IModelStore)new InMemSpdxStore(), SpreadsheetStore.SpreadsheetFormatType.XLS);
            }
            case XLSX: {
                return new SpreadsheetStore((IModelStore)new InMemSpdxStore(), SpreadsheetStore.SpreadsheetFormatType.XLSX);
            }
            case XML: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.XML, MultiFormatStore.Verbose.COMPACT);
            }
            case YAML: {
                return new MultiFormatStore((IModelStore)new InMemSpdxStore(), MultiFormatStore.Format.YAML, MultiFormatStore.Verbose.COMPACT);
            }
        }
        throw new InvalidSPDXAnalysisException("Unsupported file type: " + (Object)((Object)fileType) + ".  Check back later.");
    }

    public static SerFileType fileToFileType(File file) throws InvalidFileNameException {
        SerFileType retval;
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            throw new InvalidFileNameException("Can not convert file to file type - no file extension");
        }
        String ext = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if ("xml".equals(ext) && fileName.endsWith("rdf.xml")) {
            ext = "rdf.xml";
        }
        if (Objects.isNull((Object)(retval = EXT_TO_FILETYPE.get(ext)))) {
            throw new InvalidFileNameException("Unrecognized file extension: " + ext);
        }
        return retval;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Invalid number of arguments");
            CycloneToSpdx.usage();
            System.exit(1);
        }
        List<Object> warnings = new ArrayList();
        try {
            warnings = CycloneToSpdx.cycloneDxToSpdx(args[0], args[1]);
        }
        catch (CycloneConversionException cycloneConversionException) {
            System.out.println(cycloneConversionException.getMessage());
            System.exit(1);
        }
        if (warnings.size() > 0) {
            System.out.println("Completed with the following warnings:");
            for (String string : warnings) {
                System.out.println("\t" + string);
            }
        }
        System.exit(0);
    }

    public static List<String> cycloneDxToSpdx(String cycloneDxFilePath, String spdxFilePath) throws CycloneConversionException {
        File outFile = new File(spdxFilePath);
        if (outFile.exists()) {
            throw new CycloneConversionException("File " + spdxFilePath + " already exists.");
        }
        try {
            if (!outFile.createNewFile()) {
                throw new CycloneConversionException("Could not create output file " + spdxFilePath);
            }
        }
        catch (IOException e) {
            throw new CycloneConversionException("I/O Error creating output file " + spdxFilePath, e);
        }
        ISerializableModelStore modelStore = null;
        try {
            modelStore = CycloneToSpdx.fileTypeToStore(CycloneToSpdx.fileToFileType(outFile));
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new CycloneConversionException("Unable to create SPDX model store: " + e.getMessage(), e);
        }
        catch (InvalidFileNameException e) {
            throw new CycloneConversionException("Cyclone DX Parsing Exception: " + e.getMessage(), e);
        }
        File inFile = new File(cycloneDxFilePath);
        if (!inFile.exists()) {
            throw new CycloneConversionException("File " + cycloneDxFilePath + " does not exist.");
        }
        Bom cycloneBom = null;
        try {
            Parser cycloneParser = BomParserFactory.createParser((File)inFile);
            cycloneBom = cycloneParser.parse(inFile);
        }
        catch (ParseException e) {
            throw new CycloneConversionException("Error creating Cyclone parser:" + e.getMessage());
        }
        CycloneSpdxConverter converter = new CycloneSpdxConverter(cycloneBom, (IModelStore)modelStore);
        converter.convert();
        try {
            Throwable throwable = null;
            Object var8_16 = null;
            try (FileOutputStream output = new FileOutputStream(outFile);){
                modelStore.serialize(converter.getDocumentUri(), (OutputStream)output);
                return converter.getWarnings();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new CycloneConversionException("Output file " + spdxFilePath + " not found.", e);
        }
        catch (IOException e) {
            throw new CycloneConversionException("I/O error writing output file:" + e.getMessage(), e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new CycloneConversionException("SPDX error creating output file:" + e.getMessage(), e);
        }
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("cycloneDxFilePath spdxFilePath");
        System.out.println("\tfromFilePath - File path of the CycloneDX JSON or XML file to convert from");
        System.out.println("\ttoFilePath - output file - file extension determines the type");
        System.out.println("\tSPDX file extension must be one of json, xml, rdf.xml, rdf, spdx, or yaml");
    }

    public static enum SerFileType {
        JSON,
        RDFXML,
        XML,
        XLS,
        XLSX,
        YAML,
        TAG;

    }
}

