/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.licenselistpublisher.LicenseGeneratorException;
import org.spdx.licenselistpublisher.licensegenerator.FsfLicenseDataParser;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseTester;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseJsonFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseMarkdownFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseRdfFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseRdfaFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseTemplateFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseTextFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.SimpleLicenseTester;
import org.spdx.licenselistpublisher.licensegenerator.SpdxWebsiteFormatWriter;
import org.spdx.licensexml.XmlLicenseProvider;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ISpdxListedLicenseProvider;
import org.spdx.rdfparser.license.License;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseRestrictionException;
import org.spdx.rdfparser.license.ListedLicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.license.SpdxListedLicenseException;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class LicenseRDFAGenerator {
    static final Set<Character> INVALID_TEXT_CHARS = Sets.newHashSet();
    static int MIN_ARGS;
    static int MAX_ARGS;
    static final int ERROR_STATUS = 1;
    static final int WARNING_STATUS = 64;
    static final String CSS_TEMPLATE_FILE = "resources/screen.css";
    static final String CSS_FILE_NAME = "screen.css";
    static final String SORTTABLE_JS_FILE = "resources/sorttable.js";
    static final String SORTTABLE_FILE_NAME = "sorttable.js";
    static final String TEXT_FOLDER_NAME = "text";
    static final String TEMPLATE_FOLDER_NAME = "template";
    static final String HTML_FOLDER_NAME = "html";
    static final String RDFA_FOLDER_NAME = "rdfa";
    static final String JSON_FOLDER_NAME = "json";
    private static final String WEBSITE_FOLDER_NAME = "website";
    private static final String RDFXML_FOLDER_NAME = "rdfxml";
    private static final String RDFTURTLE_FOLDER_NAME = "rdfturtle";
    private static final String RDFNT_FOLDER_NAME = "rdfnt";
    private static final String TABLE_OF_CONTENTS_FILE_NAME = "licenses.md";
    private static final String RDF_JSON_LD_FOLDER_NAME = "jsonld";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File dir;
        File ssFile;
        if (args == null || args.length < MIN_ARGS || args.length > MAX_ARGS) {
            System.out.println("Invalid arguments");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        if (!(ssFile = new File(args[0])).exists()) {
            System.out.println("Spreadsheet file " + ssFile.getName() + " does not exist");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        if (!(dir = new File(args[1])).exists()) {
            System.out.println("Output directory " + dir.getName() + " does not exist");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        if (!dir.isDirectory()) {
            System.out.println("Output directory " + dir.getName() + " is not a directory");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        String version = null;
        if (args.length > 2) {
            version = args[2];
        }
        String releaseDate = null;
        if (args.length > 3) {
            releaseDate = args[3];
        }
        File testFileDir = null;
        if (args.length > 4) {
            testFileDir = new File(args[4]);
            if (!testFileDir.exists()) {
                System.out.println("License test directory " + testFileDir.getName() + " does not exist");
                LicenseRDFAGenerator.usage();
                System.exit(1);
            }
            if (!testFileDir.isDirectory()) {
                System.out.println("License test directory " + testFileDir.getName() + " is not a directory");
                LicenseRDFAGenerator.usage();
                System.exit(1);
            }
        }
        String[] ignoredWarnings = new String[]{};
        if (args.length > 5) {
            CSVReader reader = null;
            try {
                File warningsFile = new File(args[5]);
                reader = warningsFile.exists() ? new CSVReader((Reader)new FileReader(warningsFile)) : new CSVReader((Reader)new StringReader(args[5]));
                ignoredWarnings = reader.readNext();
            }
            catch (IOException e) {
                System.out.println("IO Error reading ignored errors: " + e.getMessage());
                System.exit(1);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        System.out.println("IO Error closing ignored errors string: " + e.getMessage());
                        System.exit(1);
                    }
                }
            }
        }
        try {
            List<String> warnings = LicenseRDFAGenerator.generateLicenseData(ssFile, dir, version, releaseDate, testFileDir);
            if (warnings != null && warnings.size() > 0) {
                int numUnexpectedWarnings = warnings.size();
                for (String warning : warnings) {
                    boolean ignore = false;
                    for (String ignoreStr : ignoredWarnings) {
                        if (!warning.equalsIgnoreCase(ignoreStr)) continue;
                        ignore = true;
                        System.out.println("Ignoring warning '" + ignoreStr + "'");
                        break;
                    }
                    if (!ignore) continue;
                    --numUnexpectedWarnings;
                }
                if (numUnexpectedWarnings > 0) {
                    System.exit(64);
                }
            }
        }
        catch (LicenseGeneratorException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    public static List<String> generateLicenseData(File licenseXmlDir, File dir, String version, String releaseDate, File testFileDir) throws LicenseGeneratorException {
        ArrayList warnings = Lists.newArrayList();
        ArrayList writers = Lists.newArrayList();
        XmlLicenseProvider licenseProvider = null;
        try {
            if (!licenseXmlDir.isDirectory()) {
                throw new LicenseGeneratorException("Unsupported file format.  Must be a .xls file");
            }
            licenseProvider = new XmlLicenseProvider(licenseXmlDir);
            File textFolder = new File(dir.getPath() + File.separator + TEXT_FOLDER_NAME);
            if (!textFolder.isDirectory() && !textFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: text folder is not a directory");
            }
            writers.add(new LicenseTextFormatWriter(textFolder));
            File templateFolder = new File(dir.getPath() + File.separator + TEMPLATE_FOLDER_NAME);
            if (!templateFolder.isDirectory() && !templateFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: template folder is not a directory");
            }
            writers.add(new LicenseTemplateFormatWriter(templateFolder));
            File htmlFolder = new File(dir.getPath() + File.separator + HTML_FOLDER_NAME);
            if (!htmlFolder.isDirectory() && !htmlFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: HTML folder is not a directory");
            }
            writers.add(new LicenseHtmlFormatWriter(version, releaseDate, htmlFolder));
            File rdfaFolder = new File(dir.getPath() + File.separator + RDFA_FOLDER_NAME);
            if (!rdfaFolder.isDirectory() && !rdfaFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: RDFa folder is not a directory");
            }
            writers.add(new LicenseRdfaFormatWriter(version, releaseDate, rdfaFolder));
            File jsonFolder = new File(dir.getPath() + File.separator + JSON_FOLDER_NAME);
            if (!jsonFolder.isDirectory() && !jsonFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: JSON folder is not a directory");
            }
            File jsonFolderDetails = new File(dir.getPath() + File.separator + JSON_FOLDER_NAME + File.separator + "details");
            if (!jsonFolderDetails.isDirectory() && !jsonFolderDetails.mkdir()) {
                throw new LicenseGeneratorException("Error: JSON folder is not a directory");
            }
            File jsonFolderExceptions = new File(dir.getPath() + File.separator + JSON_FOLDER_NAME + File.separator + "exceptions");
            if (!jsonFolderExceptions.isDirectory() && !jsonFolderExceptions.mkdir()) {
                throw new LicenseGeneratorException("Error: JSON folder is not a directory");
            }
            writers.add(new LicenseJsonFormatWriter(version, releaseDate, jsonFolder, jsonFolderDetails, jsonFolderExceptions));
            File website = new File(dir.getPath() + File.separator + WEBSITE_FOLDER_NAME);
            if (!website.isDirectory() && !website.mkdir()) {
                throw new LicenseGeneratorException("Error: Website folder is not a directory");
            }
            writers.add(new SpdxWebsiteFormatWriter(version, releaseDate, website));
            File rdfXml = new File(dir.getPath() + File.separator + RDFXML_FOLDER_NAME);
            if (!rdfXml.isDirectory() && !rdfXml.mkdir()) {
                throw new LicenseGeneratorException("Error: RdfXML folder is not a directory");
            }
            File rdfTurtle = new File(dir.getPath() + File.separator + RDFTURTLE_FOLDER_NAME);
            if (!rdfTurtle.isDirectory() && !rdfTurtle.mkdir()) {
                throw new LicenseGeneratorException("Error: RDF Turtle folder is not a directory");
            }
            File rdfNt = new File(dir.getPath() + File.separator + RDFNT_FOLDER_NAME);
            if (!rdfNt.isDirectory() && !rdfNt.mkdir()) {
                throw new LicenseGeneratorException("Error: RDF NT folder is not a directory");
            }
            File rdfJsonLd = new File(dir.getPath() + File.separator + RDF_JSON_LD_FOLDER_NAME);
            if (!rdfJsonLd.isDirectory() && !rdfJsonLd.mkdir()) {
                throw new LicenseGeneratorException("Error: RDF JSON-LD folder is not a directory");
            }
            writers.add(new LicenseRdfFormatWriter(rdfXml, rdfTurtle, rdfNt, rdfJsonLd));
            File markdownFile = new File(dir.getPath() + File.separator + TABLE_OF_CONTENTS_FILE_NAME);
            if (!markdownFile.isFile() && !markdownFile.createNewFile()) {
                throw new LicenseGeneratorException("Error: Unable to create markdown file");
            }
            writers.add(new LicenseMarkdownFormatWriter(version, releaseDate, markdownFile));
            SimpleLicenseTester tester = null;
            if (testFileDir != null) {
                tester = new SimpleLicenseTester(testFileDir);
            }
            System.out.print("Processing License List");
            LicenseRDFAGenerator.writeLicenseList(version, releaseDate, licenseProvider, warnings, writers, tester);
            System.out.println();
            System.out.print("Processing Exceptions");
            LicenseRDFAGenerator.writeExceptionList(version, releaseDate, licenseProvider, warnings, writers, tester);
            System.out.println();
            System.out.print("Writing table of contents");
            for (ILicenseFormatWriter writer : writers) {
                writer.writeToC();
            }
            LicenseRDFAGenerator.writeCssFile(website);
            LicenseRDFAGenerator.writeSortTableFile(website);
            System.out.println();
            warnings.addAll(licenseProvider.getWarnings());
            if (warnings.size() > 0) {
                System.out.println("The following warning(s) were identified:");
                for (String warning : warnings) {
                    System.out.println("\t" + warning);
                }
            }
            System.out.println("Completed processing licenses");
            return warnings;
        }
        catch (SpreadsheetException e) {
            throw new LicenseGeneratorException("\nInvalid spreadsheet: " + e.getMessage(), e);
        }
        catch (SpdxListedLicenseException e) {
            throw new LicenseGeneratorException("\nError reading standard licenses: " + e.getMessage(), e);
        }
        catch (LicenseGeneratorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LicenseGeneratorException("\nUnhandled exception generating html: " + e.getMessage(), e);
        }
    }

    private static void writeExceptionList(String version, String releaseDate, ISpdxListedLicenseProvider licenseProvider, List<String> warnings, List<ILicenseFormatWriter> writers, ILicenseTester tester) throws IOException, LicenseRestrictionException, SpreadsheetException, LicenseGeneratorException, InvalidLicenseTemplateException {
        HashSet licenseIds = Sets.newHashSet();
        try {
            Iterator licIter = licenseProvider.getLicenseIterator();
            while (licIter.hasNext()) {
                licenseIds.add(((SpdxListedLicense)licIter.next()).getLicenseId());
            }
        }
        catch (SpdxListedLicenseException e) {
            System.out.println("Warning - Not able to check for duplicate license and exception ID's");
        }
        Iterator exceptionIter = licenseProvider.getExceptionIterator();
        HashMap addedExceptionsMap = Maps.newHashMap();
        while (exceptionIter.hasNext()) {
            List<String> testResults;
            System.out.print(".");
            ListedLicenseException nextException = (ListedLicenseException)exceptionIter.next();
            LicenseRDFAGenerator.addExternalMetaData((LicenseException)nextException);
            if (nextException.getLicenseExceptionId() == null || nextException.getLicenseExceptionId().isEmpty()) continue;
            if (!nextException.isDeprecated()) {
                for (Map.Entry entry : addedExceptionsMap.entrySet()) {
                    if (!((String)entry.getValue()).trim().equals(nextException.getLicenseExceptionText().trim())) continue;
                    warnings.add("Duplicates exceptions: " + nextException.getLicenseExceptionId() + ", " + (String)entry.getKey());
                }
                addedExceptionsMap.put(nextException.getLicenseExceptionId(), nextException.getLicenseExceptionText());
            }
            if (licenseIds.contains(nextException.getLicenseExceptionId())) {
                warnings.add("A license ID exists with the same ID as an exception ID: " + nextException.getLicenseExceptionId());
            }
            LicenseRDFAGenerator.checkText(nextException.getLicenseExceptionText(), "License Exception Text for " + nextException.getLicenseExceptionId(), warnings);
            for (ILicenseFormatWriter writer : writers) {
                writer.writeException(nextException);
            }
            if (tester == null || (testResults = tester.testException((LicenseException)nextException)) == null || testResults.size() <= 0) continue;
            for (String testResult : testResults) {
                warnings.add("Test for exception " + nextException.getLicenseExceptionId() + " failed: " + testResult);
            }
        }
    }

    private static void addExternalMetaData(LicenseException exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkText(String text, String textDescription, List<String> warnings) {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        try {
            int lineNumber = 1;
            String line = reader.readLine();
            while (line != null) {
                for (int i = 0; i < line.length(); ++i) {
                    if (!INVALID_TEXT_CHARS.contains(Character.valueOf(line.charAt(i)))) continue;
                    warnings.add("Invalid character in " + textDescription + " at line number " + String.valueOf(lineNumber) + " \"" + line + "\" at character location " + String.valueOf(i));
                }
                ++lineNumber;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            warnings.add("IO error reading text");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                warnings.add("IO Error closing string reader");
            }
        }
    }

    private static void writeLicenseList(String version, String releaseDate, ISpdxListedLicenseProvider licenseProvider, List<String> warnings, List<ILicenseFormatWriter> writers, ILicenseTester tester) throws LicenseGeneratorException, InvalidSPDXAnalysisException, IOException, SpdxListedLicenseException, SpdxCompareException {
        Iterator licenseIter = licenseProvider.getLicenseIterator();
        HashMap addedLicIdTextMap = Maps.newHashMap();
        while (licenseIter.hasNext()) {
            List<String> testResults;
            System.out.print(".");
            SpdxListedLicense license = (SpdxListedLicense)licenseIter.next();
            LicenseRDFAGenerator.addExternalMetaData(license);
            if (license.getLicenseId() == null || license.getLicenseId().isEmpty()) continue;
            if (!license.isDeprecated()) {
                for (Map.Entry entry : addedLicIdTextMap.entrySet()) {
                    if (!LicenseCompareHelper.isLicenseTextEquivalent((String)((String)entry.getValue()), (String)license.getLicenseText())) continue;
                    warnings.add("Duplicates licenses: " + license.getLicenseId() + ", " + (String)entry.getKey());
                }
                addedLicIdTextMap.put(license.getLicenseId(), license.getLicenseText());
            }
            LicenseRDFAGenerator.checkText(license.getLicenseText(), "License text for " + license.getLicenseId(), warnings);
            for (ILicenseFormatWriter writer : writers) {
                writer.writeLicense(license, license.isDeprecated(), license.getDeprecatedVersion());
            }
            if (tester == null || (testResults = tester.testLicense((License)license)) == null || testResults.size() <= 0) continue;
            for (String testResult : testResults) {
                warnings.add("Test for license " + license.getLicenseId() + " failed: " + testResult);
            }
        }
    }

    private static void addExternalMetaData(SpdxListedLicense license) throws LicenseGeneratorException {
        license.setFsfLibre(FsfLicenseDataParser.getFsfLicenseDataParser().isSpdxLicenseFsfLibre(license.getLicenseId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyResourceFile(String resourceFileName, File destination) throws IOException {
        File resourceFile = new File(resourceFileName);
        if (resourceFile.exists()) {
            Files.copy((File)resourceFile, (File)destination);
        } else {
            InputStream is = LicenseRDFAGenerator.class.getClassLoader().getResourceAsStream(resourceFileName);
            InputStreamReader reader = new InputStreamReader(is);
            FileWriter writer = new FileWriter(destination);
            try {
                char[] buf = new char[2048];
                int len = reader.read(buf);
                while (len > 0) {
                    writer.write(buf, 0, len);
                    len = reader.read(buf);
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                reader.close();
            }
        }
    }

    private static void writeCssFile(File dir) throws IOException {
        File cssFile = new File(dir.getPath() + File.separator + CSS_FILE_NAME);
        if (cssFile.exists() && !cssFile.delete()) {
            throw new IOException("Unable to delete old file");
        }
        LicenseRDFAGenerator.copyResourceFile(CSS_TEMPLATE_FILE, cssFile);
    }

    private static void writeSortTableFile(File dir) throws IOException {
        File sortTableFile = new File(dir.getPath() + File.separator + SORTTABLE_FILE_NAME);
        if (sortTableFile.exists()) {
            return;
        }
        LicenseRDFAGenerator.copyResourceFile(SORTTABLE_JS_FILE, sortTableFile);
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("LicenseRDFAGenerator licencenseXmlDir outputDirectory [version] [releasedate] [testfiles] [ignoredwarnings]");
        System.out.println("   licencenseXmlDir - a directory of license XML files");
        System.out.println("   outputDirectory - Directory to store the output from the license generator");
        System.out.println("   [version] - Version of the SPDX license list");
        System.out.println("   [releasedate] - Release date of the SPDX license list");
        System.out.println("   [testfiles] - Directory of original text files to compare the generated licenses against");
        System.out.println("   [ignoredwarnings] - Either a file name or a comma separated list of warnings to be ignored");
    }

    static {
        INVALID_TEXT_CHARS.add(Character.valueOf('\ufffd'));
        MIN_ARGS = 2;
        MAX_ARGS = 6;
    }
}

