/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.rdfparser.license.ListedLicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;

public class LicenseHtmlFormatWriter
implements ILicenseFormatWriter {
    static final Set<Character> INVALID_FILENAME_CHARS = Sets.newHashSet();
    private File htmlFolder;
    private Charset utf8 = Charset.forName("UTF-8");

    public LicenseHtmlFormatWriter(String version, String releaseDate, File htmlFolder) {
        this.htmlFolder = htmlFolder;
    }

    public File getHtmlFolder() {
        return this.htmlFolder;
    }

    public void setHtmlFolder(File htmlFolder) {
        this.htmlFolder = htmlFolder;
    }

    @Override
    public void writeLicense(SpdxListedLicense license, boolean deprecated, String deprecatedVersion) throws IOException {
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        String licHtmlFileName = licBaseHtmlFileName + ".html";
        File htmlTextFile = new File(this.htmlFolder.getPath() + File.separator + licHtmlFileName);
        try {
            Files.write((CharSequence)license.getLicenseTextHtml(), (File)htmlTextFile, (Charset)this.utf8);
        }
        catch (InvalidLicenseTemplateException e) {
            Files.write((CharSequence)SpdxLicenseTemplateHelper.formatEscapeHTML((String)license.getLicenseText()), (File)htmlTextFile, (Charset)this.utf8);
        }
    }

    public static String formLicenseHTMLFileName(String id) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            if (INVALID_FILENAME_CHARS.contains(Character.valueOf(id.charAt(i)))) {
                sb.append('_');
                continue;
            }
            sb.append(id.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public void writeToC() throws IOException {
    }

    @Override
    public void writeException(ListedLicenseException exception) throws IOException {
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        File htmlTextFile = new File(this.htmlFolder.getPath() + File.separator + exceptionHtmlFileName + ".html");
        try {
            Files.write((CharSequence)exception.getExceptionTextHtml(), (File)htmlTextFile, (Charset)this.utf8);
        }
        catch (InvalidLicenseTemplateException e) {
            Files.write((CharSequence)SpdxLicenseTemplateHelper.formatEscapeHTML((String)exception.getLicenseExceptionText()), (File)htmlTextFile, (Charset)this.utf8);
        }
    }

    static {
        INVALID_FILENAME_CHARS.add(Character.valueOf('\\'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('/'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('*'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('<'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('>'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('['));
        INVALID_FILENAME_CHARS.add(Character.valueOf(']'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('='));
        INVALID_FILENAME_CHARS.add(Character.valueOf(';'));
        INVALID_FILENAME_CHARS.add(Character.valueOf(':'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('\''));
        INVALID_FILENAME_CHARS.add(Character.valueOf('\"'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('|'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('\t'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('?'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('&'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('\ufffd'));
    }
}

