/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import com.github.mustachejava.MustacheException;
import java.io.File;
import java.io.IOException;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.htmltemplates.ExceptionHtml;
import org.spdx.htmltemplates.ExceptionHtmlToc;
import org.spdx.htmltemplates.LicenseHTMLFile;
import org.spdx.htmltemplates.LicenseTOCHTMLFile;
import org.spdx.licenselistpublisher.LicenseGeneratorException;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.ListedLicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;

public class LicenseRdfaFormatWriter
implements ILicenseFormatWriter {
    static final String LICENSE_TOC_HTML_FILE_NAME = "index.html";
    static final String EXCEPTION_TOC_FILE_NAME = "exceptions-index.html";
    private File rdfaFolder;
    private String version;
    private String releaseDate;
    private LicenseHTMLFile licHtml;
    private LicenseTOCHTMLFile tableOfContentsHTML;
    private ExceptionHtmlToc htmlExceptionToc;
    private String exceptionHtmlTocReference = "./exceptions-index.html";

    public LicenseRdfaFormatWriter(String version, String releaseDate, File rdfaFolder) {
        this.rdfaFolder = rdfaFolder;
        this.version = version;
        this.releaseDate = releaseDate;
        this.tableOfContentsHTML = new LicenseTOCHTMLFile(version, releaseDate);
        this.licHtml = new LicenseHTMLFile();
        this.htmlExceptionToc = new ExceptionHtmlToc();
    }

    public File getRdfaFolder() {
        return this.rdfaFolder;
    }

    public void setRdfaFolder(File rdfaFolder) {
        this.rdfaFolder = rdfaFolder;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public LicenseHTMLFile getLicHtml() {
        return this.licHtml;
    }

    public void setLicHtml(LicenseHTMLFile licHtml) {
        this.licHtml = licHtml;
    }

    public LicenseTOCHTMLFile getTableOfContentsHTML() {
        return this.tableOfContentsHTML;
    }

    public void setTableOfContentsHTML(LicenseTOCHTMLFile tableOfContentsHTML) {
        this.tableOfContentsHTML = tableOfContentsHTML;
    }

    @Override
    public void writeLicense(SpdxListedLicense license, boolean deprecated, String deprecatedVersion) throws IOException, LicenseGeneratorException {
        this.licHtml.setLicense(license);
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        String licHtmlFileName = licBaseHtmlFileName + ".html";
        String licHTMLReference = "./" + licHtmlFileName;
        String tocHTMLReference = "./index.html";
        File licHtmlFile = new File(this.rdfaFolder.getPath() + File.separator + licHtmlFileName);
        try {
            this.licHtml.writeToFile(licHtmlFile, tocHTMLReference);
        }
        catch (MustacheException e) {
            throw new LicenseGeneratorException("Template error for license HTML file: " + e.getMessage(), e);
        }
        catch (InvalidLicenseTemplateException e) {
            throw new LicenseGeneratorException("License template error for license HTML file: " + e.getMessage(), e);
        }
        if (deprecated) {
            this.tableOfContentsHTML.addDeprecatedLicense(license, licHTMLReference);
        } else {
            this.tableOfContentsHTML.addLicense(license, licHTMLReference);
        }
    }

    @Override
    public void writeToC() throws IOException {
        File tocHtmlFile = new File(this.rdfaFolder.getPath() + File.separator + LICENSE_TOC_HTML_FILE_NAME);
        this.tableOfContentsHTML.writeToFile(tocHtmlFile);
        File exceptionTocFile = new File(this.rdfaFolder.getPath() + File.separator + EXCEPTION_TOC_FILE_NAME);
        this.htmlExceptionToc.writeToFile(exceptionTocFile, this.version);
    }

    @Override
    public void writeException(ListedLicenseException exception) throws IOException, InvalidLicenseTemplateException {
        ExceptionHtml exceptionHtml = new ExceptionHtml(exception);
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        String exceptionHTMLReference = "./" + exceptionHtmlFileName + ".html";
        File exceptionHtmlFile = new File(this.rdfaFolder.getPath() + File.separator + exceptionHtmlFileName + ".html");
        exceptionHtml.writeToFile(exceptionHtmlFile, this.exceptionHtmlTocReference);
        this.htmlExceptionToc.addException((LicenseException)exception, exceptionHTMLReference);
    }
}

