/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import com.github.mustachejava.MustacheException;
import java.io.File;
import java.io.IOException;
import org.spdx.html.ExceptionTOCJSONFile;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.html.LicenseExceptionJSONFile;
import org.spdx.html.LicenseJSONFile;
import org.spdx.html.LicenseTOCJSONFile;
import org.spdx.htmltemplates.ExceptionHtml;
import org.spdx.htmltemplates.ExceptionHtmlToc;
import org.spdx.htmltemplates.LicenseHTMLFile;
import org.spdx.htmltemplates.LicenseTOCHTMLFile;
import org.spdx.licenselistpublisher.LicenseContainer;
import org.spdx.licenselistpublisher.LicenseGeneratorException;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseRdfFormatWriter;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.ListedLicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;

public class SpdxWebsiteFormatWriter
implements ILicenseFormatWriter {
    static final String LICENSE_TOC_JSON_FILE_NAME = "licenses.json";
    static final String LICENSE_TOC_HTML_FILE_NAME = "index.html";
    static final String EXCEPTION_TOC_FILE_NAME = "exceptions-index.html";
    static final String EXCEPTION_JSON_TOC_FILE_NAME = "exceptions.json";
    private File websiteFolder;
    private LicenseHTMLFile licHtml;
    private LicenseTOCHTMLFile tableOfContentsHTML;
    LicenseJSONFile licJson;
    LicenseTOCJSONFile tableOfContentsJSON;
    String exceptionHtmlTocReference = "./exceptions-index.html";
    ExceptionHtmlToc htmlExceptionToc;
    ExceptionTOCJSONFile jsonExceptionToc;
    private String version;
    private String releaseDate;

    public SpdxWebsiteFormatWriter(String version, String releaseDate, File websiteFolder) {
        this.websiteFolder = websiteFolder;
        this.tableOfContentsHTML = new LicenseTOCHTMLFile(version, releaseDate);
        this.licHtml = new LicenseHTMLFile();
        this.licJson = new LicenseJSONFile();
        this.tableOfContentsJSON = new LicenseTOCJSONFile(version, releaseDate);
        this.htmlExceptionToc = new ExceptionHtmlToc();
        this.jsonExceptionToc = new ExceptionTOCJSONFile(version, releaseDate);
        this.version = version;
        this.releaseDate = releaseDate;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public LicenseJSONFile getLicJson() {
        return this.licJson;
    }

    public LicenseTOCJSONFile getTableOfContentsJSON() {
        return this.tableOfContentsJSON;
    }

    public ExceptionHtmlToc getHtmlExceptionToc() {
        return this.htmlExceptionToc;
    }

    public ExceptionTOCJSONFile getJsonExceptionToc() {
        return this.jsonExceptionToc;
    }

    public File getWebsiteFolder() {
        return this.websiteFolder;
    }

    public void setWebsiteFolder(File websiteFolder) {
        this.websiteFolder = websiteFolder;
    }

    public LicenseHTMLFile getLicHtml() {
        return this.licHtml;
    }

    public void setLicHtml(LicenseHTMLFile licHtml) {
        this.licHtml = licHtml;
    }

    public LicenseTOCHTMLFile getTableOfContentsHTML() {
        return this.tableOfContentsHTML;
    }

    public void setTableOfContentsHTML(LicenseTOCHTMLFile tableOfContentsHTML) {
        this.tableOfContentsHTML = tableOfContentsHTML;
    }

    @Override
    public void writeLicense(SpdxListedLicense license, boolean deprecated, String deprecatedVersion) throws IOException, LicenseGeneratorException {
        this.licHtml.setLicense(license);
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        String licHtmlFileName = licBaseHtmlFileName + ".html";
        String licJsonFileName = licBaseHtmlFileName + ".json";
        String licHTMLReference = "./" + licHtmlFileName;
        String licJSONReference = "./" + licJsonFileName;
        String tocHTMLReference = "./index.html";
        File licBaseHtmlFile = new File(this.websiteFolder.getPath() + File.separator + licBaseHtmlFileName);
        File licJsonFile = new File(this.websiteFolder.getPath() + File.separator + licJsonFileName);
        File licHtmlFile = new File(this.websiteFolder.getPath() + File.separator + licHtmlFileName);
        try {
            this.licHtml.writeToFile(licBaseHtmlFile, tocHTMLReference);
            this.licHtml.writeToFile(licHtmlFile, tocHTMLReference);
        }
        catch (MustacheException e) {
            throw new LicenseGeneratorException("Template error for license HTML file: " + e.getMessage(), e);
        }
        catch (InvalidLicenseTemplateException e) {
            throw new LicenseGeneratorException("License template error for license HTML file: " + e.getMessage(), e);
        }
        this.licJson.setLicense(license, deprecated);
        this.licJson.writeToFile(licJsonFile);
        this.tableOfContentsJSON.addLicense(license, licHTMLReference, licJSONReference, deprecated);
        if (deprecated) {
            this.tableOfContentsHTML.addDeprecatedLicense(license, licHTMLReference);
        } else {
            this.tableOfContentsHTML.addLicense(license, licHTMLReference);
        }
        LicenseContainer onlyThisLicense = new LicenseContainer();
        AnyLicenseInfo licenseClone = license.clone();
        try {
            licenseClone.createResource((IModelContainer)onlyThisLicense);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseGeneratorException("SPDX Analysis error cloning license: " + e.getMessage(), e);
        }
        LicenseRdfFormatWriter.writeRdf(onlyThisLicense, this.websiteFolder.getPath() + File.separator + licBaseHtmlFileName + ".jsonld", "JSON-LD");
    }

    @Override
    public void writeToC() throws IOException {
        File tocJsonFile = new File(this.websiteFolder.getPath() + File.separator + LICENSE_TOC_JSON_FILE_NAME);
        File tocHtmlFile = new File(this.websiteFolder.getPath() + File.separator + LICENSE_TOC_HTML_FILE_NAME);
        File exceptionTocFile = new File(this.websiteFolder.getPath() + File.separator + EXCEPTION_TOC_FILE_NAME);
        this.tableOfContentsJSON.writeToFile(tocJsonFile);
        this.tableOfContentsHTML.writeToFile(tocHtmlFile);
        this.htmlExceptionToc.writeToFile(exceptionTocFile, this.version);
        File exceptionJsonTocFile = new File(this.websiteFolder.getPath() + File.separator + EXCEPTION_JSON_TOC_FILE_NAME);
        this.jsonExceptionToc.writeToFile(exceptionJsonTocFile);
    }

    @Override
    public void writeException(ListedLicenseException exception) throws IOException, InvalidLicenseTemplateException, LicenseGeneratorException {
        ExceptionHtml exceptionHtml = new ExceptionHtml(exception);
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        String exceptionHTMLReference = "./" + exceptionHtmlFileName + ".html";
        String exceptionJsonFileName = exceptionHtmlFileName + ".json";
        String exceptionJSONReference = "./" + exceptionJsonFileName;
        File exceptionHtmlFile = new File(this.websiteFolder.getPath() + File.separator + exceptionHtmlFileName + ".html");
        exceptionHtml.writeToFile(exceptionHtmlFile, this.exceptionHtmlTocReference);
        if (exception.isDeprecated()) {
            this.htmlExceptionToc.addDeprecatedException((LicenseException)exception, exceptionHTMLReference, exception.getDeprecatedVersion());
        } else {
            this.htmlExceptionToc.addException((LicenseException)exception, exceptionHTMLReference);
        }
        this.jsonExceptionToc.addException((LicenseException)exception, exceptionHTMLReference, exceptionJSONReference, exception.isDeprecated());
        LicenseExceptionJSONFile exceptionJson = new LicenseExceptionJSONFile();
        exceptionJson.setException((LicenseException)exception, exception.isDeprecated());
        File exceptionJsonFile = new File(this.websiteFolder.getPath() + File.separator + exceptionJsonFileName);
        exceptionJson.writeToFile(exceptionJsonFile);
        LicenseException exceptionClone = exception.clone();
        LicenseContainer onlyThisException = new LicenseContainer();
        try {
            exceptionClone.createResource((IModelContainer)onlyThisException);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseGeneratorException("SPDX Analysis error cloning exception: " + e.getMessage(), e);
        }
        LicenseRdfFormatWriter.writeRdf(onlyThisException, this.websiteFolder.getPath() + File.separator + exceptionHtmlFileName + ".jsonld", "JSON-LD");
    }
}

