/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licensexml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.licensexml.LicenseXmlHelper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ListedLicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LicenseXmlDocument {
    static final Logger logger = LoggerFactory.getLogger((String)LicenseXmlDocument.class.getName());
    public static final String PROP_SCHEMA_FILENAME = "listedLicenseSchema";
    public static final String LICENSE_XML_SCHEMA_URL = "https://raw.githubusercontent.com/spdx/license-list-XML/master/schema/ListedLicense.xsd";
    public static final String LICENSE_XML_SCHEMA_LOCATION = "org/spdx/licensexml/ListedLicense.xsd";
    private static Schema _schema = null;
    private Document xmlDocument;

    public LicenseXmlDocument(File file) throws LicenseXmlException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("Parser configuration error creating document builder", (Throwable)e);
            throw new LicenseXmlException("Error creating parser for license XML file");
        }
        try {
            this.xmlDocument = builder.parse(file);
        }
        catch (SAXException e) {
            logger.error("Error parsing license XML document", (Throwable)e);
            throw new LicenseXmlException("Unable to parse license XML file: " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("I/O Error reading license XML file", (Throwable)e);
            throw new LicenseXmlException("I/O Error reading XML file: " + e.getMessage());
        }
        this.assertValid(file);
    }

    private synchronized Schema getSchema() throws LicenseXmlException {
        if (_schema == null) {
            InputStream schemaIs = null;
            try {
                String schemaFilePath = System.getProperty(PROP_SCHEMA_FILENAME);
                if (schemaFilePath != null) {
                    try {
                        schemaIs = new FileInputStream(schemaFilePath);
                    }
                    catch (IOException e) {
                        logger.error("IO Exception opening specified schema file " + schemaFilePath, (Throwable)e);
                        throw new LicenseXmlException("Invalid license XML schema file");
                    }
                }
                try {
                    URL schemaUrl = new URL(LICENSE_XML_SCHEMA_URL);
                    schemaIs = schemaUrl.openStream();
                }
                catch (Exception e) {
                    logger.warn("Unable to open license XML schema URL, using cached copy", (Throwable)e);
                }
                if (schemaIs == null) {
                    schemaIs = LicenseXmlDocument.class.getClassLoader().getResourceAsStream(LICENSE_XML_SCHEMA_LOCATION);
                }
                StreamSource schemaSource = new StreamSource(schemaIs);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                _schema = schemaFactory.newSchema(schemaSource);
            }
            catch (SAXException e) {
                logger.error("Invalid schema file", (Throwable)e);
                throw new LicenseXmlException("Invalid Listed License Schema", e);
            }
            finally {
                if (schemaIs != null) {
                    try {
                        schemaIs.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close Schema stream", (Throwable)e);
                    }
                }
            }
        }
        return _schema;
    }

    private void assertValid(File licenseXmlFile) throws LicenseXmlException {
        try {
            StreamSource xmlSource = new StreamSource(licenseXmlFile);
            Schema schema = this.getSchema();
            Validator validator = schema.newValidator();
            validator.validate(xmlSource);
        }
        catch (MalformedURLException e) {
            logger.error("Unable to open License List XML schema file", (Throwable)e);
            throw new LicenseXmlException("Unable to open License List XML schema file");
        }
        catch (SAXParseException e) {
            logger.error("Invalid license XML file " + licenseXmlFile.getName(), (Throwable)e);
            throw new LicenseXmlException("Parsing error in XML file " + licenseXmlFile.getName() + " at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ":" + e.getMessage());
        }
        catch (SAXException e) {
            logger.error("Invalid license XML file " + licenseXmlFile.getName(), (Throwable)e);
            throw new LicenseXmlException("Invalid XML file " + licenseXmlFile.getName() + ":" + e.getMessage());
        }
        catch (IOException e) {
            logger.error("IO Error validating license XML file", (Throwable)e);
            throw new LicenseXmlException("IO Error validating license XML file");
        }
    }

    public LicenseXmlDocument(Document xmlDocument) throws LicenseXmlException {
        this.xmlDocument = xmlDocument;
    }

    public List<SpdxListedLicense> getListedLicenses() throws InvalidSPDXAnalysisException, LicenseXmlException {
        ArrayList<SpdxListedLicense> retval = new ArrayList<SpdxListedLicense>();
        Element rootElement = this.xmlDocument.getDocumentElement();
        NodeList licenseElements = rootElement.getElementsByTagName("license");
        for (int i = 0; i < licenseElements.getLength(); ++i) {
            Element licenseElement = (Element)licenseElements.item(i);
            retval.add(this.getListedLicense(licenseElement));
        }
        return retval;
    }

    private SpdxListedLicense getListedLicense(Element licenseElement) throws InvalidSPDXAnalysisException, LicenseXmlException {
        NodeList textNodes;
        String name = licenseElement.getAttribute("name");
        String id = licenseElement.getAttribute("licenseId");
        boolean deprecated = licenseElement.hasAttribute("deprecatedVersion");
        String deprecatedVersion = null;
        if (deprecated) {
            deprecatedVersion = licenseElement.getAttribute("deprecatedVersion");
        }
        if ((textNodes = licenseElement.getElementsByTagName("text")).getLength() != 1) {
            throw new LicenseXmlException("Invalid number of text elements.  Expected 1 - found " + textNodes.getLength());
        }
        Element textElement = (Element)textNodes.item(0);
        String text = LicenseXmlHelper.getLicenseText(textElement);
        NodeList notes = licenseElement.getElementsByTagName("notes");
        String comment = null;
        if (notes.getLength() > 0) {
            StringBuilder commentBuilder = new StringBuilder(LicenseXmlHelper.getNoteText((Element)notes.item(0)));
            for (int i = 1; i < notes.getLength(); ++i) {
                commentBuilder.append("; ");
                commentBuilder.append(LicenseXmlHelper.getNoteText((Element)notes.item(i)));
            }
            comment = commentBuilder.toString();
        }
        NodeList urlNodes = licenseElement.getElementsByTagName("crossRef");
        String[] sourceUrls = new String[urlNodes.getLength()];
        for (int i = 0; i < urlNodes.getLength(); ++i) {
            sourceUrls[i] = urlNodes.item(i).getTextContent();
        }
        String licenseHeader = null;
        String licenseHeaderTemplate = null;
        String licenseHeaderTemplateHtml = null;
        NodeList headerNodes = licenseElement.getElementsByTagName("standardLicenseHeader");
        if (headerNodes.getLength() > 0) {
            StringBuilder sbText = new StringBuilder();
            StringBuilder sbTemplate = new StringBuilder();
            StringBuilder sbHtml = new StringBuilder();
            sbText.append(LicenseXmlHelper.getHeaderText((Element)headerNodes.item(0)));
            sbTemplate.append(LicenseXmlHelper.getHeaderTemplate((Element)headerNodes.item(0)));
            sbHtml.append(LicenseXmlHelper.getHeaderTextHtml((Element)headerNodes.item(0)));
            for (int i = 1; i < headerNodes.getLength(); ++i) {
                sbText.append('\n');
                sbText.append(LicenseXmlHelper.getHeaderText((Element)headerNodes.item(i)));
                sbTemplate.append('\n');
                sbTemplate.append(LicenseXmlHelper.getHeaderTemplate((Element)headerNodes.item(i)));
                sbHtml.append("<br />\n");
                sbHtml.append(LicenseXmlHelper.getHeaderTextHtml((Element)headerNodes.item(i)));
            }
            licenseHeader = sbText.toString();
            licenseHeaderTemplate = sbTemplate.toString();
            licenseHeaderTemplateHtml = sbHtml.toString();
        }
        String template = LicenseXmlHelper.getLicenseTemplate(textElement);
        boolean osiApproved = licenseElement.hasAttribute("isOsiApproved") ? "true".equals(licenseElement.getAttribute("isOsiApproved").toLowerCase()) : false;
        boolean fsfLibre = licenseElement.hasAttribute("isFsfLibre") ? "true".equals(licenseElement.getAttribute("isFsfLibre").toLowerCase()) : false;
        String licenseHtml = LicenseXmlHelper.getLicenseTextHtml(textElement);
        SpdxListedLicense retval = new SpdxListedLicense(name, id, text, sourceUrls, comment, licenseHeader, template, licenseHeaderTemplate, osiApproved, fsfLibre, licenseHtml, licenseHeaderTemplateHtml);
        retval.setDeprecated(deprecated);
        retval.setDeprecatedVersion(deprecatedVersion);
        return retval;
    }

    public List<ListedLicenseException> getLicenseExceptions() throws LicenseXmlException {
        ArrayList<ListedLicenseException> retval = new ArrayList<ListedLicenseException>();
        Element rootElement = this.xmlDocument.getDocumentElement();
        NodeList exceptionElements = rootElement.getElementsByTagName("exception");
        for (int i = 0; i < exceptionElements.getLength(); ++i) {
            Element exceptionElement = (Element)exceptionElements.item(i);
            retval.add(this.getException(exceptionElement));
        }
        return retval;
    }

    private ListedLicenseException getException(Element exceptionElement) throws LicenseXmlException {
        NodeList textNodes;
        String name = exceptionElement.getAttribute("name");
        String id = exceptionElement.getAttribute("licenseId");
        boolean deprecated = exceptionElement.hasAttribute("deprecatedVersion");
        String deprecatedVersion = null;
        if (deprecated) {
            deprecatedVersion = exceptionElement.getAttribute("deprecatedVersion");
        }
        if ((textNodes = exceptionElement.getElementsByTagName("text")).getLength() != 1) {
            throw new LicenseXmlException("Invalid number of text elements.  Expected 1 - found " + textNodes.getLength());
        }
        Element textElement = (Element)textNodes.item(0);
        String text = LicenseXmlHelper.getLicenseText(textElement);
        String template = LicenseXmlHelper.getLicenseTemplate(textElement);
        String html = LicenseXmlHelper.getLicenseTextHtml(textElement);
        NodeList notes = exceptionElement.getElementsByTagName("notes");
        String comment = null;
        if (notes.getLength() > 0) {
            StringBuilder commentBuilder = new StringBuilder(LicenseXmlHelper.getNoteText((Element)notes.item(0)));
            for (int i = 1; i < notes.getLength(); ++i) {
                commentBuilder.append("; ");
                commentBuilder.append(LicenseXmlHelper.getNoteText((Element)notes.item(i)));
            }
            comment = commentBuilder.toString();
        }
        NodeList urlNodes = exceptionElement.getElementsByTagName("crossRef");
        String[] sourceUrls = new String[urlNodes.getLength()];
        for (int i = 0; i < urlNodes.getLength(); ++i) {
            sourceUrls[i] = urlNodes.item(i).getTextContent();
        }
        return new ListedLicenseException(id, name, text, template, sourceUrls, comment, html, deprecated, deprecatedVersion);
    }
}

