/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licensexml;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.licensexml.LicenseXmlDocument;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ISpdxListedLicenseProvider;
import org.spdx.rdfparser.license.LicenseRestrictionException;
import org.spdx.rdfparser.license.ListedLicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.license.SpdxListedLicenseException;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class XmlLicenseProviderSingleFile
implements ISpdxListedLicenseProvider {
    Logger logger = LoggerFactory.getLogger((String)XmlLicenseProviderSingleFile.class.getName());
    private List<String> warnings = new ArrayList<String>();
    LicenseXmlDocument licDoc = null;

    public XmlLicenseProviderSingleFile(File licenseXmlFile) throws LicenseXmlException {
        this.licDoc = new LicenseXmlDocument(licenseXmlFile);
    }

    public Iterator<SpdxListedLicense> getLicenseIterator() throws SpdxListedLicenseException {
        try {
            return this.licDoc.getListedLicenses().iterator();
        }
        catch (InvalidSPDXAnalysisException e) {
            this.logger.error("SPDX Analysis exception getting license iterator", (Throwable)e);
            throw new SpdxListedLicenseException("SPDX Analysis exception getting license iterator", (Throwable)e);
        }
        catch (LicenseXmlException e) {
            this.logger.error("License XML exception getting license iterator", (Throwable)e);
            throw new SpdxListedLicenseException("Invalid License XML Document", (Throwable)e);
        }
    }

    public Iterator<ListedLicenseException> getExceptionIterator() throws LicenseRestrictionException, SpreadsheetException {
        try {
            return this.licDoc.getLicenseExceptions().iterator();
        }
        catch (LicenseXmlException e) {
            this.logger.error("License XML exception getting license iterator", (Throwable)e);
            throw new RuntimeException(new SpdxListedLicenseException("Invalid License XML Document", (Throwable)e));
        }
    }

    public List<String> getWarnings() {
        return this.warnings;
    }
}

