/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.crossref;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.crossref.Live;
import org.spdx.crossref.Match;
import org.spdx.crossref.OsiApi;
import org.spdx.crossref.Timestamp;
import org.spdx.crossref.Valid;
import org.spdx.crossref.Wayback;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.library.model.v2.license.SpdxListedLicense;

public class CrossRefHelper
implements Callable<Collection<CrossRef>> {
    static final Logger logger = LoggerFactory.getLogger((String)CrossRefHelper.class.getName());
    SpdxListedLicense license;

    public CrossRefHelper(SpdxListedLicense license) {
        this.license = license;
    }

    public static Collection<CrossRef> buildUrlDetails(SpdxListedLicense license) throws InvalidSPDXAnalysisException {
        Collection crossRefs = license.getCrossRef();
        if (crossRefs.size() == 0) {
            for (String seeAlso : license.getSeeAlso()) {
                crossRefs.add(license.createCrossRef(seeAlso).build());
            }
        }
        for (CrossRef crossRef : crossRefs) {
            Optional crossRefUrl = crossRef.getUrl();
            if (!crossRefUrl.isPresent()) continue;
            String url = (String)crossRefUrl.get();
            if (OsiApi.isOsiUrl(url) && OsiApi.getInstance().isApiAvailable()) {
                OsiApi.getInstance().setCrossRefDetails(url, license, crossRef);
                continue;
            }
            CrossRefHelper.setCrossRefDetails(url, license, crossRef);
        }
        return crossRefs;
    }

    private static void setCrossRefDetails(String url, SpdxListedLicense license, CrossRef crossRef) throws InvalidSPDXAnalysisException {
        try {
            Boolean isValidUrl = Valid.urlValidator(url);
            Boolean isLiveUrl = isValidUrl != false ? Live.urlLinkExists(url) : false;
            Boolean isWaybackUrl = isValidUrl != false ? Wayback.isWayBackUrl(url) : false;
            String currentDate = Timestamp.getTimestamp();
            String matchStatus = isLiveUrl != false ? Match.checkMatch(url, license) : "N/A";
            crossRef.setDetails(isValidUrl, isLiveUrl, isWaybackUrl, matchStatus, currentDate);
        }
        catch (Exception e) {
            logger.error("Unexpected exception", (Object)e.getMessage());
            crossRef.setUrl(url);
            crossRef.setDetails(Boolean.valueOf(Valid.urlValidator(url)), Boolean.valueOf(false), Boolean.valueOf(Wayback.isWayBackUrl(url)), "--", Timestamp.getTimestamp());
        }
    }

    @Override
    public Collection<CrossRef> call() throws Exception {
        return CrossRefHelper.buildUrlDetails(this.license);
    }
}

