/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.crossref;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.crossref.OsiLicense;
import org.spdx.crossref.Timestamp;
import org.spdx.crossref.Valid;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.library.model.v2.license.SpdxListedLicense;

public class OsiApi {
    static final Logger logger = LoggerFactory.getLogger((String)OsiApi.class.getName());
    public static final String OSI_PREFIX = "https://opensource.org/licenses";
    private static final String API_BASE_URL = "https://api.opensource.org";
    private static final String ALL_LICENSES_URL = "https://api.opensource.org/licenses/";
    private static final int READ_TIMEOUT = 5000;
    static final List<String> WHITE_LIST = Collections.unmodifiableList(Arrays.asList("osi.org"));
    private boolean apiAvailable = false;
    private Map<String, List<String>> urlToSpdxIds = new HashMap<String, List<String>>();

    public static OsiApi getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static boolean isOsiUrl(String url) {
        return Objects.nonNull(url) && url.startsWith(OSI_PREFIX);
    }

    private OsiApi() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getUrlInputStream(new URL(ALL_LICENSES_URL))));){
            String line;
            StringBuilder osiLicensesStr = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                osiLicensesStr.append(line);
            }
            Gson gson = new Gson();
            Type osiLicenseListType = new TypeToken<ArrayList<OsiLicense>>(){}.getType();
            List osiLicenses = (List)gson.fromJson(osiLicensesStr.toString(), osiLicenseListType);
            for (OsiLicense osiLicense : osiLicenses) {
                if (!Objects.nonNull(osiLicense.getLinks()) || !Objects.nonNull(osiLicense.getId()) || !Objects.nonNull(osiLicense.getIdentifiers())) continue;
                ArrayList<String> spdxIds = new ArrayList<String>();
                for (OsiLicense.IdentifierType identifier : osiLicense.getIdentifiers()) {
                    if (!"SPDX".equals(identifier.getScheme()) || !Objects.nonNull(identifier.getIdentifier())) continue;
                    spdxIds.add(identifier.getIdentifier());
                }
                if (spdxIds.isEmpty()) continue;
                for (OsiLicense.Link link : osiLicense.getLinks()) {
                    if (!Objects.nonNull(link.getUrl())) continue;
                    this.urlToSpdxIds.put(link.getUrl(), spdxIds);
                }
            }
            this.apiAvailable = true;
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL exception getting OSI licenses");
            this.apiAvailable = false;
        }
        catch (IOException e) {
            logger.error("I/O exception getting OSI licenses");
            this.apiAvailable = false;
        }
    }

    private InputStream getUrlInputStream(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setReadTimeout(5000);
        int status = connection.getResponseCode();
        if (status != 200 && (status == 302 || status == 301 || status == 303)) {
            URL redirectUrl;
            String redirectUrlStr = connection.getHeaderField("Location");
            if (Objects.isNull(redirectUrlStr) || redirectUrlStr.isEmpty()) {
                throw new IOException("Empty redirect URL response");
            }
            try {
                redirectUrl = new URL(redirectUrlStr);
            }
            catch (Exception ex) {
                throw new IOException("Invalid redirect URL");
            }
            if (!redirectUrl.getProtocol().toLowerCase().startsWith("http")) {
                throw new IOException("Invalid redirect protocol");
            }
            if (!WHITE_LIST.contains(redirectUrl.getHost())) {
                throw new IOException("Invalid redirect host - not on the allowed 'white list'");
            }
            connection = (HttpURLConnection)redirectUrl.openConnection();
        }
        return connection.getInputStream();
    }

    public boolean isApiAvailable() {
        return this.apiAvailable;
    }

    public void setCrossRefDetails(String url, SpdxListedLicense license, CrossRef crossRef) throws InvalidSPDXAnalysisException {
        Boolean isValidUrl = Valid.urlValidator(url);
        List<String> spdxIds = this.urlToSpdxIds.get(url);
        Boolean isLiveUrl = Objects.nonNull(spdxIds) && spdxIds.contains(license.getId());
        Boolean isWaybackUrl = false;
        String currentDate = Timestamp.getTimestamp();
        String matchStatus = "N/A";
        crossRef.setDetails(isValidUrl, isLiveUrl, isWaybackUrl, matchStatus, currentDate);
    }

    private static class InstanceHolder {
        private static final OsiApi INSTANCE = new OsiApi();

        private InstanceHolder() {
        }
    }
}

