/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.htmltemplates;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringEscapeUtils;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.crossref.Live;
import org.spdx.crossref.Timestamp;
import org.spdx.crossref.Valid;
import org.spdx.crossref.Wayback;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.licenseTemplate.InvalidLicenseTemplateException;

public class LicenseHTMLFile {
    static final String TEMPLATE_CLASS_PATH = "resources/htmlTemplate";
    static final String TEMPLATE_ROOT_PATH = "resources" + File.separator + "htmlTemplate";
    static final String TEMPLATE_FILE_NAME = "LicenseHTMLTemplate.html";
    static Comparator<CrossRef> licenseComparator = new Comparator<CrossRef>(){

        @Override
        public int compare(CrossRef o1, CrossRef o2) {
            Optional order2;
            Optional order1;
            try {
                order1 = o1.getOrder();
            }
            catch (InvalidSPDXAnalysisException e) {
                order1 = Optional.empty();
            }
            try {
                order2 = o2.getOrder();
            }
            catch (InvalidSPDXAnalysisException e) {
                order2 = Optional.empty();
            }
            if (order1.isPresent()) {
                if (order2.isPresent()) {
                    return ((Integer)order1.get()).compareTo((Integer)order2.get());
                }
                return -1;
            }
            if (order2.isPresent()) {
                return 0;
            }
            return 1;
        }
    };
    private SpdxListedLicense license;

    public LicenseHTMLFile(SpdxListedLicense license) {
        this.license = license;
    }

    public LicenseHTMLFile() {
        this(null);
    }

    public SpdxListedLicense getLicense() {
        return this.license;
    }

    public void setLicense(SpdxListedLicense license) {
        this.license = license;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File htmlFile, String tableOfContentsReference) throws IOException, MustacheException, InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        if (!htmlFile.exists() && !htmlFile.createNewFile()) {
            throw new IOException("Can not create new file " + htmlFile.getName());
        }
        String templateDirName = TEMPLATE_ROOT_PATH;
        File templateDirectoryRoot = new File(templateDirName);
        if (!templateDirectoryRoot.exists() || !templateDirectoryRoot.isDirectory()) {
            templateDirName = TEMPLATE_CLASS_PATH;
        }
        try {
            stream = new FileOutputStream(htmlFile);
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            DefaultMustacheFactory builder = new DefaultMustacheFactory(templateDirName);
            Map<String, Object> mustacheMap = this.buildMustachMap();
            Mustache mustache = builder.compile(TEMPLATE_FILE_NAME);
            mustache.execute((Writer)writer, mustacheMap);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    private Map<String, Object> buildMustachMap() throws InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        if (this.license != null) {
            retval.put("licenseId", this.license.getLicenseId());
            String licenseTextHtml = this.license.getLicenseTextHtml();
            retval.put("licenseText", licenseTextHtml);
            retval.put("licenseName", this.license.getName());
            String notes = this.license.getComment() != null && !this.license.getComment().isEmpty() ? this.license.getComment() : null;
            String templateText = this.license.getStandardLicenseTemplate();
            if (templateText == null) {
                templateText = StringEscapeUtils.escapeHtml4((String)this.license.getLicenseText());
            }
            retval.put("standardLicenseTemplate", templateText);
            retval.put("notes", notes);
            retval.put("osiApproved", this.license.isOsiApproved());
            retval.put("fsfLibre", this.license.isFsfLibre());
            retval.put("notFsfLibre", this.license.isNotFsfLibre());
            ArrayList<FormattedUrl> otherWebPages = new ArrayList<FormattedUrl>();
            try {
                ArrayList<CrossRef> crossRefCopy = new ArrayList<CrossRef>();
                for (CrossRef crossRef : this.license.getCrossRef()) {
                    crossRefCopy.add(crossRef);
                }
                Collections.sort(crossRefCopy, licenseComparator);
                for (CrossRef crossRef : crossRefCopy) {
                    otherWebPages.add(new FormattedUrl(crossRef.getUrl(), crossRef.getValid(), crossRef.getLive(), crossRef.getIsWayBackLink(), crossRef.getMatch(), crossRef.getTimestamp()));
                }
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new InvalidLicenseTemplateException("Error getting crossRefs", (Throwable)e);
            }
            if (otherWebPages.size() == 0) {
                otherWebPages = null;
            }
            retval.put("otherWebPages", otherWebPages);
            retval.put("title", this.license.getName());
            String header = this.license.getLicenseHeaderHtml();
            if (header != null && header.trim().isEmpty()) {
                header = null;
            }
            retval.put("licenseHeader", header);
            retval.put("deprecated", this.license.isDeprecated());
            retval.put("deprecatedVersion", this.license.getDeprecatedVersion());
        }
        return retval;
    }

    public static class FormattedUrl {
        String url;
        Boolean isValid;
        Boolean isLive;
        Boolean isWayBackLink;
        String match;
        String timestamp;

        public FormattedUrl(Optional<String> url, Optional<Boolean> isValid, Optional<Boolean> isLive, Optional<Boolean> isWayBackLink, Optional<String> match, Optional<String> timestamp) {
            this.url = url.isPresent() ? url.get() : "N/A";
            this.isValid = isValid.isPresent() ? isValid.get() : false;
            this.isLive = isLive.isPresent() ? isLive.get() : false;
            this.isWayBackLink = isWayBackLink.isPresent() ? isWayBackLink.get() : false;
            this.match = match.isPresent() ? match.get() : "N/A";
            this.timestamp = timestamp.isPresent() ? timestamp.get() : "N/A";
        }

        public String getUrl() {
            return this.url;
        }

        public String getSite() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean getIsValid() {
            if (this.isValid != null) {
                return this.isValid;
            }
            return Valid.urlValidator(this.url);
        }

        public boolean getIsLive() {
            if (this.isLive != null) {
                return this.isLive;
            }
            return Live.urlLinkExists(this.url);
        }

        public String getMatch() {
            if (this.match != null) {
                return this.match;
            }
            return "--";
        }

        public boolean getIsWayBackLink() {
            if (this.isWayBackLink != null) {
                return this.isWayBackLink;
            }
            return Wayback.isWayBackUrl(this.url);
        }

        public String getTimestamp() {
            if (this.timestamp != null) {
                return this.timestamp;
            }
            return Timestamp.getTimestamp();
        }
    }
}

