/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.crossref.CrossRefHelper;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v2.license.SpdxListedLicenseException;
import org.spdx.licenseTemplate.InvalidLicenseTemplateException;
import org.spdx.licenseTemplate.LicenseTextHelper;
import org.spdx.licenselistpublisher.ISpdxListedLicenseProvider;
import org.spdx.licenselistpublisher.LicenseGeneratorException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.FsfLicenseDataParser;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseTester;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseJsonFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseMarkdownFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseRdfFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseRdfaFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseTemplateFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseTextFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseV3JsonLdFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.SimpleLicenseTester;
import org.spdx.licenselistpublisher.licensegenerator.SpdxWebsiteFormatWriter;
import org.spdx.licensexml.XmlLicenseProviderSingleFile;
import org.spdx.licensexml.XmlLicenseProviderWithCrossRefDetails;
import org.spdx.utility.compare.LicenseCompareHelper;
import org.spdx.utility.compare.SpdxCompareException;

public class LicenseRDFAGenerator {
    static final Set<Character> INVALID_TEXT_CHARS = new HashSet<Character>();
    static int MIN_ARGS;
    static int MAX_ARGS;
    static final int ERROR_STATUS = 1;
    static final int WARNING_STATUS = 64;
    static final String CSS_TEMPLATE_FILE = "resources/screen.css";
    static final String CSS_FILE_NAME = "screen.css";
    static final String SORTTABLE_JS_FILE = "resources/sorttable.js";
    static final String SORTTABLE_FILE_NAME = "sorttable.js";
    static final String TEXT_FOLDER_NAME = "text";
    static final String TEMPLATE_FOLDER_NAME = "template";
    static final String HTML_FOLDER_NAME = "html";
    static final String RDFA_FOLDER_NAME = "rdfa";
    static final String JSON_FOLDER_NAME = "json";
    private static final String WEBSITE_FOLDER_NAME = "website";
    private static final String RDFXML_FOLDER_NAME = "rdfxml";
    private static final String RDFTURTLE_FOLDER_NAME = "rdfturtle";
    private static final String RDFNT_FOLDER_NAME = "rdfnt";
    private static final String TABLE_OF_CONTENTS_FILE_NAME = "licenses.md";
    private static final String RDF_JSON_LD_FOLDER_NAME = "jsonld";
    private static final String LICENSE_XML_FOLDER_NAME = "license-list-XML";
    private static final String ENV_USE_SYSTEM_TEST = "USE_TEST_FOR_TEXT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File dir;
        File licenseXmlFileOrDir;
        SpdxModelFactory.init();
        if (args == null || args.length < MIN_ARGS || args.length > MAX_ARGS) {
            System.out.println("Invalid arguments");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        if (!(licenseXmlFileOrDir = new File(args[0])).exists()) {
            System.out.println("License XML " + licenseXmlFileOrDir.getName() + " does not exist");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        if (!(dir = new File(args[1])).exists()) {
            System.out.println("Output directory " + dir.getName() + " does not exist");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        if (!dir.isDirectory()) {
            System.out.println("Output directory " + dir.getName() + " is not a directory");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        String version = null;
        if (args.length > 2) {
            version = args[2];
        }
        String releaseDate = null;
        if (args.length > 3) {
            releaseDate = args[3];
        }
        File testFileDir = null;
        if (args.length > 4) {
            testFileDir = new File(args[4]);
            if (!testFileDir.exists()) {
                System.out.println("License test directory " + testFileDir.getName() + " does not exist");
                LicenseRDFAGenerator.usage();
                System.exit(1);
            }
            if (!testFileDir.isDirectory()) {
                System.out.println("License test directory " + testFileDir.getName() + " is not a directory");
                LicenseRDFAGenerator.usage();
                System.exit(1);
            }
        }
        String[] ignoredWarnings = new String[]{};
        if (args.length > 5) {
            CSVReader reader = null;
            try {
                File warningsFile = new File(args[5]);
                reader = warningsFile.exists() ? new CSVReader((Reader)new FileReader(warningsFile)) : new CSVReader((Reader)new StringReader(args[5]));
                ignoredWarnings = reader.readNext();
            }
            catch (IOException e) {
                System.out.println("IO Error reading ignored errors: " + e.getMessage());
                System.exit(1);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        System.out.println("IO Error closing ignored errors string: " + e.getMessage());
                        System.exit(1);
                    }
                }
            }
        }
        boolean useTestText = true;
        try {
            String useTestTextStr = System.getenv(ENV_USE_SYSTEM_TEST);
            if (Objects.nonNull(useTestTextStr)) {
                useTestText = Boolean.parseBoolean(useTestTextStr);
            }
        }
        catch (SecurityException ex) {
            System.out.println("Security exception checking for the environment variable USE_TEST_FOR_TEXT.  Using the default useTestText = true.");
        }
        try {
            List<String> warnings = LicenseRDFAGenerator.generateLicenseData(licenseXmlFileOrDir, dir, version, releaseDate, testFileDir, useTestText);
            if (warnings != null && warnings.size() > 0) {
                int numUnexpectedWarnings = warnings.size();
                for (String warning : warnings) {
                    boolean ignore = false;
                    for (String ignoreStr : ignoredWarnings) {
                        if (!warning.equalsIgnoreCase(ignoreStr)) continue;
                        ignore = true;
                        System.out.println("Ignoring warning '" + ignoreStr + "'");
                        break;
                    }
                    if (!ignore) continue;
                    --numUnexpectedWarnings;
                }
                if (numUnexpectedWarnings > 0) {
                    System.exit(64);
                }
            }
        }
        catch (LicenseGeneratorException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    public static List<String> generateLicenseData(File licenseXml, File dir, String version, String releaseDateUnformated, File testFileDir, boolean useTestText) throws LicenseGeneratorException {
        String releaseDate = LicenseRDFAGenerator.convertDateFormat(releaseDateUnformated);
        ArrayList<String> warnings = new ArrayList<String>();
        ArrayList<ILicenseFormatWriter> writers = new ArrayList<ILicenseFormatWriter>();
        ISpdxListedLicenseProvider licenseProvider = null;
        try {
            File licenseXmlOutputFolder = new File(dir.getPath() + File.separator + LICENSE_XML_FOLDER_NAME);
            if (!licenseXmlOutputFolder.isDirectory() && !licenseXmlOutputFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: license-xml folder is not a directory");
            }
            if (licenseXml.isDirectory()) {
                licenseProvider = new XmlLicenseProviderWithCrossRefDetails(licenseXml, version, releaseDate);
                FileUtils.copyDirectory((File)licenseXml, (File)licenseXmlOutputFolder);
            } else {
                licenseProvider = new XmlLicenseProviderSingleFile(licenseXml, version, releaseDate);
                Files.copy(licenseXml.toPath(), licenseXmlOutputFolder.toPath().resolve(licenseXml.getName()), new CopyOption[0]);
            }
            File textFolder = new File(dir.getPath() + File.separator + TEXT_FOLDER_NAME);
            if (!textFolder.isDirectory() && !textFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: text folder is not a directory");
            }
            writers.add(new LicenseTextFormatWriter(textFolder));
            File templateFolder = new File(dir.getPath() + File.separator + TEMPLATE_FOLDER_NAME);
            if (!templateFolder.isDirectory() && !templateFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: template folder is not a directory");
            }
            writers.add(new LicenseTemplateFormatWriter(templateFolder));
            File htmlFolder = new File(dir.getPath() + File.separator + HTML_FOLDER_NAME);
            if (!htmlFolder.isDirectory() && !htmlFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: HTML folder is not a directory");
            }
            writers.add(new LicenseHtmlFormatWriter(version, releaseDate, htmlFolder));
            File rdfaFolder = new File(dir.getPath() + File.separator + RDFA_FOLDER_NAME);
            if (!rdfaFolder.isDirectory() && !rdfaFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: RDFa folder is not a directory");
            }
            writers.add(new LicenseRdfaFormatWriter(version, releaseDate, rdfaFolder));
            File jsonFolder = new File(dir.getPath() + File.separator + JSON_FOLDER_NAME);
            if (!jsonFolder.isDirectory() && !jsonFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: JSON folder is not a directory");
            }
            File jsonFolderDetails = new File(dir.getPath() + File.separator + JSON_FOLDER_NAME + File.separator + "details");
            if (!jsonFolderDetails.isDirectory() && !jsonFolderDetails.mkdir()) {
                throw new LicenseGeneratorException("Error: JSON folder is not a directory");
            }
            File jsonFolderExceptions = new File(dir.getPath() + File.separator + JSON_FOLDER_NAME + File.separator + "exceptions");
            if (!jsonFolderExceptions.isDirectory() && !jsonFolderExceptions.mkdir()) {
                throw new LicenseGeneratorException("Error: JSON folder is not a directory");
            }
            writers.add(new LicenseJsonFormatWriter(version, releaseDate, jsonFolder, jsonFolderDetails, jsonFolderExceptions));
            File website = new File(dir.getPath() + File.separator + WEBSITE_FOLDER_NAME);
            if (!website.isDirectory() && !website.mkdir()) {
                throw new LicenseGeneratorException("Error: Website folder is not a directory");
            }
            writers.add(new SpdxWebsiteFormatWriter(version, releaseDate, website));
            File rdfXml = new File(dir.getPath() + File.separator + RDFXML_FOLDER_NAME);
            if (!rdfXml.isDirectory() && !rdfXml.mkdir()) {
                throw new LicenseGeneratorException("Error: RdfXML folder is not a directory");
            }
            File rdfTurtle = new File(dir.getPath() + File.separator + RDFTURTLE_FOLDER_NAME);
            if (!rdfTurtle.isDirectory() && !rdfTurtle.mkdir()) {
                throw new LicenseGeneratorException("Error: RDF Turtle folder is not a directory");
            }
            File rdfNt = new File(dir.getPath() + File.separator + RDFNT_FOLDER_NAME);
            if (!rdfNt.isDirectory() && !rdfNt.mkdir()) {
                throw new LicenseGeneratorException("Error: RDF NT folder is not a directory");
            }
            File rdfJsonLd = new File(dir.getPath() + File.separator + RDF_JSON_LD_FOLDER_NAME);
            if (!rdfJsonLd.isDirectory() && !rdfJsonLd.mkdir()) {
                throw new LicenseGeneratorException("Error: RDF JSON-LD folder is not a directory");
            }
            writers.add(new LicenseRdfFormatWriter(rdfXml, rdfTurtle, rdfNt, rdfJsonLd));
            File markdownFile = new File(dir.getPath() + File.separator + TABLE_OF_CONTENTS_FILE_NAME);
            if (!markdownFile.isFile() && !markdownFile.createNewFile()) {
                throw new LicenseGeneratorException("Error: Unable to create markdown file");
            }
            writers.add(new LicenseMarkdownFormatWriter(version, releaseDate, markdownFile));
            File v3JsonLd = new File(dir.getPath() + File.separator + "SPDXv3" + File.separator + "v3jsonld");
            if (!v3JsonLd.isDirectory() && !v3JsonLd.mkdirs()) {
                throw new LicenseGeneratorException("Error: SPDX V3 Json-LD folder is not a directory");
            }
            writers.add(new LicenseV3JsonLdFormatWriter(version, releaseDate, v3JsonLd));
            SimpleLicenseTester tester = null;
            if (testFileDir != null) {
                tester = new SimpleLicenseTester(testFileDir);
            }
            System.out.print("Processing License List");
            Set<String> licenseIds = LicenseRDFAGenerator.writeLicenseList(version, releaseDate, licenseProvider, warnings, writers, tester, useTestText);
            System.out.println();
            System.out.print("Processing Exceptions");
            LicenseRDFAGenerator.writeExceptionList(version, releaseDate, licenseProvider, warnings, writers, tester, licenseIds, useTestText);
            System.out.println();
            System.out.print("Writing table of contents");
            for (ILicenseFormatWriter writer : writers) {
                writer.writeToC();
            }
            LicenseRDFAGenerator.writeCssFile(website);
            LicenseRDFAGenerator.writeSortTableFile(website);
            System.out.println();
            warnings.addAll(licenseProvider.getWarnings());
            if (warnings.size() > 0) {
                System.out.println("The following warning(s) were identified:");
                for (String warning : warnings) {
                    System.out.println("\t" + warning);
                }
            }
            System.out.println("Completed processing licenses");
            return warnings;
        }
        catch (SpdxListedLicenseException e) {
            throw new LicenseGeneratorException("\nError reading standard licenses: " + e.getMessage(), e);
        }
        catch (LicenseGeneratorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LicenseGeneratorException("\nUnhandled exception generating html: " + e.getMessage(), e);
        }
    }

    private static String convertDateFormat(String unformattedDate) throws LicenseGeneratorException {
        DateTimeFormatterBuilder fromFormatterBuilder = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("[MM/dd/yyyy][dd-MM-yyyy][yyyy-MM-dd][yyyy-MM-dd'T'HH:mm:ss'Z']"));
        DateTimeFormatter fromFormatter = fromFormatterBuilder.toFormatter();
        LocalDate date = LocalDate.parse(unformattedDate, fromFormatter);
        if (Objects.isNull(date)) {
            throw new LicenseGeneratorException("Could not parse the release date: " + unformattedDate);
        }
        DateTimeFormatter toFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return date.atStartOfDay().format(toFormatter);
    }

    private static void writeExceptionList(String version, String releaseDate, ISpdxListedLicenseProvider licenseProvider, List<String> warnings, List<ILicenseFormatWriter> writers, ILicenseTester tester, Set<String> licenseIds, boolean useTestText) throws IOException, LicenseGeneratorException, InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        Iterator<ListedExceptionContainer> exceptionIter = licenseProvider.getExceptionIterator();
        HashMap<String, String> addedExceptionsMap = new HashMap<String, String>();
        while (exceptionIter.hasNext()) {
            System.out.print(".");
            ListedExceptionContainer nextExceptionContainer = exceptionIter.next();
            LicenseRDFAGenerator.addExternalMetaData(nextExceptionContainer);
            if (nextExceptionContainer.getV2Exception().getLicenseExceptionId() == null || nextExceptionContainer.getV2Exception().getLicenseExceptionId().isEmpty()) continue;
            if (!nextExceptionContainer.getV2Exception().isDeprecated()) {
                for (Map.Entry entry : addedExceptionsMap.entrySet()) {
                    if (!((String)entry.getValue()).trim().equals(nextExceptionContainer.getV2Exception().getLicenseExceptionText().trim())) continue;
                    warnings.add("Duplicates exceptions: " + nextExceptionContainer.getV2Exception().getLicenseExceptionId() + ", " + (String)entry.getKey());
                }
                addedExceptionsMap.put(nextExceptionContainer.getV2Exception().getLicenseExceptionId(), nextExceptionContainer.getV2Exception().getLicenseExceptionText());
            }
            if (licenseIds.contains(nextExceptionContainer.getV2Exception().getLicenseExceptionId())) {
                warnings.add("A license ID exists with the same ID as an exception ID: " + nextExceptionContainer.getV2Exception().getLicenseExceptionId());
            }
            LicenseRDFAGenerator.checkText(nextExceptionContainer.getV2Exception().getLicenseExceptionText(), "License Exception Text for " + nextExceptionContainer.getV2Exception().getLicenseExceptionId(), warnings);
            if (tester != null) {
                String testText;
                List<String> testResults = tester.testException(nextExceptionContainer);
                if (testResults != null && testResults.size() > 0) {
                    Map.Entry entry;
                    entry = testResults.iterator();
                    while (entry.hasNext()) {
                        String testResult = (String)entry.next();
                        warnings.add("Test for exception " + nextExceptionContainer.getV2Exception().getLicenseExceptionId() + " failed: " + testResult);
                    }
                } else if (useTestText && Objects.nonNull(testText = tester.getExceptionTestText(nextExceptionContainer.getV2Exception().getLicenseExceptionId()))) {
                    nextExceptionContainer.getV2Exception().setLicenseExceptionText(testText);
                    nextExceptionContainer.getV3Exception().setAdditionText(testText);
                }
            }
            for (ILicenseFormatWriter writer : writers) {
                writer.writeException(nextExceptionContainer);
            }
        }
    }

    private static void addExternalMetaData(ListedExceptionContainer exceptionContainer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkText(String text, String textDescription, List<String> warnings) {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        try {
            int lineNumber = 1;
            String line = reader.readLine();
            while (line != null) {
                for (int i = 0; i < line.length(); ++i) {
                    if (!INVALID_TEXT_CHARS.contains(Character.valueOf(line.charAt(i)))) continue;
                    warnings.add("Invalid character in " + textDescription + " at line number " + String.valueOf(lineNumber) + " \"" + line + "\" at character location " + String.valueOf(i));
                }
                ++lineNumber;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            warnings.add("IO error reading text");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                warnings.add("IO Error closing string reader");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> writeLicenseList(String version, String releaseDate, ISpdxListedLicenseProvider licenseProvider, List<String> warnings, List<ILicenseFormatWriter> writers, ILicenseTester tester, boolean useTestText) throws LicenseGeneratorException, InvalidSPDXAnalysisException, IOException, SpdxListedLicenseException, SpdxCompareException, InvalidLicenseTemplateException {
        Iterator<ListedLicenseContainer> licenseIter = licenseProvider.getLicenseIterator();
        try {
            HashMap<String, String> addedLicIdTextMap = new HashMap<String, String>();
            while (licenseIter.hasNext()) {
                System.out.print(".");
                ListedLicenseContainer licenseContainer = licenseIter.next();
                if (licenseProvider instanceof XmlLicenseProviderSingleFile) {
                    licenseContainer.getV2ListedLicense().getCrossRef().addAll(CrossRefHelper.buildUrlDetails(licenseContainer.getV2ListedLicense()));
                }
                LicenseRDFAGenerator.addExternalMetaData(licenseContainer);
                String licenseId = licenseContainer.getV2ListedLicense().getLicenseId();
                if (licenseId == null || licenseId.isEmpty()) continue;
                if (!licenseContainer.getV2ListedLicense().isDeprecated()) {
                    for (Map.Entry entry2 : addedLicIdTextMap.entrySet()) {
                        if (!LicenseTextHelper.isLicenseTextEquivalent((String)((String)entry2.getValue()), (String)licenseContainer.getV2ListedLicense().getLicenseText())) continue;
                        warnings.add("Duplicates licenses: " + licenseContainer.getV2ListedLicense().getLicenseId() + ", " + (String)entry2.getKey());
                    }
                    addedLicIdTextMap.put(licenseId, licenseContainer.getV2ListedLicense().getLicenseText());
                }
                LicenseRDFAGenerator.checkText(licenseContainer.getV2ListedLicense().getLicenseText(), "License text for " + licenseId, warnings);
                if (tester != null) {
                    String testText;
                    List<String> testResults = tester.testLicense(licenseContainer);
                    if (testResults != null && testResults.size() > 0) {
                        Map.Entry entry2;
                        entry2 = testResults.iterator();
                        while (entry2.hasNext()) {
                            String testResult = (String)entry2.next();
                            warnings.add("Test for license " + licenseId + " failed: " + testResult);
                        }
                    } else if (useTestText && Objects.nonNull(testText = tester.getLicenseTestText(licenseId))) {
                        licenseContainer.getV2ListedLicense().setLicenseText(testText);
                        licenseContainer.getV3ListedLicense().setLicenseText(testText);
                    }
                }
                for (ILicenseFormatWriter writer : writers) {
                    if (writer instanceof LicenseTextFormatWriter) {
                        ((LicenseTextFormatWriter)writer).writeLicense(licenseContainer, licenseContainer.getV2ListedLicense().isDeprecated(), licenseContainer.getV2ListedLicense().getDeprecatedVersion(), !useTestText);
                        continue;
                    }
                    writer.writeLicense(licenseContainer, licenseContainer.getV2ListedLicense().isDeprecated(), licenseContainer.getV2ListedLicense().getDeprecatedVersion());
                }
            }
            if (addedLicIdTextMap.size() == 1) {
                addedLicIdTextMap.entrySet().forEach(entry -> {
                    try {
                        String[] matchingLicenseIds;
                        for (String matchingId : matchingLicenseIds = LicenseCompareHelper.matchingStandardLicenseIds((String)((String)entry.getValue()))) {
                            if (((String)entry.getKey()).equals(matchingId)) continue;
                            warnings.add("Duplicates licenses: " + (String)entry.getKey() + ", " + matchingId);
                        }
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        warnings.add("Error comparing single license to existing listed licenses: " + e.getMessage());
                    }
                    catch (SpdxCompareException e) {
                        warnings.add("Error comparing single license to existing listed licenses: " + e.getMessage());
                    }
                });
            }
            Set<String> set = addedLicIdTextMap.keySet();
            return set;
        }
        finally {
            if (licenseIter instanceof Closeable) {
                ((Closeable)((Object)licenseIter)).close();
            }
        }
    }

    private static void addExternalMetaData(ListedLicenseContainer licenseContainer) throws LicenseGeneratorException, InvalidSPDXAnalysisException {
        Boolean fsfLibre = FsfLicenseDataParser.getFsfLicenseDataParser().isSpdxLicenseFsfLibre(licenseContainer.getV2ListedLicense().getLicenseId());
        licenseContainer.getV2ListedLicense().setFsfLibre(fsfLibre);
        licenseContainer.getV3ListedLicense().setIsFsfLibre(fsfLibre);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyResourceFile(String resourceFileName, File destination) throws IOException {
        File resourceFile = new File(resourceFileName);
        if (resourceFile.exists()) {
            Files.copy(resourceFile.toPath(), destination.toPath(), new CopyOption[0]);
        } else {
            InputStream is = LicenseRDFAGenerator.class.getClassLoader().getResourceAsStream(resourceFileName);
            InputStreamReader reader = new InputStreamReader(is);
            FileWriter writer = new FileWriter(destination);
            try {
                char[] buf = new char[2048];
                int len = reader.read(buf);
                while (len > 0) {
                    writer.write(buf, 0, len);
                    len = reader.read(buf);
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                reader.close();
            }
        }
    }

    private static void writeCssFile(File dir) throws IOException {
        File cssFile = new File(dir.getPath() + File.separator + CSS_FILE_NAME);
        if (cssFile.exists() && !cssFile.delete()) {
            throw new IOException("Unable to delete old file");
        }
        LicenseRDFAGenerator.copyResourceFile(CSS_TEMPLATE_FILE, cssFile);
    }

    private static void writeSortTableFile(File dir) throws IOException {
        File sortTableFile = new File(dir.getPath() + File.separator + SORTTABLE_FILE_NAME);
        if (sortTableFile.exists()) {
            return;
        }
        LicenseRDFAGenerator.copyResourceFile(SORTTABLE_JS_FILE, sortTableFile);
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("LicenseRDFAGenerator licencenseXmlFileOrDir outputDirectory [version] [releasedate] [testfiles] [ignoredwarnings]");
        System.out.println("   licencenseXmlFileOrDir - a license XML file or a directory of license XML files");
        System.out.println("   outputDirectory - Directory to store the output from the license generator");
        System.out.println("   [version] - Version of the SPDX license list");
        System.out.println("   [releasedate] - Release date of the SPDX license list");
        System.out.println("   [testfiles] - Directory of original text files to compare the generated licenses against");
        System.out.println("   [ignoredwarnings] - Either a file name or a comma separated list of warnings to be ignored");
    }

    static {
        INVALID_TEXT_CHARS.add(Character.valueOf('\ufffd'));
        MIN_ARGS = 2;
        MAX_ARGS = 6;
    }
}

