/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.v3_0_1.expandedlicensing.License;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licensexml.LicenseXmlDocument;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.licensexml.XmlLicenseProvider;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.utility.compare.CompareTemplateOutputHandler;
import org.spdx.utility.compare.LicenseCompareHelper;
import org.spdx.utility.compare.SpdxCompareException;

public class LicenseXmlTester {
    static int MIN_ARGS = 2;
    static int MAX_ARGS = 2;
    static final int ERROR_STATUS = 1;
    static final int WARNING_STATUS = 64;

    public static void main(String[] args) {
        File testFile;
        File licenseXmlFile;
        if (args == null || args.length < MIN_ARGS || args.length > MAX_ARGS) {
            System.out.println("Invalid arguments");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        if (!(licenseXmlFile = new File(args[0])).exists()) {
            System.out.println("License XML file " + licenseXmlFile.getName() + " does not exist");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        if (!licenseXmlFile.isFile()) {
            System.out.println("License XML file " + licenseXmlFile.getName() + " is not a valid file");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        if (!(testFile = new File(args[1])).exists()) {
            System.out.println("Test file " + testFile.getName() + " does not exist");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        if (!testFile.isFile()) {
            System.out.println("Test file " + testFile.getName() + " is not a valid file");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        try {
            InMemSpdxStore spdxV2ModelStore = new InMemSpdxStore();
            InMemSpdxStore spdxV3ModelStore = new InMemSpdxStore();
            ModelCopyManager copyManager = new ModelCopyManager();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            String now = format.format(new Date());
            LicenseXmlDocument licDoc = new LicenseXmlDocument(licenseXmlFile, (IModelStore)spdxV2ModelStore, (IModelStore)spdxV3ModelStore, (IModelCopyManager)copyManager, XmlLicenseProvider.createCreationInfo((IModelStore)spdxV3ModelStore, (IModelCopyManager)copyManager, "3.25.0", now));
            List<ListedLicenseContainer> licenses = licDoc.getListedLicenses();
            if (licenses.size() == 0) {
                System.out.println("Empty license XML file - no licenses found");
                System.exit(1);
            }
            if (licenses.size() > 1) {
                System.out.println("More than one licenses found");
                System.exit(1);
            }
            String compareText = LicenseXmlTester.readText(testFile);
            CompareTemplateOutputHandler.DifferenceDescription diff = LicenseCompareHelper.isTextStandardLicense((License)licenses.get(0).getV3ListedLicense(), (String)compareText);
            if (diff.isDifferenceFound()) {
                System.out.println("Difference found comparing to test file: " + diff.getDifferenceMessage());
                System.exit(1);
            }
            System.out.println("License " + String.valueOf(licenses.get(0).getV3ListedLicense().getName()) + " passed");
        }
        catch (LicenseXmlException e) {
            System.out.println("Invalid license XML document: " + e.getMessage());
            System.exit(1);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.println("Invalid license SPDX definition: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("I/O error reading test file: " + e.getMessage());
            System.exit(1);
        }
        catch (SpdxCompareException e) {
            System.out.println("Invalid license template: " + e.getMessage());
            System.exit(1);
        }
    }

    private static String readText(File f) throws IOException {
        Charset utf8 = Charset.forName("UTF-8");
        StringBuilder text = new StringBuilder();
        try (Stream<String> fileLines = Files.lines(f.toPath(), utf8);){
            fileLines.forEach(line -> {
                text.append((String)line);
                text.append("\n");
            });
        }
        return text.toString();
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("TestLicenseXML licenseXmlFile textFile");
        System.out.println("   licenseXmlFile XML - file to test");
        System.out.println("   textFile - Text file which should match the the license text for the licenseXmlFile");
    }
}

