/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.licenselistpublisher.LicenseGeneratorException;

public class FsfLicenseDataParser {
    static final Logger logger = LoggerFactory.getLogger(FsfLicenseDataParser.class);
    static final String PROP_USE_ONLY_LOCAL_FILE = "LocalFsfFreeJson";
    static final String PROP_FSF_FREE_JSON_URL = "FsfFreeJsonUrl";
    static final String DEFAULT_FSF_JSON_URL = "https://spdx.github.io/fsf-api/licenses-full.json";
    static final String FSF_JSON_FILE_PATH = "resources" + File.separator + "licenses-full.json";
    static final String FSF_JSON_CLASS_PATH = "licenses-full.json";
    static final String FSF_JSON_NAMESPACE = "http://tremily.us/fsf/schema/";
    static final String PROPERTY_TAGS = "license.jsonldtags";
    private static final String PROPERTY_KEYWORDS = "keywords";
    private static final String SCHEMA_ORG_NAMESPACE = "https://schema.org/";
    private static final String PROPERTY_SPDXID = "license.jsonldspdx";
    private static final String PROPERTY_IDENTIFIER = "identifier";
    private static final String PROPERTY_IDENTIFIERS = "license.jsonldidentifiers";
    private static FsfLicenseDataParser fsfLicenseDataParser = null;
    private Map<String, Boolean> licenseIdToFsfFree = new HashMap<String, Boolean>();
    private boolean useOnlyLocalFile = Boolean.parseBoolean(System.getProperty("LocalFsfFreeJson", "false"));
    private String licenseJsonUrl = System.getProperty("FsfFreeJsonUrl", "https://spdx.github.io/fsf-api/licenses-full.json");

    private FsfLicenseDataParser() throws LicenseGeneratorException {
        InputStream input = null;
        ClassLoader oldContextCL = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader newClassLoader = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(newClassLoader);
            if (!this.useOnlyLocalFile) {
                try {
                    URL url = new URL(this.licenseJsonUrl);
                    input = url.openStream();
                }
                catch (MalformedURLException e) {
                    input = null;
                }
                catch (IOException e) {
                    input = null;
                }
            }
            if (input == null) {
                try {
                    input = new FileInputStream(FSF_JSON_FILE_PATH);
                }
                catch (FileNotFoundException e) {
                    input = null;
                }
            }
            if (input == null) {
                try {
                    input = this.getClass().getResourceAsStream(FSF_JSON_CLASS_PATH);
                }
                catch (Exception e) {
                    input = null;
                }
            }
            if (input == null) {
                throw new LicenseGeneratorException("Unable to open input JSON file for FSF License Data");
            }
            Model model = ModelFactory.createDefaultModel();
            model.read(input, null, "JSON-LD");
            Node p = model.getProperty(SCHEMA_ORG_NAMESPACE, PROPERTY_KEYWORDS).asNode();
            Triple m = Triple.createMatch(null, (Node)p, null);
            ExtendedIterator tripleIter = model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                List<String> spdxIds;
                Node subject;
                Triple t = (Triple)tripleIter.next();
                if (!t.getObject().isLiteral()) continue;
                String objectVal = t.getObject().toString((PrefixMapping)model);
                if ("\"libre\"".equals(objectVal)) {
                    subject = t.getSubject();
                    spdxIds = this.findSpdxIds(subject, model);
                    for (String spdxId : spdxIds) {
                        this.licenseIdToFsfFree.put(spdxId.replaceAll("\"", ""), true);
                    }
                    continue;
                }
                if (!"\"non-free\"".equals(objectVal)) continue;
                subject = t.getSubject();
                spdxIds = this.findSpdxIds(subject, model);
                for (String spdxId : spdxIds) {
                    this.licenseIdToFsfFree.put(spdxId.replaceAll("\"", ""), false);
                }
            }
        }
        catch (Exception ex) {
            throw new LicenseGeneratorException("Error parsing FSF license data");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error("Unable to close input for the FSF API");
                }
            }
            Thread.currentThread().setContextClassLoader(oldContextCL);
        }
    }

    private List<String> findSpdxIds(Node subject, Model model) throws LicenseGeneratorException {
        return this.findSpdxIds(subject, model, SCHEMA_ORG_NAMESPACE, PROPERTY_IDENTIFIER);
    }

    private List<String> findSpdxIds(Node subject, Model model, String namespace, String propertyName) throws LicenseGeneratorException {
        Node identifiersProp = model.getProperty(namespace, propertyName).asNode();
        Triple identifersMatch = Triple.createMatch((Node)subject, (Node)identifiersProp, null);
        ExtendedIterator identifiersIterator = model.getGraph().find(identifersMatch);
        ArrayList<String> retval = new ArrayList<String>();
        while (identifiersIterator.hasNext()) {
            Node identifiersObject = ((Triple)identifiersIterator.next()).getObject();
            if (identifiersObject == null) continue;
            retval.add(identifiersObject.toString((PrefixMapping)model));
        }
        return retval;
    }

    public static synchronized FsfLicenseDataParser getFsfLicenseDataParser() throws LicenseGeneratorException {
        if (fsfLicenseDataParser == null) {
            fsfLicenseDataParser = new FsfLicenseDataParser();
        }
        return fsfLicenseDataParser;
    }

    public Boolean isSpdxLicenseFsfLibre(String spdxLicenseId) {
        return this.licenseIdToFsfFree.get(spdxLicenseId);
    }
}

