/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Set;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.licenseTemplate.InvalidLicenseTemplateException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;

public class LicenseHtmlFormatWriter
implements ILicenseFormatWriter {
    static final Set<Character> INVALID_FILENAME_CHARS = new HashSet<Character>();
    private File htmlFolder;
    private Charset utf8 = Charset.forName("UTF-8");

    public LicenseHtmlFormatWriter(String version, String releaseDate, File htmlFolder) {
        this.htmlFolder = htmlFolder;
    }

    public File getHtmlFolder() {
        return this.htmlFolder;
    }

    public void setHtmlFolder(File htmlFolder) {
        this.htmlFolder = htmlFolder;
    }

    @Override
    public void writeLicense(ListedLicenseContainer licenseContainer, boolean deprecated, String deprecatedVersion) throws IOException, InvalidSPDXAnalysisException {
        SpdxListedLicense license = licenseContainer.getV2ListedLicense();
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        String licHtmlFileName = licBaseHtmlFileName + ".html";
        File htmlTextFile = new File(this.htmlFolder.getPath() + File.separator + licHtmlFileName);
        try {
            Files.write(htmlTextFile.toPath(), license.getLicenseTextHtml().getBytes(this.utf8), new OpenOption[0]);
        }
        catch (InvalidLicenseTemplateException e) {
            Files.write(htmlTextFile.toPath(), SpdxLicenseTemplateHelper.formatEscapeHTML((String)license.getLicenseText()).getBytes(this.utf8), new OpenOption[0]);
        }
    }

    public static String formLicenseHTMLFileName(String id) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < id.length(); ++i) {
            if (INVALID_FILENAME_CHARS.contains(Character.valueOf(id.charAt(i)))) {
                sb.append('_');
                continue;
            }
            sb.append(id.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public void writeToC() throws IOException {
    }

    @Override
    public void writeException(ListedExceptionContainer exceptionContainer) throws IOException, InvalidSPDXAnalysisException {
        ListedLicenseException exception = exceptionContainer.getV2Exception();
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        File htmlTextFile = new File(this.htmlFolder.getPath() + File.separator + exceptionHtmlFileName + ".html");
        Files.write(htmlTextFile.toPath(), exception.getExceptionTextHtml().getBytes(this.utf8), new OpenOption[0]);
    }

    static {
        INVALID_FILENAME_CHARS.add(Character.valueOf('\\'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('/'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('*'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('<'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('>'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('['));
        INVALID_FILENAME_CHARS.add(Character.valueOf(']'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('='));
        INVALID_FILENAME_CHARS.add(Character.valueOf(';'));
        INVALID_FILENAME_CHARS.add(Character.valueOf(':'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('\''));
        INVALID_FILENAME_CHARS.add(Character.valueOf('\"'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('|'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('\t'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('?'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('&'));
        INVALID_FILENAME_CHARS.add(Character.valueOf('\ufffd'));
    }
}

