/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.licenselistpublisher.LicenseGeneratorException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;
import org.spdx.spdxRdfStore.OutputFormat;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;

public class LicenseRdfFormatWriter
implements ILicenseFormatWriter {
    private File rdfXml;
    private File rdfTurtle;
    private File rdfNt;
    private RdfStore rdfStore;
    private File rdfJsonLd;

    public LicenseRdfFormatWriter(File rdfXml, File rdfTurtle, File rdfNt, File rdfJsonLd) throws InvalidSPDXAnalysisException {
        this.rdfXml = rdfXml;
        this.rdfTurtle = rdfTurtle;
        this.rdfNt = rdfNt;
        this.rdfJsonLd = rdfJsonLd;
        this.rdfStore = new RdfStore();
        this.rdfStore.setDocumentUri("http://spdx.org/licenses/", true);
    }

    public File getRdfXml() {
        return this.rdfXml;
    }

    public void setRdfXml(File rdfXml) {
        this.rdfXml = rdfXml;
    }

    public File getRdfTurtle() {
        return this.rdfTurtle;
    }

    public void setRdfTurtle(File rdfTurtle) {
        this.rdfTurtle = rdfTurtle;
    }

    public File getRdfNt() {
        return this.rdfNt;
    }

    public void setRdfNt(File rdfNt) {
        this.rdfNt = rdfNt;
    }

    @Override
    public void writeLicense(ListedLicenseContainer licenseContainer, boolean deprecated, String deprecatedVersion) throws IOException, LicenseGeneratorException, InvalidSPDXAnalysisException {
        SpdxListedLicense license = licenseContainer.getV2ListedLicense();
        RdfStore onlyThisLicense = new RdfStore();
        onlyThisLicense.setDocumentUri(license.getDocumentUri(), true);
        ModelCopyManager copyManager = new ModelCopyManager();
        copyManager.copy((IModelStore)onlyThisLicense, "http://spdx.org/licenses/" + license.getId(), license.getModelStore(), license.getDocumentUri() + license.getId(), license.getSpecVersion(), license.getDocumentUri());
        String licBaseFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        LicenseRdfFormatWriter.writeRdf(onlyThisLicense, "http://spdx.org/licenses/", this.rdfXml, this.rdfTurtle, this.rdfNt, this.rdfJsonLd, licBaseFileName);
        copyManager.copy((IModelStore)this.rdfStore, "http://spdx.org/licenses/" + license.getId(), license.getModelStore(), license.getDocumentUri() + license.getId(), license.getSpecVersion(), license.getDocumentUri());
    }

    private static void writeRdf(RdfStore rdfStore, String documentUri, File rdfXml, File rdfTurtle, File rdfNt, File rdfJsonLd, String name) throws LicenseGeneratorException {
        if (rdfXml != null) {
            LicenseRdfFormatWriter.writeRdf(rdfStore, documentUri, rdfXml.getPath() + File.separator + name + ".rdf", OutputFormat.XML_ABBREV);
        }
        if (rdfTurtle != null) {
            LicenseRdfFormatWriter.writeRdf(rdfStore, documentUri, rdfTurtle.getPath() + File.separator + name + ".ttl", OutputFormat.TURTLE);
        }
        if (rdfNt != null) {
            LicenseRdfFormatWriter.writeRdf(rdfStore, documentUri, rdfNt.getPath() + File.separator + name + ".nt", OutputFormat.N_TRIPLET);
        }
        if (rdfJsonLd != null) {
            LicenseRdfFormatWriter.writeRdf(rdfStore, documentUri, rdfJsonLd.getPath() + File.separator + name + ".jsonld", OutputFormat.JSON_LD);
        }
    }

    public static void writeRdf(RdfStore rdfStore, String documentUri, String fileName, OutputFormat format) throws LicenseGeneratorException {
        File outFile = new File(fileName);
        if (!outFile.exists()) {
            try {
                if (!outFile.createNewFile()) {
                    throw new LicenseGeneratorException("Can not create RDF output file " + fileName);
                }
            }
            catch (IOException e) {
                throw new LicenseGeneratorException("Can not create RDF output file " + fileName);
            }
        }
        rdfStore.setOutputFormat(format);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFile);
            rdfStore.setDocumentUri(documentUri, false);
            rdfStore.serialize((OutputStream)out);
        }
        catch (FileNotFoundException e1) {
            throw new LicenseGeneratorException("Can not create RDF output file " + fileName);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseGeneratorException("SPDX analysis exception generating the RDF output", e);
        }
        catch (IOException e) {
            throw new LicenseGeneratorException("I/O generating the RDF output", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.out.println("Warning - unable to close RDF output file " + fileName);
                }
            }
        }
    }

    @Override
    public void writeToC() throws IOException, LicenseGeneratorException {
        LicenseRdfFormatWriter.writeRdf(this.rdfStore, "http://spdx.org/licenses/", this.rdfXml, this.rdfTurtle, this.rdfNt, this.rdfJsonLd, "licenses");
    }

    @Override
    public void writeException(ListedExceptionContainer exceptionContainer) throws IOException, LicenseGeneratorException, InvalidSPDXAnalysisException {
        ListedLicenseException exception = exceptionContainer.getV2Exception();
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        RdfStore onlyThisException = new RdfStore();
        onlyThisException.setDocumentUri(exception.getDocumentUri(), true);
        ModelCopyManager copyManager = new ModelCopyManager();
        copyManager.copy((IModelStore)onlyThisException, "http://spdx.org/licenses/" + exception.getId(), exception.getModelStore(), exception.getDocumentUri() + exception.getId(), exception.getSpecVersion(), exception.getDocumentUri());
        LicenseRdfFormatWriter.writeRdf(onlyThisException, "http://spdx.org/licenses/", this.rdfXml, this.rdfTurtle, this.rdfNt, this.rdfJsonLd, exceptionHtmlFileName);
        copyManager.copy((IModelStore)this.rdfStore, "http://spdx.org/licenses/" + exception.getId(), exception.getModelStore(), exception.getDocumentUri() + exception.getId(), exception.getSpecVersion(), exception.getDocumentUri());
    }
}

