/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.TypedValue;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.core.Element;
import org.spdx.library.model.v3_0_1.core.ElementCollection;
import org.spdx.library.model.v3_0_1.core.ProfileIdentifierType;
import org.spdx.library.model.v3_0_1.core.SpdxDocument;
import org.spdx.library.model.v3_0_1.expandedlicensing.ExternalListedLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException;
import org.spdx.licenseTemplate.InvalidLicenseTemplateException;
import org.spdx.licenselistpublisher.LicenseGeneratorException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;
import org.spdx.licensexml.XmlLicenseProvider;
import org.spdx.storage.IModelStore;
import org.spdx.storage.compatv2.CompatibleModelStoreWrapper;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.v3jsonldstore.JsonLDStore;

public class LicenseV3JsonLdFormatWriter
implements ILicenseFormatWriter {
    public static final String SPDX_V3_FOLDER_NAME = "SPDXv3";
    public static final String SPDX_V3_JSON_LD_FOLDER_NAME = "v3jsonld";
    private static final String LICENSE_TOC_FILE = "licenses.json";
    private static final String EXCEPTION_TOC_FILE = "exceptions.json";
    private static final CharSequence LOCATION_PREFIX = "https://spdx.org/licenses/SPDXv3/SPDXv3";
    private static final String FILE_SUFFIX = ".json";
    private File jsonLdFolder;
    private JsonLDStore licenseTocStore;
    private JsonLDStore exceptionTocStore;
    private SpdxDocument licenseTocDoc;
    private SpdxDocument exceptionTocDoc;
    private ElementCollection licenseTocCollection;
    private ElementCollection exceptionTocCollection;
    private IModelCopyManager copyManager = new ModelCopyManager();

    public LicenseV3JsonLdFormatWriter(String version, String releaseDate, File jsonLdFolder) throws InvalidSPDXAnalysisException {
        this.jsonLdFolder = jsonLdFolder;
        this.licenseTocStore = new JsonLDStore((IModelStore)new InMemSpdxStore(), true);
        CreationInfo licTocCreation = XmlLicenseProvider.createCreationInfo((IModelStore)this.licenseTocStore, this.copyManager, releaseDate, version);
        this.licenseTocCollection = licTocCreation.createBundle("http://spdx.org/licenses/license-collection-" + version.replace('.', '_')).setContext("list of all SPDX listed licenses for license list version +version").build();
        this.licenseTocDoc = licTocCreation.createSpdxDocument("http://spdx.org/licenses/license-doc-" + version.replace('.', '_')).setDescription("Document containing the list of all SPDX listed licenses for license list version " + version).addRootElement((Element)this.licenseTocCollection).addProfileConformance(ProfileIdentifierType.CORE).addProfileConformance(ProfileIdentifierType.SOFTWARE).build();
        this.exceptionTocStore = new JsonLDStore((IModelStore)new InMemSpdxStore(), true);
        CreationInfo exceptionTocCreation = XmlLicenseProvider.createCreationInfo((IModelStore)this.exceptionTocStore, this.copyManager, releaseDate, version);
        this.exceptionTocCollection = exceptionTocCreation.createBundle("http://spdx.org/licenses/exception-collection-" + version.replace('.', '_')).setContext("list of all SPDX listed license exception for license list version " + version).build();
        this.exceptionTocDoc = exceptionTocCreation.createSpdxDocument("http://spdx.org/licenses/exception-doc-" + version.replace('.', '_')).setDescription("Document containing the list of all SPDX listed license exceptions for license list version " + version).addRootElement((Element)this.exceptionTocCollection).addProfileConformance(ProfileIdentifierType.CORE).addProfileConformance(ProfileIdentifierType.SOFTWARE).build();
    }

    public static void writeV3JsonLD(JsonLDStore store, Path filePath, boolean pretty) throws LicenseGeneratorException {
        if (!Files.exists(filePath, new LinkOption[0])) {
            try {
                Files.createFile(filePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new LicenseGeneratorException("Can not create JSONLD output file " + String.valueOf(filePath));
            }
        }
        store.setPretty(pretty);
        try (FileOutputStream stream = new FileOutputStream(filePath.toFile());){
            store.serialize((OutputStream)stream);
        }
        catch (FileNotFoundException e) {
            throw new LicenseGeneratorException("Unexpected file not found error for " + String.valueOf(filePath));
        }
        catch (IOException e) {
            throw new LicenseGeneratorException("I/O error writing JSONLD output file " + String.valueOf(filePath), e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseGeneratorException("SPDX exception creating JSONLD output file " + String.valueOf(filePath), e);
        }
    }

    @Override
    public void writeLicense(ListedLicenseContainer licenseContainer, boolean deprecated, String deprecatedVersion) throws IOException, LicenseGeneratorException, InvalidSPDXAnalysisException, InvalidLicenseTemplateException {
        ListedLicense license = licenseContainer.getV3ListedLicense();
        JsonLDStore onlyThisLicenseStore = new JsonLDStore((IModelStore)new InMemSpdxStore(), true);
        ModelCopyManager onlyLicenseCopyManager = new ModelCopyManager();
        TypedValue tv = onlyLicenseCopyManager.copy((IModelStore)onlyThisLicenseStore, license.getModelStore(), license.getObjectUri(), license.getSpecVersion(), license.getIdPrefix());
        String licenseId = CompatibleModelStoreWrapper.objectUriToId((boolean)false, (String)license.getObjectUri(), (String)"http://spdx.org/licenses/");
        ListedLicense copiedLicense = (ListedLicense)SpdxModelFactory.inflateModelObject((IModelStore)onlyThisLicenseStore, (String)tv.getObjectUri(), (String)tv.getType(), (IModelCopyManager)onlyLicenseCopyManager, (String)tv.getSpecVersion(), (boolean)false, (String)license.getIdPrefix());
        List verify = copiedLicense.createSpdxDocument(license.getObjectUri() + "_document").setName(licenseId + " document").setComment("SPDX Document For " + licenseId).addRootElement((Element)copiedLicense).build().verify();
        if (!verify.isEmpty()) {
            throw new LicenseGeneratorException("Invalid license data generated for " + licenseId + ": " + (String)verify.get(0));
        }
        this.licenseTocDoc.getSpdxImports().add(this.licenseTocDoc.createExternalMap(this.licenseTocStore.getNextId(IModelStore.IdType.Anonymous)).setExternalSpdxId(license.getObjectUri()).setLocationHint(license.getObjectUri().replace("http://spdx.org/licenses/", LOCATION_PREFIX) + FILE_SUFFIX).build());
        LicenseV3JsonLdFormatWriter.writeV3JsonLD(onlyThisLicenseStore, this.jsonLdFolder.toPath().resolve(LicenseHtmlFormatWriter.formLicenseHTMLFileName(licenseId) + FILE_SUFFIX), true);
        this.licenseTocCollection.getElements().add(new ExternalListedLicense(this.licenseTocCollection.getModelStore(), license.getObjectUri(), this.licenseTocCollection.getCopyManager(), true, "http://spdx.org/licenses/"));
    }

    @Override
    public void writeToC() throws IOException, LicenseGeneratorException {
        LicenseV3JsonLdFormatWriter.writeV3JsonLD(this.licenseTocStore, this.jsonLdFolder.toPath().resolve(LICENSE_TOC_FILE), true);
        List verify = this.licenseTocDoc.verify();
        if (!verify.isEmpty()) {
            throw new LicenseGeneratorException("Invalid license TOC data generated: " + (String)verify.get(0));
        }
        LicenseV3JsonLdFormatWriter.writeV3JsonLD(this.exceptionTocStore, this.jsonLdFolder.toPath().resolve(EXCEPTION_TOC_FILE), true);
        verify = this.exceptionTocDoc.verify();
        if (!verify.isEmpty()) {
            throw new LicenseGeneratorException("Invalid exception TOC data generated: " + (String)verify.get(0));
        }
    }

    @Override
    public void writeException(ListedExceptionContainer exceptionContainer) throws IOException, LicenseGeneratorException, InvalidLicenseTemplateException, InvalidSPDXAnalysisException {
        ListedLicenseException exception = exceptionContainer.getV3Exception();
        JsonLDStore onlyThisExceptionStore = new JsonLDStore((IModelStore)new InMemSpdxStore(), true);
        ModelCopyManager onlyExceptionCopyManager = new ModelCopyManager();
        TypedValue tv = onlyExceptionCopyManager.copy((IModelStore)onlyThisExceptionStore, exception.getModelStore(), exception.getObjectUri(), exception.getSpecVersion(), exception.getIdPrefix());
        String exceptionId = CompatibleModelStoreWrapper.objectUriToId((boolean)false, (String)exception.getObjectUri(), (String)"http://spdx.org/licenses/");
        ListedLicenseException copiedException = (ListedLicenseException)SpdxModelFactory.inflateModelObject((IModelStore)onlyThisExceptionStore, (String)tv.getObjectUri(), (String)tv.getType(), (IModelCopyManager)onlyExceptionCopyManager, (String)tv.getSpecVersion(), (boolean)false, (String)exception.getIdPrefix());
        List verify = copiedException.createSpdxDocument(exception.getObjectUri() + "_document").setName(exceptionId + " document").setComment("SPDX Document For " + exceptionId).addRootElement((Element)copiedException).build().verify();
        if (!verify.isEmpty()) {
            throw new LicenseGeneratorException("Invalid exception data generated for " + exceptionId + ": " + (String)verify.get(0));
        }
        this.exceptionTocDoc.getSpdxImports().add(this.exceptionTocDoc.createExternalMap(this.exceptionTocStore.getNextId(IModelStore.IdType.Anonymous)).setExternalSpdxId(exception.getObjectUri()).setLocationHint(exception.getObjectUri().replace("http://spdx.org/licenses/", LOCATION_PREFIX) + FILE_SUFFIX).build());
        LicenseV3JsonLdFormatWriter.writeV3JsonLD(onlyThisExceptionStore, this.jsonLdFolder.toPath().resolve(LicenseHtmlFormatWriter.formLicenseHTMLFileName(exceptionId) + FILE_SUFFIX), true);
        this.exceptionTocCollection.getElements().add(new ExternalListedLicense(this.exceptionTocCollection.getModelStore(), exception.getObjectUri(), this.exceptionTocCollection.getCopyManager(), true, "http://spdx.org/licenses/"));
    }
}

