/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.License;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseTester;
import org.spdx.utility.compare.CompareTemplateOutputHandler;
import org.spdx.utility.compare.LicenseCompareHelper;
import org.spdx.utility.compare.SpdxCompareException;

public class SimpleLicenseTester
implements ILicenseTester {
    private Charset utf8 = Charset.forName("UTF-8");
    private File testFileDir;

    public SimpleLicenseTester(File testFileDir) {
        this.testFileDir = testFileDir;
    }

    @Override
    public List<String> testException(ListedExceptionContainer exceptionContainer) throws IOException, InvalidSPDXAnalysisException {
        ListedLicenseException exception = exceptionContainer.getV2Exception();
        File exceptionFile = new File(this.testFileDir.getPath() + File.separator + exception.getLicenseExceptionId() + ".txt");
        ArrayList<String> retval = new ArrayList<String>();
        if (!exceptionFile.exists()) {
            retval.add("No test text exists for license exception ID " + exception.getLicenseExceptionId());
        } else {
            String compareText = this.readText(exceptionFile);
            try {
                CompareTemplateOutputHandler.DifferenceDescription result = LicenseCompareHelper.isTextStandardException((LicenseException)exception, (String)compareText);
                if (result.isDifferenceFound()) {
                    retval.add("Test for exception ID " + exception.getLicenseExceptionId() + " failed due to difference found " + result.getDifferenceMessage());
                }
            }
            catch (SpdxCompareException e) {
                retval.add("Invalid template found for exception ID " + exception.getLicenseExceptionId() + ": " + e.getMessage());
            }
        }
        return retval;
    }

    private String readText(File f) throws IOException {
        StringBuilder text = new StringBuilder();
        try (Stream<String> fileLines = Files.lines(f.toPath(), this.utf8);){
            fileLines.forEach(line -> {
                text.append((String)line);
                text.append("\n");
            });
        }
        return text.toString();
    }

    @Override
    public List<String> testLicense(ListedLicenseContainer licenseContainer) throws IOException, InvalidSPDXAnalysisException {
        SpdxListedLicense license = licenseContainer.getV2ListedLicense();
        ArrayList<String> retval = new ArrayList<String>();
        File licenseTextFile = new File(this.testFileDir.getPath() + File.separator + license.getLicenseId() + ".txt");
        if (!licenseTextFile.exists()) {
            if (!license.isDeprecated()) {
                retval.add("No test text exists for license ID " + license.getLicenseId());
            }
        } else {
            String compareText = this.readText(licenseTextFile);
            try {
                CompareTemplateOutputHandler.DifferenceDescription result = LicenseCompareHelper.isTextStandardLicense((License)license, (String)compareText);
                if (result.isDifferenceFound()) {
                    retval.add("Test for license ID " + license.getLicenseId() + " failed due to difference found " + result.getDifferenceMessage());
                }
            }
            catch (SpdxCompareException e) {
                retval.add("Invalid template found for license ID " + license.getLicenseId() + ": " + e.getMessage());
            }
        }
        return retval;
    }

    @Override
    public String getLicenseTestText(String licenseId) throws IOException {
        File licenseTextFile = new File(this.testFileDir.getPath() + File.separator + licenseId + ".txt");
        if (licenseTextFile.exists()) {
            return this.readText(licenseTextFile);
        }
        return null;
    }

    @Override
    public String getExceptionTestText(String licenseExceptionId) throws IOException {
        File exceptionFile = new File(this.testFileDir.getPath() + File.separator + licenseExceptionId + ".txt");
        if (exceptionFile.exists()) {
            return this.readText(exceptionFile);
        }
        return null;
    }
}

