/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licensexml;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.compress.utils.FileNameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.v2.license.SpdxListedLicenseException;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.licenselistpublisher.ISpdxListedLicenseProvider;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licensexml.LicenseXmlDocument;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class XmlLicenseProvider
implements ISpdxListedLicenseProvider {
    Logger logger = LoggerFactory.getLogger((String)XmlLicenseProvider.class.getName());
    protected List<String> warnings = new ArrayList<String>();
    protected IModelStore v2ModelStore = new InMemSpdxStore();
    protected IModelStore v3ModelStore = new InMemSpdxStore();
    protected IModelCopyManager copyManager = new ModelCopyManager();
    private List<File> xmlFiles = new ArrayList<File>();
    protected String releaseDate;
    protected String currentListVersion;
    protected CreationInfo creationInfo;

    public XmlLicenseProvider(File xmlFileDirectory, String currentListVersion, String releaseDate) throws InvalidSPDXAnalysisException {
        if (!xmlFileDirectory.isDirectory()) {
            throw new SpdxListedLicenseException("XML File Directory is not a directory");
        }
        this.releaseDate = releaseDate;
        this.currentListVersion = currentListVersion;
        this.creationInfo = XmlLicenseProvider.createCreationInfo(this.v3ModelStore, this.copyManager, releaseDate, currentListVersion);
        this.xmlFiles = new ArrayList<File>();
        this.addXmlFiles(xmlFileDirectory, this.xmlFiles);
    }

    public static CreationInfo createCreationInfo(IModelStore modelStore, @Nullable IModelCopyManager copyManager, String listCreationDate, String licenseListVersion) throws InvalidSPDXAnalysisException {
        CreationInfo retval = new CreationInfo.CreationInfoBuilder(modelStore, modelStore.getNextId(IModelStore.IdType.Anonymous), copyManager).setCreated(listCreationDate).setSpecVersion("3.0.1").build();
        retval.getCreatedBys().add(retval.createOrganization("https://spdx.org/licenses/creatoragent/" + licenseListVersion.replace('.', '_')).setName("SPDX Legal Team").build());
        retval.getCreatedUsings().add(retval.createTool("https://spdx.org/tools/licenselistpublisher").setName("SPDX License List Publisher").build());
        retval.setComment("This object is created and maintained by the SPDX legal team (https://spdx.dev/engage/participate/legal-team/) using the LicenseListPublisher (https://github.com/spdx/licenselistpublisher)");
        return retval;
    }

    private void addXmlFiles(File xmlFileDirectory, List<File> alFiles) {
        File[] localFiles;
        File[] directories = xmlFileDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (directories != null) {
            for (File subDir : directories) {
                this.addXmlFiles(subDir, alFiles);
            }
        }
        if ((localFiles = xmlFileDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && "xml".equals(FileNameUtils.getExtension((Path)pathname.toPath()).toLowerCase());
            }
        })) != null) {
            for (File file : localFiles) {
                alFiles.add(file);
            }
        }
    }

    @Override
    public Iterator<ListedLicenseContainer> getLicenseIterator() throws SpdxListedLicenseException {
        return new XmlLicenseIterator();
    }

    @Override
    public Iterator<ListedExceptionContainer> getExceptionIterator() throws InvalidSPDXAnalysisException {
        return new XmlExceptionIterator();
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    class XmlLicenseIterator
    implements Iterator<ListedLicenseContainer> {
        private int xmlFileIndex = 0;
        protected ListedLicenseContainer nextListedLicense = null;
        private Iterator<ListedLicenseContainer> fileListedLicenseIter = null;

        public XmlLicenseIterator() {
            this.findNextItem();
        }

        protected void findNextItem() {
            this.nextListedLicense = null;
            if (this.fileListedLicenseIter == null || !this.fileListedLicenseIter.hasNext()) {
                this.fileListedLicenseIter = null;
                while (this.xmlFileIndex < XmlLicenseProvider.this.xmlFiles.size() && this.fileListedLicenseIter == null) {
                    try {
                        LicenseXmlDocument licDoc = new LicenseXmlDocument(XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex), XmlLicenseProvider.this.v2ModelStore, XmlLicenseProvider.this.v3ModelStore, XmlLicenseProvider.this.copyManager, XmlLicenseProvider.this.creationInfo);
                        try {
                            List<ListedLicenseContainer> licList = licDoc.getListedLicenses();
                            if (licList == null || licList.isEmpty()) continue;
                            this.fileListedLicenseIter = licList.iterator();
                        }
                        catch (InvalidSPDXAnalysisException e) {
                            XmlLicenseProvider.this.warnings.add(e.getMessage() + ", Skipping file " + XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex).getName());
                            XmlLicenseProvider.this.logger.warn(e.getMessage() + ", Skipping file " + XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex).getName());
                        }
                    }
                    catch (LicenseXmlException e) {
                        XmlLicenseProvider.this.warnings.add(e.getMessage() + ", Skipping file " + XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex).getName());
                        XmlLicenseProvider.this.logger.warn(e.getMessage() + ", Skipping file " + XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex).getName());
                    }
                    finally {
                        ++this.xmlFileIndex;
                    }
                }
            }
            if (this.fileListedLicenseIter != null && this.fileListedLicenseIter.hasNext()) {
                this.nextListedLicense = this.fileListedLicenseIter.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextListedLicense != null;
        }

        @Override
        public ListedLicenseContainer next() {
            ListedLicenseContainer retval = this.nextListedLicense;
            this.findNextItem();
            if (Objects.isNull(retval)) {
                throw new NoSuchElementException();
            }
            return retval;
        }

        @Override
        public void remove() {
        }
    }

    class XmlExceptionIterator
    implements Iterator<ListedExceptionContainer> {
        private int xmlFileIndex = 0;
        private ListedExceptionContainer nextLicenseException = null;
        private Iterator<ListedExceptionContainer> fileExceptionIterator = null;

        public XmlExceptionIterator() throws InvalidSPDXAnalysisException {
            this.findNextItem();
        }

        private void findNextItem() throws InvalidSPDXAnalysisException {
            this.nextLicenseException = null;
            if (this.fileExceptionIterator == null || !this.fileExceptionIterator.hasNext()) {
                this.fileExceptionIterator = null;
                while (this.xmlFileIndex < XmlLicenseProvider.this.xmlFiles.size() && this.fileExceptionIterator == null) {
                    try {
                        LicenseXmlDocument licDoc = new LicenseXmlDocument(XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex), XmlLicenseProvider.this.v2ModelStore, XmlLicenseProvider.this.v3ModelStore, XmlLicenseProvider.this.copyManager, XmlLicenseProvider.this.creationInfo);
                        List<ListedExceptionContainer> exceptionList = licDoc.getLicenseExceptions();
                        if (exceptionList != null && !exceptionList.isEmpty()) {
                            this.fileExceptionIterator = exceptionList.iterator();
                        }
                    }
                    catch (LicenseXmlException e) {
                        XmlLicenseProvider.this.warnings.add(e.getMessage() + ", Skipping file " + XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex).getName());
                        XmlLicenseProvider.this.logger.warn(e.getMessage() + ", Skipping file " + XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex).getName());
                    }
                    ++this.xmlFileIndex;
                }
            }
            if (this.fileExceptionIterator != null && this.fileExceptionIterator.hasNext()) {
                this.nextLicenseException = this.fileExceptionIterator.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLicenseException != null;
        }

        @Override
        public ListedExceptionContainer next() {
            ListedExceptionContainer retval = this.nextLicenseException;
            try {
                this.findNextItem();
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
            if (Objects.isNull(retval)) {
                throw new NoSuchElementException();
            }
            return retval;
        }

        @Override
        public void remove() {
        }
    }
}

