/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licensexml;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.crossref.CrossRefHelper;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.library.model.v2.license.SpdxListedLicenseException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licensexml.XmlLicenseProvider;
import org.spdx.storage.IModelStore;

public class XmlLicenseProviderWithCrossRefDetails
extends XmlLicenseProvider {
    private static final int NUMBER_THREADS = 10;

    public XmlLicenseProviderWithCrossRefDetails(File xmlFileDirectory, String currentListVersion, String releaseDate) throws InvalidSPDXAnalysisException {
        super(xmlFileDirectory, currentListVersion, releaseDate);
    }

    @Override
    public Iterator<ListedLicenseContainer> getLicenseIterator() throws SpdxListedLicenseException {
        return new XmlLicenseIterator(this.v2ModelStore, this.v3ModelStore, this.copyManager, this.currentListVersion, this.releaseDate);
    }

    @Override
    public Iterator<ListedExceptionContainer> getExceptionIterator() throws InvalidSPDXAnalysisException {
        return new XmlExceptionIterator(this.v2ModelStore, this.v3ModelStore, this.copyManager, this.currentListVersion, this.releaseDate);
    }

    class XmlLicenseIterator
    extends XmlLicenseProvider.XmlLicenseIterator
    implements Closeable {
        private ExecutorService executorService = Executors.newFixedThreadPool(10);
        private Map<ListedLicenseContainer, Future<Collection<CrossRef>>> urlDetailsInProgress = new HashMap<ListedLicenseContainer, Future<Collection<CrossRef>>>();

        private void fillCrossRefPool() {
            while (super.hasNext() && this.urlDetailsInProgress.size() < 10) {
                ListedLicenseContainer nextLicense = super.next();
                this.urlDetailsInProgress.put(nextLicense, this.executorService.submit(new CrossRefHelper(nextLicense.getV2ListedLicense())));
            }
        }

        public XmlLicenseIterator(IModelStore v2Store, IModelStore v3Store, IModelCopyManager copyManager, String currentListVersion, String releaseDate) {
            this.fillCrossRefPool();
        }

        @Override
        public synchronized boolean hasNext() {
            return this.urlDetailsInProgress.size() > 0;
        }

        @Override
        public synchronized ListedLicenseContainer next() {
            Map.Entry<ListedLicenseContainer, Future<Collection<CrossRef>>> readyLicense = null;
            for (Map.Entry<ListedLicenseContainer, Future<Collection<CrossRef>>> licenseInProgress : this.urlDetailsInProgress.entrySet()) {
                if (!licenseInProgress.getValue().isDone()) continue;
                readyLicense = licenseInProgress;
                break;
            }
            if (Objects.isNull(readyLicense) && Objects.isNull(readyLicense = this.urlDetailsInProgress.entrySet().iterator().next())) {
                return null;
            }
            ListedLicenseContainer retval = (ListedLicenseContainer)readyLicense.getKey();
            try {
                for (CrossRef crossRef : readyLicense.getValue().get()) {
                    retval.getV2ListedLicense().getCrossRef().add(crossRef);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                XmlLicenseProviderWithCrossRefDetails.this.logger.error("Error getting URL value.  URL values will not be filled in for license ID " + retval.getV2ListedLicense().getLicenseId(), (Throwable)e);
                XmlLicenseProviderWithCrossRefDetails.this.warnings.add("Error getting URL value.  URL values will not be filled in for license ID " + retval.getV2ListedLicense().getLicenseId());
            }
            catch (InvalidSPDXAnalysisException e) {
                XmlLicenseProviderWithCrossRefDetails.this.logger.error("Error setting cross refs", (Throwable)e);
                XmlLicenseProviderWithCrossRefDetails.this.warnings.add("Unable to set cross references due to error: " + e.getMessage());
            }
            this.urlDetailsInProgress.remove(retval);
            this.fillCrossRefPool();
            return retval;
        }

        @Override
        public void close() throws IOException {
            this.executorService.shutdown();
        }
    }

    class XmlExceptionIterator
    extends XmlLicenseProvider.XmlExceptionIterator {
        public XmlExceptionIterator(IModelStore v2Store, IModelStore v3Store, IModelCopyManager copyManager, String currentListVersion, String releaseDate) throws InvalidSPDXAnalysisException {
        }
    }
}

