/**
 * SpdxLicenseIdentifier: Apache-2.0
 * 
 * Copyright (c) 2022 Source Auditor Inc.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
*/
package org.spdx.crossref;

import java.util.List;

/**
 * OSI License as returned from the OSI API
 * 
 * @author gary
 *
 */
public class OsiLicense {
	
	public class IdentifierType {
		String identifier;
		String scheme;
		/**
		 * @return the identifier
		 */
		public String getIdentifier() {
			return identifier;
		}
		/**
		 * @return the scheme
		 */
		public String getScheme() {
			return scheme;
		}
		
	}
	
	public class Link {
		String note;
		String url;
		/**
		 * @return the note
		 */
		public String getNote() {
			return note;
		}
		/**
		 * @return the url
		 */
		public String getUrl() {
			return url;
		}
		
		
	}
	
	String id;
	List<IdentifierType> identifiers;
	List<Link> links;
	String name;
	List<String> keywords;
	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}
	/**
	 * @return the identifiers
	 */
	public List<IdentifierType> getIdentifiers() {
		return identifiers;
	}
	/**
	 * @return the links
	 */
	public List<Link> getLinks() {
		return links;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @return the keywords
	 */
	public List<String> getKeywords() {
		return keywords;
	}
}
