/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.crossref;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.utility.compare.LicenseCompareHelper;

public class Match
implements Callable<String> {
    static final Logger logger = LoggerFactory.getLogger((String)Match.class.getName());
    String url;
    SpdxListedLicense license;

    public Match(String url, SpdxListedLicense license) {
        this.url = url;
        this.license = license;
    }

    public static String checkMatch(String url, SpdxListedLicense license) {
        try {
            Document doc = Jsoup.connect((String)url).get();
            String bodyText = doc.body().text();
            return String.valueOf(LicenseCompareHelper.isStandardLicenseWithinText((String)bodyText, (SpdxListedLicense)license));
        }
        catch (IOException e) {
            logger.warn("IO exception comparing license text for license ID " + license.getLicenseId() + " and URL " + url);
            return String.valueOf(false);
        }
    }

    @Override
    public String call() throws Exception {
        return Match.checkMatch(this.url, this.license);
    }
}

