/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.v2.license.License;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.LicenseTester;
import org.spdx.licenselistpublisher.licensegenerator.SimpleLicenseTester;
import org.spdx.licensexml.LicenseXmlDocument;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.licensexml.XmlLicenseProvider;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;
import org.spdx.utility.compare.SpdxCompareException;

public class LicenseXmlTester {
    static int MIN_ARGS = 2;
    static int MAX_ARGS = 3;
    static final int ERROR_STATUS = 1;
    static final int WARNING_STATUS = 64;

    public static void main(String[] args) {
        File testFile;
        File licenseXmlFile;
        if (args == null || args.length < MIN_ARGS || args.length > MAX_ARGS) {
            System.out.println("Invalid arguments");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        if (!(licenseXmlFile = new File(args[0])).exists()) {
            System.out.println("License XML file " + licenseXmlFile.getName() + " does not exist");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        if (!licenseXmlFile.isFile()) {
            System.out.println("License XML file " + licenseXmlFile.getName() + " is not a valid file");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        if (!(testFile = new File(args[1])).exists()) {
            System.out.println("Test file " + testFile.getName() + " does not exist");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        if (!testFile.isFile()) {
            System.out.println("Test file " + testFile.getName() + " is not a valid file");
            LicenseXmlTester.usage();
            System.exit(1);
        }
        File testDirectory = null;
        if (args.length > 2) {
            testDirectory = new File(args[2]);
            if (!testDirectory.exists()) {
                System.out.println("Test directory " + testDirectory.getName() + " does not exist");
                LicenseXmlTester.usage();
                System.exit(1);
            }
            if (!testDirectory.isDirectory()) {
                System.out.println("Test directory " + testDirectory.getName() + " is not a directory");
                LicenseXmlTester.usage();
                System.exit(1);
            }
        }
        try {
            List<String> result = LicenseXmlTester.testLicenseXml(licenseXmlFile, testFile, testDirectory);
            if (result.isEmpty()) {
                System.out.println("License passed");
            } else {
                System.out.println("The following error(s) were found:");
                for (String error : result) {
                    System.out.print("\t");
                    System.out.println(error);
                }
                System.exit(64);
            }
        }
        catch (LicenseXmlException e) {
            System.out.println("Invalid license XML document: " + e.getMessage());
            System.exit(1);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.println("Invalid license SPDX definition: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("I/O error reading test file: " + e.getMessage());
            System.exit(1);
        }
        catch (SpdxCompareException e) {
            System.out.println("Compare error: " + e.getMessage());
            System.exit(1);
        }
    }

    public static List<String> testLicenseXml(File licenseXmlFile, File testFile, @Nullable File testDirectory) throws InvalidSPDXAnalysisException, LicenseXmlException, IOException, SpdxCompareException {
        InMemSpdxStore spdxV2ModelStore = new InMemSpdxStore();
        InMemSpdxStore spdxV3ModelStore = new InMemSpdxStore();
        ModelCopyManager copyManager = new ModelCopyManager();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String now = format.format(new Date());
        LicenseXmlDocument licDoc = new LicenseXmlDocument(licenseXmlFile, (IModelStore)spdxV2ModelStore, (IModelStore)spdxV3ModelStore, (IModelCopyManager)copyManager, XmlLicenseProvider.createCreationInfo((IModelStore)spdxV3ModelStore, (IModelCopyManager)copyManager, now, "3.25.0"));
        List<ListedLicenseContainer> licenses = licDoc.getListedLicenses();
        if (licenses.isEmpty()) {
            return List.of("Empty license XML file - no licenses found");
        }
        if (licenses.size() > 1) {
            return List.of("More than one licenses found");
        }
        List<String> retval = SimpleLicenseTester.testLicense((License)licenses.get(0).getV2ListedLicense(), testFile);
        if (Objects.nonNull(testDirectory)) {
            LicenseTester tester = new LicenseTester(testDirectory);
            retval.addAll(tester.testLicense(licenses.get(0)));
        }
        return retval;
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("TestLicenseXML licenseXmlFile textFile");
        System.out.println("   licenseXmlFile XML - file to test");
        System.out.println("   textFile - Text file which should match the the license text for the licenseXmlFile");
        System.out.println("   testDirectory - Optional directory of test files in the form {license-id}/(license|header|exception)/(good|bad)/{test-id}.txt");
    }
}

