/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;

public class MarkdownTable {
    List<ExceptionInfo> exceptions = new ArrayList<ExceptionInfo>();
    List<LicenseInfo> licenses = new ArrayList<LicenseInfo>();
    private String licenseListVersion;

    public MarkdownTable(String licenseListVersion) {
        this.licenseListVersion = licenseListVersion == null ? "UNKNOWN" : licenseListVersion;
    }

    public void addException(LicenseException exception, boolean deprecated) throws InvalidSPDXAnalysisException {
        this.exceptions.add(new ExceptionInfo(exception.getLicenseExceptionId(), exception.getName(), deprecated));
    }

    public void addLicense(SpdxListedLicense license, boolean deprecated) throws InvalidSPDXAnalysisException {
        this.licenses.add(new LicenseInfo(license.getLicenseId(), license.getName(), deprecated, license.isOsiApproved(), license.isFsfLibre()));
    }

    public void writeToFile(File file) throws IOException {
        try (FileWriter writer = null;){
            writer = new FileWriter(file);
            this.writeTOC(writer);
        }
    }

    public void writeTOC(Writer writer) throws IOException {
        this.exceptions.sort(new Comparator<ExceptionInfo>(){

            @Override
            public int compare(ExceptionInfo arg0, ExceptionInfo arg1) {
                return arg0.getId().compareToIgnoreCase(arg1.getId());
            }
        });
        this.licenses.sort(new Comparator<LicenseInfo>(){

            @Override
            public int compare(LicenseInfo arg0, LicenseInfo arg1) {
                return arg0.getId().compareToIgnoreCase(arg1.getId());
            }
        });
        int maxLicenseName = "Full Name of License".length();
        int maxExceptionName = "Full Name of Exception".length();
        int maxDeprecatedLicenseName = "Full Name of License".length();
        int maxShortIdLength = "Deprecated SPDX License Identifier".length();
        for (LicenseInfo li : this.licenses) {
            if (li.getId().length() + 4 > maxShortIdLength) {
                maxShortIdLength = li.getId().length() + 4;
            }
            if (li.isDeprecated()) {
                if (li.getName().length() <= maxDeprecatedLicenseName) continue;
                maxDeprecatedLicenseName = li.getName().length();
                continue;
            }
            if (li.getName().length() <= maxLicenseName) continue;
            maxLicenseName = li.getName().length();
        }
        for (ExceptionInfo ei : this.exceptions) {
            if (ei.getId().length() + 4 > maxShortIdLength) {
                maxShortIdLength = ei.getId().length() + 4;
            }
            if (ei.getName().length() <= maxExceptionName) continue;
            maxExceptionName = ei.getName().length();
        }
        writer.write("# License List\n");
        writer.write("The following licenses have been generated from the license list version ");
        writer.write(this.licenseListVersion);
        writer.write("\n\n");
        writer.write("## Licenses with Short Identifiers\n\n");
        String licenseTableHeaderFormat = "| %-" + maxLicenseName + "s | %-" + maxShortIdLength + "s | %-4s | %-9s |\n";
        writer.write(String.format(licenseTableHeaderFormat, "Full Name of License", "Short Identifier", "OSI?", "FSFLibre?"));
        writer.write("|-");
        this.addFill(writer, '-', maxLicenseName);
        writer.write("-|-");
        this.addFill(writer, '-', maxShortIdLength);
        writer.write("-|-");
        this.addFill(writer, '-', 4);
        writer.write("-|-");
        this.addFill(writer, '-', 9);
        writer.write("-|\n");
        String licenseTableRowFormat = "| %-" + maxLicenseName + "s | %-" + maxShortIdLength + "s | %-4s | %-9s |\n";
        for (LicenseInfo li : this.licenses) {
            if (li.isDeprecated()) continue;
            String idStr = this.formatIdString(li.getId(), maxShortIdLength);
            writer.write(String.format(licenseTableRowFormat, li.getName(), idStr, li.isOsiApproved ? "Y" : "", li.isFsfLibre() ? "Y" : ""));
        }
        writer.write("\n");
        writer.write("## Exception List\n\n");
        String exceptionTableHeaderFormat = "| %-" + maxExceptionName + "s | %-" + maxShortIdLength + "s\n";
        writer.write(String.format(exceptionTableHeaderFormat, "Full Name of Exception", "SPDX LicenseException"));
        writer.write("|-");
        this.addFill(writer, '-', maxExceptionName);
        writer.write("-|-");
        this.addFill(writer, '-', maxShortIdLength);
        writer.write("-|\n");
        String exceptionTableRowFormat = "| %-" + maxExceptionName + "s | %-" + maxShortIdLength + "s |\n";
        for (ExceptionInfo ei : this.exceptions) {
            if (ei.isDeprecated()) continue;
            String idStr = this.formatIdString(ei.getId(), maxShortIdLength);
            writer.write(String.format(exceptionTableRowFormat, ei.getName(), idStr));
        }
        writer.write("\n");
        writer.write("## Deprecated Licenses\n\n");
        String deprecatedLicenseTableHeaderFormat = "| %-" + maxLicenseName + "s | %-" + maxShortIdLength + "s |\n";
        writer.write(String.format(deprecatedLicenseTableHeaderFormat, "Full Name of License", "Deprecated SPDX License Identifier"));
        writer.write("|-");
        this.addFill(writer, '-', maxLicenseName);
        writer.write("-|-");
        this.addFill(writer, '-', maxShortIdLength);
        writer.write("-|\n");
        String deprecatedLicenseTableRowFormat = "| %-" + maxLicenseName + "s | %-" + maxShortIdLength + "s \n";
        for (LicenseInfo li : this.licenses) {
            if (!li.isDeprecated()) continue;
            String idStr = this.formatIdString(li.getId(), maxShortIdLength);
            writer.write(String.format(deprecatedLicenseTableRowFormat, li.getName(), idStr));
        }
        writer.write("\n");
        String linkFormat = "[%s]: text/%s.txt\n";
        for (LicenseInfo li : this.licenses) {
            writer.write(String.format(linkFormat, li.getId(), li.getId()));
        }
        for (ExceptionInfo ei : this.exceptions) {
            writer.write(String.format(linkFormat, ei.getId(), ei.getId()));
        }
    }

    private String formatIdString(String id, int maxShortIdLength) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(id);
        sb.append("][]");
        return sb.toString();
    }

    private void addFill(Writer writer, char c, int fillLen) throws IOException {
        for (int i = 0; i < fillLen; ++i) {
            writer.write(c);
        }
    }

    class ExceptionInfo {
        private String id;
        private String name;
        private boolean deprecated;

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }

        private ExceptionInfo(String id, String name, boolean deprecated) {
            this.id = id;
            this.name = name;
            this.deprecated = deprecated;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    class LicenseInfo
    extends ExceptionInfo {
        private boolean isOsiApproved;
        private boolean isFsfLibre;

        public LicenseInfo(String id, String name, boolean deprecated, boolean isOsiApproved, boolean isFsfLibre) {
            super(id, name, deprecated);
            this.isOsiApproved = isOsiApproved;
            this.isFsfLibre = isFsfLibre;
        }

        public boolean isOsiApproved() {
            return this.isOsiApproved;
        }

        public void setOsiApproved(boolean isOsiApproved) {
            this.isOsiApproved = isOsiApproved;
        }

        public boolean isFsfLibre() {
            return this.isFsfLibre;
        }

        public void setFsfLibre(boolean isFsfLibre) {
            this.isFsfLibre = isFsfLibre;
        }
    }
}

