/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseTester;
import org.spdx.licenselistpublisher.licensegenerator.LicenseTester;
import org.spdx.licenselistpublisher.licensegenerator.SimpleLicenseTester;
import org.spdx.utility.compare.SpdxCompareException;

public class CombinedLicenseTester
implements ILicenseTester {
    private final ILicenseTester simpleLicenseTester;
    private final ILicenseTester licenseTester;

    public CombinedLicenseTester(File simpleLicenseTestDir, File licenseTestDir) {
        this.simpleLicenseTester = new SimpleLicenseTester(simpleLicenseTestDir);
        this.licenseTester = new LicenseTester(licenseTestDir);
    }

    @Override
    public List<String> testException(ListedExceptionContainer exceptionContainer) throws IOException, InvalidSPDXAnalysisException {
        List<String> retval = this.simpleLicenseTester.testException(exceptionContainer);
        retval.addAll(this.licenseTester.testException(exceptionContainer));
        return retval;
    }

    @Override
    public List<String> testLicense(ListedLicenseContainer licenseContainer) throws IOException, SpdxCompareException, InvalidSPDXAnalysisException {
        List<String> retval = this.simpleLicenseTester.testLicense(licenseContainer);
        retval.addAll(this.licenseTester.testLicense(licenseContainer));
        return retval;
    }

    @Override
    @Nullable
    public String getLicenseTestText(String licenseId) throws IOException {
        return this.simpleLicenseTester.getLicenseTestText(licenseId);
    }

    @Override
    @Nullable
    public String getExceptionTestText(String licenseExceptionId) throws IOException {
        return this.simpleLicenseTester.getExceptionTestText(licenseExceptionId);
    }
}

