/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Comparator;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.licenseTemplate.InvalidLicenseTemplateException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;
import org.spdx.storage.listedlicense.ExceptionJson;
import org.spdx.storage.listedlicense.LicenseJson;
import org.spdx.storage.listedlicense.LicenseJsonTOC;
import org.spdx.storage.listedlicense.SortableExceptionJsonTOC;

public class LicenseJsonFormatWriter
implements ILicenseFormatWriter {
    static final String LICENSE_TOC_JSON_FILE_NAME = "licenses.json";
    static final String EXCEPTION_JSON_TOC_FILE_NAME = "exceptions.json";
    private File jsonFolder;
    private File jsonFolderExceptions;
    private File jsonFolderDetails;
    LicenseJson licJson;
    LicenseJsonTOC tableOfContentsJSON;
    SortableExceptionJsonTOC jsonExceptionToc;
    Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public LicenseJsonFormatWriter(String version, String releaseDate, File jsonFolder, File jsonFolderDetails, File jsonFolderExceptions) {
        this.jsonFolder = jsonFolder;
        this.jsonFolderDetails = jsonFolderDetails;
        this.jsonFolderExceptions = jsonFolderExceptions;
        this.licJson = new LicenseJson();
        this.tableOfContentsJSON = new LicenseJsonTOC(version, releaseDate);
        this.jsonExceptionToc = new SortableExceptionJsonTOC(version, releaseDate);
    }

    public File getJsonFolder() {
        return this.jsonFolder;
    }

    public void setJsonFolder(File jsonFolder) {
        this.jsonFolder = jsonFolder;
    }

    public File getJsonFolderExceptions() {
        return this.jsonFolderExceptions;
    }

    public void setJsonFolderExceptions(File jsonFolderExceptions) {
        this.jsonFolderExceptions = jsonFolderExceptions;
    }

    public File getJsonFolderDetails() {
        return this.jsonFolderDetails;
    }

    public void setJsonFolderDetails(File jsonFolderDetails) {
        this.jsonFolderDetails = jsonFolderDetails;
    }

    @Override
    public void writeLicense(ListedLicenseContainer licenseContainer, boolean deprecated, String deprecatedVersion) throws IOException, InvalidSPDXAnalysisException, InvalidLicenseTemplateException {
        SpdxListedLicense license = licenseContainer.getV2ListedLicense();
        this.licJson.copyFrom(license);
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        String licHtmlFileName = licBaseHtmlFileName + ".html";
        String licJsonFileName = licBaseHtmlFileName + ".json";
        String licHTMLReference = "./" + licHtmlFileName;
        String licJSONReference = "./" + licJsonFileName;
        File licJsonFile = new File(this.jsonFolder.getPath() + File.separator + "details" + File.separator + licJsonFileName);
        this.writeToFile(licJsonFile, this.licJson);
        this.tableOfContentsJSON.addLicense(license, licHTMLReference, licJSONReference, deprecated);
    }

    private void writeToFile(File file, Object jsonSerializableObject) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            writer.write(this.gson.toJson(jsonSerializableObject));
        }
    }

    @Override
    public void writeToC() throws IOException {
        File tocJsonFile = new File(this.jsonFolder.getPath() + File.separator + LICENSE_TOC_JSON_FILE_NAME);
        Collections.sort(this.tableOfContentsJSON.getLicenses(), new Comparator<LicenseJsonTOC.LicenseJson>(){

            @Override
            public int compare(LicenseJsonTOC.LicenseJson o1, LicenseJsonTOC.LicenseJson o2) {
                return o1.getLicenseId().compareToIgnoreCase(o2.getLicenseId());
            }
        });
        this.writeToFile(tocJsonFile, this.tableOfContentsJSON);
        File exceptionJsonTocFile = new File(this.jsonFolder.getPath() + File.separator + EXCEPTION_JSON_TOC_FILE_NAME);
        this.jsonExceptionToc.sortExceptions();
        this.writeToFile(exceptionJsonTocFile, (Object)this.jsonExceptionToc);
    }

    @Override
    public void writeException(ListedExceptionContainer exceptionContainer) throws IOException, InvalidSPDXAnalysisException {
        ListedLicenseException exception = exceptionContainer.getV2Exception();
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        String exceptionJsonFileName = exceptionHtmlFileName + ".json";
        String exceptionJSONReference = "./" + exceptionJsonFileName;
        String exceptionHTMLReference = "./" + exceptionHtmlFileName + ".html";
        ExceptionJson exceptionJson = new ExceptionJson();
        this.jsonExceptionToc.addException(exception, exceptionHTMLReference, exceptionJSONReference, exception.isDeprecated());
        exceptionJson.copyFrom(exception);
        File exceptionJsonFile = new File(this.jsonFolder.getPath() + File.separator + "exceptions" + File.separator + exceptionJsonFileName);
        this.writeToFile(exceptionJsonFile, exceptionJson);
    }
}

