/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.IOException;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.MarkdownTable;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;

public class LicenseMarkdownFormatWriter
implements ILicenseFormatWriter {
    private File markdownFile;
    private MarkdownTable markdownTable;

    public LicenseMarkdownFormatWriter(String version, String releaseDate, File markdownFile) {
        this.markdownFile = markdownFile;
        this.markdownTable = new MarkdownTable(version);
    }

    public File getMarkdownFile() {
        return this.markdownFile;
    }

    public void setMarkdownFile(File markdownFile) {
        this.markdownFile = markdownFile;
    }

    @Override
    public void writeLicense(ListedLicenseContainer licenseContainer, boolean deprecated, String deprecatedVersion) throws IOException, InvalidSPDXAnalysisException {
        this.markdownTable.addLicense(licenseContainer.getV2ListedLicense(), deprecated);
    }

    @Override
    public void writeToC() throws IOException {
        this.markdownTable.writeToFile(this.markdownFile);
    }

    @Override
    public void writeException(ListedExceptionContainer exceptionContianer) throws IOException, InvalidSPDXAnalysisException {
        this.markdownTable.addException((LicenseException)exceptionContianer.getV2Exception(), exceptionContianer.getV2Exception().isDeprecated());
    }
}

