/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.licenselistpublisher.LicenseGeneratorException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;

public class LicenseTemplateFormatWriter
implements ILicenseFormatWriter {
    private File templateFolder;
    private Charset utf8 = Charset.forName("UTF-8");

    public LicenseTemplateFormatWriter(File templateFolder) {
        this.templateFolder = templateFolder;
    }

    public File getTemplateFolder() {
        return this.templateFolder;
    }

    public void setTemplateFolder(File templateFolder) {
        this.templateFolder = templateFolder;
    }

    @Override
    public void writeLicense(ListedLicenseContainer licenseContainer, boolean deprecated, String deprecatedVersion) throws IOException, InvalidSPDXAnalysisException {
        SpdxListedLicense license = licenseContainer.getV2ListedLicense();
        Object licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        if (deprecated) {
            licBaseHtmlFileName = "deprecated_" + (String)licBaseHtmlFileName;
        }
        File templateFile = new File(this.templateFolder.getPath() + File.separator + (String)licBaseHtmlFileName + ".template.txt");
        if (license.getStandardLicenseTemplate() != null && !license.getStandardLicenseTemplate().trim().isEmpty()) {
            Files.write(templateFile.toPath(), license.getStandardLicenseTemplate().getBytes(this.utf8), new OpenOption[0]);
        } else {
            Files.write(templateFile.toPath(), license.getLicenseText().getBytes(this.utf8), new OpenOption[0]);
        }
    }

    @Override
    public void writeToC() throws IOException, LicenseGeneratorException {
    }

    @Override
    public void writeException(ListedExceptionContainer exceptionContainer) throws IOException, LicenseGeneratorException, InvalidSPDXAnalysisException {
        ListedLicenseException exception = exceptionContainer.getV2Exception();
        Object licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        if (exception.isDeprecated()) {
            licBaseHtmlFileName = "deprecated_" + (String)licBaseHtmlFileName;
        }
        File templateFile = new File(this.templateFolder.getPath() + File.separator + (String)licBaseHtmlFileName + ".template.txt");
        Files.write(templateFile.toPath(), exception.getLicenseExceptionTemplate().getBytes(this.utf8), new OpenOption[0]);
    }
}

