/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.License;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.licenseTemplate.LicenseTextHelper;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseTester;
import org.spdx.utility.compare.CompareTemplateOutputHandler;
import org.spdx.utility.compare.LicenseCompareHelper;
import org.spdx.utility.compare.SpdxCompareException;

public class LicenseTester
implements ILicenseTester {
    private final Map<String, File> licenseIdToTestMap = new HashMap<String, File>();
    private static final FileFilter testFileFilter = arg0 -> arg0.isFile() && arg0.getName().toLowerCase().endsWith(".txt");

    public LicenseTester(File licenseTestDirectory) {
        File[] licenseIdDirs = licenseTestDirectory.listFiles();
        if (licenseIdDirs != null) {
            for (File dir : licenseIdDirs) {
                if (!dir.isDirectory()) continue;
                this.licenseIdToTestMap.put(dir.getName(), dir);
            }
        }
    }

    @Override
    public List<String> testLicense(ListedLicenseContainer licenseContainer) throws IOException, SpdxCompareException, InvalidSPDXAnalysisException {
        File[] negativeTests;
        File negativeTestDir;
        File[] positiveTests;
        SpdxListedLicense license = licenseContainer.getV2ListedLicense();
        ArrayList<String> retval = new ArrayList<String>();
        File licenseDir = this.licenseIdToTestMap.get(license.getLicenseId());
        if (licenseDir == null || !licenseDir.exists()) {
            return retval;
        }
        File positiveTestDir = new File(licenseDir.getPath() + File.separator + "license" + File.separator + "good");
        if (positiveTestDir.exists() && positiveTestDir.isDirectory() && (positiveTests = positiveTestDir.listFiles(testFileFilter)) != null) {
            for (File test : positiveTests) {
                String text = this.readText(test);
                CompareTemplateOutputHandler.DifferenceDescription result = LicenseCompareHelper.isTextStandardLicense((License)license, (String)text);
                if (!result.isDifferenceFound()) continue;
                retval.add("Test 'positive-" + String.valueOf(test.toPath().getFileName()) + "' failed due to difference found " + result.getDifferenceMessage());
            }
        }
        if ((negativeTestDir = new File(licenseDir.getPath() + File.separator + "bad")).exists() && negativeTestDir.isDirectory() && (negativeTests = negativeTestDir.listFiles(testFileFilter)) != null) {
            for (File test : negativeTests) {
                String text = this.readText(test);
                CompareTemplateOutputHandler.DifferenceDescription result = LicenseCompareHelper.isTextStandardLicense((License)license, (String)text);
                if (result.isDifferenceFound()) continue;
                retval.add("Test 'negative-" + String.valueOf(test.toPath().getFileName()) + "' failed - no difference found");
            }
        }
        return retval;
    }

    private String readText(File f) throws IOException {
        StringBuilder text = new StringBuilder();
        try (Stream<String> fileLines = Files.lines(f.toPath());){
            fileLines.forEach(line -> {
                text.append((String)line);
                text.append("\n");
            });
        }
        return text.toString();
    }

    @Override
    public List<String> testException(ListedExceptionContainer exceptionContainer) throws IOException, InvalidSPDXAnalysisException {
        File[] negativeTests;
        File negativeTestDir;
        File[] positiveTests;
        ListedLicenseException exception = exceptionContainer.getV2Exception();
        ArrayList<String> retval = new ArrayList<String>();
        File exceptionDir = this.licenseIdToTestMap.get(exception.getLicenseExceptionId());
        if (exceptionDir == null || !exceptionDir.exists()) {
            return retval;
        }
        File positiveTestDir = new File(exceptionDir.getPath() + File.separator + "exception" + File.separator + "good");
        if (positiveTestDir.exists() && positiveTestDir.isDirectory() && (positiveTests = positiveTestDir.listFiles(testFileFilter)) != null) {
            for (File test : positiveTests) {
                String text = this.readText(test);
                if (LicenseTextHelper.isLicenseTextEquivalent((String)text, (String)exception.getLicenseExceptionText())) continue;
                retval.add("Test 'positive-" + String.valueOf(test.toPath().getFileName()) + "' failed due to difference found");
            }
        }
        if ((negativeTestDir = new File(exceptionDir.getPath() + File.separator + "bad")).exists() && negativeTestDir.isDirectory() && (negativeTests = negativeTestDir.listFiles(testFileFilter)) != null) {
            for (File test : negativeTests) {
                String text = this.readText(test);
                if (!LicenseTextHelper.isLicenseTextEquivalent((String)text, (String)exception.getLicenseExceptionText())) continue;
                retval.add("Test 'negative-" + String.valueOf(test.toPath().getFileName()) + "' failed - no difference found");
            }
        }
        return retval;
    }

    @Override
    public String getLicenseTestText(String licenseId) {
        throw new RuntimeException("Unimplemented getLicenseTestText");
    }

    @Override
    public String getExceptionTestText(String licenseExceptionId) {
        throw new RuntimeException("Unimplemented getExceptionTestText");
    }
}

