/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;

public class LicenseTextFormatWriter
implements ILicenseFormatWriter {
    private static final int MAX_LINE_CHARS = 80;
    private static final int TYPICAL_WORD_CHARS = 8;
    private File textFolder;
    private Charset utf8 = Charset.forName("UTF-8");

    public LicenseTextFormatWriter(File textFolder) {
        this.textFolder = textFolder;
    }

    public File getTextFolder() {
        return this.textFolder;
    }

    public void setTextFolder(File textFolder) {
        this.textFolder = textFolder;
    }

    public void writeLicense(ListedLicenseContainer licenseContainer, boolean deprecated, String deprecatedVersion, boolean wordWrapText) throws InvalidSPDXAnalysisException, IOException {
        SpdxListedLicense license = licenseContainer.getV2ListedLicense();
        Object licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        if (deprecated) {
            licBaseHtmlFileName = "deprecated_" + (String)licBaseHtmlFileName;
        }
        Path textFilePath = Paths.get(this.textFolder.getPath(), (String)licBaseHtmlFileName + ".txt");
        String[] lines = license.getLicenseText().split("\\n");
        ArrayList<String> wordWrappedLines = new ArrayList<String>();
        for (String line : lines) {
            if (line.length() < 80 || !wordWrapText) {
                wordWrappedLines.add(line);
                continue;
            }
            String[] words = line.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                if (currentLine.length() > 72) {
                    wordWrappedLines.add(currentLine.toString());
                    currentLine.setLength(0);
                } else if (currentLine.length() > 0) {
                    currentLine.append(' ');
                }
                currentLine.append(word);
            }
            if (currentLine.length() <= 0) continue;
            wordWrappedLines.add(currentLine.toString());
        }
        Files.write(textFilePath, wordWrappedLines, this.utf8, new OpenOption[0]);
    }

    @Override
    public void writeLicense(ListedLicenseContainer licenseContainer, boolean deprecated, String deprecatedVersion) throws IOException, InvalidSPDXAnalysisException {
        this.writeLicense(licenseContainer, deprecated, deprecatedVersion, true);
    }

    @Override
    public void writeToC() throws IOException {
    }

    @Override
    public void writeException(ListedExceptionContainer exceptionContainer) throws IOException, InvalidSPDXAnalysisException {
        ListedLicenseException exception = exceptionContainer.getV2Exception();
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        Path textFilePath = Paths.get(this.textFolder.getPath(), exceptionHtmlFileName + ".txt");
        Files.write(textFilePath, Arrays.asList(exception.getLicenseExceptionText().split("\\n")), this.utf8, new OpenOption[0]);
    }
}

