/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licenselistpublisher.licensegenerator;

import com.github.mustachejava.MustacheException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.htmltemplates.ExceptionHtml;
import org.spdx.htmltemplates.ExceptionHtmlToc;
import org.spdx.htmltemplates.LicenseHTMLFile;
import org.spdx.htmltemplates.LicenseTOCHTMLFile;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.v2.license.LicenseException;
import org.spdx.library.model.v2.license.ListedLicenseException;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.licenseTemplate.InvalidLicenseTemplateException;
import org.spdx.licenselistpublisher.LicenseGeneratorException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licenselistpublisher.licensegenerator.ILicenseFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseHtmlFormatWriter;
import org.spdx.licenselistpublisher.licensegenerator.LicenseRdfFormatWriter;
import org.spdx.spdxRdfStore.OutputFormat;
import org.spdx.spdxRdfStore.RdfStore;
import org.spdx.storage.IModelStore;
import org.spdx.storage.listedlicense.ExceptionJson;
import org.spdx.storage.listedlicense.ExceptionJsonTOC;
import org.spdx.storage.listedlicense.LicenseJson;
import org.spdx.storage.listedlicense.LicenseJsonTOC;

public class SpdxWebsiteFormatWriter
implements ILicenseFormatWriter {
    static final String LICENSE_TOC_JSON_FILE_NAME = "licenses.json";
    static final String LICENSE_TOC_HTML_FILE_NAME = "index.html";
    static final String EXCEPTION_TOC_FILE_NAME = "exceptions-index.html";
    static final String EXCEPTION_JSON_TOC_FILE_NAME = "exceptions.json";
    private File websiteFolder;
    private LicenseHTMLFile licHtml;
    private LicenseTOCHTMLFile tableOfContentsHTML;
    LicenseJson licJson;
    LicenseJsonTOC tableOfContentsJSON;
    String exceptionHtmlTocReference = "./exceptions-index.html";
    ExceptionHtmlToc htmlExceptionToc;
    ExceptionJsonTOC jsonExceptionToc;
    private String version;
    private String releaseDate;
    Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public SpdxWebsiteFormatWriter(String version, String releaseDate, File websiteFolder) {
        this.websiteFolder = websiteFolder;
        this.tableOfContentsHTML = new LicenseTOCHTMLFile(version, releaseDate);
        this.licHtml = new LicenseHTMLFile();
        this.licJson = new LicenseJson();
        this.tableOfContentsJSON = new LicenseJsonTOC(version, releaseDate);
        this.htmlExceptionToc = new ExceptionHtmlToc();
        this.jsonExceptionToc = new ExceptionJsonTOC(version, releaseDate);
        this.version = version;
        this.releaseDate = releaseDate;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public LicenseJson getLicJson() {
        return this.licJson;
    }

    public LicenseJsonTOC getTableOfContentsJSON() {
        return this.tableOfContentsJSON;
    }

    public ExceptionHtmlToc getHtmlExceptionToc() {
        return this.htmlExceptionToc;
    }

    public ExceptionJsonTOC getJsonExceptionToc() {
        return this.jsonExceptionToc;
    }

    public File getWebsiteFolder() {
        return this.websiteFolder;
    }

    public void setWebsiteFolder(File websiteFolder) {
        this.websiteFolder = websiteFolder;
    }

    public LicenseHTMLFile getLicHtml() {
        return this.licHtml;
    }

    public void setLicHtml(LicenseHTMLFile licHtml) {
        this.licHtml = licHtml;
    }

    public LicenseTOCHTMLFile getTableOfContentsHTML() {
        return this.tableOfContentsHTML;
    }

    public void setTableOfContentsHTML(LicenseTOCHTMLFile tableOfContentsHTML) {
        this.tableOfContentsHTML = tableOfContentsHTML;
    }

    @Override
    public void writeLicense(ListedLicenseContainer licenseContainer, boolean deprecated, String deprecatedVersion) throws IOException, LicenseGeneratorException, InvalidSPDXAnalysisException, InvalidLicenseTemplateException {
        SpdxListedLicense license = licenseContainer.getV2ListedLicense();
        this.licHtml.setLicense(license);
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        String licHtmlFileName = licBaseHtmlFileName + ".html";
        String licJsonFileName = licBaseHtmlFileName + ".json";
        String licHTMLReference = "./" + licHtmlFileName;
        String licJSONReference = "./" + licJsonFileName;
        String tocHTMLReference = "./index.html";
        File licBaseHtmlFile = new File(this.websiteFolder.getPath() + File.separator + licBaseHtmlFileName);
        File licJsonFile = new File(this.websiteFolder.getPath() + File.separator + licJsonFileName);
        File licHtmlFile = new File(this.websiteFolder.getPath() + File.separator + licHtmlFileName);
        try {
            this.licHtml.writeToFile(licBaseHtmlFile, tocHTMLReference);
            this.licHtml.writeToFile(licHtmlFile, tocHTMLReference);
        }
        catch (MustacheException e) {
            throw new LicenseGeneratorException("Template33 error for license HTML file: " + e.getMessage(), e);
        }
        catch (InvalidLicenseTemplateException e) {
            throw new LicenseGeneratorException("License template error for license HTML file: " + e.getMessage(), e);
        }
        this.licJson.copyFrom(license);
        this.writeToFile(licJsonFile, this.licJson);
        this.tableOfContentsJSON.addLicense(license, licHTMLReference, licJSONReference, deprecated);
        if (deprecated) {
            this.tableOfContentsHTML.addDeprecatedLicense(license, licHTMLReference);
        } else {
            this.tableOfContentsHTML.addLicense(license, licHTMLReference);
        }
        RdfStore onlyThisLicense = new RdfStore();
        onlyThisLicense.setDocumentUri(license.getDocumentUri(), true);
        ModelCopyManager copyManager = new ModelCopyManager();
        copyManager.copy((IModelStore)onlyThisLicense, license.getDocumentUri() + license.getId(), license.getModelStore(), license.getDocumentUri() + license.getId(), license.getSpecVersion(), license.getDocumentUri());
        LicenseRdfFormatWriter.writeRdf(onlyThisLicense, license.getDocumentUri(), this.websiteFolder.getPath() + File.separator + licBaseHtmlFileName + ".jsonld", OutputFormat.JSON_LD);
        LicenseRdfFormatWriter.writeRdf(onlyThisLicense, license.getDocumentUri(), this.websiteFolder.getPath() + File.separator + licBaseHtmlFileName + ".ttl", OutputFormat.TURTLE);
    }

    private void writeToFile(File file, Object jsonSerializableObject) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            writer.write(this.gson.toJson(jsonSerializableObject));
        }
    }

    @Override
    public void writeToC() throws IOException {
        File tocJsonFile = new File(this.websiteFolder.getPath() + File.separator + LICENSE_TOC_JSON_FILE_NAME);
        File tocHtmlFile = new File(this.websiteFolder.getPath() + File.separator + LICENSE_TOC_HTML_FILE_NAME);
        File exceptionTocFile = new File(this.websiteFolder.getPath() + File.separator + EXCEPTION_TOC_FILE_NAME);
        this.writeToFile(tocJsonFile, this.tableOfContentsJSON);
        this.tableOfContentsHTML.writeToFile(tocHtmlFile);
        this.htmlExceptionToc.writeToFile(exceptionTocFile, this.version);
        File exceptionJsonTocFile = new File(this.websiteFolder.getPath() + File.separator + EXCEPTION_JSON_TOC_FILE_NAME);
        this.writeToFile(exceptionJsonTocFile, this.jsonExceptionToc);
    }

    @Override
    public void writeException(ListedExceptionContainer exceptionContainer) throws IOException, InvalidLicenseTemplateException, LicenseGeneratorException, InvalidSPDXAnalysisException {
        ListedLicenseException exception = exceptionContainer.getV2Exception();
        ExceptionHtml exceptionHtml = new ExceptionHtml(exception);
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        String exceptionHTMLReference = "./" + exceptionHtmlFileName + ".html";
        String exceptionJsonFileName = exceptionHtmlFileName + ".json";
        String exceptionJSONReference = "./" + exceptionJsonFileName;
        File exceptionHtmlFile = new File(this.websiteFolder.getPath() + File.separator + exceptionHtmlFileName + ".html");
        exceptionHtml.writeToFile(exceptionHtmlFile, this.exceptionHtmlTocReference);
        File exceptionBaseFile = new File(this.websiteFolder.getPath() + File.separator + exceptionHtmlFileName);
        exceptionHtml.writeToFile(exceptionBaseFile, this.exceptionHtmlTocReference);
        if (exception.isDeprecated()) {
            this.htmlExceptionToc.addDeprecatedException((LicenseException)exception, exceptionHTMLReference, exception.getDeprecatedVersion());
        } else {
            this.htmlExceptionToc.addException((LicenseException)exception, exceptionHTMLReference);
        }
        this.jsonExceptionToc.addException(exception, exceptionHTMLReference, exceptionJSONReference, exception.isDeprecated());
        ExceptionJson exceptionJson = new ExceptionJson();
        exceptionJson.copyFrom(exception);
        File exceptionJsonFile = new File(this.websiteFolder.getPath() + File.separator + exceptionJsonFileName);
        this.writeToFile(exceptionJsonFile, exceptionJson);
        RdfStore onlyThisException = new RdfStore();
        onlyThisException.setDocumentUri(exception.getDocumentUri(), true);
        ModelCopyManager copyManager = new ModelCopyManager();
        copyManager.copy((IModelStore)onlyThisException, exception.getDocumentUri() + exception.getId(), exception.getModelStore(), exception.getDocumentUri() + exception.getId(), exception.getSpecVersion(), exception.getDocumentUri());
        LicenseRdfFormatWriter.writeRdf(onlyThisException, exception.getDocumentUri(), this.websiteFolder.getPath() + File.separator + exceptionHtmlFileName + ".jsonld", OutputFormat.JSON_LD);
        LicenseRdfFormatWriter.writeRdf(onlyThisException, exception.getDocumentUri(), this.websiteFolder.getPath() + File.separator + exceptionHtmlFileName + ".ttl", OutputFormat.TURTLE);
    }
}

