/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licensexml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.model.v2.license.CrossRef;
import org.spdx.library.model.v2.license.SpdxListedLicense;
import org.spdx.library.model.v3_0_1.core.CreationInfo;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicense;
import org.spdx.library.model.v3_0_1.expandedlicensing.ListedLicenseException;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.licensexml.LicenseXmlHelper;
import org.spdx.storage.IModelStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LicenseXmlDocument {
    static final Logger logger = LoggerFactory.getLogger((String)LicenseXmlDocument.class.getName());
    public static final String PROP_SCHEMA_FILENAME = "listedLicenseSchema";
    public static final String LICENSE_XML_SCHEMA_URL = "https://raw.githubusercontent.com/spdx/license-list-XML/master/schema/ListedLicense.xsd";
    public static final String LICENSE_XML_SCHEMA_LOCATION = "org/spdx/licensexml/ListedLicense.xsd";
    private static Schema _schema = null;
    private Document xmlDocument;
    private IModelStore v2ModelStore;
    private IModelStore v3ModelStore;
    private IModelCopyManager copyManager;
    private CreationInfo creationInfo;

    public LicenseXmlDocument(File file, IModelStore v2ModelStore, IModelStore v3ModelStore, IModelCopyManager copyManager, CreationInfo creationInfo) throws LicenseXmlException {
        DocumentBuilder builder;
        this.v2ModelStore = v2ModelStore;
        this.v3ModelStore = v3ModelStore;
        this.copyManager = copyManager;
        this.creationInfo = creationInfo;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.error("Parser configuration error creating document builder", (Throwable)e);
            throw new LicenseXmlException("Error creating parser for license XML file");
        }
        try {
            this.xmlDocument = builder.parse(file);
        }
        catch (SAXException e) {
            logger.error("Error parsing license XML document", (Throwable)e);
            throw new LicenseXmlException("Unable to parse license XML file: " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("I/O Error reading license XML file", (Throwable)e);
            throw new LicenseXmlException("I/O Error reading XML file: " + e.getMessage());
        }
        this.assertValid(file);
    }

    private synchronized Schema getSchema() throws LicenseXmlException {
        if (_schema == null) {
            InputStream schemaIs = null;
            try {
                String schemaFilePath = System.getProperty(PROP_SCHEMA_FILENAME);
                if (schemaFilePath != null) {
                    try {
                        schemaIs = new FileInputStream(schemaFilePath);
                    }
                    catch (IOException e) {
                        logger.error("IO Exception opening specified schema file " + schemaFilePath, (Throwable)e);
                        throw new LicenseXmlException("Invalid license XML schema file");
                    }
                }
                try {
                    URL schemaUrl = new URL(LICENSE_XML_SCHEMA_URL);
                    schemaIs = schemaUrl.openStream();
                }
                catch (Exception e) {
                    logger.warn("Unable to open license XML schema URL, using cached copy", (Throwable)e);
                }
                if (schemaIs == null) {
                    schemaIs = LicenseXmlDocument.class.getClassLoader().getResourceAsStream(LICENSE_XML_SCHEMA_LOCATION);
                }
                StreamSource schemaSource = new StreamSource(schemaIs);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                _schema = schemaFactory.newSchema(schemaSource);
            }
            catch (SAXException e) {
                logger.error("Invalid schema file", (Throwable)e);
                throw new LicenseXmlException("Invalid Listed License Schema", e);
            }
            finally {
                if (schemaIs != null) {
                    try {
                        schemaIs.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close Schema stream", (Throwable)e);
                    }
                }
            }
        }
        return _schema;
    }

    private void assertValid(File licenseXmlFile) throws LicenseXmlException {
        try {
            StreamSource xmlSource = new StreamSource(licenseXmlFile);
            Schema schema = this.getSchema();
            if (Objects.isNull(schema)) {
                throw new LicenseXmlException("Unable to open schema file for validation");
            }
            Validator validator = schema.newValidator();
            validator.validate(xmlSource);
        }
        catch (MalformedURLException e) {
            logger.error("Unable to open License List XML schema file", (Throwable)e);
            throw new LicenseXmlException("Unable to open License List XML schema file");
        }
        catch (SAXParseException e) {
            logger.error("Invalid license XML file " + licenseXmlFile.getName(), (Throwable)e);
            throw new LicenseXmlException("Parsing error in XML file " + licenseXmlFile.getName() + " at line " + e.getLineNumber() + ", column " + e.getColumnNumber() + ":" + e.getMessage());
        }
        catch (SAXException e) {
            logger.error("Invalid license XML file " + licenseXmlFile.getName(), (Throwable)e);
            throw new LicenseXmlException("Invalid XML file " + licenseXmlFile.getName() + ":" + e.getMessage());
        }
        catch (IOException e) {
            logger.error("IO Error validating license XML file", (Throwable)e);
            throw new LicenseXmlException("IO Error validating license XML file");
        }
    }

    public LicenseXmlDocument(Document xmlDocument) throws LicenseXmlException {
        this.xmlDocument = xmlDocument;
    }

    public List<ListedLicenseContainer> getListedLicenses() throws InvalidSPDXAnalysisException, LicenseXmlException {
        ArrayList<ListedLicenseContainer> retval = new ArrayList<ListedLicenseContainer>();
        Element rootElement = this.xmlDocument.getDocumentElement();
        NodeList licenseElements = rootElement.getElementsByTagName("license");
        for (int i = 0; i < licenseElements.getLength(); ++i) {
            Element licenseElement = (Element)licenseElements.item(i);
            retval.add(this.getListedLicense(licenseElement));
        }
        return retval;
    }

    private ListedLicenseContainer getListedLicense(Element licenseElement) throws InvalidSPDXAnalysisException, LicenseXmlException {
        NodeList textNodes;
        String name = licenseElement.getAttribute("name");
        String id = licenseElement.getAttribute("licenseId");
        boolean deprecated = licenseElement.hasAttribute("deprecatedVersion");
        String deprecatedVersion = null;
        if (deprecated) {
            deprecatedVersion = licenseElement.getAttribute("deprecatedVersion");
        }
        if ((textNodes = licenseElement.getElementsByTagName("text")).getLength() != 1) {
            throw new LicenseXmlException("Invalid number of text elements.  Expected 1 - found " + textNodes.getLength());
        }
        Element textElement = (Element)textNodes.item(0);
        String text = LicenseXmlHelper.getLicenseText(textElement);
        NodeList notes = licenseElement.getElementsByTagName("notes");
        String comment = null;
        if (notes.getLength() > 0) {
            StringBuilder commentBuilder = new StringBuilder(LicenseXmlHelper.getNoteText((Element)notes.item(0)));
            for (int i = 1; i < notes.getLength(); ++i) {
                commentBuilder.append("; ");
                commentBuilder.append(LicenseXmlHelper.getNoteText((Element)notes.item(i)));
            }
            comment = commentBuilder.toString();
        }
        NodeList urlNodes = licenseElement.getElementsByTagName("crossRef");
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (int i = 0; i < urlNodes.getLength(); ++i) {
            String sourceUrl = urlNodes.item(i).getTextContent().trim();
            sourceUrls.add(sourceUrl);
        }
        String licenseHeader = null;
        String licenseHeaderTemplate = null;
        String licenseHeaderTemplateHtml = null;
        NodeList headerNodes = licenseElement.getElementsByTagName("standardLicenseHeader");
        if (headerNodes.getLength() > 0) {
            StringBuilder sbText = new StringBuilder();
            StringBuilder sbTemplate = new StringBuilder();
            StringBuilder sbHtml = new StringBuilder();
            sbText.append(LicenseXmlHelper.getHeaderText((Element)headerNodes.item(0)));
            sbTemplate.append(LicenseXmlHelper.getHeaderTemplate((Element)headerNodes.item(0)));
            sbHtml.append(LicenseXmlHelper.getHeaderTextHtml((Element)headerNodes.item(0)));
            for (int i = 1; i < headerNodes.getLength(); ++i) {
                sbText.append('\n');
                sbText.append(LicenseXmlHelper.getHeaderText((Element)headerNodes.item(i)));
                sbTemplate.append('\n');
                sbTemplate.append(LicenseXmlHelper.getHeaderTemplate((Element)headerNodes.item(i)));
                sbHtml.append("<br />\n");
                sbHtml.append(LicenseXmlHelper.getHeaderTextHtml((Element)headerNodes.item(i)));
            }
            licenseHeader = sbText.toString();
            licenseHeaderTemplate = sbTemplate.toString();
            licenseHeaderTemplateHtml = sbHtml.toString();
        }
        String template = LicenseXmlHelper.getLicenseTemplate(textElement);
        boolean osiApproved = licenseElement.hasAttribute("isOsiApproved") ? "true".equals(licenseElement.getAttribute("isOsiApproved").toLowerCase()) : false;
        boolean fsfLibre = licenseElement.hasAttribute("isFsfLibre") ? "true".equals(licenseElement.getAttribute("isFsfLibre").toLowerCase()) : false;
        String licenseHtml = LicenseXmlHelper.getLicenseTextHtml(textElement);
        SpdxListedLicense licv2 = new SpdxListedLicense(this.v2ModelStore, "http://spdx.org/licenses/", id, this.copyManager, true);
        ListedLicense licv3 = new ListedLicense(this.v3ModelStore, "http://spdx.org/licenses/" + id, this.copyManager, true, null);
        licv3.setCreationInfo(this.creationInfo);
        licv2.setName(name);
        licv3.setName(name);
        licv2.setLicenseText(text);
        licv3.setLicenseText(text);
        licv2.setSeeAlso(sourceUrls);
        licv3.getSeeAlsos().addAll(sourceUrls);
        licv2.setComment(comment);
        licv3.setComment(comment);
        licv2.setStandardLicenseHeader(licenseHeader);
        licv3.setStandardLicenseHeader(licenseHeader);
        licv2.setStandardLicenseTemplate(template);
        licv3.setStandardLicenseTemplate(template);
        licv2.setOsiApproved(Boolean.valueOf(osiApproved));
        licv3.setIsOsiApproved(Boolean.valueOf(osiApproved));
        licv2.setFsfLibre(Boolean.valueOf(fsfLibre));
        licv3.setIsFsfLibre(Boolean.valueOf(fsfLibre));
        licv2.setLicenseTextHtml(licenseHtml);
        licv2.setDeprecated(Boolean.valueOf(deprecated));
        licv3.setIsDeprecatedLicenseId(Boolean.valueOf(deprecated));
        licv2.setDeprecatedVersion(deprecatedVersion);
        licv3.setDeprecatedVersion(deprecatedVersion);
        licv2.setLicenseHeaderHtml(licenseHeaderTemplateHtml);
        licv2.setStandardLicenseHeaderTemplate(licenseHeaderTemplate);
        int i = 0;
        for (String sourceUrl : sourceUrls) {
            CrossRef crossRef = licv2.createCrossRef(sourceUrl).setOrder(Integer.valueOf(i++)).build();
            licv2.getCrossRef().add(crossRef);
        }
        return new ListedLicenseContainer(licv2, licv3);
    }

    public List<ListedExceptionContainer> getLicenseExceptions() throws LicenseXmlException, InvalidSPDXAnalysisException {
        ArrayList<ListedExceptionContainer> retval = new ArrayList<ListedExceptionContainer>();
        Element rootElement = this.xmlDocument.getDocumentElement();
        NodeList exceptionElements = rootElement.getElementsByTagName("exception");
        for (int i = 0; i < exceptionElements.getLength(); ++i) {
            Element exceptionElement = (Element)exceptionElements.item(i);
            retval.add(this.getException(exceptionElement));
        }
        return retval;
    }

    private ListedExceptionContainer getException(Element exceptionElement) throws LicenseXmlException, InvalidSPDXAnalysisException {
        NodeList textNodes;
        String name = exceptionElement.getAttribute("name");
        String id = exceptionElement.getAttribute("licenseId");
        boolean deprecated = exceptionElement.hasAttribute("deprecatedVersion");
        String deprecatedVersion = null;
        if (deprecated) {
            deprecatedVersion = exceptionElement.getAttribute("deprecatedVersion");
        }
        if ((textNodes = exceptionElement.getElementsByTagName("text")).getLength() != 1) {
            throw new LicenseXmlException("Invalid number of text elements.  Expected 1 - found " + textNodes.getLength());
        }
        Element textElement = (Element)textNodes.item(0);
        String text = LicenseXmlHelper.getLicenseText(textElement);
        String template = LicenseXmlHelper.getLicenseTemplate(textElement);
        String html = LicenseXmlHelper.getLicenseTextHtml(textElement);
        NodeList notes = exceptionElement.getElementsByTagName("notes");
        String comment = null;
        if (notes.getLength() > 0) {
            StringBuilder commentBuilder = new StringBuilder(LicenseXmlHelper.getNoteText((Element)notes.item(0)));
            for (int i = 1; i < notes.getLength(); ++i) {
                commentBuilder.append("; ");
                commentBuilder.append(LicenseXmlHelper.getNoteText((Element)notes.item(i)));
            }
            comment = commentBuilder.toString();
        }
        NodeList urlNodes = exceptionElement.getElementsByTagName("crossRef");
        ArrayList<String> sourceUrls = new ArrayList<String>();
        for (int i = 0; i < urlNodes.getLength(); ++i) {
            sourceUrls.add(urlNodes.item(i).getTextContent().trim());
        }
        org.spdx.library.model.v2.license.ListedLicenseException exceptionV2 = new org.spdx.library.model.v2.license.ListedLicenseException(this.v2ModelStore, "http://spdx.org/licenses/", id, this.copyManager, true);
        ListedLicenseException exceptionV3 = new ListedLicenseException(this.v3ModelStore, "http://spdx.org/licenses/" + id, this.copyManager, true, null);
        exceptionV3.setCreationInfo(this.creationInfo);
        exceptionV2.setName(name);
        exceptionV3.setName(name);
        exceptionV2.setLicenseExceptionText(text);
        exceptionV3.setAdditionText(text);
        exceptionV2.setLicenseExceptionTemplate(template);
        exceptionV3.setStandardAdditionTemplate(template);
        exceptionV2.setSeeAlso(sourceUrls);
        exceptionV3.getSeeAlsos().addAll(sourceUrls);
        exceptionV2.setComment(comment);
        exceptionV3.setComment(comment);
        exceptionV2.setExceptionTextHtml(html);
        exceptionV2.setDeprecated(Boolean.valueOf(deprecated));
        exceptionV3.setIsDeprecatedAdditionId(Boolean.valueOf(deprecated));
        exceptionV2.setDeprecatedVersion(deprecatedVersion);
        exceptionV3.setDeprecatedVersion(deprecatedVersion);
        return new ListedExceptionContainer(exceptionV2, exceptionV3);
    }
}

