/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licensexml;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.v2.license.SpdxListedLicenseException;
import org.spdx.licenselistpublisher.ISpdxListedLicenseProvider;
import org.spdx.licenselistpublisher.ListedExceptionContainer;
import org.spdx.licenselistpublisher.ListedLicenseContainer;
import org.spdx.licensexml.LicenseXmlDocument;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.licensexml.XmlLicenseProvider;
import org.spdx.storage.IModelStore;
import org.spdx.storage.simple.InMemSpdxStore;

public class XmlLicenseProviderSingleFile
implements ISpdxListedLicenseProvider {
    Logger logger = LoggerFactory.getLogger((String)XmlLicenseProviderSingleFile.class.getName());
    private List<String> warnings = new ArrayList<String>();
    LicenseXmlDocument licDoc = null;
    protected IModelStore v2ModelStore = new InMemSpdxStore();
    protected IModelStore v3ModelStore = new InMemSpdxStore();
    protected IModelCopyManager copyManager = new ModelCopyManager();

    public XmlLicenseProviderSingleFile(File licenseXmlFile, String currentListVersion, String releaseDate) throws LicenseXmlException, InvalidSPDXAnalysisException {
        this.licDoc = new LicenseXmlDocument(licenseXmlFile, this.v2ModelStore, this.v3ModelStore, this.copyManager, XmlLicenseProvider.createCreationInfo(this.v3ModelStore, this.copyManager, releaseDate, currentListVersion));
    }

    @Override
    public Iterator<ListedLicenseContainer> getLicenseIterator() throws SpdxListedLicenseException {
        try {
            return this.licDoc.getListedLicenses().iterator();
        }
        catch (InvalidSPDXAnalysisException e) {
            this.logger.error("SPDX Analysis exception getting license iterator", (Throwable)e);
            throw new SpdxListedLicenseException("SPDX Analysis exception getting license iterator", (Throwable)e);
        }
        catch (LicenseXmlException e) {
            this.logger.error("License XML exception getting license iterator", (Throwable)e);
            throw new SpdxListedLicenseException("Invalid License XML Document", (Throwable)e);
        }
    }

    @Override
    public Iterator<ListedExceptionContainer> getExceptionIterator() throws InvalidSPDXAnalysisException {
        try {
            return this.licDoc.getLicenseExceptions().iterator();
        }
        catch (LicenseXmlException e) {
            this.logger.error("License XML exception getting license iterator", (Throwable)e);
            throw new RuntimeException(new SpdxListedLicenseException("Invalid License XML Document", (Throwable)e));
        }
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }
}

