/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.jacksonstore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IndividualUriValue;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.ModelRegistry;
import org.spdx.core.SpdxInvalidTypeException;
import org.spdx.core.TypedValue;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.jacksonstore.PropertyComparator;
import org.spdx.library.model.v2.ExternalDocumentRef;
import org.spdx.library.model.v2.ExternalSpdxElement;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxElement;
import org.spdx.library.model.v2.SpdxModelFactoryCompatV2;
import org.spdx.library.model.v2.enumerations.Purpose;
import org.spdx.library.model.v2.enumerations.RelationshipType;
import org.spdx.library.model.v2.enumerations.SpdxEnumFactoryCompatV2;
import org.spdx.library.model.v2.license.AnyLicenseInfo;
import org.spdx.library.model.v2.license.SimpleLicensingInfo;
import org.spdx.storage.IModelStore;
import org.spdx.storage.compatv2.CompatibleModelStoreWrapper;

public class JacksonSerializer {
    static final Logger logger = LoggerFactory.getLogger(JacksonSerializer.class);
    static final Comparator<JsonNode> NODE_COMPARATOR = new Comparator<JsonNode>(){

        @Override
        public int compare(JsonNode arg0, JsonNode arg1) {
            if (Objects.isNull(arg0)) {
                return Objects.isNull(arg1) ? 0 : 1;
            }
            if (Objects.isNull(arg1)) {
                return -1;
            }
            if (arg0.isTextual()) {
                return arg1.isTextual() ? arg0.asText().compareTo(arg1.asText()) : 1;
            }
            if (arg0.isObject()) {
                return arg1.isObject() ? this.compareObject(arg0, arg1) : 1;
            }
            if (arg0.isArray()) {
                if (!arg1.isArray()) {
                    return 1;
                }
                if (arg0.size() > arg1.size()) {
                    return 1;
                }
                if (arg0.size() < arg1.size()) {
                    return -1;
                }
                ArrayList<JsonNode> list0 = new ArrayList<JsonNode>();
                arg0.spliterator().forEachRemaining(list0::add);
                list0.sort(NODE_COMPARATOR);
                ArrayList<JsonNode> list1 = new ArrayList<JsonNode>();
                arg1.spliterator().forEachRemaining(list1::add);
                list1.sort(NODE_COMPARATOR);
                for (int i = 0; i < list0.size(); ++i) {
                    int retval = this.compare((JsonNode)list0.get(i), (JsonNode)list1.get(i));
                    if (retval == 0) continue;
                    return retval;
                }
                return 0;
            }
            return Integer.compare(arg0.hashCode(), arg1.hashCode());
        }

        private int compareObject(JsonNode arg0, JsonNode arg1) {
            if (!arg1.isObject()) {
                return 1;
            }
            JsonNode spdxid0 = arg0.get("SPDXID");
            if (Objects.nonNull(spdxid0) && spdxid0.isTextual()) {
                JsonNode spdxid1 = arg1.get("SPDXID");
                return Objects.nonNull(spdxid1) && spdxid1.isTextual() ? spdxid0.asText().compareTo(spdxid1.asText()) : 1;
            }
            JsonNode licenseId0 = arg0.get(SpdxConstantsCompatV2.PROP_LICENSE_ID.getName());
            if (Objects.nonNull(licenseId0) && licenseId0.isTextual()) {
                return this.compareExtractedLicense(licenseId0.asText(), arg1);
            }
            JsonNode spdxDocument0 = arg0.get(SpdxConstantsCompatV2.PROP_EXTERNAL_SPDX_DOCUMENT.getName());
            JsonNode externalDocId0 = arg0.get(SpdxConstantsCompatV2.PROP_EXTERNAL_DOCUMENT_ID.getName());
            if (Objects.nonNull(spdxDocument0) && Objects.nonNull(externalDocId0) && spdxDocument0.isTextual() && externalDocId0.isTextual()) {
                return this.compareExternalDocumentRef(spdxDocument0.asText(), externalDocId0.asText(), arg1);
            }
            JsonNode refCategory0 = arg0.get(SpdxConstantsCompatV2.PROP_REFERENCE_CATEGORY.getName());
            JsonNode refType0 = arg0.get(SpdxConstantsCompatV2.PROP_REFERENCE_TYPE.getName());
            JsonNode refLocator0 = arg0.get(SpdxConstantsCompatV2.PROP_REFERENCE_LOCATOR.getName());
            if (Objects.nonNull(refCategory0) && Objects.nonNull(refType0) && Objects.nonNull(refLocator0) && refCategory0.isTextual() && refType0.isTextual() && refLocator0.isTextual()) {
                return this.compareExternalRef(refCategory0.asText(), refType0.asText(), refLocator0.asText(), arg1);
            }
            ArrayList fieldNames = new ArrayList();
            arg0.fieldNames().forEachRemaining(fieldNames::add);
            Collections.sort(fieldNames);
            int retval = 0;
            for (String fieldName : fieldNames) {
                JsonNode value1;
                JsonNode value0 = arg0.get(fieldName);
                retval = this.compare(value0, value1 = arg1.get(fieldName));
                if (retval == 0) continue;
                return retval;
            }
            return retval;
        }

        private int compareExternalRef(String refCategory, String refType, String refLocator, JsonNode compare) {
            JsonNode compRefCategory = compare.get(SpdxConstantsCompatV2.PROP_REFERENCE_CATEGORY.getName());
            JsonNode compRefType = compare.get(SpdxConstantsCompatV2.PROP_REFERENCE_TYPE.getName());
            JsonNode compRefLocator = compare.get(SpdxConstantsCompatV2.PROP_REFERENCE_LOCATOR.getName());
            if (Objects.isNull(compRefCategory) || Objects.isNull(compRefType) || Objects.isNull(compRefLocator) || !compRefCategory.isTextual() || !compRefType.isTextual() || !compRefLocator.isTextual()) {
                return 1;
            }
            int retval = refCategory.compareTo(compRefCategory.asText());
            if (retval != 0) {
                return retval;
            }
            retval = refType.compareTo(compRefType.asText());
            if (retval != 0) {
                return retval;
            }
            return refLocator.compareTo(compRefLocator.asText());
        }

        private int compareExternalDocumentRef(String document, String externalDocId, JsonNode compare) {
            JsonNode compDocument = compare.get(SpdxConstantsCompatV2.PROP_EXTERNAL_SPDX_DOCUMENT.getName());
            JsonNode compExternalDocId = compare.get(SpdxConstantsCompatV2.PROP_EXTERNAL_DOCUMENT_ID.getName());
            if (Objects.isNull(compDocument) || Objects.isNull(compExternalDocId) || !compDocument.isTextual() || !compExternalDocId.isTextual()) {
                return 1;
            }
            int retval = document.compareTo(compDocument.asText());
            if (retval != 0) {
                return retval;
            }
            return externalDocId.compareTo(compExternalDocId.asText());
        }

        private int compareExtractedLicense(String licenseId, JsonNode compare) {
            JsonNode compLicenseId = compare.get(SpdxConstantsCompatV2.PROP_LICENSE_ID.getName());
            if (Objects.isNull(compLicenseId) || !compLicenseId.isTextual()) {
                return 1;
            }
            return licenseId.compareTo(compLicenseId.asText());
        }
    };
    private final ObjectMapper mapper;
    private final CompatibleModelStoreWrapper store;
    private final MultiFormatStore.Format format;
    private final MultiFormatStore.Verbose verbose;

    public JacksonSerializer(ObjectMapper mapper, MultiFormatStore.Format format, MultiFormatStore.Verbose verbose, IModelStore store) {
        Objects.requireNonNull(mapper, "Non-null required Jackson mapper");
        Objects.requireNonNull(format, "Non-null required format");
        Objects.requireNonNull(verbose, "Non-null required verbose");
        Objects.requireNonNull(store, "Non-null required store");
        this.mapper = mapper;
        this.store = new CompatibleModelStoreWrapper(store);
        this.format = format;
        this.verbose = verbose;
    }

    public ArrayNode docsToJsonNode(List<String> documentUris) throws InvalidSPDXAnalysisException {
        ArrayNode retval = this.mapper.createArrayNode();
        for (String documentUri : documentUris) {
            retval.add((JsonNode)this.docToJsonNode(documentUri));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode docToJsonNode(String documentUri) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(documentUri, "Null Document URI");
        IModelStore.IModelStoreLock lock = this.store.enterCriticalSection(documentUri, false);
        try {
            ObjectNode output;
            ArrayNode snippets;
            ArrayNode files;
            TypedValue document = CompatibleModelStoreWrapper.typedValueFromDocUri((String)documentUri, (String)"SPDXRef-DOCUMENT", (boolean)false, (String)"SpdxDocument");
            ArrayNode relationships = this.mapper.createArrayNode();
            ObjectNode doc = this.typedValueToObjectNode(documentUri, document, relationships);
            doc.put(SpdxConstantsCompatV2.PROP_DOCUMENT_NAMESPACE.getName(), documentUri);
            ArrayNode packages = this.getDocElements(documentUri, "Package", relationships);
            if (!packages.isEmpty()) {
                this.sortArrayNode(packages);
                doc.set(SpdxConstantsCompatV2.PROP_DOCUMENT_PACKAGES.getName(), (JsonNode)packages);
            }
            if (!(files = this.getDocElements(documentUri, "File", relationships)).isEmpty()) {
                this.sortArrayNode(files);
                doc.set(SpdxConstantsCompatV2.PROP_DOCUMENT_FILES.getName(), (JsonNode)files);
            }
            if (!(snippets = this.getDocElements(documentUri, "Snippet", relationships)).isEmpty()) {
                this.sortArrayNode(snippets);
                doc.set(SpdxConstantsCompatV2.PROP_DOCUMENT_SNIPPETS.getName(), (JsonNode)snippets);
            }
            HashMap iDRelTypeRelatediDMap = new HashMap();
            Iterator relIter = relationships.elements();
            ArrayNode deDupedRelationships = new ArrayNode(JsonNodeFactory.instance);
            while (relIter.hasNext()) {
                HashSet<String> relatedIds;
                JsonNode relationship = (JsonNode)relIter.next();
                String id = relationship.get(SpdxConstantsCompatV2.PROP_SPDX_ELEMENTID.getName()).asText();
                String relType = relationship.get(SpdxConstantsCompatV2.PROP_RELATIONSHIP_TYPE.getName()).asText();
                String relatedID = relationship.get(SpdxConstantsCompatV2.PROP_RELATED_SPDX_ELEMENT.getName()).asText();
                HashMap relTypeRelatedIdMap = (HashMap)iDRelTypeRelatediDMap.get(id);
                if (Objects.isNull(relTypeRelatedIdMap)) {
                    relTypeRelatedIdMap = new HashMap();
                    iDRelTypeRelatediDMap.put(id, relTypeRelatedIdMap);
                }
                if (Objects.isNull(relatedIds = (HashSet<String>)relTypeRelatedIdMap.get(relType))) {
                    relatedIds = new HashSet<String>();
                    relTypeRelatedIdMap.put(relType, relatedIds);
                }
                if (relatedIds.contains(relatedID)) continue;
                deDupedRelationships.add(relationship);
                relatedIds.add(relatedID);
            }
            this.sortArrayNode(deDupedRelationships);
            doc.set(SpdxConstantsCompatV2.PROP_DOCUMENT_RELATIONSHIPS.getName(), (JsonNode)deDupedRelationships);
            switch (this.format) {
                case XML: {
                    output = new Document(JsonNodeFactory.instance);
                    output.setAll(doc);
                    break;
                }
                default: {
                    output = doc;
                }
            }
            ObjectNode objectNode = output;
            return objectNode;
        }
        finally {
            this.store.leaveCriticalSection(lock);
        }
    }

    private void sortArrayNode(ArrayNode an) {
        List arrayElements = StreamSupport.stream(an.spliterator(), false).sorted(NODE_COMPARATOR).collect(Collectors.toList());
        an.removeAll();
        an.addAll(arrayElements);
    }

    private ObjectNode typedValueToObjectNode(String documentUri, TypedValue storedItem, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        ObjectNode retval = this.mapper.createObjectNode();
        HashSet<String> hasFileIds = new HashSet<String>();
        HashSet<String> documentDescribesIds = new HashSet<String>();
        ArrayList<String> docPropNames = new ArrayList<String>(this.store.getPropertyValueNames(storedItem.getObjectUri()));
        docPropNames.sort(new PropertyComparator(storedItem.getType()));
        Class clazz = (Class)SpdxModelFactoryCompatV2.SPDX_TYPE_TO_CLASS_V2.get(storedItem.getType());
        IModelStore.IdType idType = this.store.getIdType(storedItem.getObjectUri());
        String id = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)storedItem.getObjectUri(), (String)documentUri);
        if (SpdxElement.class.isAssignableFrom(clazz)) {
            if (IModelStore.IdType.SpdxId.equals((Object)idType)) {
                retval.put("SPDXID", CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)storedItem.getObjectUri(), (String)documentUri));
            } else if (!IModelStore.IdType.Anonymous.equals((Object)idType)) {
                logger.error("Invalid ID {}.  Must be an SPDX Identifier or Anonymous", (Object)storedItem.getObjectUri());
                throw new InvalidSPDXAnalysisException("Invalid ID " + storedItem.getObjectUri() + ".  Must be an SPDX Identifier or Anonymous");
            }
        } else if (ExternalDocumentRef.class.isAssignableFrom(clazz)) {
            retval.put("externalDocumentId", CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)storedItem.getObjectUri(), (String)documentUri));
        } else if (SimpleLicensingInfo.class.isAssignableFrom(clazz)) {
            retval.put(SpdxConstantsCompatV2.PROP_LICENSE_ID.getName(), id);
        }
        for (String propertyName : docPropNames) {
            if (SpdxConstantsCompatV2.PROP_RELATIONSHIP.getName().equals(propertyName)) {
                this.addJsonRelationships(documentUri, storedItem, retval, relationships, hasFileIds, documentDescribesIds);
                continue;
            }
            if (SpdxConstantsCompatV2.PROP_SPDX_EXTRACTED_LICENSES.getName().equals(propertyName)) {
                retval.set(MultiFormatStore.propertyNameToCollectionPropertyName(propertyName), (JsonNode)this.toExtractedLicensesArrayNode(documentUri, id, propertyName, relationships));
                continue;
            }
            if (this.store.isCollectionProperty(documentUri, id, propertyName)) {
                ArrayNode valuesArray;
                Iterator propertyValues = this.store.listValues(documentUri, id, propertyName);
                if (SpdxConstantsCompatV2.PROP_PACKAGE_FILE.getName().equals(propertyName) && !hasFileIds.isEmpty()) {
                    ArrayList hasFilesToAdd = new ArrayList();
                    while (propertyValues.hasNext()) {
                        Object fileToAdd = propertyValues.next();
                        if (fileToAdd instanceof TypedValue) {
                            String fileToAddId = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)((TypedValue)fileToAdd).getObjectUri(), (String)documentUri);
                            if (hasFileIds.contains(fileToAddId)) continue;
                            hasFilesToAdd.add(fileToAdd);
                            hasFileIds.add(fileToAddId);
                            continue;
                        }
                        hasFilesToAdd.add(fileToAdd);
                    }
                    valuesArray = this.toArrayNode(documentUri, hasFilesToAdd.iterator(), relationships);
                } else if (SpdxConstantsCompatV2.PROP_DOCUMENT_DESCRIBES.getName().equals(propertyName) && !documentDescribesIds.isEmpty()) {
                    ArrayList describesToAdd = new ArrayList();
                    while (propertyValues.hasNext()) {
                        Object describedElementToAdd = propertyValues.next();
                        if (describedElementToAdd instanceof TypedValue) {
                            String describedElementToAddId = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)((TypedValue)describedElementToAdd).getObjectUri(), (String)documentUri);
                            if (hasFileIds.contains(describedElementToAddId)) continue;
                            describesToAdd.add(describedElementToAdd);
                            hasFileIds.add(describedElementToAddId);
                            continue;
                        }
                        describesToAdd.add(describedElementToAdd);
                    }
                    valuesArray = this.toArrayNode(documentUri, describesToAdd.iterator(), relationships);
                } else {
                    valuesArray = this.toArrayNode(documentUri, propertyValues, relationships);
                }
                retval.set(MultiFormatStore.propertyNameToCollectionPropertyName(propertyName), (JsonNode)valuesArray);
                continue;
            }
            Optional value = this.store.getValue(documentUri, id, propertyName);
            if (!value.isPresent()) continue;
            this.setValueField(retval, propertyName, documentUri, value.get(), relationships);
        }
        return retval;
    }

    private ArrayNode getDocElements(String documentUri, String type, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        return this.store.getAllItems(documentUri, type).collect(() -> ((ObjectMapper)this.mapper).createArrayNode(), (an, item) -> {
            try {
                an.add((JsonNode)this.typedValueToObjectNode(documentUri, (TypedValue)item, relationships));
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
        }, ArrayNode::addAll);
    }

    private ArrayNode toExtractedLicensesArrayNode(String documentUri, String id, String propertyName, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        ArrayList<Object> retval = new ArrayList<Object>();
        Iterator extractedLicenses = this.store.listValues(documentUri, id, propertyName);
        while (extractedLicenses.hasNext()) {
            Object extractedLicense = extractedLicenses.next();
            if (!(extractedLicense instanceof TypedValue) || !"ExtractedLicensingInfo".equals(((TypedValue)extractedLicense).getType())) {
                throw new SpdxInvalidTypeException("Extracted License Infos not of type ExtractedLicensingInfo");
            }
            retval.add(this.typedValueToObjectNode(documentUri, (TypedValue)extractedLicense, relationships));
        }
        retval.sort(NODE_COMPARATOR);
        return this.mapper.createArrayNode().addAll(retval);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addJsonRelationships(String documentUri, TypedValue element, ObjectNode elementNode, ArrayNode relationships, Set<String> hasFileIds, Set<String> documentDescribesIds) throws InvalidSPDXAnalysisException {
        Iterator valueList = this.store.listValues(documentUri, CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)element.getObjectUri(), (String)documentUri), SpdxConstantsCompatV2.PROP_RELATIONSHIP);
        while (valueList.hasNext()) {
            String relatedElementId;
            Object value = valueList.next();
            if (!(value instanceof TypedValue)) {
                throw new SpdxInvalidTypeException("Expected relationship type, value list element was of type " + value.getClass());
            }
            TypedValue tvValue = (TypedValue)value;
            String tvId = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)tvValue.getObjectUri(), (String)documentUri);
            if (!"Relationship".equals(tvValue.getType())) {
                throw new SpdxInvalidTypeException("Expected relationship type, value list element was of type " + tvValue.getType());
            }
            Optional relatedSpdxElement = this.store.getValue(documentUri, tvId, SpdxConstantsCompatV2.PROP_RELATED_SPDX_ELEMENT);
            if (!relatedSpdxElement.isPresent()) {
                logger.warn("Missing related SPDX element for a relationship for {}.  Skipping the serialization of this relationship.", (Object)element.getObjectUri());
                continue;
            }
            Optional relationshipComment = this.store.getValue(documentUri, tvId, SpdxConstantsCompatV2.RDFS_PROP_COMMENT);
            if (relatedSpdxElement.get() instanceof TypedValue) {
                relatedElementId = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)((TypedValue)relatedSpdxElement.get()).getObjectUri(), (String)documentUri);
            } else {
                if (!(relatedSpdxElement.get() instanceof IndividualUriValue)) throw new SpdxInvalidTypeException("SPDX element must be of SpdxElement or external SPDX element type.  Found type " + relatedSpdxElement.get().getClass());
                String externalUri = ((IndividualUriValue)relatedSpdxElement.get()).getIndividualURI();
                if (SpdxConstantsCompatV2.URI_VALUE_NONE.equals(externalUri)) {
                    relatedElementId = SpdxConstantsCompatV2.NONE_VALUE;
                } else if (SpdxConstantsCompatV2.URI_VALUE_NOASSERTION.equals(externalUri)) {
                    relatedElementId = SpdxConstantsCompatV2.NOASSERTION_VALUE;
                } else {
                    if (!SpdxConstantsCompatV2.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(externalUri).matches()) throw new SpdxInvalidTypeException("SPDX element must be of SpdxElement, SpdxNoneElement, SpdxNoAssertionElement or external SPDX element type.  URI does not match pattern for external element: " + externalUri);
                    relatedElementId = ExternalSpdxElement.uriToExternalSpdxElementReference((String)externalUri, (IModelStore)this.store, (String)documentUri, null, (String)"SPDX-2.3");
                }
            }
            Optional relationshipType = this.store.getValue(documentUri, tvId, SpdxConstantsCompatV2.PROP_RELATIONSHIP_TYPE);
            if (!relationshipType.isPresent()) {
                logger.warn("Missing type for a relationship for {}.  Skipping the serialization of this relationship.", (Object)element.getObjectUri());
                continue;
            }
            if (!(relationshipType.get() instanceof IndividualUriValue)) {
                throw new SpdxInvalidTypeException("Expected RelationshipType type for relationshipType property.  Unexpected type " + relatedSpdxElement.get().getClass());
            }
            String relationshipTypeStr = this.individualUriToString(documentUri, ((IndividualUriValue)relationshipType.get()).getIndividualURI());
            ObjectNode relationship = this.mapper.createObjectNode();
            relationship.put(SpdxConstantsCompatV2.PROP_SPDX_ELEMENTID.getName(), CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)element.getObjectUri(), (String)documentUri));
            relationship.put(SpdxConstantsCompatV2.PROP_RELATIONSHIP_TYPE.getName(), relationshipTypeStr);
            relationship.put(SpdxConstantsCompatV2.PROP_RELATED_SPDX_ELEMENT.getName(), relatedElementId);
            relationshipComment.ifPresent(o -> relationship.put(SpdxConstantsCompatV2.RDFS_PROP_COMMENT.getName(), (String)o));
            relationships.add((JsonNode)relationship);
        }
    }

    private ArrayNode toArrayNode(String documentUri, Iterator<Object> valueList, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        ArrayNode unsorted = this.mapper.createArrayNode();
        while (valueList.hasNext()) {
            Object value = valueList.next();
            this.addValueToArrayNode(unsorted, documentUri, value, relationships);
        }
        ArrayList<JsonNode> nodeList = new ArrayList<JsonNode>();
        unsorted.spliterator().forEachRemaining(nodeList::add);
        nodeList.sort(NODE_COMPARATOR);
        return this.mapper.createArrayNode().addAll(unsorted);
    }

    private void setValueField(ObjectNode node, String field, String documentUri, Object value, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        Object nodeValue = this.toSerializable(documentUri, value, relationships);
        if (nodeValue instanceof JsonNode) {
            node.set(field, (JsonNode)nodeValue);
        } else if (nodeValue instanceof String) {
            node.put(field, (String)nodeValue);
        } else if (nodeValue instanceof Integer) {
            node.put(field, (Integer)nodeValue);
        } else if (nodeValue instanceof Boolean) {
            node.put(field, (Boolean)nodeValue);
        } else {
            throw new SpdxInvalidTypeException("Can not serialize the JSON type for " + nodeValue.getClass());
        }
    }

    private Object toSerializable(String documentUri, Object value, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        if (value instanceof IndividualUriValue) {
            return this.individualUriToString(documentUri, ((IndividualUriValue)value).getIndividualURI());
        }
        if (value instanceof TypedValue) {
            TypedValue tvStoredValue = (TypedValue)value;
            String tvId = CompatibleModelStoreWrapper.objectUriToId((IModelStore)this.store, (String)tvStoredValue.getObjectUri(), (String)documentUri);
            Class clazz = (Class)SpdxModelFactoryCompatV2.SPDX_TYPE_TO_CLASS_V2.get(tvStoredValue.getType());
            if (AnyLicenseInfo.class.isAssignableFrom(clazz) && (MultiFormatStore.Verbose.STANDARD.equals((Object)this.verbose) || MultiFormatStore.Verbose.COMPACT.equals((Object)this.verbose))) {
                CoreModelObject inflated = ModelRegistry.getModelRegistry().inflateModelObject((IModelStore)this.store, tvStoredValue.getObjectUri(), tvStoredValue.getType(), null, tvStoredValue.getSpecVersion(), false, documentUri + "#");
                return inflated.toString();
            }
            if (SpdxElement.class.isAssignableFrom(clazz) && MultiFormatStore.Verbose.COMPACT.equals((Object)this.verbose) && !IModelStore.IdType.Anonymous.equals((Object)this.store.getIdType(tvId))) {
                return tvId;
            }
            return this.typedValueToObjectNode(documentUri, (TypedValue)value, relationships);
        }
        return value;
    }

    private String individualUriToString(String documentUri, String uri) throws InvalidSPDXAnalysisException {
        Object enumval = SpdxEnumFactoryCompatV2.uriToEnum.get(uri);
        if (Objects.nonNull(enumval)) {
            if (enumval instanceof RelationshipType || enumval instanceof Purpose) {
                return enumval.toString();
            }
            return enumval.toString().replaceAll("_", "-");
        }
        if (SpdxConstantsCompatV2.EXTERNAL_SPDX_ELEMENT_URI_PATTERN.matcher(uri).matches()) {
            return ExternalSpdxElement.uriToExternalSpdxElementReference((String)uri, (IModelStore)this.store, (String)documentUri, null, (String)"SPDX-2.3");
        }
        if (SpdxConstantsCompatV2.URI_VALUE_NONE.equals(uri)) {
            return SpdxConstantsCompatV2.NONE_VALUE;
        }
        if (SpdxConstantsCompatV2.URI_VALUE_NOASSERTION.equals(uri)) {
            return SpdxConstantsCompatV2.NOASSERTION_VALUE;
        }
        if (uri.startsWith("http://spdx.org/rdf/references/")) {
            return uri.substring("http://spdx.org/rdf/references/".length());
        }
        return uri;
    }

    private void addValueToArrayNode(ArrayNode node, String documentUri, Object value, ArrayNode relationships) throws InvalidSPDXAnalysisException {
        Object nodeValue = this.toSerializable(documentUri, value, relationships);
        if (nodeValue instanceof JsonNode) {
            node.add((JsonNode)nodeValue);
        } else if (nodeValue instanceof String) {
            node.add((String)nodeValue);
        } else if (nodeValue instanceof Integer) {
            node.add((Integer)nodeValue);
        } else if (nodeValue instanceof Boolean) {
            node.add((Boolean)nodeValue);
        } else {
            throw new SpdxInvalidTypeException("Can not serialize the JSON type for " + nodeValue.getClass());
        }
    }

    static class Document
    extends ObjectNode {
        private static final long serialVersionUID = 1L;

        public Document(JsonNodeFactory nc) {
            super(nc);
        }
    }
}

