/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.jacksonstore;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.core.CoreModelObject;
import org.spdx.core.IModelCopyManager;
import org.spdx.core.InvalidSPDXAnalysisException;
import org.spdx.core.TypedValue;
import org.spdx.jacksonstore.JacksonDeSerializer;
import org.spdx.jacksonstore.JacksonSerializer;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxModelFactory;
import org.spdx.library.model.v2.SpdxConstantsCompatV2;
import org.spdx.library.model.v2.SpdxDocument;
import org.spdx.storage.IModelStore;
import org.spdx.storage.ISerializableModelStore;
import org.spdx.storage.simple.ExtendedSpdxStore;

public class MultiFormatStore
extends ExtendedSpdxStore
implements ISerializableModelStore {
    static final Logger logger = LoggerFactory.getLogger(MultiFormatStore.class);
    private Format format;
    private Verbose verbose;
    static final ObjectMapper JSON_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    static final ObjectMapper XML_MAPPER = new XmlMapper().configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true).enable(SerializationFeature.INDENT_OUTPUT);
    static final YAMLFactory yamlFactory = new YAMLFactory();
    static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)yamlFactory);
    static final XmlFactory xmlFactory = new XmlFactory();
    private ObjectMapper outputMapper;
    private ObjectMapper inputMapper;

    public MultiFormatStore(IModelStore baseStore, Format format, Verbose verbose) {
        super(baseStore);
        Objects.requireNonNull(format);
        Objects.requireNonNull(verbose);
        this.format = format;
        this.verbose = verbose;
        this.setMapper();
    }

    private void setMapper() {
        switch (this.format.ordinal()) {
            case 2: {
                this.outputMapper = XML_MAPPER;
                this.inputMapper = JSON_MAPPER;
                break;
            }
            case 3: {
                this.outputMapper = YAML_MAPPER;
                this.inputMapper = YAML_MAPPER;
                break;
            }
            default: {
                this.outputMapper = JSON_MAPPER;
                this.inputMapper = JSON_MAPPER;
            }
        }
    }

    public MultiFormatStore(IModelStore baseStore, Format format) {
        this(baseStore, format, Verbose.COMPACT);
    }

    public synchronized Format getFormat() {
        return this.format;
    }

    public synchronized void setFormat(Format format) {
        Objects.requireNonNull(format);
        this.format = format;
        this.setMapper();
    }

    public synchronized Verbose getVerbose() {
        return this.verbose;
    }

    public synchronized void setVerbose(Verbose verbose) {
        Objects.requireNonNull(verbose);
        this.verbose = verbose;
        this.setMapper();
    }

    public synchronized void serialize(OutputStream stream) throws InvalidSPDXAnalysisException, IOException {
        this.serialize(stream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void serialize(OutputStream stream, @Nullable CoreModelObject modelObject) throws InvalidSPDXAnalysisException, IOException {
        ObjectNode output;
        JacksonSerializer serializer = new JacksonSerializer(this.outputMapper, this.format, this.verbose, (IModelStore)this);
        if (Objects.nonNull(modelObject)) {
            output = serializer.docToJsonNode(modelObject.getObjectUri().substring(0, modelObject.getObjectUri().indexOf(35)));
        } else {
            List<String> allDocuments = this.getAllItems(null, "SpdxDocument").map(tv -> tv.getObjectUri().substring(0, tv.getObjectUri().indexOf(35))).collect(Collectors.toList());
            if (allDocuments.isEmpty()) {
                logger.warn("No SPDX Spec Version 2 Documents were found to serialize.  Note: For SPDX Spec version 3, the spdx-v3jsonld-store should be used");
            }
            output = allDocuments.size() == 1 ? serializer.docToJsonNode(allDocuments.get(0)) : serializer.docsToJsonNode(allDocuments);
        }
        YAMLGenerator jgen = null;
        try {
            switch (this.format.ordinal()) {
                case 3: {
                    jgen = yamlFactory.createGenerator(stream);
                    break;
                }
                case 0: {
                    jgen = this.outputMapper.getFactory().createGenerator(stream);
                    break;
                }
                default: {
                    jgen = this.outputMapper.getFactory().createGenerator(stream).useDefaultPrettyPrinter();
                }
            }
            this.outputMapper.writeTree((JsonGenerator)jgen, (JsonNode)output);
        }
        finally {
            if (Objects.nonNull(jgen)) {
                jgen.close();
            }
        }
    }

    public static String propertyNameToCollectionPropertyName(String propertyName) {
        if (propertyName.endsWith("y")) {
            return propertyName.substring(0, propertyName.length() - 1) + "ies";
        }
        if (SpdxConstantsCompatV2.PROP_PACKAGE_LICENSE_INFO_FROM_FILES.getName().equals(propertyName)) {
            return propertyName;
        }
        return propertyName + "s";
    }

    public static String collectionPropertyNameToPropertyName(String collectionPropertyName) {
        if (collectionPropertyName.endsWith("ies")) {
            return collectionPropertyName.substring(0, collectionPropertyName.length() - 3) + "y";
        }
        if (SpdxConstantsCompatV2.PROP_PACKAGE_LICENSE_INFO_FROM_FILES.getName().equals(collectionPropertyName)) {
            return collectionPropertyName;
        }
        return collectionPropertyName.substring(0, collectionPropertyName.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized SpdxDocument deSerialize(InputStream stream, boolean overwrite) throws InvalidSPDXAnalysisException, IOException {
        void var8_14;
        JsonNode root;
        Objects.requireNonNull(stream, "Input stream must not be null");
        if (this.verbose != Verbose.COMPACT) {
            throw new InvalidSPDXAnalysisException("Only COMPACT verbose option is supported for deserialization");
        }
        if (Format.XML.equals((Object)this.format)) {
            JSONObject jo = XML.toJSONObject((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
            root = this.inputMapper.readTree(jo.toString()).get("Document");
        } else {
            root = this.inputMapper.readTree(stream);
        }
        if (Objects.isNull(root)) {
            throw new InvalidSPDXAnalysisException("Missing SPDX Document");
        }
        ArrayList<String> documentNamespaces = new ArrayList<String>();
        if (root instanceof ArrayNode) {
            for (JsonNode docNode : root) {
                documentNamespaces.add(this.getNamespaceFromDoc(docNode));
            }
        } else {
            documentNamespaces.add(this.getNamespaceFromDoc(root));
        }
        Set<String> existingDocNamespaces = this.getDocumentUris();
        boolean existing = false;
        for (String string : documentNamespaces) {
            if (!existingDocNamespaces.contains(string)) continue;
            existing = true;
            break;
        }
        if (existing) {
            IModelStore.IModelStoreLock lock = this.enterCriticalSection(false);
            try {
                if (!overwrite) {
                    throw new InvalidSPDXAnalysisException("Document namespace(s) already exists.");
                }
                for (String docNamespace3 : documentNamespaces) {
                    if (!existingDocNamespaces.contains(docNamespace3)) continue;
                    this.clear(docNamespace3);
                }
            }
            finally {
                this.leaveCriticalSection(lock);
            }
        }
        JacksonDeSerializer deSerializer = new JacksonDeSerializer((IModelStore)this, (IModelCopyManager)new ModelCopyManager(), this.format);
        if (root instanceof ArrayNode) {
            for (JsonNode doc : root) {
                deSerializer.storeDocument(this.getNamespaceFromDoc(doc), doc);
            }
            String string = this.getNamespaceFromDoc(root.get(0));
        } else {
            deSerializer.storeDocument(this.getNamespaceFromDoc(root), root);
            String string = this.getNamespaceFromDoc(root);
        }
        return (SpdxDocument)SpdxModelFactory.inflateModelObject((IModelStore)this, (String)((String)var8_14 + "#" + "SPDXRef-DOCUMENT"), (String)"SpdxDocument", (IModelCopyManager)new ModelCopyManager(), (String)"SPDX-2.3", (boolean)false, (String)var8_14);
    }

    private String getNamespaceFromDoc(JsonNode docNode) throws InvalidSPDXAnalysisException {
        JsonNode namespaceNode = docNode.get(SpdxConstantsCompatV2.PROP_DOCUMENT_NAMESPACE.getName());
        if (Objects.isNull(namespaceNode)) {
            throw new InvalidSPDXAnalysisException("Missing document namespace");
        }
        String documentNamespace = namespaceNode.asText();
        if (Objects.isNull(documentNamespace) || documentNamespace.isEmpty()) {
            throw new InvalidSPDXAnalysisException("Empty document namespace");
        }
        return documentNamespace;
    }

    public void clear(String documentNamespace) throws InvalidSPDXAnalysisException {
        List valuesToDelete = this.getAllItems(documentNamespace, null).collect(Collectors.toList());
        for (TypedValue valueToDelete : valuesToDelete) {
            this.delete(valueToDelete.getObjectUri());
        }
    }

    public Set<String> getDocumentUris() throws InvalidSPDXAnalysisException {
        HashSet<String> retval = new HashSet<String>();
        this.getAllItems(null, null).forEach(tv -> {
            if (tv.getObjectUri().contains("#")) {
                retval.add(tv.getObjectUri().substring(0, tv.getObjectUri().indexOf(35)));
            }
        });
        return retval;
    }

    public static enum Format {
        JSON,
        JSON_PRETTY,
        XML,
        YAML;

    }

    public static enum Verbose {
        COMPACT,
        STANDARD,
        FULL;

    }
}

